/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.importer.div.tasks;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.ILabMapping;
import ch.elexis.core.model.ILabResult;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.builder.ICoverageBuilder;
import ch.elexis.core.model.builder.IEncounterBuilder;
import ch.elexis.core.model.ch.BillingLaw;
import ch.elexis.core.model.message.MessageCodeMessageId;
import ch.elexis.core.model.message.TransientMessage;
import ch.elexis.core.model.tasks.IIdentifiedRunnable;
import ch.elexis.core.model.tasks.SerializableBoolean;
import ch.elexis.core.model.tasks.TaskException;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.services.ICoverageService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.BillingServiceHolder;
import ch.elexis.core.services.holder.CodeElementServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.CoverageServiceHolder;
import ch.elexis.core.services.holder.EncounterServiceHolder;
import ch.elexis.core.services.holder.LabServiceHolder;
import ch.elexis.core.services.holder.MessageServiceHolder;
import ch.elexis.core.time.TimeUtil;
import ch.rgw.tools.Result;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BillLabResultOnCreationIdentifiedRunnable
implements IIdentifiedRunnable {
    public static final String RUNNABLE_ID = "billLabResultOnCreation";
    private static final int MAX_WAIT = 40;
    private static Object addTarifLock = new Object();
    private static Logger logger;
    private final IModelService coreModelService;
    private final EncounterSelector encounterSelector;

    public BillLabResultOnCreationIdentifiedRunnable(IModelService coreModelService, EncounterSelector encounterSelection) {
        this.coreModelService = coreModelService;
        this.encounterSelector = encounterSelection;
        logger = LoggerFactory.getLogger(BillLabResultOnCreationIdentifiedRunnable.class);
    }

    private IBillable getKonsVerrechenbar(IEncounter kons) {
        if (kons.getCoverage() != null) {
            Map context = CodeElementServiceHolder.createContext((IEncounter)kons);
            Optional tarmed = CodeElementServiceHolder.get().loadFromString("Tarmed", "00.0010", context);
            if (tarmed.isPresent()) {
                return (IBillable)tarmed.get();
            }
        }
        return null;
    }

    private boolean isLabResultReady(ILabResult labResult) {
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(labResult.getItem());
        values.add(labResult.getPatient());
        for (Object e : values) {
            if (e != null) continue;
            return false;
        }
        return true;
    }

    private Optional<IEncounter> getBillableEncounter(IPatient patient, boolean autoAddBillableEncounter, boolean notifyOnAutoAddEncounter) throws TaskException {
        IStatus result;
        ICoverage coverageToCreateIEncounterUpon;
        String konsId;
        IEncounter validEncounter = null;
        IQuery openCoverageQuery = CoreModelServiceHolder.get().getQuery(ICoverage.class);
        openCoverageQuery.and((EStructuralFeature)ModelPackage.Literals.ICOVERAGE__PATIENT, IQuery.COMPARATOR.EQUALS, (Object)patient);
        openCoverageQuery.and((EStructuralFeature)ModelPackage.Literals.ICOVERAGE__DATE_TO, IQuery.COMPARATOR.EQUALS, null);
        List openCoverages = openCoverageQuery.execute();
        List todaysOpenBillableEncounters = null;
        if (!openCoverages.isEmpty()) {
            todaysOpenBillableEncounters = openCoverages.stream().flatMap(cv -> cv.getEncounters().stream()).filter(encounter -> TimeUtil.isToday((LocalDate)encounter.getDate())).filter(encounter -> BillingServiceHolder.get().isEditable(encounter).isOK()).collect(Collectors.toList());
            if (todaysOpenBillableEncounters.size() == 1) {
                validEncounter = (IEncounter)todaysOpenBillableEncounters.get(0);
            } else if (todaysOpenBillableEncounters.size() > 1 && (validEncounter = (IEncounter)todaysOpenBillableEncounters.stream().filter(enc -> enc.getCoverage().getBillingSystem().getLaw() == BillingLaw.KVG).findFirst().orElse(null)) == null) {
                validEncounter = (IEncounter)todaysOpenBillableEncounters.get(0);
            }
        }
        if (validEncounter == null && this.encounterSelector != null && (konsId = this.encounterSelector.createOrOpenConsultation(patient)) != null) {
            validEncounter = (IEncounter)this.coreModelService.load(konsId, IEncounter.class).get();
        }
        if (validEncounter != null) {
            return Optional.of(validEncounter);
        }
        if (!autoAddBillableEncounter) {
            return Optional.empty();
        }
        boolean createdCoverage = false;
        if (openCoverages.isEmpty()) {
            coverageToCreateIEncounterUpon = this.createDefaultCoverage(this.coreModelService, patient);
            createdCoverage = true;
        } else if (openCoverages.size() == 1) {
            coverageToCreateIEncounterUpon = (ICoverage)openCoverages.get(0);
        } else {
            coverageToCreateIEncounterUpon = openCoverages.stream().filter(coverage -> coverage.getBillingSystem().getLaw() == BillingLaw.KVG).findFirst().orElse(null);
            if (coverageToCreateIEncounterUpon == null) {
                coverageToCreateIEncounterUpon = openCoverages.stream().filter(coverage -> coverage.getBillingSystem().getLaw() == BillingLaw.UVG).findFirst().orElse(null);
            }
            if (coverageToCreateIEncounterUpon == null) {
                coverageToCreateIEncounterUpon = this.createDefaultCoverage(this.coreModelService, patient);
                createdCoverage = true;
            }
        }
        if (createdCoverage) {
            logger.info("Created new coverage [{}] as no applicable found.", (Object)coverageToCreateIEncounterUpon);
        }
        IMandator mandatorToBillUpon = null;
        if (todaysOpenBillableEncounters != null && !todaysOpenBillableEncounters.isEmpty()) {
            mandatorToBillUpon = ((IEncounter)todaysOpenBillableEncounters.get(0)).getMandator();
        } else {
            List allEncountersForPatient = EncounterServiceHolder.get().getAllEncountersForPatient(patient);
            if (!allEncountersForPatient.isEmpty()) {
                mandatorToBillUpon = ((IEncounter)allEncountersForPatient.get(0)).getMandator();
            }
        }
        if (mandatorToBillUpon == null) {
            List mandators = this.coreModelService.getQuery(IMandator.class).execute();
            if (mandators.isEmpty()) {
                logger.warn("Could not determine a mandator for patient, and no mandators available!");
                throw new TaskException(6, "Could not determine a mandator for patient, and no mandators available!");
            }
            mandatorToBillUpon = (IMandator)mandators.get(0);
            logger.warn("Could not determine existing mandator for patient, using [{}]", (Object)mandatorToBillUpon);
        }
        validEncounter = (IEncounter)new IEncounterBuilder(this.coreModelService, coverageToCreateIEncounterUpon, mandatorToBillUpon).buildAndSave();
        logger.info("Added encounter [{}] to bill results", (Object)validEncounter.getId());
        if (notifyOnAutoAddEncounter && !(result = this.sendMessageToOwner(patient)).isOK()) {
            logger.warn("Could not send notification message.");
        }
        return Optional.ofNullable(validEncounter);
    }

    private ICoverage createDefaultCoverage(IModelService coreModelService2, IPatient patient) {
        ICoverageService iCoverageService = CoverageServiceHolder.get();
        return new ICoverageBuilder(this.coreModelService, patient, iCoverageService.getDefaultCoverageLabel(), iCoverageService.getDefaultCoverageReason(), iCoverageService.getDefaultCoverageLaw()).buildAndSave();
    }

    private IStatus sendMessageToOwner(IPatient patient) {
        IUser owner = ContextServiceHolder.get().getActiveUser().orElse(null);
        TransientMessage transientMessage = MessageServiceHolder.get().prepare(this.getClass().getSimpleName(), "internal:" + owner.getId());
        transientMessage.addMessageCode("messageId", MessageCodeMessageId.INFO_BILLING_AUTO_CREATE_ENCOUNTER.name());
        transientMessage.addMessageCode("messageIdParam", patient.getPatientNr());
        transientMessage.setSenderAcceptsAnswer(false);
        transientMessage.setMessageText(Messages.NO_BILLABLE_ENCOUNTER1 + patient.getPatientNr() + Messages.NO_BILLABLE_ENCOUNTER2);
        return MessageServiceHolder.get().send(transientMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result<?> addTarifToKons(IBillable tarif, IEncounter kons, boolean autoBillTarmed00_0010IfNotAlreadyBilledOnEncounter) throws TaskException {
        if (autoBillTarmed00_0010IfNotAlreadyBilledOnEncounter) {
            IEncounter iEncounter = kons;
            synchronized (iEncounter) {
                IBillable consVerrechenbar;
                List leistungen = kons.getBilled();
                boolean addCons = true;
                for (IBilled verrechnet : leistungen) {
                    IBillable verrechenbar = verrechnet.getBillable();
                    if (verrechenbar == null || !verrechenbar.getCodeSystemName().equals("Tarmed") || !verrechenbar.getCode().equals("00.0010")) continue;
                    addCons = false;
                    break;
                }
                if (addCons && (consVerrechenbar = this.getKonsVerrechenbar(kons)) != null) {
                    Result result = BillingServiceHolder.get().bill(consVerrechenbar, kons, 1.0);
                    if (!result.isOK()) {
                        throw new TaskException(6, result);
                    }
                    ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)kons);
                }
            }
        }
        logger.info(String.format("Adding EAL tarif [%s] to [%s]", tarif.getCode(), kons.getLabel()));
        Result result = BillingServiceHolder.get().bill(tarif, kons, 1.0);
        if (!result.isOK()) {
            throw new TaskException(6, result);
        }
        return result;
    }

    private IBillable getLabor2009TarifByCode(String ealCode) {
        Map context = CodeElementServiceHolder.createContext();
        context.put(ICodeElementService.ContextKeys.DATE, LocalDate.now());
        Optional tarif = CodeElementServiceHolder.get().loadFromString("EAL 2009", ealCode, context);
        if (tarif.isPresent() && tarif.get() instanceof IBillable) {
            return (IBillable)tarif.get();
        }
        return null;
    }

    public String getId() {
        return RUNNABLE_ID;
    }

    public String getLocalizedDescription() {
        return "Bill an EAL 2009 service on a patients encounter on creation of a Labresult";
    }

    public Map<String, Serializable> getDefaultRunContext() {
        HashMap<String, Serializable> defaultRunContext = new HashMap<String, Serializable>();
        defaultRunContext.put("identifiableId", (Serializable)((Object)"missingRequired"));
        defaultRunContext.put("at.medevit.elexis.roche.labor.bill.addcons", Boolean.FALSE);
        defaultRunContext.put("autoCreateBillalbeEncounter", Boolean.TRUE);
        defaultRunContext.put("notifyOnAutoAddEncounter", Boolean.TRUE);
        return defaultRunContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Serializable> run(Map<String, Serializable> runContext, IProgressMonitor progressMonitor, Logger logger) throws TaskException {
        Optional mapping;
        String labresultId = (String)((Object)runContext.get("identifiableId"));
        Optional _labResult = this.coreModelService.load(labresultId, ILabResult.class);
        if (!_labResult.isPresent()) {
            throw new TaskException(6, "LabResult [" + labresultId + "] could not be loaded");
        }
        boolean autoBillTarmed00_0010IfNotAlreadyBilledOnEncounter = SerializableBoolean.valueOf(runContext, (String)"at.medevit.elexis.roche.labor.bill.addcons");
        boolean autoAddBillableEncounter = SerializableBoolean.valueOf(runContext, (String)"autoCreateBillalbeEncounter");
        boolean notifyOnAutoAddEncounter = SerializableBoolean.valueOf(runContext, (String)"notifyOnAutoAddEncounter");
        ILabResult labResult = (ILabResult)_labResult.get();
        if (!this.isLabResultReady(labResult)) {
            int waitForFields = 0;
            while (waitForFields < 40) {
                try {
                    ++waitForFields;
                    Thread.sleep(500L);
                    if (!this.isLabResultReady(labResult)) continue;
                    break;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (waitForFields == 40) {
                String errorMessage = String.format("Could not get data from result [%s].", labResult.getId());
                logger.warn(errorMessage);
                throw new TaskException(6, errorMessage);
            }
        }
        if ((mapping = LabServiceHolder.get().getLabMappingByContactAndItem(labResult.getOrigin(), labResult.getItem())).isPresent() && ((ILabMapping)mapping.get()).isCharge()) {
            String ealCode = labResult.getItem().getBillingCode();
            logger.info(String.format("Adding EAL tarif [%s] from [%s]", ealCode, labResult.getOrigin().getLabel()));
            if (ealCode != null && !ealCode.isEmpty()) {
                IBillable tarif = this.getLabor2009TarifByCode(ealCode);
                if (tarif == null) {
                    String errorString = String.format("Item %s: EAL tarif [%s] does not exist.", labResult.getItem().getLabel(), ealCode);
                    logger.warn(errorString);
                    throw new TaskException(6, errorString);
                }
                Object object = addTarifLock;
                synchronized (object) {
                    Optional<IEncounter> kons = this.getBillableEncounter(labResult.getPatient(), autoAddBillableEncounter, notifyOnAutoAddEncounter);
                    if (kons.isPresent()) {
                        Result<?> addTarifToKons = this.addTarifToKons(tarif, kons.get(), autoBillTarmed00_0010IfNotAlreadyBilledOnEncounter);
                        return Collections.singletonMap("resultData", addTarifToKons.toString());
                    }
                    String errorString = String.format("Could not add tarif [%s] for result of patient [%s] because no billable kons found.", ealCode, labResult.getPatient().getLabel());
                    logger.warn(errorString);
                    HashMap<String, Serializable> resultMap = new HashMap<String, Serializable>();
                    resultMap.put("markerWarn", null);
                    resultMap.put("resultData", (Serializable)((Object)errorString));
                    return resultMap;
                }
            }
        } else {
            logger.debug("No mapping present or is not to charge");
        }
        return Collections.singletonMap("markerDoNotPersist", true);
    }

    public static interface EncounterSelector {
        public String createOrOpenConsultation(IPatient var1);
    }

    public class Parameters {
        public static final String ADDCONS = "at.medevit.elexis.roche.labor.bill.addcons";
        public static final String BOOLEAN_AUTO_ADD_BILLABLE_ENCOUNTER = "autoCreateBillalbeEncounter";
        public static final String BOOLEAN_NOTIFY_ON_AUTO_ADD_ENCOUNTER = "notifyOnAutoAddEncounter";
    }
}

