/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.tasks.internal.service.quartz;

import ch.elexis.core.model.tasks.TaskException;
import ch.elexis.core.tasks.model.ITaskDescriptor;
import ch.elexis.core.tasks.model.ITaskService;
import ch.elexis.core.tasks.model.TaskTriggerType;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.LoggerFactory;

public class TriggerTaskJob
implements Job {
    public void execute(JobExecutionContext executionContext) throws JobExecutionException {
        ITaskService taskService = (ITaskService)executionContext.getMergedJobDataMap().get((Object)"taskService");
        ITaskDescriptor taskDescriptor = (ITaskDescriptor)executionContext.getMergedJobDataMap().get((Object)"taskDescriptor");
        try {
            taskService.trigger(taskDescriptor, null, TaskTriggerType.CRON, null);
        }
        catch (TaskException e) {
            LoggerFactory.getLogger((String)(this.getClass().getName() + "_" + taskDescriptor.getId())).warn("Error triggering taskDescriptor", (Throwable)e);
        }
    }
}

