/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.mediorder;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IOrderEntry;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.IStock;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IMedicationService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IOrderService;
import ch.elexis.core.services.IStockService;
import ch.elexis.core.services.IStoreToStringService;
import ch.elexis.core.ui.e4.dnd.GenericObjectDropTarget;
import ch.elexis.core.ui.e4.parts.IRefreshablePart;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.mediorder.MedicationHistoryComparator;
import ch.elexis.core.ui.mediorder.MediorderEntryState;
import ch.elexis.core.ui.mediorder.MediorderHistoryFilter;
import ch.elexis.core.ui.mediorder.MediorderPartUtil;
import ch.elexis.core.ui.mediorder.MediorderStockFilter;
import ch.elexis.core.ui.views.contribution.IViewContribution;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Service;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.slf4j.LoggerFactory;

public class MediorderPart
implements IRefreshablePart {
    @Inject
    private EPartService partService;
    @Inject
    IEventBroker eventBroker;
    @Inject
    IContextService contextService;
    @Inject
    IStockService stockService;
    @Inject
    IOrderService orderService;
    @Inject
    IStoreToStringService storeToStringService;
    @Inject
    @Service(filterExpression="(service.model.name=ch.elexis.core.model)")
    IModelService coreModelService;
    @Inject
    ESelectionService selectionService;
    @Inject
    IMedicationService medicationService;
    private TableViewer tableViewer;
    private TableViewer tableViewerDetails;
    private TableViewer tableViewerHistory;
    private Composite cDetails_table;
    private Composite cHistory_table;
    private StackLayout stackLayout;
    private Composite viewComposite;
    private StockComparator stockComparator;
    private MedicationComparator medicationComparator;
    private MedicationHistoryComparator medicationHistoryComparator;
    private final DateTimeFormatter dateFormatter;
    private MediorderStockFilter searchFilter;
    private MediorderHistoryFilter orderHistoryFilter;
    private WritableValue<IStock> selectedDetailStock;
    private IPatient actPatient;
    public Map<IStock, Integer> imageStockStates = new HashMap<IStock, Integer>();
    private List<IStock> filteredStocks = new ArrayList<IStock>();
    private List<Integer> currentFilterValue;
    private boolean filterActive = false;
    private boolean isDetailsViewActive = true;
    private Preferences preferences = InstanceScope.INSTANCE.getNode("ch.elexis.core.ui.mediorder");
    private static final String CURRENT_FILTER_VALUE = "currentFilterValues";
    private static final String IS_FILTER_ACTIVE = "isFilterActive";
    private static final String LAST_ACTIVE_TABLEVIEWER = "lastActiveView";

    public MediorderPart() {
        this.dateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");
        this.selectedDetailStock = new WritableValue();
    }

    @Focus
    public void setFocus() {
        this.tableViewer.getTable().setFocus();
        this.activePatient(this.contextService.getActivePatient().orElse(null));
    }

    @Inject
    void activePatient(@Optional IPatient patient) {
        Display.getDefault().asyncExec(() -> {
            if (CoreUiUtil.isActiveControl((Control)this.tableViewer.getControl()) && this.actPatient != patient) {
                this.actPatient = patient;
                java.util.Optional patientStock = this.stockService.getPatientStock(patient);
                if (patientStock.isPresent()) {
                    this.tableViewer.setSelection((ISelection)new StructuredSelection(patientStock.get()));
                    this.tableViewer.refresh();
                }
            }
        });
    }

    @Inject
    @Optional
    public void reload(@UIEventTopic(value="info/elexis/model/reload") Class<?> clazz) {
        if (IStock.class.equals(clazz)) {
            this.refresh();
        }
    }

    public void refresh(Map<Object, Object> filterParameters) {
        Object firstElement = this.tableViewer.getStructuredSelection().getFirstElement();
        this.tableViewer.setInput(this.filterActive ? MediorderPartUtil.calculateFilteredStocks(this.currentFilterValue) : this.getStocksExcludingAwaitingRequests());
        if (this.tableViewer.contains(firstElement)) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection(firstElement));
            MediorderPartUtil.updateStockImageState(this.imageStockStates, (IStock)firstElement);
        }
        this.tableViewer.refresh(true);
    }

    @PostConstruct
    public void postConstruct(Composite parent, EMenuService menuService, IExtensionRegistry extensionRegistry) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.stockComparator = new StockComparator();
        this.medicationComparator = new MedicationComparator();
        this.medicationHistoryComparator = new MedicationHistoryComparator();
        this.createSearchBar(parent);
        SashForm sashForm = new SashForm(parent, 512);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        sashForm.setSashWidth(5);
        this.createPatientorderListViewer(extensionRegistry, (Composite)sashForm);
        this.viewComposite = new Composite((Composite)sashForm, 0);
        this.stackLayout = new StackLayout();
        this.viewComposite.setLayout((Layout)this.stackLayout);
        this.createPatientorderDetailViewer(this.viewComposite);
        this.createPatientorderHistory(this.viewComposite);
        this.stackLayout.topControl = this.cDetails_table;
        this.viewComposite.layout();
        this.addDragAndDrop();
        menuService.registerContextMenu((Object)this.tableViewer.getTable(), "ch.elexis.core.ui.mediorder.popupmenu.viewer");
        menuService.registerContextMenu((Object)this.tableViewerDetails.getTable(), "ch.elexis.core.ui.mediorder.popupmenu.viewerdetails");
        this.tableViewer.setInput(this.getStocksExcludingAwaitingRequests());
        this.applySavedFilter();
        this.refresh();
        this.selectedDetailStock.addChangeListener(ev -> this.selectionService.setSelection(this.selectedDetailStock.getValue()));
    }

    public boolean toggleViews() {
        this.isDetailsViewActive = !this.isDetailsViewActive;
        this.stackLayout.topControl = this.isDetailsViewActive ? this.cDetails_table : this.cHistory_table;
        this.viewComposite.layout();
        this.saveFilterStatus();
        return this.isDetailsViewActive;
    }

    private void createSearchBar(Composite parent) {
        Composite searchComposite = new Composite(parent, 0);
        searchComposite.setLayout((Layout)new GridLayout(2, false));
        searchComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        final Text txtSearch = new Text(searchComposite, 2176);
        txtSearch.setLayoutData((Object)new GridData(768));
        txtSearch.setMessage(Messages.Core_DoSearch);
        txtSearch.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                MediorderPart.this.searchFilter.setSearchTerm(txtSearch.getText());
                MediorderPart.this.tableViewer.refresh();
            }
        });
    }

    private void createPatientorderListViewer(IExtensionRegistry extensionRegistry, Composite parent) {
        Composite cStockTable = new Composite(parent, 0);
        cStockTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout tcLayout = new TableColumnLayout();
        cStockTable.setLayout((Layout)tcLayout);
        this.tableViewer = new TableViewer(cStockTable, 65540);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setComparator((ViewerComparator)this.stockComparator);
        this.searchFilter = new MediorderStockFilter();
        this.tableViewer.addFilter((ViewerFilter)this.searchFilter);
        this.tableViewer.addSelectionChangedListener(event -> {
            IStructuredSelection selection = this.tableViewer.getStructuredSelection();
            this.selectedDetailStock.setValue((Object)((IStock)selection.getFirstElement()));
        });
        TableViewerColumn tvcOrderState = new TableViewerColumn(this.tableViewer, 0);
        tvcOrderState.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                IStock stock = (IStock)element;
                int number = MediorderPartUtil.getImageForStock(MediorderPart.this.imageStockStates, stock);
                return switch (number) {
                    case 0 -> Images.IMG_BULLET_GREY.getImage();
                    case 1 -> Images.IMG_BULLET_GREEN.getImage();
                    case 2 -> Images.IMG_BULLET_YELLOW.getImage();
                    case 3 -> Images.IMG_BULLET_BLUE.getImage();
                    default -> null;
                };
            }

            public String getText(Object element) {
                return null;
            }
        });
        TableColumn tblclmntvcOrderState = tvcOrderState.getColumn();
        tcLayout.setColumnData((Widget)tblclmntvcOrderState, (ColumnLayoutData)new ColumnWeightData(0, 20, true));
        tblclmntvcOrderState.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MediorderPart.this.stockComparator.setColumn(0);
                MediorderPart.this.refresh();
            }
        });
        TableViewerColumn tvcPatientNumber = new TableViewerColumn(this.tableViewer, 0);
        tvcPatientNumber.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IStock stock = (IStock)element;
                return stock.getOwner().getCode();
            }
        });
        TableColumn tblclmntvcPatientNumber = tvcPatientNumber.getColumn();
        tcLayout.setColumnData((Widget)tblclmntvcPatientNumber, (ColumnLayoutData)new ColumnWeightData(10, 70, true));
        tblclmntvcPatientNumber.setText(Messages.Core_Patient_Number);
        tblclmntvcPatientNumber.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MediorderPart.this.stockComparator.setColumn(1);
                MediorderPart.this.refresh();
            }
        });
        TableViewerColumn tvcPatientLastName = new TableViewerColumn(this.tableViewer, 0);
        tvcPatientLastName.setLabelProvider((CellLabelProvider)ColumnLabelProvider.createTextProvider(e -> ((IStock)e).getOwner().getLastName()));
        TableColumn tblclmntvcPatientLastName = tvcPatientLastName.getColumn();
        tcLayout.setColumnData((Widget)tblclmntvcPatientLastName, (ColumnLayoutData)new ColumnWeightData(30, 200, true));
        tblclmntvcPatientLastName.setText(Messages.Core_Name);
        tblclmntvcPatientLastName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MediorderPart.this.stockComparator.setColumn(2);
                MediorderPart.this.refresh();
            }
        });
        TableViewerColumn tvcPatientFirstName = new TableViewerColumn(this.tableViewer, 0);
        tvcPatientFirstName.setLabelProvider((CellLabelProvider)ColumnLabelProvider.createTextProvider(e -> ((IStock)e).getOwner().getFirstName()));
        TableColumn tblclmntvcPatientFirstName = tvcPatientFirstName.getColumn();
        tcLayout.setColumnData((Widget)tblclmntvcPatientFirstName, (ColumnLayoutData)new ColumnWeightData(30, 200, true));
        tblclmntvcPatientFirstName.setText(Messages.Core_Firstname);
        tblclmntvcPatientFirstName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MediorderPart.this.stockComparator.setColumn(3);
                MediorderPart.this.refresh();
            }
        });
        TableViewerColumn tvcPatientBirthdate = new TableViewerColumn(this.tableViewer, 0);
        tvcPatientBirthdate.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IStock stock = (IStock)element;
                LocalDateTime birthdate = stock.getOwner().getDateOfBirth();
                return birthdate.format(MediorderPart.this.dateFormatter);
            }
        });
        TableColumn tblclmntvcPatientBirthdate = tvcPatientBirthdate.getColumn();
        tcLayout.setColumnData((Widget)tblclmntvcPatientBirthdate, (ColumnLayoutData)new ColumnWeightData(10, 90, true));
        tblclmntvcPatientBirthdate.setText(Messages.Core_Enter_Birthdate);
        tblclmntvcPatientBirthdate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MediorderPart.this.stockComparator.setColumn(4);
                MediorderPart.this.refresh();
            }
        });
        cStockTable.setData("tableViewer", (Object)this.tableViewer);
        IConfigurationElement[] configurationElementsFor = extensionRegistry.getConfigurationElementsFor("ch.elexis.core.ui.ViewContribution");
        List<IConfigurationElement> filteredExtensions = Arrays.asList(configurationElementsFor).stream().filter(p -> MediorderPart.class.getName().equalsIgnoreCase(p.getAttribute("viewId"))).collect(Collectors.toList());
        filteredExtensions.forEach(e -> {
            try {
                IViewContribution contribution = (IViewContribution)e.createExecutableExtension("class");
                contribution.initComposite(cStockTable);
            }
            catch (CoreException e1) {
                LoggerFactory.getLogger(this.getClass()).error("Error", (Throwable)e1);
            }
        });
    }

    private void createPatientorderDetailViewer(Composite parent) {
        this.cDetails_table = new Composite(parent, 0);
        this.cDetails_table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.cDetails_table.setLayout((Layout)new GridLayout(1, false));
        this.setCompositeTitle(this.cDetails_table, Messages.Mediorder_details);
        Composite tableComposite = new Composite(this.cDetails_table, 0);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout tcLayout_cDetails = new TableColumnLayout();
        tableComposite.setLayout((Layout)tcLayout_cDetails);
        this.tableViewerDetails = new TableViewer(tableComposite, 65538);
        Table tableDetails = this.tableViewerDetails.getTable();
        tableDetails.setHeaderVisible(true);
        this.tableViewerDetails.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.selectedDetailStock.addChangeListener(sel -> {
            IStock stock = (IStock)this.selectedDetailStock.getValue();
            if (stock != null) {
                List lStocks = stock.getStockEntries();
                this.tableViewerDetails.setInput((Object)lStocks);
            } else {
                this.tableViewerDetails.setInput(null);
            }
        });
        this.tableViewerDetails.setComparator((ViewerComparator)this.medicationComparator);
        this.tableViewerDetails.addDoubleClickListener(event -> {
            IStockEntry entry;
            IOrderEntry orderEntry;
            Object selectedElement;
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (!selection.isEmpty() && (selectedElement = selection.getFirstElement()) instanceof IStockEntry && (orderEntry = this.orderService.findOpenOrderEntryForStockEntry(entry = (IStockEntry)selectedElement)) != null) {
                MPart part = this.partService.findPart("ch.elexis.BestellenView");
                if (part == null) {
                    part = this.partService.showPart("ch.elexis.BestellenView", EPartService.PartState.CREATE);
                }
                this.partService.showPart(part, EPartService.PartState.ACTIVATE);
                this.eventBroker.post("BestellenView/orderSelected", (Object)orderEntry.getOrder());
            }
        });
        TableViewerColumn tvcMediorderEntryState = new TableViewerColumn(this.tableViewerDetails, 0);
        TableColumn tblclmntvcMedicationOrdered = tvcMediorderEntryState.getColumn();
        tcLayout_cDetails.setColumnData((Widget)tblclmntvcMedicationOrdered, (ColumnLayoutData)new ColumnWeightData(10, 120, true));
        tblclmntvcMedicationOrdered.setText(Messages.Mediorder_Order_status);
        tblclmntvcMedicationOrdered.setImage(Images.IMG_PERSPECTIVE_ORDERS.getImage());
        tblclmntvcMedicationOrdered.setToolTipText(Messages.Mediorder_Order_status_Tooltip);
        tvcMediorderEntryState.setLabelProvider((CellLabelProvider)ColumnLabelProvider.createTextProvider(MediorderPartUtil::createMediorderEntryStateLabel));
        TableViewerColumn tvcMedication = new TableViewerColumn(this.tableViewerDetails, 0);
        tvcMedication.setLabelProvider((CellLabelProvider)ColumnLabelProvider.createTextProvider(e -> ((IStockEntry)e).getArticle().getLabel()));
        TableColumn tblclmntvcMedication = tvcMedication.getColumn();
        tcLayout_cDetails.setColumnData((Widget)tblclmntvcMedication, (ColumnLayoutData)new ColumnWeightData(30, 400, true));
        tblclmntvcMedication.setText(Messages.Core_Article);
        tblclmntvcMedication.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MediorderPart.this.medicationComparator.setColumn(0);
                MediorderPart.this.refresh();
            }
        });
        TableViewerColumn tvcMedicationDosage = new TableViewerColumn(this.tableViewerDetails, 0);
        tvcMedicationDosage.setLabelProvider((CellLabelProvider)ColumnLabelProvider.createTextProvider(element -> {
            IStockEntry entry = (IStockEntry)element;
            IPatient patient = entry.getStock().getOwner().asIPatient();
            List lMedication = patient.getMedication(Arrays.asList(EntryType.FIXED_MEDICATION, EntryType.RESERVE_MEDICATION, EntryType.SYMPTOMATIC_MEDICATION));
            for (IPrescription prescription : lMedication) {
                if (!prescription.getArticle().equals(entry.getArticle())) continue;
                return prescription.getDosageInstruction();
            }
            return "";
        }));
        TableColumn tblclmntvcMedicationDosage = tvcMedicationDosage.getColumn();
        tcLayout_cDetails.setColumnData((Widget)tblclmntvcMedicationDosage, (ColumnLayoutData)new ColumnWeightData(10, 70, true));
        tblclmntvcMedicationDosage.setText(Messages.Core_Dosage);
        TableViewerColumn tvcMediorderEntryOutreach = new TableViewerColumn(this.tableViewerDetails, 0);
        tvcMediorderEntryOutreach.setLabelProvider((CellLabelProvider)ColumnLabelProvider.createTextProvider(MediorderPartUtil::createMediorderEntryOutreachLabel));
        TableColumn tblclmntvcMedicationAmountDay = tvcMediorderEntryOutreach.getColumn();
        tcLayout_cDetails.setColumnData((Widget)tblclmntvcMedicationAmountDay, (ColumnLayoutData)new ColumnWeightData(10, 100, true));
        tblclmntvcMedicationAmountDay.setText(Messages.Mediorder_sufficient_for);
        TableViewerColumn tvcMedicationAmount = new TableViewerColumn(this.tableViewerDetails, 0);
        tvcMedicationAmount.setLabelProvider((CellLabelProvider)ColumnLabelProvider.createTextProvider(element -> {
            IStockEntry entry = (IStockEntry)element;
            return String.valueOf(entry.getMinimumStock());
        }));
        tvcMedicationAmount.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewerDetails){

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)MediorderPart.this.tableViewerDetails.getTable());
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                IStockEntry entry = (IStockEntry)element;
                return String.valueOf(entry.getMinimumStock());
            }

            protected void setValue(Object element, Object value) {
                IStockEntry entry = (IStockEntry)element;
                String amount = (String)value;
                entry.setMinimumStock(Integer.parseInt(amount));
                MediorderPart.this.coreModelService.save((Identifiable)entry);
                MediorderPart.this.tableViewerDetails.refresh(true);
                MediorderPart.this.removeStockEntry(entry);
                MediorderPartUtil.updateStockImageState(MediorderPart.this.imageStockStates, entry.getStock());
                MediorderPart.this.refresh();
            }
        });
        TableColumn tblclmntvcMedicationAmount = tvcMedicationAmount.getColumn();
        tcLayout_cDetails.setColumnData((Widget)tblclmntvcMedicationAmount, (ColumnLayoutData)new ColumnWeightData(10, 110, true));
        tblclmntvcMedicationAmount.setText(Messages.Mediorder_requested);
        tblclmntvcMedicationAmount.setImage(Images.IMG_ACHTUNG.getImage());
        tblclmntvcMedicationAmount.setToolTipText(Messages.Mediorder_requested_Tooltip);
        TableViewerColumn tvcMedicationClearance = new TableViewerColumn(this.tableViewerDetails, 0);
        tvcMedicationClearance.setLabelProvider((CellLabelProvider)ColumnLabelProvider.createTextProvider(element -> {
            IStockEntry entry = (IStockEntry)element;
            return String.valueOf(entry.getMaximumStock());
        }));
        tvcMedicationClearance.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewerDetails){

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)MediorderPart.this.tableViewerDetails.getTable());
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                IStockEntry entry = (IStockEntry)element;
                return String.valueOf(entry.getMaximumStock());
            }

            protected void setValue(Object element, Object value) {
                IStockEntry entry = (IStockEntry)element;
                String amount = (String)value;
                entry.setMaximumStock(Integer.parseInt(amount));
                MediorderPart.this.coreModelService.save((Identifiable)entry);
                MediorderPart.this.tableViewerDetails.refresh(true);
                MediorderPart.this.removeStockEntry(entry);
                MediorderPartUtil.updateStockImageState(MediorderPart.this.imageStockStates, entry.getStock());
            }
        });
        TableColumn tblclmntvcMedicationClearance = tvcMedicationClearance.getColumn();
        tcLayout_cDetails.setColumnData((Widget)tblclmntvcMedicationClearance, (ColumnLayoutData)new ColumnWeightData(10, 110, true));
        tblclmntvcMedicationClearance.setImage(Images.IMG_TICK.getImage());
        tblclmntvcMedicationClearance.setText(Messages.Mediorder_approved);
        tblclmntvcMedicationClearance.setToolTipText(Messages.Mediorder_approved_Tooltip);
        TableViewerColumn tvcOrderDate = new TableViewerColumn(this.tableViewerDetails, 0);
        TableColumn tblclmntvcOrderDate = tvcOrderDate.getColumn();
        tcLayout_cDetails.setColumnData((Widget)tblclmntvcOrderDate, (ColumnLayoutData)new ColumnWeightData(10, 80, true));
        tblclmntvcOrderDate.setText(Messages.Mediorder_order_date);
        tblclmntvcOrderDate.setToolTipText(Messages.Mediorder_order_date_Tooltip);
        tvcOrderDate.setLabelProvider((CellLabelProvider)ColumnLabelProvider.createTextProvider(element -> {
            String regex;
            Pattern pattern;
            Matcher matcher;
            IStockEntry entry = (IStockEntry)element;
            IOrderEntry orderEntry = this.orderService.findOpenOrderEntryForStockEntry(entry);
            if (orderEntry != null && (matcher = (pattern = Pattern.compile(regex = "\\d{2}\\.\\d{2}\\.\\d{4}")).matcher(orderEntry.getOrder().getLabel())).find()) {
                return matcher.group();
            }
            return null;
        }));
    }

    private void createPatientorderHistory(Composite parent) {
        this.cHistory_table = new Composite(parent, 0);
        this.cHistory_table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.cHistory_table.setLayout((Layout)new GridLayout(1, false));
        this.setCompositeTitle(this.cHistory_table, Messages.Mediorder_history);
        Composite searchComposite = new Composite(this.cHistory_table, 0);
        searchComposite.setLayout((Layout)new GridLayout(2, false));
        searchComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        final Text txtSearch = new Text(searchComposite, 2176);
        txtSearch.setLayoutData((Object)new GridData(768));
        txtSearch.setMessage(Messages.Core_DoSearch);
        txtSearch.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                MediorderPart.this.orderHistoryFilter.setSearchTerm(txtSearch.getText());
                MediorderPart.this.tableViewerHistory.refresh();
            }
        });
        Composite tableComposite = new Composite(this.cHistory_table, 0);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout tcLayout_cHistory = new TableColumnLayout();
        tableComposite.setLayout((Layout)tcLayout_cHistory);
        this.tableViewerHistory = new TableViewer(tableComposite, 65538);
        Table tableHistory = this.tableViewerHistory.getTable();
        tableHistory.setHeaderVisible(true);
        this.tableViewerHistory.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewerHistory.setComparator((ViewerComparator)this.medicationHistoryComparator);
        this.selectedDetailStock.addChangeListener(sel -> this.tableViewerHistory.setInput(java.util.Optional.ofNullable((IStock)this.selectedDetailStock.getValue()).map(arg_0 -> ((IOrderService)this.orderService).findOrderEntryForStock(arg_0)).orElse(null)));
        this.orderHistoryFilter = new MediorderHistoryFilter();
        this.tableViewerHistory.addFilter((ViewerFilter)this.orderHistoryFilter);
        TableViewerColumn tvcMediorderOrderDate = new TableViewerColumn(this.tableViewerHistory, 0);
        tvcMediorderOrderDate.setLabelProvider((CellLabelProvider)ColumnLabelProvider.createTextProvider(e -> ((IOrderEntry)e).getOrder().getTimestamp().format(this.dateFormatter)));
        TableColumn tblclmntvcMedicationDosage = tvcMediorderOrderDate.getColumn();
        tcLayout_cHistory.setColumnData((Widget)tblclmntvcMedicationDosage, (ColumnLayoutData)new ColumnWeightData(10, 70, true));
        tblclmntvcMedicationDosage.setText(Messages.Core_Date);
        tblclmntvcMedicationDosage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MediorderPart.this.medicationHistoryComparator.setColumn(2);
                MediorderPart.this.refresh();
            }
        });
        TableViewerColumn tvcMediorderArticle = new TableViewerColumn(this.tableViewerHistory, 0);
        TableColumn tblclmntvcMedicationArticle = tvcMediorderArticle.getColumn();
        tcLayout_cHistory.setColumnData((Widget)tblclmntvcMedicationArticle, (ColumnLayoutData)new ColumnWeightData(30, 400, true));
        tblclmntvcMedicationArticle.setText(Messages.Core_Article);
        tvcMediorderArticle.setLabelProvider((CellLabelProvider)ColumnLabelProvider.createTextProvider(e -> ((IOrderEntry)e).getArticle().getLabel()));
        tblclmntvcMedicationArticle.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MediorderPart.this.medicationHistoryComparator.setColumn(0);
                MediorderPart.this.refresh();
            }
        });
        TableViewerColumn tvcMediorderAmount = new TableViewerColumn(this.tableViewerHistory, 0);
        tvcMediorderAmount.setLabelProvider((CellLabelProvider)ColumnLabelProvider.createTextProvider(e -> String.valueOf(((IOrderEntry)e).getAmount())));
        TableColumn tblclmntvcMediorderAmount = tvcMediorderAmount.getColumn();
        tcLayout_cHistory.setColumnData((Widget)tblclmntvcMediorderAmount, (ColumnLayoutData)new ColumnWeightData(10, 50, true));
        tblclmntvcMediorderAmount.setText(Messages.Core_Count);
        tblclmntvcMediorderAmount.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MediorderPart.this.medicationHistoryComparator.setColumn(1);
                MediorderPart.this.refresh();
            }
        });
    }

    private void addDragAndDrop() {
        new GenericObjectDropTarget(this.storeToStringService, (Control)this.tableViewer.getTable(), (list, event) -> {
            list.forEach(entry -> {
                if (entry instanceof IArticle) {
                    IArticle article = (IArticle)entry;
                    this.addMedicationOrderEntryToStock(null, article);
                }
            });
            this.refresh();
        });
        new GenericObjectDropTarget(this.storeToStringService, (Control)this.tableViewerDetails.getTable(), (list, event) -> {
            list.forEach(entry -> {
                if (entry instanceof IArticle) {
                    IArticle article = (IArticle)entry;
                    IStock selectedStock = (IStock)this.tableViewer.getStructuredSelection().getFirstElement();
                    this.addMedicationOrderEntryToStock(selectedStock, article);
                }
            });
            this.refresh();
        });
    }

    private void addMedicationOrderEntryToStock(IStock stock, IArticle article) {
        IStockEntry stockEntry;
        if (StringUtils.isBlank((CharSequence)article.getGtin())) {
            return;
        }
        if (stock == null) {
            IPatient patient = (IPatient)this.contextService.getActivePatient().get();
            this.stockService.setEnablePatientStock(patient, true);
            stock = (IStock)this.stockService.getPatientStock(patient).get();
        }
        if ((stockEntry = this.stockService.findStockEntryForArticleInStock(stock, article)) != null) {
            int value = stockEntry.getMinimumStock() + 1;
            stockEntry.setMinimumStock(value);
            value = stockEntry.getMaximumStock() + 1;
            stockEntry.setMaximumStock(value);
        } else {
            stockEntry = this.stockService.storeArticleInStock(stock, article);
            stockEntry.setCurrentStock(0);
            stockEntry.setMinimumStock(1);
            stockEntry.setMaximumStock(1);
        }
        this.coreModelService.save((Identifiable)stockEntry);
        MediorderPartUtil.updateStockImageState(this.imageStockStates, stock);
    }

    private List<IStock> getStocksExcludingAwaitingRequests() {
        return this.stockService.getAllPatientStock().stream().filter(stock -> !stock.getStockEntries().isEmpty()).filter(stock -> stock.getStockEntries().stream().anyMatch(entry -> !MediorderEntryState.AWAITING_REQUEST.equals((Object)MediorderPartUtil.determineState(entry)))).toList();
    }

    public List<IStockEntry> getSelectedStockEntries() {
        return this.tableViewerDetails.getStructuredSelection().toList();
    }

    public IStock getSelectedStock() {
        return (IStock)this.selectedDetailStock.getValue();
    }

    public void removeStockEntry(IStockEntry entry) {
        if (entry.getMaximumStock() == 0 && entry.getMinimumStock() == 0) {
            this.coreModelService.remove((Identifiable)entry);
            IStock stock = entry.getStock();
            if (stock.getStockEntries().isEmpty()) {
                this.coreModelService.remove((Identifiable)stock);
            }
            this.refresh();
        }
    }

    private void setCompositeTitle(Composite composite, String title) {
        Label titleLabel = new Label(composite, 0);
        titleLabel.setText(title);
        titleLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        FontData fontData = titleLabel.getFont().getFontData()[0];
        Font boldFont = new Font((Device)composite.getDisplay(), new FontData(fontData.getName(), fontData.getHeight(), 1));
        titleLabel.setFont(boldFont);
    }

    public void saveFilterStatus() {
        String filterValue = this.currentFilterValue == null || this.currentFilterValue.isEmpty() ? "" : this.currentFilterValue.stream().map(String::valueOf).collect(Collectors.joining(","));
        boolean isFilterActive = filterValue.isEmpty() ? false : this.filterActive;
        this.preferences.put(CURRENT_FILTER_VALUE, filterValue);
        this.preferences.putBoolean(IS_FILTER_ACTIVE, isFilterActive);
        this.preferences.putBoolean(LAST_ACTIVE_TABLEVIEWER, this.isDetailsViewActive);
        try {
            this.preferences.flush();
        }
        catch (BackingStoreException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error saving filter values", (Throwable)e);
        }
    }

    public void applySavedFilter() {
        this.filterActive = this.preferences.getBoolean(IS_FILTER_ACTIVE, false);
        String filterValue = this.preferences.get(CURRENT_FILTER_VALUE, "");
        if (!filterValue.isEmpty() && this.filterActive) {
            this.currentFilterValue = Arrays.stream(filterValue.split(",")).map(Integer::parseInt).collect(Collectors.toList());
        }
        this.stackLayout.topControl = this.preferences.getBoolean(LAST_ACTIVE_TABLEVIEWER, true) ? this.cDetails_table : this.cHistory_table;
        this.viewComposite.layout();
    }

    public void setFilterActive(boolean active) {
        this.filterActive = active;
        this.saveFilterStatus();
    }

    public boolean isFilterActive() {
        return this.filterActive;
    }

    public void setFilteredStocks(List<IStock> stocks) {
        this.filteredStocks = stocks;
    }

    public List<IStock> getFilteredStocks() {
        return this.filteredStocks;
    }

    public void setCurrentFilterValue(List<Integer> value) {
        this.currentFilterValue = value;
        this.saveFilterStatus();
    }

    public List<Integer> getCurrentFilterValue() {
        return this.currentFilterValue;
    }

    public class MedicationComparator
    extends ViewerComparator {
        private int propertyIndex = 0;
        private int direction = -1;

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction *= -1;
            }
            this.propertyIndex = column;
        }

        public int compare(Viewer viewer, Object o1, Object o2) {
            IStockEntry stockEntry1 = (IStockEntry)o1;
            IStockEntry stockEntry2 = (IStockEntry)o2;
            switch (this.propertyIndex) {
                case 0: {
                    String articleName1 = stockEntry1.getArticle().getName();
                    String articleName2 = stockEntry2.getArticle().getName();
                    return Objects.compare(articleName1, articleName2, Comparator.nullsFirst(Comparator.naturalOrder())) * this.direction;
                }
            }
            return super.compare(viewer, o1, o2);
        }
    }

    public class StockComparator
    extends ViewerComparator {
        private int propertyIndex = 0;
        private int direction = -1;

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction *= -1;
            }
            this.propertyIndex = column;
        }

        public int compare(Viewer viewer, Object o1, Object o2) {
            IStock ts1 = (IStock)o1;
            IStock ts2 = (IStock)o2;
            int number1 = MediorderPartUtil.getImageForStock(MediorderPart.this.imageStockStates, ts1);
            int number2 = MediorderPartUtil.getImageForStock(MediorderPart.this.imageStockStates, ts2);
            switch (this.propertyIndex) {
                case 0: {
                    return Objects.compare(number1, number2, Comparator.nullsFirst(Comparator.naturalOrder())) * this.direction;
                }
                case 1: {
                    Integer patientNr1 = Integer.valueOf(ts1.getId().substring(13));
                    Integer patientNr2 = Integer.valueOf(ts2.getId().substring(13));
                    return Objects.compare(patientNr1, patientNr2, Comparator.nullsFirst(Comparator.naturalOrder())) * this.direction;
                }
                case 2: {
                    String patientName1 = ts1.getOwner().getLastName();
                    String patientName2 = ts2.getOwner().getLastName();
                    return Objects.compare(patientName1, patientName2, Comparator.nullsFirst(Comparator.naturalOrder())) * this.direction;
                }
                case 3: {
                    String patientFirstName1 = ts1.getOwner().getFirstName();
                    String patientFirstName2 = ts2.getOwner().getFirstName();
                    return Objects.compare(patientFirstName1, patientFirstName2, Comparator.nullsFirst(Comparator.naturalOrder())) * this.direction;
                }
                case 4: {
                    LocalDateTime birthDate1 = ts1.getOwner().getDateOfBirth();
                    return birthDate1.compareTo(ts2.getOwner().getDateOfBirth()) * this.direction;
                }
            }
            return super.compare(viewer, o1, o2);
        }
    }
}

