/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.extension.ICoreOperationAdvisor;
import ch.elexis.core.events.MessageEvent;
import ch.elexis.core.services.IAccessControlService;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IElexisEntityManager;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IXidService;
import ch.elexis.core.utils.CoreUtil;
import ch.elexis.data.DBConnection;
import ch.elexis.data.Mandant;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.PersistentObjectUtil;
import ch.elexis.data.Trace;
import ch.rgw.io.ISettingChangedListener;
import ch.rgw.tools.ExHandler;
import java.sql.SQLException;
import java.util.Locale;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={PersistentObjectDataSourceActivator.class})
public class PersistentObjectDataSourceActivator {
    @Reference
    private ICoreOperationAdvisor coreOperationAdvisor;
    @Reference(target="(id=default)")
    private DataSource dataSource;
    @Reference(target="(id=default)")
    private IElexisEntityManager elexisEntityManager;
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;
    @Reference
    private IContextService contextService;
    @Reference
    private IConfigService configService;
    @Reference
    private IAccessControlService accessControlService;
    @Reference
    private IXidService xidService;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    @Activate
    void activate() throws SQLException {
        this.elexisEntityManager.getEntityManager(true);
        if (!this.elexisEntityManager.isUpdateSuccess()) {
            this.coreOperationAdvisor.openInformation("DB Update Fehler", "Beim Datenbank Update ist ein Fehler aufgetreten.\nIhre Datenbank wurde nicht aktualisiert.\nDetails dazu finden Sie in der log Datei.");
        }
        this.log.debug("PersistentObject#connect");
        boolean connect = PersistentObject.connect(this.dataSource);
        if (!connect) {
            throw new IllegalStateException("Connect to database failed", new Throwable());
        }
        this.log.debug("PersistentObject#legacyPostInitDB");
        boolean legacyPostInitDB = this.legacyPostInitDB();
        if (!legacyPostInitDB) {
            throw new IllegalStateException("legacyPostInitDB failed", new Throwable());
        }
    }

    private boolean legacyPostInitDB() {
        DBConnection defaultConnection = PersistentObject.getDefaultConnection();
        if (CoreHub.globalCfg == null || CoreHub.globalCfg.get("created", null) == null) {
            this.log.info("PO data initialization");
            try {
                PersistentObjectUtil.initializeGlobalCfg(defaultConnection);
                Mandant.initializeAdministratorUser(this.accessControlService, this.coreModelService);
                Mandant bypassMandator = PersistentObjectUtil.autoCreateFirstMandant(defaultConnection.isRunningFromScratch() || CoreUtil.isTestMode());
                if (bypassMandator == null) {
                    this.coreOperationAdvisor.requestInitialMandatorConfiguration();
                    MessageEvent.fireInformation((String)"Neue Datenbank", (String)"Es wurde eine neue Datenbank angelegt.");
                } else {
                    this.log.info("Bypassed mandator initialization dialog, auto-created Mandator [{}] {}", (Object)bypassMandator.getId(), (Object)bypassMandator.getPersonalia());
                }
                CoreHub.globalCfg.flush();
                CoreHub.localCfg.flush();
            }
            catch (Throwable ex) {
                ExHandler.handle((Throwable)ex);
                return false;
            }
        }
        CoreHub.globalCfg.setSettingChangedListener(new ISettingChangedListener(){

            public void settingRemoved(String key) {
                Trace.addTraceEntry("W globalCfg key [" + key + "] => removed");
            }

            public void settingWritten(String key, String value) {
                Trace.addTraceEntry("W globalCfg key [" + key + "] => value [" + value + "]");
            }
        });
        Locale locale = Locale.getDefault();
        String dbStoredLocale = CoreHub.globalCfg.get("locale", null);
        if (dbStoredLocale == null) {
            CoreHub.globalCfg.set("locale", locale.toString());
            CoreHub.globalCfg.flush();
        } else if (!locale.toString().equals(dbStoredLocale)) {
            String msg2 = String.format("Your locale [%1s] does not match the required database locale [%2s] as specified in config table. Ignore?", locale.toString(), dbStoredLocale);
            this.log.error(msg2);
            if (!this.coreOperationAdvisor.openQuestion("Difference in locale setting ", msg2)) {
                System.exit(2);
            } else {
                this.log.error("User continues with difference locale set");
            }
        }
        return true;
    }
}

