/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.activator;

import ch.elexis.Desk;
import ch.elexis.core.constants.Elexis;
import ch.elexis.core.data.activator.CoreHubHelper;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.Heartbeat;
import ch.elexis.core.data.interfaces.ShutdownJob;
import ch.elexis.core.data.interfaces.scripting.Interpreter;
import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.events.MessageEvent;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.services.LocalConfigService;
import ch.elexis.data.Anwender;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.PersistentObjectFactory;
import ch.elexis.data.Query;
import ch.rgw.io.Settings;
import ch.rgw.io.SqlSettings;
import ch.rgw.io.SysSettings;
import ch.rgw.tools.StringTool;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.eclipse.equinox.internal.app.CommandLineArgs;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreHub
implements BundleActivator {
    public static final String PLUGIN_ID = "ch.elexis.core.data";
    public static String Version = Elexis.VERSION;
    public static final String APPLICATION_NAME = "Elexis Core";
    protected static Logger log = LoggerFactory.getLogger((String)CoreHub.class.getName());
    private static String LocalCfgFile = null;
    private BundleContext context;
    public static CoreHub plugin;
    private static List<ShutdownJob> shutdownJobs;
    private static String stationIdentifier;
    public static final PersistentObjectFactory poFactory;
    public static Heartbeat heart;
    private static File userDir;
    @Deprecated
    public static Settings globalCfg;
    @Deprecated
    public static Settings localCfg;
    @Deprecated(forRemoval=true)
    public static Mandant actMandant;

    static {
        shutdownJobs = new LinkedList<ShutdownJob>();
        poFactory = new PersistentObjectFactory();
    }

    @Nullable
    public static Anwender getLoggedInContact() {
        Optional userContact = ContextServiceHolder.get().getActiveUserContact();
        if (userContact.isPresent()) {
            return Anwender.load(((IContact)userContact.get()).getId());
        }
        return null;
    }

    public static String getBasePath() {
        return FrameworkUtil.getBundle(CoreHub.class).getEntry("/").toString();
    }

    public static File getTempDir() {
        File ret = null;
        String temp = System.getProperty("java.io.tmpdir");
        if (!StringTool.isNothing((Object)temp)) {
            ret = new File(temp);
            if (ret.exists() && ret.isDirectory()) {
                return ret;
            }
            if (ret.mkdirs()) {
                return ret;
            }
        }
        return CoreHub.getWritableUserDir();
    }

    private static void initUserDir() {
        if (userDir == null) {
            String userhome = null;
            if (localCfg != null) {
                userhome = localCfg.get("elexis-userDir", null);
            }
            if (userhome == null) {
                userhome = System.getProperty("user.home");
            }
            if (StringTool.isNothing(userhome)) {
                userhome = System.getProperty("java.io.tempdir");
            }
            userDir = new File(userhome, "elexis");
        }
        if (!userDir.exists() && !userDir.mkdirs()) {
            System.err.print("fatal: could not create Userdir");
            MessageEvent.fireLoggedError((String)"Panic exit", (String)("could not create userdir " + userDir.getAbsolutePath()));
            System.exit(-5);
        }
    }

    public static File getWritableUserDir() {
        return userDir;
    }

    public void start(BundleContext context) throws Exception {
        this.context = context;
        log.debug("Starting " + CoreHub.class.getName());
        plugin = this;
        String[] args = CommandLineArgs.getApplicationArgs();
        String config = "default";
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.startsWith("--use-config=")) {
                String[] c = s.split("=");
                config = c[1];
            }
            ++n2;
        }
        if ("RunFromScratch".equals(System.getProperty("elexis-run-mode"))) {
            config = UUID.randomUUID().toString();
        }
        CoreHub.initUserDir();
        this.loadLocalCfg(config);
        int instanceNo = this.initializeLock();
        stationIdentifier = LocalConfigService.get((String)"station/identId", (String)("notset_" + System.currentTimeMillis()));
        if (instanceNo > 0) {
            stationIdentifier = String.valueOf(stationIdentifier) + "$" + instanceNo;
        }
        log.info("Basepath: " + CoreHub.getBasePath());
        heart = Heartbeat.getInstance();
        Interpreter.classLoaders.add(CoreHub.class.getClassLoader());
        if (!"RunFromScratch".equals(System.getProperty("elexis-run-mode"))) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    SysSettings localCfg = (SysSettings)CoreHub.localCfg;
                    localCfg.write_xml(LocalCfgFile);
                }
            });
        }
    }

    public void stop(BundleContext context) throws Exception {
        log.debug("Stopping " + CoreHub.class.getName());
        LocalLockServiceHolder.get().releaseAllLocks();
        LocalLockServiceHolder.get().shutdown();
        CoreHub.logoffAnwender();
        PersistentObject.disconnect();
        ElexisEventDispatcher.getInstance().dump();
        globalCfg = null;
        heart.stop();
        plugin = null;
        this.context = null;
    }

    private int initializeLock() {
        int MAX_LOCKS = 25;
        FileLock fileLock = null;
        int i = 0;
        while (i < 25) {
            block4: {
                Object fileName = i > 0 ? "elexislock." + i : "elexislock";
                File lockFile = new File(CoreHub.getWritableUserDir(), (String)fileName);
                try {
                    FileChannel lockFileChannel = new RandomAccessFile(lockFile, "rw").getChannel();
                    fileLock = lockFileChannel.tryLock();
                    if (fileLock == null) {
                        lockFileChannel.close();
                        break block4;
                    }
                    log.debug("Acquired lock on " + (String)fileName);
                    return i;
                }
                catch (IOException ioe) {
                    log.error("Can not aquire lock file in " + String.valueOf(userDir) + "; " + ioe.getMessage());
                }
            }
            ++i;
        }
        log.error("Could not initializeLock()");
        System.exit(-250);
        return -250;
    }

    public static String getId() {
        StringBuilder sb = new StringBuilder();
        sb.append(APPLICATION_NAME).append(" v.").append(Version).append("\n").append(CoreHubHelper.getRevision(true, plugin)).append("\n").append(System.getProperty("os.name")).append("/").append(System.getProperty("os.version")).append("/").append(System.getProperty("os.arch"));
        return sb.toString();
    }

    private void loadLocalCfg(String branch) {
        LocalCfgFile = String.valueOf(userDir) + "/localCfg_" + branch + ".xml";
        String msg = "loadLocalCfg: Loading branch " + branch + " from " + LocalCfgFile;
        System.out.println(msg);
        log.debug(msg);
        SysSettings cfg = SysSettings.getOrCreate((int)0, Desk.class);
        cfg.read_xml(LocalCfgFile);
        localCfg = cfg;
    }

    @Deprecated
    public static void setMandant(Mandant newMandant) {
        actMandant = newMandant;
        ElexisEventDispatcher.getInstance().fire(new ElexisEvent(newMandant, Mandant.class, 128));
        if (newMandant != null) {
            ContextServiceHolder.get().setActiveMandator(NoPoUtil.loadAsIdentifiable(newMandant, IMandator.class).get());
        } else {
            ContextServiceHolder.get().setActiveMandator(null);
        }
    }

    public static Settings getUserSetting(Kontakt user) {
        SqlSettings settings = new SqlSettings(PersistentObject.getConnection(), "USERCONFIG", "Param", "Value", "UserID=" + user.getWrappedId());
        return settings;
    }

    public Bundle getBundle() {
        return this.context.getBundle();
    }

    public static List<Mandant> getMandantenList() {
        Query qbe = new Query(Mandant.class);
        return qbe.execute().parallelStream().filter(m -> !m.isInactive()).collect(Collectors.toList());
    }

    public static List<Anwender> getUserList() {
        Query qbe = new Query(Anwender.class);
        return qbe.execute();
    }

    public static String getCfgVariant() {
        String config = System.getProperty("config");
        return config == null ? "default" : config;
    }

    public void setUserDir(File dir) {
        userDir = dir;
        localCfg.set("elexis-userDir", dir.getAbsolutePath());
    }

    public static void addShutdownJob(ShutdownJob job) {
        if (!shutdownJobs.contains(job)) {
            shutdownJobs.add(job);
        }
    }

    public static int getSystemLogLevel() {
        return localCfg.get("ablauf/LogLevel", 2);
    }

    public static void logoffAnwender() {
        if (CoreHub.getLoggedInContact() == null) {
            return;
        }
        LocalLockServiceHolder.get().releaseAllLocks();
        CoreHub.setMandant(null);
        heart.suspend();
        ContextServiceHolder.get().setActiveMandator(null);
        ContextServiceHolder.get().setActiveUser(null);
    }

    public static Object getStationIdentifier() {
        return stationIdentifier;
    }
}

