/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.tasks.internal;

import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.tasks.model.ITask;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class GenericTaskResultDetailComposite {
    private final DateTimeFormatter dtf = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm.ss");
    private Text txtRunContext;
    private Text txtResult;
    private static Font boldFont;

    public GenericTaskResultDetailComposite(Composite parent, ITask task) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        Label taskHeader = new Label(container, 0);
        taskHeader.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        if (boldFont == null) {
            FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)taskHeader.getFont()).setStyle(1);
            boldFont = boldDescriptor.createFont((Device)taskHeader.getDisplay());
        }
        taskHeader.setFont(boldFont);
        taskHeader.setText(task.getState().getName() + ": " + task.getId() + " (" + task.getTaskDescriptor().getReferenceId() + ")");
        Label lblCreated = new Label(container, 0);
        lblCreated.setText("created ");
        Label valCreated = new Label(container, 0);
        valCreated.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        valCreated.setText(this.dtf.format(task.getCreatedAt()));
        Label lblLblrun = new Label(container, 0);
        lblLblrun.setText("run");
        Label valRun = new Label(container, 0);
        valRun.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (task.getRunAt() != null) {
            valRun.setText(this.dtf.format(task.getRunAt()) + " on " + task.getRunner());
        }
        Label lblFinished = new Label(container, 0);
        lblFinished.setText("finished");
        Label valFinished = new Label(container, 0);
        valFinished.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (task.getFinishedAt() != null) {
            valFinished.setText(this.dtf.format(task.getFinishedAt()));
        }
        Label lblTrigger = new Label(container, 0);
        lblTrigger.setText("trigger");
        Label valTrigger = new Label(container, 0);
        valTrigger.setText(task.getTriggerEvent().getName());
        Label lblResult = new Label(container, 0);
        lblResult.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblResult.setText("result");
        this.txtResult = new Text(container, 2122);
        this.txtResult.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        StringBuilder sbResult = new StringBuilder();
        task.getResult().forEach((k, v) -> {
            if (v instanceof String) {
                String value = (String)v;
                if ("url".equals(k)) {
                    value = IVirtualFilesystemService.hidePasswordInUrlString((String)value);
                }
                sbResult.append("- " + k + ": " + value + "\n");
            } else {
                sbResult.append("- " + k + ": " + String.valueOf(v) + "\n");
            }
        });
        this.txtResult.setText(sbResult.toString());
        Label lblRunContext = new Label(container, 0);
        lblRunContext.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblRunContext.setText("runcontext");
        this.txtRunContext = new Text(container, 2122);
        this.txtRunContext.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        StringBuilder sbRunContext = new StringBuilder();
        task.getRunContext().forEach((k, v) -> {
            String value = Objects.toString(v);
            if ("url".equals(k)) {
                value = IVirtualFilesystemService.hidePasswordInUrlString((String)((String)((Object)v)));
            }
            sbRunContext.append("- " + k + ": " + value + "\n");
        });
        this.txtRunContext.setText(sbRunContext.toString());
    }
}

