/*
 * Decompiled with CFR 0.152.
 */
package com.equo.chromium.swt.internal;

import com.equo.chromium.ChromiumBrowser;
import com.equo.chromium.internal.Engine;
import com.equo.chromium.internal.IndependentBrowser;
import com.equo.chromium.internal.Subscriber;
import com.equo.chromium.swt.Browser;
import com.equo.chromium.swt.BrowserFunction;
import com.equo.chromium.swt.OpenWindowListener;
import com.equo.chromium.swt.WindowEvent;
import com.equo.chromium.swt.internal.AbstractEval;
import com.equo.chromium.swt.internal.Clipboard;
import com.equo.chromium.swt.internal.DownloadItem;
import com.equo.chromium.swt.internal.EvalBrowserFunctionImpl;
import com.equo.chromium.swt.internal.EvalFileImpl;
import com.equo.chromium.swt.internal.EvalSimpleImpl;
import com.equo.chromium.swt.internal.FindDialog;
import com.equo.chromium.swt.internal.MimeTypeLinux;
import com.equo.chromium.swt.internal.Net;
import com.equo.chromium.swt.internal.SetTextResourceHandler;
import com.equo.chromium.swt.internal.WebBrowser;
import com.equo.chromium.swt.internal.spi.CommRouterHandler;
import com.equo.chromium.swt.internal.spi.CommunicationManager;
import com.equo.chromium.swt.internal.spi.ScriptExtension;
import com.equo.chromium.utils.EventAction;
import com.github.cliftonlabs.json_simple.Jsoner;
import java.io.IOException;
import java.net.HttpCookie;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.cef.CefApp;
import org.cef.CefClientSwt;
import org.cef.CefColor;
import org.cef.CefSettings;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefBrowserSwt;
import org.cef.browser.CefFrame;
import org.cef.browser.CefMessageRouter;
import org.cef.browser.CefPopup;
import org.cef.browser.CefRequestContext;
import org.cef.callback.CefAuthCallback;
import org.cef.callback.CefBeforeDownloadCallback;
import org.cef.callback.CefCallback;
import org.cef.callback.CefCompletionCallback;
import org.cef.callback.CefContextMenuParams;
import org.cef.callback.CefCookieVisitor;
import org.cef.callback.CefDownloadItem;
import org.cef.callback.CefDownloadItemCallback;
import org.cef.callback.CefFileDialogCallback;
import org.cef.callback.CefJSDialogCallback;
import org.cef.callback.CefMenuModel;
import org.cef.callback.CefStringVisitor;
import org.cef.handler.CefContextMenuHandlerAdapter;
import org.cef.handler.CefDialogHandler;
import org.cef.handler.CefDisplayHandlerAdapter;
import org.cef.handler.CefDownloadHandlerAdapter;
import org.cef.handler.CefFocusHandler;
import org.cef.handler.CefFocusHandlerAdapter;
import org.cef.handler.CefJSDialogHandler;
import org.cef.handler.CefJSDialogHandlerAdapter;
import org.cef.handler.CefKeyboardHandler;
import org.cef.handler.CefKeyboardHandlerAdapter;
import org.cef.handler.CefLifeSpanHandlerAdapter;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.cef.handler.CefPrintHandlerAdapter;
import org.cef.handler.CefRequestHandler;
import org.cef.handler.CefRequestHandlerAdapter;
import org.cef.handler.CefResourceHandler;
import org.cef.handler.CefResourceHandlerAdapter;
import org.cef.handler.CefResourceRequestHandler;
import org.cef.handler.CefResourceRequestHandlerAdapter;
import org.cef.misc.BoolRef;
import org.cef.misc.IntRef;
import org.cef.misc.StringRef;
import org.cef.network.CefCookie;
import org.cef.network.CefCookieManager;
import org.cef.network.CefPostData;
import org.cef.network.CefPostDataElement;
import org.cef.network.CefRequest;
import org.cef.network.CefResponse;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.AuthenticationEvent;
import org.eclipse.swt.browser.AuthenticationListener;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

final class Chromium
extends WebBrowser {
    private static final String DATA_TEXT_URL = "data:text/html";
    private static final String ABOUT_BLANK = "about:blank";
    private static final String DATA_TEXT_BASE64_URL = "data:text/html;base64,";
    private static final int MAX_PROGRESS = 100;
    private static String setTextUrl = "";
    private static int GTK_VERSION = 0;
    private static final boolean CHROME_RUNTIME = Boolean.getBoolean("chrome_runtime");
    private static CefClientSwt clientHandler;
    private static FocusHandler focusHandler;
    private static KeyboardHandler keyboardHandler;
    private static LifeSpanHandler lifeSpanHandler;
    private static LoadHandler loadHandler;
    private static DialogHandler dialogHandler;
    private static DisplayHandler displayHandler;
    private static RequestHandler requestHandler;
    private static JsDialogHandler jsDialogHandler;
    private static ContextMenuHandler contextMenuHandler;
    private static DownloadHandler downloadHandler;
    private static CefMessageRouter router;
    Composite chromium;
    OpenWindowListener[] openWindowListeners = new OpenWindowListener[0];
    private CefFocusListener focusListener;
    private String url;
    private String title = "";
    private CompletableFuture<Boolean> enableProgress = new CompletableFuture();
    private CompletableFuture<Boolean> created = new CompletableFuture();
    private CompletableFuture<Boolean> loaded = new CompletableFuture();
    private Dispose disposing = Dispose.No;
    private boolean hasFocus;
    private boolean ignoreFirstFocus = true;
    private Listener traverseListener;
    private WindowEvent isPopup;
    private ExtraApi extraApi;
    private boolean loadingPage;
    private CefBrowserSwt cefBrowser;
    Stack<FunctionsResourceHandler> functionsResourceHandler = new Stack();
    private HashMap<String, Boolean> changedCache = new HashMap();
    private CompletableFuture<Void> urls = CompletableFuture.completedFuture(null);
    private static boolean isOpenDialog;
    private ControlAdapter fullscreenListener = null;
    private ResizeListener resize;
    private boolean inEvalBlocking = false;
    private EvalFileImpl eval;
    FindDialog findDialog = null;
    private static boolean winSkipFocus;

    static {
        Chromium.setupCookies();
        try {
            if ("gtk".equals(SWT.getPlatform())) {
                GTK_VERSION = Chromium.getGtkVersion();
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        isOpenDialog = false;
        winSkipFocus = true;
    }

    static int getGtkVersion() throws ReflectiveOperationException {
        String swtGtk3 = System.getenv().get("SWT_GTK3");
        if (swtGtk3 != null && "0".equals(swtGtk3)) {
            return 2;
        }
        Class<?> gtkClass = null;
        String major = null;
        try {
            gtkClass = Class.forName("org.eclipse.swt.internal.gtk.GTK");
            major = "gtk_get_major_version";
        }
        catch (ClassNotFoundException e) {
            try {
                gtkClass = Class.forName("org.eclipse.swt.internal.gtk.OS");
                major = "gtk_major_version";
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return (Integer)gtkClass.getDeclaredMethod(major, new Class[0]).invoke(null, new Object[0]);
    }

    Chromium() {
    }

    @Override
    public void addOpenWindowListener(OpenWindowListener listener) {
        OpenWindowListener[] newOpenWindowListeners = new OpenWindowListener[this.openWindowListeners.length + 1];
        System.arraycopy(this.openWindowListeners, 0, newOpenWindowListeners, 0, this.openWindowListeners.length);
        this.openWindowListeners = newOpenWindowListeners;
        this.openWindowListeners[this.openWindowListeners.length - 1] = listener;
    }

    @Override
    public void removeOpenWindowListener(OpenWindowListener listener) {
        if (this.openWindowListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.openWindowListeners.length) {
            if (listener == this.openWindowListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.openWindowListeners.length == 1) {
            this.openWindowListeners = new OpenWindowListener[0];
            return;
        }
        OpenWindowListener[] newOpenWindowListeners = new OpenWindowListener[this.openWindowListeners.length - 1];
        System.arraycopy(this.openWindowListeners, 0, newOpenWindowListeners, 0, index);
        System.arraycopy(this.openWindowListeners, index + 1, newOpenWindowListeners, index, this.openWindowListeners.length - index - 1);
        this.openWindowListeners = newOpenWindowListeners;
    }

    @Override
    public void setBrowser(Composite browser) {
        super.setBrowser(browser);
        this.chromium = browser;
    }

    @Override
    public void createFunction(BrowserFunction function) {
        this.loaded.thenRun(() -> {
            String[] arrFrames = function.getFrameNames();
            if (arrFrames == null && !browserFunction.top) {
                return;
            }
            for (BrowserFunction current : this.functions.values()) {
                if (!current.getName().equals(function.getName())) continue;
                this.destroyFunction(current);
                break;
            }
            browserFunction.index = this.getNextFunctionIndex();
            this.registerFunction(function);
            String frames = arrFrames != null && arrFrames.length > 0 ? Arrays.stream(arrFrames).collect(Collectors.joining(";", "", ";")) : (arrFrames == null || !browserFunction.top ? ";" : "");
            int id = this.cefBrowser.getIdentifier();
            String encodedFn = "__browserFunction;" + browserFunction.index + ";" + browserFunction.token + ";" + "functions" + ";" + id + ";" + browserFunction.top + ";" + frames;
            CefMessageRouter.CefMessageRouterConfig config = new CefMessageRouter.CefMessageRouterConfig(encodedFn, function.getName());
            CefMessageRouter fnRouter = CefMessageRouter.create(config);
            this.getClientHandler().addMessageRouter(fnRouter);
            browserFunction.router = fnRouter;
        });
    }

    @Override
    public void destroyFunction(BrowserFunction function) {
        this.checkBrowser();
        this.deregisterFunction(function);
        if (function.router != null) {
            clientHandler.removeMessageRouter(function.router);
            function.router.dispose();
        }
    }

    @Override
    public void create(Composite parent, int style) {
        Engine.initCEF();
        if (Boolean.getBoolean("chromium.inherit_bg_color")) {
            this.chromium.setBackground(parent.getBackground());
        } else if (CefColor.DARK_MODE) {
            this.chromium.setBackground(new Color((Device)parent.getDisplay(), CefColor.DARK_MODE_COLOR.getRed(), CefColor.DARK_MODE_COLOR.getGreen(), CefColor.DARK_MODE_COLOR.getBlue()));
        } else {
            this.chromium.setBackground(parent.getDisplay().getSystemColor(1));
        }
        this.createBrowser();
        if ("image".equals(System.getProperty("chromium.resize", "live"))) {
            this.resize = new ResizeListener();
        }
        if (Boolean.getBoolean("chromium.find_dialog")) {
            this.chromium.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if ((e.stateMask & 0x40000) == 262144 && e.keyCode == 102 && (Chromium.this.findDialog == null || Chromium.this.findDialog != null && !Chromium.this.findDialog.isOpen())) {
                        Chromium.this.findDialog = new FindDialog(Chromium.this.extraApi, Chromium.this.chromium.getShell());
                        Chromium.this.findDialog.open();
                    }
                }
            });
        }
    }

    private void debugPrint(String log) {
        Engine.debug(log, this.cefBrowser);
    }

    private void prepareBrowser() {
        this.chromium.addDisposeListener(e -> {
            this.debugPrint("disposing chromium");
            this.dispose();
        });
        this.focusListener = new CefFocusListener();
        this.chromium.addFocusListener((FocusListener)this.focusListener);
        this.getClientHandler();
    }

    private CefClientSwt getClientHandler() {
        if (clientHandler == null || clientHandler.isDisposed()) {
            Chromium.createClienthandler();
        }
        return clientHandler;
    }

    private void createBrowser() {
        this.prepareBrowser();
        this.traverseListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 31) {
                    if (event.character == '\t' && !Chromium.this.focusListener.enabled) {
                        Chromium.this.focusListener.enabled = true;
                        Chromium.this.cefBrowser.setFocus(true);
                        return;
                    }
                    if (!"gtk".equals(SWT.getPlatform())) {
                        event.doit = false;
                    }
                }
            }
        };
        this.chromium.addListener(1, this.traverseListener);
        if ("win32".equals(SWT.getPlatform())) {
            this.chromium.addListener(31, this.traverseListener);
        }
        Net.config();
        this.cefBrowser = (CefBrowserSwt)clientHandler.createBrowser(this.url == null ? ABOUT_BLANK : this.url, false, false, this.extraApi().createRequestContext(), null);
        this.cefBrowser.createImmediately(this.chromium);
    }

    private static void createClienthandler() {
        clientHandler = (CefClientSwt)Engine.createClient();
        Chromium.setFocusHandler();
        Chromium.setKeyboardHandler();
        Chromium.setLifeSpanHandler();
        Chromium.setLoadHandler();
        Chromium.setDialogHandler();
        Chromium.setDisplayHandler();
        Chromium.setRequestHandler();
        Chromium.setJsdialogHandler();
        Chromium.setContextMenuHandler();
        Chromium.setDownloadHandler();
        Chromium.setPrintHandler();
        CommunicationManager commManager = CommunicationManager.get();
        if (commManager != null) {
            CefMessageRouter commRouter = CommRouterHandler.createRouter();
            commRouter.addHandler(new CommRouterHandler(commManager), true);
            clientHandler.addMessageRouter(commRouter);
        }
        if (!Boolean.getBoolean("chromium.disable_script_extensions")) {
            Iterator<ScriptExtension> scriptExtensions = ScriptExtension.get();
            scriptExtensions.forEachRemaining(scriptExtensionProvider -> {
                List<CefMessageRouter> routers = ScriptExtension.createRouter(scriptExtensionProvider.getScriptExtensions());
                routers.stream().forEach(router -> clientHandler.addMessageRouter((CefMessageRouter)router));
            });
        }
        router = AbstractEval.createRouter();
        clientHandler.addMessageRouter(router);
        Clipboard.createClipboardRouters(clientHandler);
    }

    private static CefBrowser getTopParentPopup(CefBrowser browser) {
        CefBrowser parent = browser;
        while (parent != null && parent.isPopup()) {
            parent = ((CefPopup)parent).getParent();
        }
        return parent;
    }

    static Chromium getChromium(CefBrowser browser) {
        CefBrowser cefBrowser = browser;
        if (cefBrowser.isPopup() && (cefBrowser = Chromium.getTopParentPopup(browser)) == null) {
            return null;
        }
        Composite composite = ((CefBrowserSwt)cefBrowser).getComposite();
        ExtraApi webBrowser = null;
        if (composite instanceof Browser) {
            Browser chromiumBrowser = (Browser)composite;
            webBrowser = (ExtraApi)chromiumBrowser.getWebBrowser();
        } else {
            org.eclipse.swt.browser.Browser swtBrowser = (org.eclipse.swt.browser.Browser)composite;
            webBrowser = (ExtraApi)swtBrowser.getWebBrowser();
        }
        return webBrowser.getChromium();
    }

    private static void setLifeSpanHandler() {
        lifeSpanHandler = new LifeSpanHandler();
        clientHandler.addLifeSpanHandler(lifeSpanHandler);
    }

    private void onBeforeClose() {
        for (BrowserFunction function : new ArrayList(this.functions.values())) {
            function.dispose(true);
        }
        this.functions.clear();
        if (CHROME_RUNTIME) {
            this.doDispose();
        }
        if (this.disposing == Dispose.FromBrowser) {
            Chromium.syncExec(() -> {
                this.fireCloseListener();
                this.chromium.dispose();
            });
        }
        this.deleteTempFolder();
        this.chromium = null;
        this.debugPrint("closed");
        this.cefBrowser = null;
    }

    private void fireCloseListener() {
        if (this.chromium != null) {
            Display display = Display.getDefault();
            org.eclipse.swt.browser.WindowEvent event = new org.eclipse.swt.browser.WindowEvent((Widget)this.chromium);
            event.display = display;
            event.widget = this.chromium;
            CloseWindowListener[] closeWindowListenerArray = this.closeWindowListeners;
            int n = this.closeWindowListeners.length;
            int n2 = 0;
            while (n2 < n) {
                CloseWindowListener listener = closeWindowListenerArray[n2];
                listener.close(event);
                ++n2;
            }
        }
    }

    private boolean doClose() {
        this.doDispose();
        this.debugPrint("AFTER DoClose");
        return true;
    }

    private void doDispose() {
        if (this.disposing == Dispose.FromClose || this.disposing == Dispose.Unload || this.disposing == Dispose.UnloadClosed || this.disposing == Dispose.WaitIfClosed) {
            this.disposing = Dispose.DoIt;
        } else if (this.disposing == Dispose.No && this.chromium != null) {
            this.disposing = Dispose.FromBrowser;
            Chromium.asyncExec(() -> ((Composite)this.chromium).dispose());
        }
    }

    private void onAfterCreated() {
        if (this.isDisposed()) {
            return;
        }
        Chromium.syncExec(() -> this.cefBrowser.resize());
        this.created.complete(true);
        this.loaded.complete(true);
        if (this.url != null) {
            this.enableProgress.complete(true);
        }
        if (this.isPopup != null) {
            Chromium.syncExec(() -> {
                org.eclipse.swt.browser.WindowEvent event = new org.eclipse.swt.browser.WindowEvent((Widget)this.chromium);
                event.display = this.chromium.getDisplay();
                event.widget = this.chromium;
                event.size = this.isPopup.size;
                event.location = this.isPopup.location;
                event.addressBar = this.isPopup.addressBar;
                event.menuBar = this.isPopup.menuBar;
                event.statusBar = this.isPopup.statusBar;
                event.toolBar = this.isPopup.toolBar;
                if (event.size != null && !event.size.equals((Object)new Point(0, 0))) {
                    Point size = event.size;
                    this.chromium.getShell().setSize(this.chromium.getShell().computeSize(size.x, size.y));
                }
                VisibilityWindowListener[] visibilityWindowListenerArray = this.visibilityWindowListeners;
                int n = this.visibilityWindowListeners.length;
                int n2 = 0;
                while (n2 < n) {
                    VisibilityWindowListener listener = visibilityWindowListenerArray[n2];
                    listener.show(event);
                    ++n2;
                }
            });
        }
    }

    private boolean onBeforePopup(String target_url, String target_frame_name) {
        if (this.isDisposed()) {
            return true;
        }
        WindowEvent event = new WindowEvent((Widget)this.chromium);
        event.data = target_url;
        event.display = this.chromium.getDisplay();
        event.widget = this.chromium;
        event.required = false;
        event.addressBar = true;
        event.menuBar = true;
        event.statusBar = true;
        event.toolBar = true;
        Chromium.syncExec(() -> {
            OpenWindowListener[] openWindowListenerArray = this.openWindowListeners;
            int n = this.openWindowListeners.length;
            int n2 = 0;
            while (n2 < n) {
                OpenWindowListener listener = openWindowListenerArray[n2];
                listener.open(event);
                ++n2;
            }
        });
        if (event.browser != null) {
            if (target_url != null) {
                this.setUrl(target_url, null, null);
            }
            return true;
        }
        return event.browser == null && event.required;
    }

    private static void setLoadHandler() {
        loadHandler = new LoadHandler();
        clientHandler.addLoadHandler(loadHandler);
    }

    private void on_loading_state_change(boolean isLoading, boolean canGoBack, boolean canGoForward) {
        Engine.debug("on_loading_state_change: " + isLoading);
        if (this.isDisposed()) {
            return;
        }
        if (this.isPopup != null) {
            this.enableProgress.complete(true);
        } else {
            if (!this.enableProgress.isDone() && !isLoading) {
                this.enableProgress.complete(true);
                return;
            }
            if (!this.enableProgress.isDone()) {
                return;
            }
        }
        if (!isLoading) {
            ProgressEvent event = new ProgressEvent((Widget)this.chromium);
            event.display = this.chromium.getDisplay();
            event.widget = this.chromium;
            event.current = 100;
            event.total = 100;
            if (this.loadingPage) {
                this.loadingPage = false;
                this.debugPrint("progress completed");
                Chromium.asyncExec(() -> {
                    if (this.isDisposed()) {
                        return;
                    }
                    ProgressListener[] progressListenerArray = this.progressListeners;
                    int n = this.progressListeners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ProgressListener listener = progressListenerArray[n2];
                        listener.completed(event);
                        ++n2;
                    }
                });
            }
        }
    }

    private static void setDialogHandler() {
        dialogHandler = new DialogHandler();
        clientHandler.addDialogHandler(dialogHandler);
    }

    private boolean onFileDialog(CefDialogHandler.FileDialogMode mode, String title, String defaultFilePath, Vector<String> acceptFilters, CefFileDialogCallback callback) {
        if ("gtk".equals(SWT.getPlatform())) {
            String defaultDlgTitle;
            int swtMode;
            if (isOpenDialog) {
                return true;
            }
            switch (mode) {
                case FILE_DIALOG_OPEN_MULTIPLE: {
                    swtMode = 4098;
                    defaultDlgTitle = "Open Files";
                    break;
                }
                case FILE_DIALOG_SAVE: {
                    swtMode = 8192;
                    defaultDlgTitle = "Save File";
                    break;
                }
                default: {
                    swtMode = 4096;
                    defaultDlgTitle = "Open File";
                }
            }
            String dlgTitle = title == null || title.isEmpty() ? defaultDlgTitle : title;
            Thread thread = this.preventBlockUI();
            Chromium.asyncExec(() -> {
                FileDialog dlg = new FileDialog(this.chromium.getShell(), swtMode | 0x80);
                dlg.setText(dlgTitle);
                String[] acceptFiltersArray = MimeTypeLinux.getExtensions(acceptFilters);
                dlg.setFilterExtensions(acceptFiltersArray);
                dlg.setOverwrite(true);
                isOpenDialog = true;
                thread.start();
                String selected = dlg.open();
                isOpenDialog = false;
                if (selected != null) {
                    Vector<String> filePaths = new Vector<String>();
                    String[] stringArray = dlg.getFileNames();
                    int n2 = stringArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        String fileName = stringArray[n3];
                        filePaths.add(Paths.get(dlg.getFilterPath(), fileName).toString());
                        ++n3;
                    }
                    callback.Continue(filePaths);
                } else {
                    callback.Cancel();
                }
            });
            return true;
        }
        return false;
    }

    private static void setDisplayHandler() {
        displayHandler = new DisplayHandler();
        clientHandler.addDisplayHandler(displayHandler);
    }

    private void onTitleChange(String title) {
        if (this.isDisposed()) {
            return;
        }
        String str = this.getPlainUrl(title);
        TitleEvent event = new TitleEvent((Widget)this.chromium);
        event.display = this.chromium.getDisplay();
        event.widget = this.chromium;
        event.title = str;
        this.title = str != null ? str : "";
        Chromium.asyncExec(() -> {
            TitleListener[] titleListenerArray = this.titleListeners;
            int n = this.titleListeners.length;
            int n2 = 0;
            while (n2 < n) {
                TitleListener listener = titleListenerArray[n2];
                listener.changed(event);
                ++n2;
            }
        });
    }

    private void onAddressChange(CefFrame frame, String url) {
        if (this.isDisposed()) {
            return;
        }
        if (Chromium.allowTurboLink() && !ABOUT_BLANK.equals(url)) {
            if (!this.changedCache.containsKey(url)) {
                return;
            }
            this.changedCache.remove(url);
        }
        LocationEvent event = new LocationEvent((Widget)this.chromium);
        event.display = this.chromium.getDisplay();
        event.widget = this.chromium;
        event.doit = true;
        event.location = this.getPlainUrl(url);
        event.top = frame.isMain();
        if (!this.enableProgress.isDone()) {
            this.debugPrint("!on_address_change to " + event.location + " " + (event.top ? "main" : "!main"));
            return;
        }
        this.debugPrint("on_address_change to " + event.location + " " + (event.top ? "main" : "!main"));
        boolean crossOrigin = true;
        if (crossOrigin) {
            for (BrowserFunction current : this.functions.values()) {
                if (current.router == null) continue;
                this.getClientHandler().removeMessageRouter(current.router);
                this.getClientHandler().addMessageRouter(current.router);
            }
        }
        Chromium.asyncExec(() -> {
            LocationListener[] locationListenerArray = this.locationListeners;
            int n = this.locationListeners.length;
            int n2 = 0;
            while (n2 < n) {
                LocationListener listener = locationListenerArray[n2];
                listener.changed(event);
                ++n2;
            }
            this.loaded.complete(true);
        });
    }

    private void onStatusMessage(String status) {
        if (this.isDisposed()) {
            return;
        }
        StatusTextEvent event = new StatusTextEvent((Widget)this.chromium);
        event.display = this.chromium.getDisplay();
        event.widget = this.chromium;
        event.text = status;
        Chromium.asyncExec(() -> {
            StatusTextListener[] statusTextListenerArray = this.statusTextListeners;
            int n = this.statusTextListeners.length;
            int n2 = 0;
            while (n2 < n) {
                StatusTextListener listener = statusTextListenerArray[n2];
                listener.changed(event);
                ++n2;
            }
        });
    }

    private boolean onConsoleMessage(CefSettings.LogSeverity level, String message, String source, int line) {
        if (this.isDisposed()) {
            return false;
        }
        AtomicBoolean prevent = new AtomicBoolean();
        if (this.extraApi != null) {
            Chromium.syncExec(() -> prevent.set(this.extraApi.onConsoleMessage(this.cefBrowser, level, message, source, line)));
        }
        return prevent.get();
    }

    private void onLoadingProgressChange(CefBrowser browser, double progress) {
        if (!this.enableProgress.isDone() || this.isDisposed()) {
            return;
        }
        ProgressEvent event = new ProgressEvent((Widget)this.chromium);
        event.display = this.chromium.getDisplay();
        event.widget = this.chromium;
        event.current = (int)(progress * 100.0);
        event.total = 100;
        if (100 != event.current) {
            Chromium.asyncExec(() -> {
                ProgressListener[] progressListenerArray = this.progressListeners;
                int n = this.progressListeners.length;
                int n2 = 0;
                while (n2 < n) {
                    ProgressListener listener = progressListenerArray[n2];
                    listener.changed(event);
                    ++n2;
                }
            });
        }
    }

    private void onFullscreenModeChange(CefBrowser browser, boolean fullScreen) {
        if (this.isDisposed()) {
            return;
        }
        Chromium.syncExec(() -> {
            this.chromium.getShell().setFullScreen(fullScreen);
            Shell cefBrowserShell = this.cefBrowser.getComposite().getShell();
            if (!fullScreen) {
                if (this.fullscreenListener != null) {
                    cefBrowserShell.removeControlListener((ControlListener)this.fullscreenListener);
                    this.fullscreenListener = null;
                }
                this.cefBrowser.resize();
                return;
            }
            this.fullscreenListener = new ControlAdapter(){
                boolean isFirtsResized = !"win32".equals(SWT.getPlatform());

                public void controlResized(ControlEvent arg0) {
                    if (!this.isFirtsResized) {
                        Chromium.this.execute("if(document.exitFullscreen) { document.exitFullscreen(); }");
                    }
                    this.isFirtsResized = false;
                }
            };
            cefBrowserShell.addControlListener((ControlListener)this.fullscreenListener);
        });
    }

    private static void setRequestHandler() {
        requestHandler = new RequestHandler();
        clientHandler.addRequestHandler(requestHandler);
    }

    private static boolean allowTurboLink() {
        String[] turbolink = System.getProperty("chromium.turbolinks", "").split(";");
        return "true".equals(turbolink[0]) || turbolink[0].contains("=");
    }

    private boolean onBeforeBrowse(CefFrame frame, CefRequest request) {
        if (this.isDisposed()) {
            return false;
        }
        this.inEvalBlocking = true;
        LocationEvent event = new LocationEvent((Widget)this.chromium);
        event.display = this.chromium.getDisplay();
        event.widget = this.chromium;
        event.doit = true;
        event.top = frame.isMain();
        event.location = this.getPlainUrl(request.getURL());
        this.debugPrint("on_before_browse:" + event.location + " top:" + event.top);
        try {
            Chromium.syncExec(() -> {
                LocationListener[] locationListenerArray = this.locationListeners;
                int n = this.locationListeners.length;
                int n2 = 0;
                while (n2 < n) {
                    LocationListener listener = locationListenerArray[n2];
                    listener.changing(event);
                    ++n2;
                }
            });
        }
        finally {
            this.inEvalBlocking = false;
        }
        if (Chromium.allowTurboLink()) {
            this.changedCache.put(event.location, true);
        }
        if (!event.doit) {
            this.debugPrint("canceled nav");
            this.enableProgress = new CompletableFuture();
        } else {
            this.loadingPage = true;
        }
        return !event.doit;
    }

    protected CefResourceHandler createFunctionResourceHandler() {
        this.functionsResourceHandler.push(new FunctionsResourceHandler());
        return this.functionsResourceHandler.peek();
    }

    private void getAuthCredentials(String origin_url, String host, int port, String realm, String scheme, CefAuthCallback callback) {
        if (this.isDisposed()) {
            return;
        }
        String protocol = "http";
        try {
            URL u = new URL(this.url);
            protocol = u.getProtocol();
        }
        catch (MalformedURLException u) {
            // empty catch block
        }
        AuthenticationEvent event = new AuthenticationEvent((Widget)this.chromium);
        event.display = this.chromium.getDisplay();
        event.widget = this.chromium;
        event.doit = true;
        event.location = String.valueOf(protocol) + "://" + host;
        this.debugPrint("get_auth_credentials: " + event.location);
        Chromium.syncExec(() -> {
            AuthenticationListener[] authenticationListenerArray = this.authenticationListeners;
            int n = this.authenticationListeners.length;
            int n2 = 0;
            while (n2 < n) {
                AuthenticationListener listener = authenticationListenerArray[n2];
                listener.authenticate(event);
                ++n2;
            }
            if (authenticationEvent.doit && authenticationEvent.user == null && authenticationEvent.password == null) {
                new AuthDialog(this.chromium.getShell()).open(event, realm, callback);
            }
            if (authenticationEvent.doit) {
                callback.Continue(authenticationEvent.user, authenticationEvent.password);
            } else {
                callback.cancel();
            }
        });
    }

    private boolean onCertificateError(CefLoadHandler.ErrorCode cert_error, String request_url, CefCallback callback) {
        if (this.extraApi().isIgnoreCertificateErrors()) {
            callback.Continue();
            return true;
        }
        if (this.extraApi().handleCertificateProperty()) {
            return false;
        }
        Chromium.asyncExec(() -> {
            String javaHost = request_url;
            Consumer<Integer> close = result -> {
                if (result == 64) {
                    callback.Continue();
                } else {
                    callback.cancel();
                }
            };
            if ("test".equals(System.getProperty("chromium.dialogs", ""))) {
                this.headlessDialog(close);
                return;
            }
            MessageBox prompt = new MessageBox(this.chromium.getShell(), 192);
            prompt.setText(SWT.getMessage((String)"SWT_InvalidCert_Title"));
            String cefError = cert_error.toString();
            String specific = cefError.isEmpty() ? "\n\n" : "\n\n" + cefError + "\n\n";
            String message = String.valueOf(SWT.getMessage((String)"SWT_InvalidCert_Message", (Object[])new Object[]{javaHost})) + specific + SWT.getMessage((String)"SWT_InvalidCert_Connect");
            prompt.setMessage(message);
            int result2 = prompt.open();
            close.accept(result2);
        });
        return true;
    }

    private static void setJsdialogHandler() {
        jsDialogHandler = new JsDialogHandler();
        clientHandler.addJSDialogHandler(jsDialogHandler);
    }

    private boolean onJsdialog(CefBrowser browser, String origin_url, CefJSDialogHandler.JSDialogType dialog_type, String message_text, String default_prompt_text, CefJSDialogCallback callback, BoolRef suppress_message) {
        String use;
        if (this.isDisposed() && !browser.isPopup()) {
            return false;
        }
        String prompt = default_prompt_text;
        String url = origin_url;
        String title = this.getPlainUrl(url);
        switch (use = System.getProperty("chromium.dialogs", "swt")) {
            case "swt-host": {
                try {
                    title = new URL(this.getPlainUrl(url)).getHost();
                }
                catch (MalformedURLException e) {
                    title = "";
                }
                break;
            }
            case "swt-empty": {
                title = "";
                break;
            }
            case "swt-title": {
                title = this.title;
            }
        }
        this.openJsDialog(browser.isPopup(), dialog_type, title, message_text, prompt, default_prompt_text, callback);
        return true;
    }

    private Shell getShell(boolean condition, AtomicBoolean disposeDialog) {
        if (condition) {
            return this.chromium.getShell();
        }
        disposeDialog.set(true);
        return new Shell();
    }

    public void openJsDialog(boolean isPopup, CefJSDialogHandler.JSDialogType dialog_type, String title, String msg, String prompt, String default_prompt_text, CefJSDialogCallback callback) {
        Consumer<Integer> close = open -> {
            boolean r = open == 32 || open == 64;
            Engine.debug("JS Dialog Closed with " + r);
            if (this.browser != null && !isPopup) {
                if (!(this.disposing != Dispose.Unload && this.disposing != Dispose.WaitIfClosed || r)) {
                    this.disposing = Dispose.UnloadCancel;
                }
                Chromium.asyncExec(() -> callback.Continue(r, default_prompt_text));
                this.chromium.getShell().forceActive();
            } else {
                Chromium.asyncExec(() -> callback.Continue(r, default_prompt_text));
            }
        };
        Chromium.asyncExec(() -> {
            int style = 16;
            switch (dialog_type) {
                case JSDIALOGTYPE_ALERT: {
                    style = 2;
                    break;
                }
                case JSDIALOGTYPE_CONFIRM: {
                    style = 296;
                    break;
                }
                case JSDIALOGTYPE_PROMPT: {
                    style = 292;
                }
            }
            if (!"test".equals(System.getProperty("chromium.dialogs", "")) || this.browser == null) {
                AtomicBoolean disposeDialog = new AtomicBoolean(false);
                Shell shell = this.getShell(this.browser != null && !isPopup, disposeDialog);
                MessageBox box = new MessageBox(shell, style);
                box.setText(title);
                box.setMessage(prompt != null ? String.valueOf(msg) + "\n\n" + prompt : msg);
                isOpenDialog = true;
                int open = box.open();
                isOpenDialog = false;
                if (disposeDialog.get()) {
                    shell.dispose();
                }
                close.accept(open);
            } else {
                this.headlessDialog(close);
            }
        });
    }

    private void headlessDialog(Consumer<Integer> close) {
        CompletableFuture f = (CompletableFuture)this.chromium.getData("chromium.dialogs");
        if (f != null) {
            f.thenAccept(close);
            this.chromium.setData("chromium.dialogs", null);
            Display display = this.chromium.getDisplay();
            while (!f.isDone() && !display.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
    }

    private void onDialogClosed() {
        Engine.debug("on_dialog_closed_cb disposing: " + (Object)((Object)this.disposing));
        if (this.disposing == Dispose.Unload) {
            this.disposing = Dispose.UnloadClosed;
        }
    }

    private boolean onBeforeUnloadDialog(String message_text, boolean is_reload, CefJSDialogCallback callback) {
        Engine.debug("on_before_unload_dialog disposing: " + (Object)((Object)this.disposing));
        if (this.disposing == Dispose.FromClose) {
            this.disposing = Dispose.Unload;
        }
        if (Chromium.useSwtDialogs()) {
            this.openJsDialog(false, CefJSDialogHandler.JSDialogType.JSDIALOGTYPE_CONFIRM, "Are you sure you want to leave this page?", message_text, null, null, callback);
            if (this.disposing == Dispose.Unload) {
                this.disposing = Dispose.UnloadClosed;
            }
            return true;
        }
        return false;
    }

    private static boolean useSwtDialogs() {
        return "gtk".equals(SWT.getPlatform()) || !"native".equals(System.getProperty("chromium.dialogs", "swt"));
    }

    private static void setContextMenuHandler() {
        contextMenuHandler = new ContextMenuHandler();
        clientHandler.addContextMenuHandler(contextMenuHandler);
    }

    private void onBeforeContextMenu(CefMenuModel model) {
        boolean hasMenu = Chromium.syncExec(() -> this.chromium.getMenu() != null);
        if (hasMenu) {
            model.clear();
            if (Boolean.getBoolean("chromium.hide_context_menu")) {
                return;
            }
            boolean isGTK = "gtk".equals(SWT.getPlatform());
            if (isGTK && GTK_VERSION == 2) {
                int commandIdCounter = 26500;
                Chromium.copyMenu(Chromium.syncExec(() -> this.chromium.getMenu()), model, commandIdCounter);
            } else {
                Chromium.asyncExec(() -> {
                    if (isGTK) {
                        Display.getDefault().timerExec(200, () -> this.chromium.getMenu().setVisible(true));
                    } else {
                        this.chromium.getMenu().setVisible(true);
                    }
                });
            }
        } else if (CHROME_RUNTIME) {
            this.clearExtraMenuItem(model);
        }
    }

    private void clearExtraMenuItem(CefMenuModel menu) {
        int i = menu.getCount() - 1;
        while (i >= 0) {
            String label = menu.getLabelAt(i).toLowerCase();
            if (label.contains("save") || label.contains("cast") || label.contains("qr") || label.contains("nspect") || label.contains("search google")) {
                if (menu.hasAcceleratorAt(i)) {
                    menu.removeAcceleratorAt(i);
                }
                menu.removeAt(i);
            } else if (menu.getTypeAt(i).equals((Object)CefMenuModel.MenuItemType.MENUITEMTYPE_SEPARATOR)) {
                menu.removeAt(i);
            }
            --i;
        }
    }

    public boolean onContextMenuCommand(CefContextMenuParams params, int commandId) {
        if (GTK_VERSION == 2) {
            AtomicBoolean ab = new AtomicBoolean();
            Chromium.syncExec(() -> {
                Menu menu = this.chromium.getMenu();
                if (menu != null) {
                    ab.set(this.handleMenuEvent(menu, commandId, params));
                }
            });
            return ab.get();
        }
        return false;
    }

    private boolean handleMenuEvent(Menu menu, int commandId, CefContextMenuParams params) {
        MenuItem[] menuItemArray = menu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            int myCommandId;
            MenuItem menuItem = menuItemArray[n2];
            boolean wasHandled = false;
            if (menuItem.getMenu() != null) {
                wasHandled = this.handleMenuEvent(menuItem.getMenu(), commandId, params);
            }
            if (!wasHandled && commandId == (myCommandId = ((Integer)menuItem.getData("commandId")).intValue())) {
                Listener[] listeners = menuItem.getListeners(13);
                Event event = new Event();
                event.display = menuItem.getDisplay();
                event.data = menuItem.getData();
                event.item = menuItem;
                event.widget = menuItem;
                event.type = 13;
                event.y = params.getYCoord();
                event.x = params.getXCoord();
                Listener[] listenerArray = listeners;
                if (listeners.length != 0) {
                    Listener listener = listenerArray[0];
                    Chromium.asyncExec(() -> listener.handleEvent(event));
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public static CefMenuModel copyMenu(Menu originalMenu, CefMenuModel copiedMenu, int commandIdCounter) {
        MenuItem[] menuItemArray = Chromium.syncExec(() -> originalMenu.getItems());
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem menuItem = menuItemArray[n2];
            AtomicInteger commandIdCounterAtomic = new AtomicInteger(++commandIdCounter);
            Chromium.syncExec(() -> menuItem.setData("commandId", (Object)commandIdCounterAtomic.get()));
            int style = Chromium.syncExec(() -> menuItem.getStyle());
            String label = Chromium.syncExec(() -> menuItem.getText());
            boolean enabled = Chromium.syncExec(() -> menuItem.isEnabled());
            boolean checked = Chromium.syncExec(() -> menuItem.getSelection());
            if ((style & 0x20) != 0) {
                copiedMenu.addCheckItem(commandIdCounter, label);
                copiedMenu.setEnabledAt(commandIdCounter, enabled);
                copiedMenu.setChecked(commandIdCounter, checked);
            } else if ((style & 8) != 0) {
                copiedMenu.addItem(commandIdCounter, label);
            } else if ((style & 0x10) != 0) {
                copiedMenu.addRadioItem(commandIdCounter, label, 0);
                copiedMenu.setEnabledAt(commandIdCounter, enabled);
                copiedMenu.setChecked(commandIdCounter, checked);
            } else if ((style & 0x40) != 0) {
                Menu subMenu = Chromium.syncExec(() -> menuItem.getMenu());
                if (subMenu != null) {
                    CefMenuModel subMenuModel = copiedMenu.addSubMenu(commandIdCounter, label);
                    Chromium.copyMenu(subMenu, subMenuModel, commandIdCounter);
                }
            } else if ((style & 2) != 0) {
                copiedMenu.addSeparator();
            }
            copiedMenu.setEnabledAt(commandIdCounter, enabled);
            copiedMenu.setVisible(commandIdCounter, true);
            ++n2;
        }
        return copiedMenu;
    }

    private static void setDownloadHandler() {
        downloadHandler = new DownloadHandler();
        clientHandler.addDownloadHandler(downloadHandler);
    }

    private static void setPrintHandler() {
        clientHandler.addPrintHandler(new CefPrintHandlerAdapter(){});
    }

    private void onBeforeDownload(CefDownloadItem download_item, String suggested_name, CefBeforeDownloadCallback callback) {
        String name = suggested_name;
        DownloadItem downloadItem = new DownloadItem(download_item);
        if (Boolean.getBoolean("chromium.downloadLocationListener")) {
            LocationEvent event = new LocationEvent((Widget)this.chromium);
            event.display = this.chromium.getDisplay();
            event.widget = this.chromium;
            event.doit = true;
            event.location = this.getPlainUrl(downloadItem.url);
            LocationListener[] locationListenerArray = this.locationListeners;
            int n = this.locationListeners.length;
            int n2 = 0;
            while (n2 < n) {
                LocationListener listener = locationListenerArray[n2];
                listener.changing(event);
                ++n2;
            }
            if (!event.doit) {
                return;
            }
        }
        Chromium.asyncExec(() -> {
            if ("test".equals(System.getProperty("chromium.dialogs", ""))) {
                Consumer<Integer> close = open -> {
                    boolean r = open == 32 || open == 64;
                    Engine.debug("JS Dialog Closed with " + r);
                    if (r) {
                        if (downloadItem.isValid) {
                            Download d = new Download(downloadItem, name, this);
                            d.isReady = true;
                        }
                        callback.Continue("", false);
                    }
                };
                this.headlessDialog(close);
                return;
            }
            if ("gtk".equals(SWT.getPlatform())) {
                if (isOpenDialog) {
                    Download d = new Download(downloadItem, null, this);
                    d.isReady = true;
                    return;
                }
                AtomicBoolean disposeDialog = new AtomicBoolean(false);
                Shell shell = this.getShell(this.chromium != null && !this.chromium.isDisposed(), disposeDialog);
                FileDialog dlg = new FileDialog(shell, 8320);
                dlg.setText("Save File");
                dlg.setOverwrite(true);
                if (name != null && !name.isEmpty()) {
                    dlg.setFileName(name);
                }
                Thread thread = this.preventBlockUI();
                Chromium.asyncExec(() -> {
                    isOpenDialog = true;
                    thread.start();
                    String selected = dlg.open();
                    isOpenDialog = false;
                    if (disposeDialog.get()) {
                        shell.dispose();
                    }
                    if (selected != null && downloadItem.isValid) {
                        Download d = new Download(downloadItem, selected, this);
                        d.isReady = true;
                        callback.Continue(selected, false);
                        return;
                    }
                    Download d = new Download(downloadItem, null, this);
                    d.isReady = true;
                });
            } else {
                if (downloadItem.isValid) {
                    new Download(downloadItem, name, this);
                }
                callback.Continue("", true);
            }
        });
    }

    private Thread preventBlockUI() {
        Thread thread = new Thread(() -> {
            while (isOpenDialog) {
                try {
                    Thread.sleep(100L);
                    Display.getDefault().asyncExec(null);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        return thread;
    }

    private static void onDownloadUpdated(int browserId, CefDownloadItem download_item, CefDownloadItemCallback callback) {
        if (download_item.isValid()) {
            Chromium.asyncExec(() -> {
                Download download = Download.downloads.get(download_item.getId());
                if (download != null && download.isReady) {
                    download.update(download_item, callback);
                    if (download_item.isCanceled() || !download.isReady) {
                        download.dispose();
                    } else if (!download.open && !Boolean.getBoolean("chromium.disable-download-progress")) {
                        download.show();
                    }
                }
            });
        }
    }

    private static void setKeyboardHandler() {
        keyboardHandler = new KeyboardHandler();
        clientHandler.addKeyboardHandler(keyboardHandler);
    }

    private boolean on_key_event(CefKeyboardHandler.CefKeyEvent event) {
        if (this.isDisposed()) {
            return false;
        }
        Event firedEvent = new Event();
        if (event.type == CefKeyboardHandler.CefKeyEvent.EventType.KEYEVENT_KEYDOWN || event.type == CefKeyboardHandler.CefKeyEvent.EventType.KEYEVENT_RAWKEYDOWN) {
            firedEvent.type = 1;
        } else if (event.type == CefKeyboardHandler.CefKeyEvent.EventType.KEYEVENT_KEYUP) {
            firedEvent.type = 2;
        } else {
            return false;
        }
        int translateKey = event.windows_key_code == 91 || event.windows_key_code == 93 ? 0x400000 : this.translateKey(event.windows_key_code);
        firedEvent.keyCode = translateKey != 0 ? translateKey : event.windows_key_code;
        firedEvent.widget = this.chromium;
        firedEvent.character = event.character;
        firedEvent.display = this.chromium.getDisplay();
        int stateMask = 0;
        if (cef_event_flags.CAPS_LOCK_ON.shouldSetState(event.modifiers, firedEvent)) {
            stateMask += 16777298;
        }
        if (cef_event_flags.SHIFT_DOWN.shouldSetState(event.modifiers, firedEvent)) {
            stateMask += 131072;
        }
        if (cef_event_flags.CONTROL_DOWN.shouldSetState(event.modifiers, firedEvent)) {
            stateMask += 262144;
        }
        if (cef_event_flags.ALT_DOWN.shouldSetState(event.modifiers, firedEvent)) {
            stateMask += 65536;
        }
        if (cef_event_flags.COMMAND_DOWN.shouldSetState(event.modifiers, firedEvent)) {
            stateMask += 0x400000;
        }
        if (cef_event_flags.NUM_LOCK_ON.shouldSetState(event.modifiers, firedEvent)) {
            stateMask += 16777299;
        }
        if (cef_event_flags.IS_KEY_PAD.shouldSetState(event.modifiers, firedEvent)) {
            stateMask += 2;
        }
        if (cef_event_flags.IS_LEFT.shouldSetState(event.modifiers, firedEvent)) {
            stateMask += 16384;
        }
        if (cef_event_flags.IS_RIGHT.shouldSetState(event.modifiers, firedEvent)) {
            stateMask += 131072;
        }
        firedEvent.stateMask = stateMask;
        Chromium.asyncExec(() -> {
            if (!this.isDisposed()) {
                this.sendKeyEvent(firedEvent);
            }
        });
        if (firedEvent.doit && "cocoa".equals(SWT.getPlatform())) {
            CefFrame cefFrame;
            CefFrame focusedFrame = this.cefBrowser.getFocusedFrame();
            CefFrame cefFrame2 = cefFrame = focusedFrame != null ? focusedFrame : this.cefBrowser.getMainFrame();
            if (event.modifiers == 128 && event.type != CefKeyboardHandler.CefKeyEvent.EventType.KEYEVENT_RAWKEYDOWN) {
                if (event.native_key_code >= 8 && event.native_key_code <= 9) {
                    return true;
                }
            } else {
                if (event.modifiers == 128 && event.type == CefKeyboardHandler.CefKeyEvent.EventType.KEYEVENT_RAWKEYDOWN) {
                    switch (event.native_key_code) {
                        case 0: {
                            cefFrame.selectAll();
                            return true;
                        }
                        case 8: {
                            cefFrame.copy();
                            return true;
                        }
                        case 9: {
                            cefFrame.paste();
                            CefApp.getInstance().doMessageLoopWork(-1L);
                            return true;
                        }
                        case 7: {
                            cefFrame.cut();
                            return true;
                        }
                        case 6: {
                            cefFrame.undo();
                            CefApp.getInstance().doMessageLoopWork(-1L);
                            return true;
                        }
                    }
                    return false;
                }
                if (event.modifiers == 130 && event.type == CefKeyboardHandler.CefKeyEvent.EventType.KEYEVENT_RAWKEYDOWN && event.native_key_code == 6) {
                    cefFrame.redo();
                    CefApp.getInstance().doMessageLoopWork(-1L);
                    return true;
                }
            }
        }
        if (this.fullscreenListener != null && event.windows_key_code == 27 && event.type == CefKeyboardHandler.CefKeyEvent.EventType.KEYEVENT_RAWKEYDOWN) {
            Chromium.syncExec(() -> this.cefBrowser.getComposite().getShell().setFullScreen(false));
            this.execute("document.exitFullscreen()");
        }
        return false;
    }

    private static void setFocusHandler() {
        focusHandler = new FocusHandler();
        clientHandler.addFocusHandler(focusHandler);
    }

    private void onGotFocus() {
        Chromium.syncExec(() -> {
            if (this.isDisposed()) {
                return;
            }
            if (this.chromium.getDisplay().getFocusControl() != this.chromium && this.focusListener != null) {
                this.debugPrint("on_got_focus: setFocus");
                boolean focusListenerPrev = this.focusListener.enabled;
                this.focusListener.enabled = false;
                this.chromium.setFocus();
                this.focusListener.enabled = focusListenerPrev;
            } else {
                "gtk".equals(SWT.getPlatform());
            }
            if ("win32".equals(SWT.getPlatform()) && this.focusListener != null) {
                this.focusListener.enabled = true;
            }
            this.hasFocus = true;
        });
    }

    private boolean onSetFocus(CefFocusHandler.FocusSource focusSource) {
        boolean chromiumFocusControl;
        if (this.isDisposed()) {
            return true;
        }
        boolean bl = "gtk".equals(SWT.getPlatform()) ? true : (chromiumFocusControl = Chromium.syncExec(() -> this.chromium.getDisplay().getFocusControl()) != this.chromium);
        if (this.ignoreFirstFocus && chromiumFocusControl && focusSource == CefFocusHandler.FocusSource.FOCUS_SOURCE_NAVIGATION) {
            this.debugPrint("ignoreFirstFocus");
            this.ignoreFirstFocus = false;
            return true;
        }
        if (Chromium.syncExec(() -> this.isDisposed() ? true : this.chromium.isFocusControl()).booleanValue()) {
            if (this.focusListener != null) {
                this.focusListener.enabled = true;
            }
        } else if ("win32".equals(SWT.getPlatform()) && winSkipFocus) {
            winSkipFocus = false;
        } else {
            if (this.focusListener != null && !"gtk".equals(SWT.getPlatform())) {
                this.focusListener.enabled = false;
            }
            return true;
        }
        this.hasFocus = true;
        return false;
    }

    private Composite getParent(Composite composite) {
        Composite parent = composite;
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        return parent;
    }

    private List<Control> getTabList(Composite composite) {
        ArrayList<Control> tabOrder = new ArrayList<Control>();
        Control[] controlArray = composite.getTabList();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c.isVisible() && !(c instanceof Label)) {
                if (c instanceof Composite && ((Composite)c).getTabList().length > 0) {
                    tabOrder.addAll(this.getTabList((Composite)c));
                } else {
                    tabOrder.add(c);
                }
            }
            ++n2;
        }
        return tabOrder;
    }

    private void onTakeFocus(boolean next) {
        if (this.isDisposed()) {
            return;
        }
        this.hasFocus = false;
        Chromium.syncExec(() -> {
            List<Control> tabOrder = this.getTabList(this.getParent(this.chromium));
            int indexOf = tabOrder.indexOf(this.chromium);
            if (indexOf != -1) {
                int newIndex;
                int n = newIndex = next ? indexOf + 1 : indexOf - 1;
                if (newIndex > 0 && newIndex < tabOrder.size() && !tabOrder.get(newIndex).isDisposed()) {
                    tabOrder.get(newIndex).setFocus();
                    return;
                }
            }
            Control nextFocus = tabOrder.get(0);
            if (!(this.isDisposed() || this.chromium.getParent().isDisposed() || nextFocus.isDisposed())) {
                nextFocus.setFocus();
            }
        });
    }

    @Override
    public boolean isFocusControl() {
        return "gtk".equals(SWT.getPlatform()) ? this.hasFocus : false;
    }

    private synchronized void checkBrowser() {
        if (this.cefBrowser == null) {
            SWT.error((int)24);
        }
    }

    @Override
    public boolean close() {
        if (this.disposing != Dispose.No || this.isDisposed()) {
            return false;
        }
        if (this.cefBrowser == null) {
            return true;
        }
        boolean closed = false;
        this.debugPrint("call try_close_browser");
        this.disposing = Dispose.FromClose;
        this.cefBrowser.close(false);
        long t = System.currentTimeMillis();
        long end = t + 10000L;
        Shell shell = this.chromium.getShell();
        Display display = shell.getDisplay();
        while (!shell.isDisposed() && System.currentTimeMillis() < end) {
            if (this.disposing == Dispose.Unload) {
                end += 1000L;
            } else {
                if (this.disposing == Dispose.UnloadCancel) {
                    Engine.debug("in close, disposing:" + (Object)((Object)this.disposing));
                    break;
                }
                if (this.disposing == Dispose.UnloadClosed) {
                    Engine.debug("in close, disposing:" + (Object)((Object)this.disposing));
                    this.disposing = Dispose.WaitIfClosed;
                    end = System.currentTimeMillis() + 600L;
                } else if (this.disposing == Dispose.DoIt) {
                    Engine.debug("in close, disposing:" + (Object)((Object)this.disposing));
                    closed = true;
                    break;
                }
            }
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (!closed) {
            this.disposing = Dispose.No;
        }
        return closed;
    }

    @Override
    public void dispose() {
        this.debugPrint("in dispose, disposing " + (Object)((Object)this.disposing));
        if (this.created != null && !this.created.isDone() && this.cefBrowser != null) {
            this.cefBrowser.close(false);
            Shell shell = this.chromium.getShell();
            Display display = shell.getDisplay();
            while (!shell.isDisposed() && !this.created.isDone()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        if (this.disposing == Dispose.FromDispose || this.isDisposed()) {
            return;
        }
        if (this.disposing != Dispose.FromBrowser) {
            this.disposing = Dispose.FromDispose;
        }
        if (this.focusListener != null) {
            this.chromium.removeFocusListener((FocusListener)this.focusListener);
        }
        this.focusListener = null;
        if (this.traverseListener != null) {
            this.chromium.removeListener(31, this.traverseListener);
            this.chromium.removeListener(1, this.traverseListener);
            this.traverseListener = null;
        }
        if (this.resize != null) {
            this.resize.remove();
        }
    }

    private void deleteTempFolder() {
        Path tempFilesToDelete = this.getBrowserTempFolder();
        if (!Files.exists(tempFilesToDelete, new LinkOption[0])) {
            return;
        }
        try {
            Files.walk(tempFilesToDelete, new FileVisitOption[0]).sorted((path1, path2) -> -path1.compareTo((Path)path2)).forEach(t -> {
                try {
                    Files.deleteIfExists(t);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void setupCookies() {
        WebBrowser.NativeClearSessions = () -> Engine.ready.thenRun(() -> {
            CefCookieManager globalManager = CefCookieManager.getGlobalManager();
            if (globalManager != null) {
                globalManager.deleteCookies(null, null);
            }
            CefCompletionCallback callback = new CefCompletionCallback(){

                @Override
                public void onComplete() {
                    Engine.debug("certificate exceptions cleared");
                }
            };
            CefRequestContext.getGlobalContext().clearCertificateExceptions(callback);
        });
        WebBrowser.NativeClearCookies = () -> Engine.ready.thenRun(() -> {
            CefCookieManager globalManager = CefCookieManager.getGlobalManager();
            if (globalManager != null) {
                CefCookieVisitor visitor = new CefCookieVisitor(){

                    @Override
                    public boolean visit(CefCookie cookie, int count, int total, BoolRef delete) {
                        if (cookie.domain.matches(WebBrowser.ClearCookieUrl) && cookie.name.matches(WebBrowser.ClearCookieName)) {
                            Engine.debug("Delete Cookie: " + cookie.name);
                            delete.set(true);
                        }
                        return true;
                    }
                };
                WebBrowser.CookieResult = globalManager.visitAllCookies(visitor);
                globalManager.flushStore(null);
            }
        });
        WebBrowser.NativeSetCookie = () -> {
            List<HttpCookie> cookies = HttpCookie.parse(WebBrowser.CookieValue);
            Iterator<HttpCookie> iterator = cookies.iterator();
            if (iterator.hasNext()) {
                HttpCookie cookie = iterator.next();
                long age = cookie.getMaxAge();
                if (age != -1L) {
                    age = Instant.now().plusSeconds(age).getEpochSecond();
                }
                Date now = new Date();
                Date expires = new Date(age);
                CefCookie cefCookie = new CefCookie(cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), cookie.getSecure(), cookie.isHttpOnly(), now, now, cookie.getMaxAge() != -1L, expires);
                String cookieUrl = WebBrowser.CookieUrl;
                Engine.ready.thenRun(() -> {
                    CefCookieManager globalManager = CefCookieManager.getGlobalManager();
                    if (globalManager != null) {
                        WebBrowser.CookieResult = globalManager.setCookie(cookieUrl, cefCookie);
                        globalManager.flushStore(null);
                    }
                });
            }
        };
        if (NativePendingCookies != null) {
            Chromium.SetPendingCookies(NativePendingCookies);
            NativePendingCookies = null;
        }
        WebBrowser.NativeGetCookie = () -> {
            final AtomicBoolean cookieVisited = new AtomicBoolean();
            CefCookieVisitor visitor = new CefCookieVisitor(){

                @Override
                public boolean visit(CefCookie cookie, int count, int total, BoolRef delete) {
                    if (WebBrowser.CookieName != null && WebBrowser.CookieName.equals(cookie.name)) {
                        Engine.debug("cookie value: " + cookie.value);
                        WebBrowser.CookieValue = cookie.value;
                        cookieVisited.set(true);
                        return false;
                    }
                    if (count + 1 == total) {
                        cookieVisited.set(true);
                    }
                    return true;
                }
            };
            CefCookieManager globalManager = CefCookieManager.getGlobalManager();
            if (globalManager == null) {
                throw new SWTException("Failed to get cookies, cookie manager not ready");
            }
            boolean result = globalManager.visitUrlCookies(WebBrowser.CookieUrl, true, visitor);
            if (!result) {
                throw new SWTException("Failed to get cookies");
            }
            long end = System.currentTimeMillis() + 50L;
            Display display = Display.getCurrent() == null ? Display.getDefault() : Display.getCurrent();
            while (!cookieVisited.get() && !display.isDisposed() && System.currentTimeMillis() < end) {
                if (display.readAndDispatch() || CefApp.getInstance().getAllClients().isEmpty()) continue;
                display.sleep();
            }
        };
    }

    @Override
    public boolean back() {
        if (this.cefBrowser != null && this.cefBrowser.canGoBack()) {
            this.cefBrowser.goBack();
            return true;
        }
        return false;
    }

    @Override
    public boolean forward() {
        if (this.cefBrowser != null && this.cefBrowser.canGoForward()) {
            this.cefBrowser.goForward();
            return true;
        }
        return false;
    }

    @Override
    public boolean execute(String script) {
        if (!this.jsEnabled) {
            return false;
        }
        this.enableProgress.thenRun(() -> this.cefBrowser.executeJavaScript(script, this.getPlainUrl(this.url), 1));
        return true;
    }

    @Override
    public Object evaluate(String script) throws SWTException {
        if (!this.jsEnabled) {
            return null;
        }
        if (this.cefBrowser == null) {
            this.createBrowser();
        }
        this.checkBrowser();
        AbstractEval eval = null;
        boolean destroy = false;
        try {
            if (!this.functionsResourceHandler.isEmpty() && this.functionsResourceHandler.peek().inFunction) {
                eval = new EvalBrowserFunctionImpl(router, this.functionsResourceHandler.peek());
            } else if (this.inEvalBlocking) {
                if (this.eval == null) {
                    this.eval = new EvalFileImpl(this, this.cefBrowser);
                    destroy = true;
                }
                eval = this.eval;
            } else {
                eval = new EvalSimpleImpl(this.cefBrowser, router, this.getPlainUrl(this.url));
            }
            Object object = ((AbstractEval)eval).eval(script, this.created);
            return object;
        }
        catch (InterruptedException e) {
            throw new SWTException("Script that was evaluated failed");
        }
        catch (ExecutionException e) {
            throw (SWTException)e.getCause();
        }
        finally {
            if (destroy) {
                this.eval = null;
            }
        }
    }

    static String encodeType(Object ret) {
        try {
            return Jsoner.serialize(ret);
        }
        catch (IllegalArgumentException e) {
            throw new SWTException(String.valueOf(new SWTException(51).getMessage()) + ": " + ret.getClass().getName());
        }
    }

    @Override
    public String getBrowserType() {
        return "chromium";
    }

    @Override
    public String getText() {
        if (this.cefBrowser != null && !this.isDisposed() && this.disposing == Dispose.No) {
            final CompletableFuture textVisited = new CompletableFuture();
            CefStringVisitor visitor = new CefStringVisitor(){

                @Override
                public void visit(String string) {
                    if (string != null) {
                        Chromium.this.debugPrint("text visited completed");
                        textVisited.complete(string);
                    } else {
                        textVisited.complete("");
                        Chromium.this.debugPrint("text visited null");
                    }
                }
            };
            this.created.thenRun(() -> this.cefBrowser.getSource(visitor));
            Display display = this.chromium.getDisplay();
            while (!textVisited.isDone() && !display.isDisposed()) {
                Engine.debug("in text loop");
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            try {
                return (String)textVisited.get(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                // empty catch block
            }
        }
        return "";
    }

    @Override
    public String getUrl() {
        if (this.cefBrowser == null) {
            if (this.url == null) {
                return ABOUT_BLANK;
            }
            return this.getPlainUrl(this.url);
        }
        String cefurl = this.cefBrowser.getURL();
        if (cefurl == null) {
            cefurl = this.getPlainUrl(this.url);
        }
        if (cefurl != null && cefurl.startsWith("file:") && cefurl.contains(this.getBrowserTempFolder().toUri().toString())) {
            return ABOUT_BLANK;
        }
        return cefurl;
    }

    @Override
    public boolean isBackEnabled() {
        if (this.cefBrowser == null) {
            return false;
        }
        return this.cefBrowser.canGoBack();
    }

    @Override
    public boolean isForwardEnabled() {
        if (this.cefBrowser == null) {
            return false;
        }
        return this.cefBrowser.canGoForward();
    }

    @Override
    public Object getWebBrowser() {
        return this.extraApi();
    }

    private ExtraApi extraApi() {
        if (this.extraApi == null) {
            this.extraApi = new ExtraApi();
            this.extraApi.setCreated();
        }
        return this.extraApi;
    }

    @Override
    public void refresh() {
        this.jsEnabled = this.jsEnabledOnNextPage;
        if (this.cefBrowser != null) {
            this.cefBrowser.reload();
        }
    }

    public Path getBrowserTempFolder() {
        String tempPath = System.getProperty("java.io.tmpdir");
        String id = "chromium-" + this.hashCode();
        return Paths.get(tempPath, id);
    }

    @Override
    public boolean setText(String html, boolean trusted) {
        String texturl = Base64.getEncoder().encodeToString(html.getBytes());
        String setTextNewUrl = System.getProperty("chromium.setTextAsUrl", "");
        if (!setTextNewUrl.isEmpty()) {
            if (!setTextUrl.isEmpty() && !setTextUrl.equals(setTextNewUrl)) {
                SetTextResourceHandler.unregisterScheme(setTextUrl);
            }
            if (setTextNewUrl.startsWith("file:")) {
                try {
                    Path browserTempFolder = this.getBrowserTempFolder();
                    if (!Files.exists(browserTempFolder, new LinkOption[0])) {
                        Files.createDirectory(browserTempFolder, new FileAttribute[0]);
                    }
                    Path file = Files.createTempFile(browserTempFolder, "tempfile", ".html", new FileAttribute[0]);
                    Files.write(file, html.getBytes(StandardCharsets.UTF_8.toString()), new OpenOption[0]);
                    file.toFile().deleteOnExit();
                    setTextUrl = file.toUri().toString();
                    this.setUrl(setTextUrl, null, null);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.setUrl(DATA_TEXT_BASE64_URL + texturl, null, null);
                }
            } else {
                if (!setTextUrl.equals(setTextNewUrl)) {
                    SetTextResourceHandler.configureScheme(setTextNewUrl);
                }
                setTextUrl = setTextNewUrl;
                this.setUrl(String.valueOf(setTextUrl) + "/__text__", null, new String[]{"dataText:" + texturl, "chromium:setText"});
            }
            return true;
        }
        return this.setUrl(DATA_TEXT_BASE64_URL + texturl, null, null);
    }

    private String getPlainUrl(String url) {
        if (url != null && url.startsWith(DATA_TEXT_BASE64_URL)) {
            return DATA_TEXT_URL;
        }
        String setTextNewUrl = System.getProperty("chromium.setTextAsUrl", "");
        if (!setTextNewUrl.isEmpty() && url != null && url.startsWith("file:") && url.contains(this.getBrowserTempFolder().toUri().toString())) {
            return ABOUT_BLANK;
        }
        return url;
    }

    @Override
    public boolean setUrl(String url, String postData, String[] headers) {
        boolean isCreating;
        boolean isPost = postData != null || headers != null;
        boolean bl = isCreating = clientHandler != null && clientHandler.isCreating();
        if (this.created.isDone() || !isPost && !isCreating) {
            this.url = url;
        }
        this.jsEnabled = this.jsEnabledOnNextPage;
        this.debugPrint("set url: " + this.getPlainUrl(url));
        if (this.created.isDone() || isCreating || isPost) {
            this.ignoreFirstFocus = true;
            this.urls = this.enableProgress.runAfterBoth(this.urls, () -> {
                this.url = url;
                this.doSetUrl(url, postData, headers);
            });
        }
        return true;
    }

    private void doSetUrl(String url, String postData, String[] headers) {
        this.loaded = new CompletableFuture();
        Net.config();
        if (postData == null && headers == null || url.startsWith("file:")) {
            this.cefBrowser.loadURL(url);
        } else {
            CefRequest request = CefRequest.create();
            request.setURL(url);
            if (postData != null) {
                CefPostData post = CefPostData.create();
                CefPostDataElement elem = CefPostDataElement.create();
                byte[] postBytes = postData.getBytes(Charset.forName("ASCII"));
                elem.setToBytes(postBytes.length, postBytes);
                post.addElement(elem);
                request.setPostData(post);
            }
            if (headers != null) {
                Map<String, String> headersMap = Arrays.stream(headers).map(h -> h.split(":", 2)).collect(Collectors.toMap(k -> k[0], v -> v[1]));
                request.setHeaderMap(headersMap);
            }
            this.cefBrowser.loadRequest(request);
        }
    }

    @Override
    public void stop() {
        if (this.cefBrowser != null) {
            this.loaded.complete(true);
            this.cefBrowser.stopLoad();
        }
    }

    boolean isDisposed() {
        return this.chromium == null || this.chromium.isDisposed();
    }

    static void syncExec(Runnable run) {
        if (Display.getCurrent() != null) {
            run.run();
        } else {
            Display.getDefault().syncExec(run);
        }
    }

    static <V> V syncExec(Callable<V> run) {
        ErrorHandlingCallable handling = new ErrorHandlingCallable(run);
        if (Display.getCurrent() != null) {
            handling.run();
        } else {
            Display.getDefault().syncExec(handling);
        }
        if (handling.exception != null) {
            throw new RuntimeException(handling.exception);
        }
        return (V)handling.result;
    }

    static void asyncExec(Runnable run) {
        Display.getDefault().asyncExec(run);
    }

    class AuthDialog
    extends Dialog {
        public AuthDialog(Shell parent) {
            super(parent);
        }

        public void open(final AuthenticationEvent authEvent, String realm, final CefAuthCallback callback) {
            Shell parent = this.getParent();
            final Shell shell = new Shell(parent, 67696);
            shell.setText("Authentication Required");
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 10;
            layout.marginWidth = 10;
            shell.setLayout((Layout)layout);
            Label info = new Label((Composite)shell, 64);
            StringBuilder infoText = new StringBuilder(authEvent.location);
            infoText.append(" is requesting you username and password.");
            if (realm != null) {
                infoText.append(" The site says: \"").append(realm).append("\"");
            }
            info.setText(infoText.toString());
            info.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            Label label1 = new Label((Composite)shell, 0);
            label1.setText("User Name: ");
            final Text username = new Text((Composite)shell, 2052);
            username.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            Label label2 = new Label((Composite)shell, 0);
            label2.setText("Password: ");
            final Text password = new Text((Composite)shell, 2052);
            password.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            password.setEchoChar('*');
            Composite bar = new Composite((Composite)shell, 0);
            bar.setLayoutData((Object)new GridData(0x1000008, 0x1000008, false, true, 2, 1));
            bar.setLayout((Layout)new GridLayout(2, true));
            Button cancelButton = new Button(bar, 8);
            cancelButton.setText("Cancel");
            cancelButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    authEvent.doit = false;
                    shell.close();
                    callback.cancel();
                }
            });
            GridData cancelData = new GridData(0x1000000, 0x1000008, false, false);
            cancelData.widthHint = 80;
            cancelButton.setLayoutData((Object)cancelData);
            Button okButton = new Button(bar, 8);
            okButton.setText("Ok");
            okButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    authEvent.user = username.getText();
                    authEvent.password = password.getText();
                    shell.close();
                    callback.Continue(authEvent.user, authEvent.password);
                }
            });
            GridData okData = new GridData(0x1000000, 0x1000008, false, false);
            okData.minimumWidth = -1;
            okData.widthHint = 80;
            okButton.setLayoutData((Object)okData);
            shell.pack();
            shell.open();
            Display display = parent.getDisplay();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
    }

    private final class CefFocusListener
    implements FocusListener {
        private boolean enabled = true;

        private CefFocusListener() {
        }

        public void focusLost(FocusEvent e) {
            if (!this.enabled) {
                return;
            }
            this.enabled = false;
            if (Chromium.this.cefBrowser != null) {
                Chromium.this.cefBrowser.setFocus(false);
            }
            Chromium.this.hasFocus = false;
            this.enabled = true;
        }

        public void focusGained(FocusEvent e) {
            if (!this.enabled) {
                return;
            }
            this.enabled = false;
            if (Chromium.this.cefBrowser != null && !isOpenDialog) {
                Chromium.this.cefBrowser.setFocus(true);
            }
            this.enabled = true;
        }
    }

    static class ContextMenuHandler
    extends CefContextMenuHandlerAdapter {
        ContextMenuHandler() {
        }

        @Override
        public void onBeforeContextMenu(CefBrowser browser, CefFrame frame, CefContextMenuParams params, CefMenuModel model) {
            Engine.debug("onBeforeContextMenu", browser);
            if (!browser.isPopup()) {
                Chromium.getChromium(browser).onBeforeContextMenu(model);
            }
        }

        @Override
        public boolean onContextMenuCommand(CefBrowser browser, CefFrame frame, CefContextMenuParams params, int commandId, int eventFlags) {
            Engine.debug("onContextMenuCommand", browser);
            if (!browser.isPopup()) {
                return Chromium.getChromium(browser).onContextMenuCommand(params, commandId);
            }
            return false;
        }
    }

    static class DialogHandler
    implements CefDialogHandler {
        DialogHandler() {
        }

        @Override
        public boolean onFileDialog(CefBrowser browser, CefDialogHandler.FileDialogMode mode, String title, String defaultFilePath, Vector<String> acceptFilters, CefFileDialogCallback callback) {
            Chromium ch = Chromium.getChromium(browser);
            if (ch != null) {
                return ch.onFileDialog(mode, title, defaultFilePath, acceptFilters, callback);
            }
            return false;
        }
    }

    static class DisplayHandler
    extends CefDisplayHandlerAdapter {
        DisplayHandler() {
        }

        @Override
        public void onAddressChange(CefBrowser browser, CefFrame frame, String url) {
            Engine.debug("onAddressChange", browser);
            if (!browser.isPopup()) {
                Chromium.getChromium(browser).onAddressChange(frame, url);
                ((ExtraApi)Chromium.getChromium(browser).getWebBrowser()).getSubscriber().onAddressChangeNotify(browser.isLoading(), url);
            }
        }

        @Override
        public void onTitleChange(CefBrowser browser, String title) {
            if (!browser.isPopup()) {
                Chromium.getChromium(browser).onTitleChange(title);
            }
        }

        @Override
        public void onStatusMessage(CefBrowser browser, String value) {
            if (!browser.isPopup()) {
                Chromium.getChromium(browser).onStatusMessage(value);
            }
        }

        @Override
        public boolean onConsoleMessage(CefBrowser browser, CefSettings.LogSeverity level, String message, String source, int line) {
            if (!browser.isPopup()) {
                return Chromium.getChromium(browser).onConsoleMessage(level, message, source, line);
            }
            return false;
        }

        @Override
        public void onLoadingProgressChange(CefBrowser browser, double progress) {
            if (!browser.isPopup()) {
                Chromium.getChromium(browser).onLoadingProgressChange(browser, progress);
            }
        }

        @Override
        public void onFullscreenModeChange(CefBrowser browser, boolean fullscreen) {
            if (!browser.isPopup()) {
                Chromium.getChromium(browser).onFullscreenModeChange(browser, fullscreen);
            }
        }
    }

    static enum Dispose {
        No,
        FromDispose,
        FromClose,
        FromBrowser,
        Unload,
        UnloadClosed,
        UnloadCancel,
        WaitIfClosed,
        DoIt;

    }

    static class Download {
        static final Map<Integer, Download> downloads = new HashMap<Integer, Download>();
        private int id;
        private Shell shell = null;
        private Label statusLabel;
        private Button cancel;
        private CefDownloadItemCallback cancel_cb;
        private boolean open;
        private Label nameLabel;
        private ProgressBar pb;
        final Listener cancelListener = event -> {
            this.pb.setState(4);
            this.cancel_cb.cancel();
            this.dispose();
        };
        public boolean isReady = false;

        public Download(DownloadItem download_item, String name, Chromium browser) {
            downloads.put(download_item.id, this);
            if (name == null) {
                return;
            }
            this.id = download_item.id;
            this.shell = new Shell();
            String msg = Compatibility.getMessage((String)"SWT_FileDownload");
            this.shell.setText(msg);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginHeight = 15;
            gridLayout.marginWidth = 15;
            gridLayout.verticalSpacing = 20;
            this.shell.setLayout((Layout)gridLayout);
            this.nameLabel = new Label((Composite)this.shell, 64);
            this.setText(download_item);
            GridData data = new GridData();
            Monitor monitor = browser.chromium != null ? browser.chromium.getMonitor() : Display.getDefault().getPrimaryMonitor();
            int maxWidth = monitor.getBounds().width / 2;
            int width = this.nameLabel.computeSize((int)-1, (int)-1).x;
            data.widthHint = Math.min(width, maxWidth);
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            this.nameLabel.setLayoutData((Object)data);
            int pbStyle = download_item.percentComplete == -1 ? 65794 : 65792;
            this.pb = new ProgressBar((Composite)this.shell, pbStyle);
            this.pb.setSelection(download_item.percentComplete);
            this.pb.setMinimum(0);
            this.pb.setMaximum(100);
            this.pb.setState(0);
            this.pb.setLayoutData((Object)new GridData(4, 1, true, false));
            this.statusLabel = new Label((Composite)this.shell, 0);
            this.statusLabel.setText(Compatibility.getMessage((String)"SWT_Download_Started"));
            data = new GridData(1808);
            this.statusLabel.setLayoutData((Object)data);
            this.cancel = new Button((Composite)this.shell, 8);
            this.cancel.setText(Compatibility.getMessage((String)"SWT_Cancel"));
            data = new GridData();
            data.horizontalAlignment = 2;
            this.cancel.setLayoutData((Object)data);
            this.cancel.addListener(13, this.cancelListener);
        }

        private void show() {
            this.open = true;
            this.shell.pack();
            this.shell.open();
        }

        private void update(CefDownloadItem download_item, CefDownloadItemCallback callback) {
            if (this.shell == null) {
                callback.cancel();
                this.isReady = false;
                return;
            }
            this.cancel_cb = callback;
            if (this.shell.isDisposed()) {
                this.dispose();
                return;
            }
            if (download_item.isComplete()) {
                Display.getDefault().timerExec(3000, this::dispose);
            }
            this.setText(new DownloadItem(download_item));
            long current = download_item.getReceivedBytes() / 1024L;
            long total = download_item.getTotalBytes() / 1024L;
            String message = Compatibility.getMessage((String)"SWT_Download_Status", (Object[])new Object[]{current, total});
            message = String.valueOf(message) + " at " + download_item.getCurrentSpeed() / 1024L + " KB/s " + (download_item.getPercentComplete() != -1 ? "(" + download_item.getPercentComplete() + "%)" : "");
            this.statusLabel.setText(message);
            this.pb.setSelection(download_item.getPercentComplete());
            if (download_item.isCanceled() || !download_item.isComplete() && !download_item.isInProgress()) {
                this.pb.setState(1);
                this.statusLabel.setText(Compatibility.getMessage((String)"SWT_Download_Error"));
                this.cancel.removeListener(13, this.cancelListener);
                this.cancel.addListener(13, event -> this.dispose());
                return;
            }
        }

        private void setText(DownloadItem download_item) {
            String nameString = download_item.fullPath;
            String urlString = download_item.url;
            String msg = Compatibility.getMessage((String)"SWT_Download_Location", (Object[])new Object[]{String.valueOf(nameString) + "\n", urlString});
            if (urlString.startsWith("data:")) {
                msg = "Saving...";
            }
            this.nameLabel.setText(msg);
        }

        private void dispose() {
            downloads.remove(this.id);
            this.cancel_cb = null;
            if (this.shell != null) {
                this.shell.dispose();
            }
        }
    }

    static class DownloadHandler
    extends CefDownloadHandlerAdapter {
        DownloadHandler() {
        }

        @Override
        public void onBeforeDownload(CefBrowser browser, CefDownloadItem downloadItem, String suggestedName, CefBeforeDownloadCallback callback) {
            Engine.debug("onBeforeDownload", browser);
            Chromium chm = Chromium.getChromium(browser);
            if (chm != null) {
                chm.onBeforeDownload(downloadItem, suggestedName, callback);
            }
        }

        @Override
        public void onDownloadUpdated(CefBrowser browser, CefDownloadItem downloadItem, CefDownloadItemCallback callback) {
            Engine.debug("onDownloadUpdated", browser);
            Chromium.onDownloadUpdated(browser.getIdentifier(), downloadItem, callback);
        }
    }

    private static class ErrorHandlingCallable<T>
    implements Runnable {
        private Callable<T> runnable;
        private T result;
        private Exception exception;

        private ErrorHandlingCallable(Callable<T> runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            try {
                this.result = this.runnable.call();
            }
            catch (Exception e) {
                this.exception = e;
            }
        }
    }

    class ExtraApi
    extends IndependentBrowser
    implements ChromiumBrowser {
        List<Object> errors;

        ExtraApi() {
        }

        @Override
        protected CefBrowser getBrowser() {
            return Chromium.this.cefBrowser;
        }

        @Override
        protected CefRequestContext createRequestContext() {
            return super.createRequestContext();
        }

        @Override
        public void find(String search, boolean forward, boolean matchCase) {
            Chromium.this.checkBrowser();
            super.find(search, forward, matchCase);
        }

        private void initErrors() {
            if (this.errors == null) {
                this.errors = new ArrayList<Object>();
            }
        }

        void error(Object status) {
            this.initErrors();
            this.errors.add(status);
        }

        @Override
        public List<Object> getErrors() {
            this.initErrors();
            return this.errors;
        }

        public Chromium getChromium() {
            return Chromium.this;
        }

        @Override
        public void zoom(double zoomLevel) {
            Chromium.this.checkBrowser();
            super.zoom(zoomLevel);
        }

        @Override
        protected boolean onConsoleMessage(CefBrowser browser, CefSettings.LogSeverity level, String message, String source, int line) {
            return super.onConsoleMessage(browser, level, message, source, line);
        }

        @Override
        protected boolean handleCertificateProperty() {
            return super.handleCertificateProperty();
        }

        @Override
        public void executeJavaScript(String script) {
            Chromium.this.execute(script);
        }

        @Override
        public void executeJavacript(String script) {
            this.executeJavaScript(script);
        }

        @Override
        public boolean setUrl(String url) {
            return Chromium.this.setUrl(url, null, null);
        }

        @Override
        public boolean close() {
            return super.close();
        }

        @Override
        public Object getUIComponent() {
            return Chromium.this.cefBrowser.getComposite();
        }

        @Override
        public boolean setText(String html) {
            return Chromium.this.setText(html, true);
        }

        public void setCreated() {
            EventAction eventAction = Subscriber.getEventActionOfAfterCreated();
            if (eventAction != null && !this.isCreated().isDone()) {
                HashMap<String, Object> mapData = new HashMap<String, Object>();
                mapData.put("chromium_instance", this);
                eventAction.setJsonData(mapData);
                eventAction.run();
            }
            this.isCreated().complete(true);
        }

        @Override
        public void showDevTools() {
            Chromium.this.created.thenRun(() -> this.getBrowser().getDevTools().createImmediately());
        }
    }

    static class FocusHandler
    extends CefFocusHandlerAdapter {
        FocusHandler() {
        }

        @Override
        public void onTakeFocus(CefBrowser browser, boolean next) {
            Engine.debug("onTakeFocus", browser);
            if (!browser.isPopup()) {
                Chromium.getChromium(browser).onTakeFocus(next);
            }
        }

        @Override
        public boolean onSetFocus(CefBrowser browser, CefFocusHandler.FocusSource source) {
            Engine.debug("onSetFocus", browser);
            if (!browser.isPopup()) {
                return Chromium.getChromium(browser).onSetFocus(source);
            }
            return "win32".equals(SWT.getPlatform());
        }

        @Override
        public void onGotFocus(CefBrowser browser) {
            Engine.debug("onGotFocus", browser);
            if (!browser.isPopup()) {
                Chromium.getChromium(browser).onGotFocus();
            }
        }
    }

    class FunctionsResourceHandler
    extends CefResourceHandlerAdapter {
        private byte[] resp = new byte[0];
        private Throwable ex;
        private int offset = 0;
        private CefCallback callback;
        private boolean eval;
        public boolean inFunction;

        FunctionsResourceHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean processRequest(CefRequest request, CefCallback callback) {
            if (Chromium.this.isDisposed()) {
                return false;
            }
            if (RequestHandler.isFunction(Chromium.this.cefBrowser, request) && request.getPostData() != null) {
                try {
                    Object payload;
                    int index = RequestHandler.getFunctionIndex(request);
                    CefPostData data = request.getPostData();
                    Vector<CefPostDataElement> elements = new Vector<CefPostDataElement>();
                    data.getElements(elements);
                    String encoded = "";
                    Iterator<CefPostDataElement> iterator = elements.iterator();
                    if (iterator.hasNext()) {
                        CefPostDataElement el = iterator.next();
                        byte[] payload2 = new byte[el.getBytesCount()];
                        el.getBytes(payload2.length, payload2);
                        encoded = new String(payload2, StandardCharsets.UTF_8);
                        Engine.debug("processRequest el: " + encoded);
                    }
                    if ((payload = AbstractEval.decodeType(encoded, 5)).getClass().isArray() && ((Object[])payload).length >= 3) {
                        String token = (String)((Object[])payload)[0];
                        Object[] args = (Object[])((Object[])payload)[2];
                        BrowserFunction browserFunction = (BrowserFunction)Chromium.this.functions.get(index);
                        if (browserFunction != null && browserFunction.token.equals(token)) {
                            if (((Object[])payload).length == 4) {
                                Engine.debug("processRequest return function result: " + browserFunction.getName());
                                BrowserFunction browserFunction2 = browserFunction;
                                synchronized (browserFunction2) {
                                    if (this.resp.length > 0) {
                                        callback.Continue();
                                    } else {
                                        this.callback = callback;
                                    }
                                }
                            } else {
                                Engine.debug("processRequest calling function: " + browserFunction.getName());
                                Chromium.asyncExec(() -> {
                                    block20: {
                                        Object ret = null;
                                        try {
                                            try {
                                                this.callback = callback;
                                                this.inFunction = true;
                                                ret = browserFunction.function(args);
                                                BrowserFunction browserFunction2 = browserFunction;
                                                synchronized (browserFunction2) {
                                                    this.resp = Chromium.encodeType(ret).getBytes(StandardCharsets.UTF_8);
                                                }
                                            }
                                            catch (Throwable t) {
                                                this.ex = t;
                                                this.inFunction = false;
                                                BrowserFunction browserFunction3 = browserFunction;
                                                synchronized (browserFunction3) {
                                                    if (this.callback != null) {
                                                        this.callback.Continue();
                                                    }
                                                    this.callback = null;
                                                    break block20;
                                                }
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            this.inFunction = false;
                                            BrowserFunction browserFunction4 = browserFunction;
                                            synchronized (browserFunction4) {
                                                if (this.callback != null) {
                                                    this.callback.Continue();
                                                }
                                                this.callback = null;
                                            }
                                            throw throwable;
                                        }
                                        this.inFunction = false;
                                        BrowserFunction browserFunction5 = browserFunction;
                                        synchronized (browserFunction5) {
                                            if (this.callback != null) {
                                                this.callback.Continue();
                                            }
                                            this.callback = null;
                                        }
                                    }
                                });
                            }
                            return true;
                        }
                    }
                }
                catch (SWTException e) {
                    this.ex = e;
                    callback.Continue();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            callback.cancel();
            return false;
        }

        @Override
        public void getResponseHeaders(CefResponse response, IntRef responseLength, StringRef redirectUrl) {
            Engine.debug("getResponseHeaders", Chromium.this.cefBrowser);
            response.setHeaderByName("Access-Control-Allow-Origin", "*", true);
            if (this.ex != null) {
                response.setStatus(400);
                response.setStatusText(this.ex.getMessage());
                responseLength.set(0);
            } else if (this.eval) {
                response.setStatus(206);
                response.setMimeType("text");
                responseLength.set(this.resp.length);
            } else {
                response.setStatus(200);
                response.setMimeType("text");
                responseLength.set(this.resp.length);
            }
        }

        @Override
        public boolean readResponse(byte[] dataOut, int bytesToRead, IntRef bytesRead, CefCallback callback) {
            Engine.debug("readResponse", Chromium.this.cefBrowser);
            if (this.ex != null) {
                return false;
            }
            if (this.offset < this.resp.length) {
                int transfer = Math.min(this.resp.length - this.offset, bytesToRead);
                System.arraycopy(this.resp, this.offset, dataOut, 0, transfer);
                this.offset += transfer;
                bytesRead.set(transfer);
                return true;
            }
            this.resp = new byte[0];
            if (!this.eval) {
                Chromium.this.functionsResourceHandler.remove(this);
            }
            this.eval = false;
            this.offset = 0;
            this.ex = null;
            return false;
        }

        public void setEval(String eval) {
            if (this.callback != null) {
                this.inFunction = false;
                this.resp = eval.getBytes(StandardCharsets.UTF_8);
                this.eval = true;
                this.callback.Continue();
                this.callback = null;
            }
        }
    }

    static class JsDialogHandler
    extends CefJSDialogHandlerAdapter {
        JsDialogHandler() {
        }

        @Override
        public boolean onJSDialog(CefBrowser browser, String origin_url, CefJSDialogHandler.JSDialogType dialog_type, String message_text, String default_prompt_text, CefJSDialogCallback callback, BoolRef suppress_message) {
            Engine.debug("onJSDialog", browser);
            Chromium chm = Chromium.getChromium(browser);
            if (!Chromium.useSwtDialogs() || chm == null) {
                return false;
            }
            return chm.onJsdialog(browser, origin_url, dialog_type, message_text, default_prompt_text, callback, suppress_message);
        }

        @Override
        public boolean onBeforeUnloadDialog(CefBrowser browser, String message_text, boolean is_reload, CefJSDialogCallback callback) {
            Engine.debug("onBeforeUnloadDialog", browser);
            if (!browser.isPopup()) {
                return Chromium.getChromium(browser).onBeforeUnloadDialog(message_text, is_reload, callback);
            }
            return false;
        }

        @Override
        public void onDialogClosed(CefBrowser browser) {
            Engine.debug("onDialogClosed", browser);
            if (!browser.isPopup()) {
                Chromium.getChromium(browser).onDialogClosed();
            }
        }
    }

    static class KeyboardHandler
    extends CefKeyboardHandlerAdapter {
        KeyboardHandler() {
        }

        @Override
        public boolean onKeyEvent(CefBrowser browser, CefKeyboardHandler.CefKeyEvent event) {
            if (!browser.isPopup()) {
                return Chromium.getChromium(browser).on_key_event(event);
            }
            return false;
        }
    }

    static class LifeSpanHandler
    extends CefLifeSpanHandlerAdapter {
        LifeSpanHandler() {
        }

        @Override
        public void onAfterCreated(CefBrowser browser) {
            Engine.debug("onAfterCreated", browser);
            if (!browser.isPopup()) {
                Chromium.getChromium(browser).onAfterCreated();
                ((ExtraApi)Chromium.getChromium(browser).getWebBrowser()).getSubscriber().onAfterCreatedNotify(browser);
            }
        }

        @Override
        public boolean doClose(CefBrowser browser) {
            Engine.debug("doClose", browser);
            if (!browser.isPopup()) {
                return Chromium.getChromium(browser).doClose();
            }
            browser.doClose();
            return "win32".equals(SWT.getPlatform());
        }

        @Override
        public void onBeforeClose(CefBrowser browser) {
            Engine.debug("onBeforeClose", browser);
            if (!browser.isPopup()) {
                Chromium.getChromium(browser).onBeforeClose();
            }
        }

        @Override
        public boolean onBeforePopup(CefBrowser browser, CefFrame frame, String target_url, String target_frame_name) {
            Engine.debug("onBeforePopup", browser);
            if ("_external".equals(target_frame_name)) {
                return Program.launch((String)target_url);
            }
            if (!browser.isPopup()) {
                return Chromium.getChromium(browser).onBeforePopup(target_url, target_frame_name);
            }
            return false;
        }
    }

    static class LoadHandler
    extends CefLoadHandlerAdapter {
        LoadHandler() {
        }

        @Override
        public void onLoadingStateChange(CefBrowser browser, boolean isLoading, boolean canGoBack, boolean canGoForward) {
            if (!browser.isPopup()) {
                Chromium.getChromium(browser).on_loading_state_change(isLoading, canGoBack, canGoForward);
                ((ExtraApi)Chromium.getChromium(browser).getWebBrowser()).getSubscriber().onLoadingStateChangeNotify(isLoading, browser.getURL());
            }
        }

        @Override
        public void onLoadEnd(CefBrowser browser, CefFrame frame, int httpStatusCode) {
            if (!browser.isPopup()) {
                ((ExtraApi)Chromium.getChromium(browser).getWebBrowser()).getSubscriber().onLoadEndNotify(frame);
            }
        }

        @Override
        public void onLoadError(CefBrowser browser, CefFrame frame, CefLoadHandler.ErrorCode errorCode, String errorText, String failedUrl) {
            if (!browser.isPopup()) {
                ((ExtraApi)Chromium.getChromium(browser).getWebBrowser()).getSubscriber().onLoadErrorNotify(errorCode.getCode());
            }
        }
    }

    static class RequestHandler
    extends CefRequestHandlerAdapter {
        private static final String FUNCTION_HOST = "functions";

        RequestHandler() {
        }

        @Override
        public void onRenderProcessTerminated(CefBrowser browser, CefRequestHandler.TerminationStatus status, int errorCode, String errorString) {
            if (!browser.isPopup()) {
                Chromium.getChromium(browser).extraApi().error((Object)status);
            }
        }

        @Override
        public boolean onBeforeBrowse(CefBrowser browser, CefFrame frame, CefRequest request, boolean user_gesture, boolean is_redirect) {
            if (!browser.isPopup()) {
                ((ExtraApi)Chromium.getChromium(browser).getWebBrowser()).getSubscriber().onBeforeBrowseNotify();
                return Chromium.getChromium(browser).onBeforeBrowse(frame, request);
            }
            return false;
        }

        @Override
        public boolean getAuthCredentials(CefBrowser browser, String origin_url, boolean isProxy, String host, int port, String realm, String scheme, CefAuthCallback callback) {
            Chromium chm = Chromium.getChromium(browser);
            if (chm != null) {
                chm.getAuthCredentials(origin_url, host, port, realm, scheme, callback);
                return true;
            }
            return false;
        }

        @Override
        public boolean onCertificateError(CefBrowser browser, CefLoadHandler.ErrorCode cert_error, String request_url, CefCallback callback) {
            Engine.debug("onCertificateError", browser);
            Chromium chm = Chromium.getChromium(browser);
            if (chm != null) {
                return chm.onCertificateError(cert_error, request_url, callback);
            }
            return false;
        }

        @Override
        public CefResourceRequestHandler getResourceRequestHandler(CefBrowser browser, CefFrame frame, CefRequest request, boolean isNavigation, boolean isDownload, String requestInitiator, BoolRef disableDefaultHandling) {
            boolean isCustomProtocol = false;
            if (RequestHandler.isFunction(browser, request)) {
                return null;
            }
            final String requestUrl = request.getURL();
            if (Engine.middlewareResourceRequestHandler != null && Engine.middlewareResourceRequestHandler.shouldHandleRequest(requestUrl)) {
                return Engine.middlewareResourceRequestHandler;
            }
            if (!(requestUrl.startsWith("http") || requestUrl.startsWith("data") || requestUrl.startsWith("file") || requestUrl.startsWith("chrome") || requestUrl.startsWith("about") || requestUrl.startsWith("devtools"))) {
                if (this.shouldAllowProtocol(requestUrl, browser)) {
                    return new CefResourceRequestHandlerAdapter(){

                        @Override
                        public boolean onBeforeResourceLoad(CefBrowser browser, CefFrame frame, CefRequest request) {
                            return false;
                        }

                        @Override
                        public void onProtocolExecution(CefBrowser browser, CefFrame frame, CefRequest request, BoolRef allowOsExecution) {
                            Engine.debug("onProtocolExecution: " + request.getURL(), browser);
                            browser.stopLoad();
                            Program.launch((String)requestUrl);
                        }
                    };
                }
                isCustomProtocol = true;
            }
            if (Chromium.allowTurboLink() && this.containsTurbolinkHeader(request) || isCustomProtocol) {
                return new CefResourceRequestHandlerAdapter(){

                    @Override
                    public boolean onBeforeResourceLoad(CefBrowser browser, CefFrame frame, CefRequest request) {
                        return true;
                    }
                };
            }
            return null;
        }

        private boolean containsTurbolinkHeader(CefRequest request) {
            String[] turbolinkHeaders;
            HashMap<String, String> headers = new HashMap<String, String>();
            request.getHeaderMap(headers);
            Map<String, String> headersLowerCase = headers.keySet().stream().collect(Collectors.toMap(key -> key.toLowerCase(), key -> (String)headers.get(key)));
            String[] stringArray = turbolinkHeaders = System.getProperty("chromium.turbolinks", "").split(";");
            int n = turbolinkHeaders.length;
            int n2 = 0;
            while (n2 < n) {
                String turbolinkHeader = stringArray[n2];
                if (turbolinkHeader.contains("=")) {
                    String hKey = turbolinkHeader.split("=")[0].toLowerCase();
                    String hValue = turbolinkHeader.split("=")[1];
                    if (headersLowerCase.containsKey(hKey) && headersLowerCase.get(hKey).equals(hValue)) {
                        return true;
                    }
                }
                ++n2;
            }
            return "true".equals(request.getHeaderByName("x-pjax")) || !request.getHeaderByName("Turbo-Frame").isEmpty() || "empty".equals(request.getHeaderByName("sec-fetch-dest")) && !"navigate".equals(request.getHeaderByName("Sec-Fetch-Mode")) && !"websocket".equals(request.getHeaderByName("Sec-Fetch-Mode"));
        }

        private static boolean isFunction(CefBrowser browser, CefRequest request) {
            if (!"POST".equals(request.getMethod()) || !request.getURL().contains(FUNCTION_HOST)) {
                return false;
            }
            try {
                int functionIndex = RequestHandler.getFunctionIndex(request);
                if (!browser.isPopup()) {
                    return Chromium.getChromium((CefBrowser)browser).functions.containsKey(functionIndex);
                }
                return false;
            }
            catch (NumberFormatException | URISyntaxException e) {
                return false;
            }
        }

        protected boolean isPartial(CefRequest request) {
            try {
                URI url = new URI(request.getURL());
                return url.getFragment() != null;
            }
            catch (URISyntaxException e) {
                return false;
            }
        }

        private static int getFunctionIndex(CefRequest request) throws URISyntaxException {
            URI url = new URI(request.getURL());
            return Integer.parseInt(url.getQuery());
        }

        private boolean shouldAllowProtocol(String requestUrl, CefBrowser browser) {
            String[] protocolProps = System.getProperty("chromium.custom_protocol", "").split(";");
            if (protocolProps.length > 1) {
                String[] stringArray = protocolProps;
                int n = protocolProps.length;
                int n2 = 0;
                while (n2 < n) {
                    String protocolAllow = stringArray[n2];
                    if (requestUrl.startsWith(protocolAllow)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
            String allowType = protocolProps[0].toLowerCase();
            if ("true".equals(allowType)) {
                return true;
            }
            if ("confirm".equals(allowType)) {
                final CompletableFuture dialogSuccess = new CompletableFuture();
                CefJSDialogCallback callback = new CefJSDialogCallback(){

                    @Override
                    public void Continue(boolean success, String user_input) {
                        dialogSuccess.complete(success);
                    }
                };
                Chromium chm = Chromium.getChromium(browser);
                if (chm != null) {
                    chm.openJsDialog(browser.isPopup(), CefJSDialogHandler.JSDialogType.JSDIALOGTYPE_CONFIRM, "", "The link will be opened with the operating system.", "Do you want to continue?", "default_prompt_text", callback);
                }
                try {
                    return (Boolean)dialogSuccess.get();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    private class ResizeListener
    implements ControlListener,
    Listener,
    Runnable {
        private boolean mouseDown;
        private Composite overlay;
        private Image image;
        private Image scaledImage;
        private Runnable loop = new Runnable(){

            @Override
            public void run() {
                CefApp.getInstance().doMessageLoopWork(-1L);
            }
        };

        public ResizeListener() {
            this.overlay = new Composite(Chromium.this.chromium, 0);
            this.overlay.setBackground(Chromium.this.chromium.getDisplay().getSystemColor(1));
            this.overlay.setBounds(Chromium.this.chromium.getClientArea());
            this.overlay.setVisible(false);
            this.install();
        }

        private Image getImage() {
            GC gc;
            Rectangle bounds = this.overlay.getBounds();
            Display display = Chromium.this.chromium.getDisplay();
            if (bounds.width <= 0 || bounds.height <= 0) {
                return null;
            }
            if (!Chromium.this.created.isDone() || !Chromium.this.chromium.isVisible()) {
                return null;
            }
            if (this.image == null) {
                gc = new GC((Drawable)Chromium.this.chromium.getShell());
                Rectangle cefBounds = Chromium.this.cefBrowser.getCurrentBounds();
                if (cefBounds == null || cefBounds.width == 0 || cefBounds.height == 0) {
                    return null;
                }
                Image orig = new Image((Device)display, cefBounds.width, cefBounds.height);
                gc.copyArea(orig, cefBounds.x, cefBounds.y);
                gc.dispose();
                this.image = orig;
            }
            if (bounds.equals((Object)this.image.getBounds())) {
                return this.image;
            }
            if (this.scaledImage != null) {
                if (this.scaledImage.getBounds().equals((Object)bounds)) {
                    return this.scaledImage;
                }
                this.scaledImage.dispose();
                this.scaledImage = null;
            }
            this.scaledImage = new Image((Device)display, bounds.width, bounds.height);
            gc = new GC((Drawable)this.scaledImage);
            gc.setAntialias(1);
            gc.setInterpolation(2);
            gc.drawImage(this.image, 0, 0, this.image.getBounds().width, this.image.getBounds().height, 0, 0, bounds.width, bounds.height);
            gc.dispose();
            return this.scaledImage;
        }

        @Override
        public void run() {
            this.hideOverlay();
        }

        public void controlResized(ControlEvent e) {
            if (Chromium.this.isDisposed()) {
                return;
            }
            this.overlay.setBounds(Chromium.this.chromium.getClientArea());
            this.showOverlay(e.display);
        }

        public void controlMoved(ControlEvent e) {
            if (Chromium.this.isDisposed()) {
                return;
            }
            this.overlay.setBounds(Chromium.this.chromium.getClientArea());
            this.showOverlay(e.display);
        }

        public void handleEvent(Event event) {
            if (Chromium.this.isDisposed()) {
                return;
            }
            boolean bl = this.mouseDown = event.type == 3;
            if (this.mouseDown && Chromium.this.chromium.isVisible() && this.isSash(event.widget)) {
                this.getImage();
            }
            if (event.type == 29 && Chromium.this.chromium.isVisible() && (event.widget instanceof CTabFolder || event.widget instanceof TabFolder)) {
                this.getImage();
                event.display.timerExec(8000, this::disposeImage);
            } else if (!(this.mouseDown || this.image == null && this.scaledImage == null)) {
                this.disposeImage();
            }
        }

        private void showOverlay(Display display) {
            if (Chromium.this.created.isDone()) {
                this.overlay.setVisible(true);
                Image img = this.getImage();
                this.overlay.setBackgroundImage(img);
                if (img == null) {
                    this.overlay.setBackground(display.getSystemColor(1));
                }
                display.timerExec(33, this.loop);
                display.timerExec(132, (Runnable)this);
            }
        }

        private void hideOverlay() {
            if (this.overlay.isVisible()) {
                this.overlay.setVisible(false);
            }
            this.disposeImage();
        }

        private void disposeImage() {
            if (this.image != null) {
                this.image.dispose();
                this.image = null;
            }
            if (this.scaledImage != null) {
                this.scaledImage.dispose();
                this.scaledImage = null;
            }
        }

        private boolean isSash(Widget widget) {
            if (widget instanceof Sash && this.isAncestor(((Sash)widget).getParent())) {
                return true;
            }
            if (!(widget instanceof Composite)) {
                return false;
            }
            Layout layout = ((Composite)widget).getLayout();
            return layout != null && layout.getClass().getSimpleName().contains("SashLayout") && this.isAncestor((Composite)widget);
        }

        private boolean isAncestor(Composite ancestor) {
            Composite parent = Chromium.this.chromium.getParent();
            while (parent != null) {
                if (parent == ancestor) {
                    return true;
                }
                parent = parent.getParent();
            }
            return false;
        }

        public void remove() {
            Chromium.this.chromium.removeControlListener((ControlListener)this);
            Chromium.this.chromium.getDisplay().removeFilter(1, (Listener)this);
            Chromium.this.chromium.getDisplay().removeFilter(2, (Listener)this);
            Chromium.this.chromium.getDisplay().removeFilter(29, (Listener)this);
            Chromium.this.resize = null;
        }

        public void install() {
            Chromium.this.chromium.addControlListener((ControlListener)this);
            Chromium.this.chromium.getDisplay().addFilter(3, (Listener)this);
            Chromium.this.chromium.getDisplay().addFilter(4, (Listener)this);
            Chromium.this.chromium.getDisplay().addFilter(29, (Listener)this);
        }
    }

    private static enum cef_event_flags {
        NONE(0),
        CAPS_LOCK_ON(1),
        SHIFT_DOWN(2, 131072),
        CONTROL_DOWN(4, 262144),
        ALT_DOWN(8, 65536),
        COMMAND_DOWN(128, 0x400000),
        NUM_LOCK_ON(256),
        IS_KEY_PAD(512),
        IS_LEFT(1024),
        IS_RIGHT(2048);

        int cefFlag;
        private int swtKey;

        private cef_event_flags(int flag) {
            this(flag, 0);
        }

        private cef_event_flags(int flag, int swtKey) {
            this.cefFlag = flag;
            this.swtKey = swtKey;
        }

        boolean shouldSetState(int modifiers, Event event) {
            if (this.isSet(modifiers)) {
                return event.type != 1 || event.keyCode != this.swtKey || this.swtKey == 0;
            }
            return event.type == 2 && event.keyCode == this.swtKey && this.swtKey != 0;
        }

        boolean isSet(int modifiers) {
            return (modifiers & this.cefFlag) != 0;
        }
    }
}

