/*
 * Decompiled with CFR 0.152.
 */
package com.equo.chromium.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.cef.OS;

public class ResourceExpander {
    public static final String DEFAULT_EXECUTABLE_NAME = OS.isMacintosh() ? "equochro Helper" : "equochro_helper";
    public static final String CUSTOM_EXECUTABLE_NAME = System.getProperty("chromium.executable.name", DEFAULT_EXECUTABLE_NAME);

    public static void setExecutable(File newFile) {
        String[] executables = new String[]{"", "so"};
        if (Arrays.asList(executables).contains(ResourceExpander.getExtension(newFile.getName())) && !newFile.canExecute()) {
            try {
                newFile.setExecutable(true);
            }
            catch (Throwable e) {
                System.err.println(e.getMessage());
            }
        }
    }

    public static String getExtension(String filename) {
        Optional<String> ext = Optional.ofNullable(filename).filter(f -> f.contains(".")).map(f -> f.substring(filename.lastIndexOf(".") + 1));
        return ext.isPresent() ? ext.get() : "";
    }

    public static Path findResource(Path extractTo, String resource, boolean replace) {
        Path path = extractTo.resolve(resource);
        if (Files.exists(path, new LinkOption[0]) && !replace) {
            return path;
        }
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            if (ResourceExpander.extract(path, resource) && Files.exists(path, new LinkOption[0])) {
                return path;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to extract " + resource + "from jar");
        }
        throw new UnsatisfiedLinkError("Could not find resource " + resource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean extract(Path extractToFilePath, String resource) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream is = ResourceExpander.class.getResourceAsStream("/" + resource);){
            if (is == null) return false;
            Files.copy(is, extractToFilePath, StandardCopyOption.REPLACE_EXISTING);
            ResourceExpander.setExecutable(extractToFilePath.toFile());
            return true;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    static Path extractFromJar(String chromiumPath, String arch, String subdir, Class<?> fragmentClass) throws IOException {
        Path extractPath = chromiumPath.isEmpty() ? Paths.get(System.getProperty("user.home"), ".equo", "chromium") : Paths.get(chromiumPath, new String[0]);
        extractPath = extractPath.resolve(arch);
        URL url = fragmentClass.getResource("/" + subdir + "/chromium.properties");
        if (url != null) {
            block32: {
                Throwable throwable = null;
                Object var7_8 = null;
                try (InputStream is = url.openStream();){
                    Object object;
                    Properties props = new Properties();
                    props.load(is);
                    String ver = props.getProperty("version");
                    boolean replace = true;
                    Path oldFile = extractPath.resolve(subdir).resolve("chromium.properties");
                    if (Files.exists(oldFile, new LinkOption[0])) {
                        Properties oldProps = new Properties();
                        object = null;
                        Object var15_20 = null;
                        try (BufferedReader oldis = Files.newBufferedReader(oldFile);){
                            oldProps.load(oldis);
                            String oldVer = oldProps.getProperty("version");
                            if (Objects.equals(ver, oldVer)) {
                                replace = false;
                            }
                        }
                        catch (Throwable throwable2) {
                            if (object == null) {
                                object = throwable2;
                            } else if (object != throwable2) {
                                ((Throwable)object).addSuppressed(throwable2);
                            }
                            throw object;
                        }
                    }
                    for (String prop : props.stringPropertyNames()) {
                        if (prop.length() != 2) continue;
                        String propValue = props.getProperty(prop);
                        Path path = ResourceExpander.findResource(extractPath, propValue, replace);
                        if (CUSTOM_EXECUTABLE_NAME.equals(DEFAULT_EXECUTABLE_NAME) || !ResourceExpander.isHelperExecutable(path)) continue;
                        ResourceExpander.createExecutableWithCustomName(path);
                    }
                    if (!replace) break block32;
                    Throwable throwable3 = null;
                    object = null;
                    try (InputStream propsIs = url.openStream();){
                        Files.copy(propsIs, oldFile, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                    } else if (throwable != throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable;
                }
            }
            return extractPath;
        }
        return null;
    }

    public static boolean isHelperExecutable(Path path) {
        String pathString = path.toString();
        if (OS.isMacintosh()) {
            String macPattern = ".*/equochro Helper( \\(.*\\))?\\.app/Contents/MacOS/equochro Helper( \\(.*\\))?";
            return pathString.matches(macPattern);
        }
        if (OS.isLinux()) {
            return DEFAULT_EXECUTABLE_NAME.equals(path.getFileName().toString());
        }
        return (String.valueOf(DEFAULT_EXECUTABLE_NAME) + ".exe").equals(path.getFileName().toString());
    }

    public static Path createExecutableWithCustomName(Path originalFile) {
        String pathString = originalFile.toString();
        int lastIndex = pathString.lastIndexOf(DEFAULT_EXECUTABLE_NAME);
        if (lastIndex != -1) {
            String newPathString = String.valueOf(pathString.substring(0, lastIndex)) + CUSTOM_EXECUTABLE_NAME + pathString.substring(lastIndex + DEFAULT_EXECUTABLE_NAME.length());
            Path newPath = Paths.get(newPathString, new String[0]);
            try {
                if (OS.isMacintosh()) {
                    Files.createSymbolicLink(newPath, originalFile, new FileAttribute[0]);
                } else {
                    Files.move(originalFile, newPath, StandardCopyOption.REPLACE_EXISTING);
                }
                return newPath;
            }
            catch (FileAlreadyExistsException e) {
                return newPath;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return originalFile;
    }
}

