/*
 * Decompiled with CFR 0.152.
 */
package com.equo.chromium;

import com.equo.chromium.internal.IndependentBrowser;
import com.equo.chromium.utils.StorageType;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class Storage {
    private final String storage;
    private final String setStorageFunction;
    private final String getStorageFunction;
    private final String removeStorageFunction;
    private final String clearStorageFunction;
    private IndependentBrowser browser;

    public Storage(IndependentBrowser browser, StorageType st) {
        this.browser = browser;
        this.storage = "window." + st.name().toLowerCase() + "Storage";
        this.setStorageFunction = String.valueOf(this.storage) + ".setItem";
        this.getStorageFunction = String.valueOf(this.storage) + ".getItem";
        this.removeStorageFunction = String.valueOf(this.storage) + ".removeItem";
        this.clearStorageFunction = String.valueOf(this.storage) + ".clear";
    }

    private CompletableFuture<Object> sendDevToolsMessage(String script, String wanted) {
        ArrayList<Map.Entry<String, Object>> params = new ArrayList<Map.Entry<String, Object>>();
        params.add(new AbstractMap.SimpleEntry<String, String>("expression", script));
        return this.browser.sendDevToolsMessage("Runtime.evaluate", params, wanted);
    }

    public void setItem(String key, String value) {
        String script = String.valueOf(this.setStorageFunction) + "('" + key + "','" + value + "')";
        this.sendDevToolsMessage(script, null);
    }

    public CompletableFuture<String> getItem(String key) {
        String script = String.valueOf(this.getStorageFunction) + "('" + key + "')";
        return this.sendDevToolsMessage(script, "result").thenApply(json -> (String)((Map)json).get("value"));
    }

    public void remove(String key) {
        String script = String.valueOf(this.removeStorageFunction) + "('" + key + "')";
        this.sendDevToolsMessage(script, null);
    }

    public void clear() {
        String script = String.valueOf(this.clearStorageFunction) + "()";
        this.sendDevToolsMessage(script, null);
    }
}

