/*
 * Decompiled with CFR 0.152.
 */
package com.equo.chromium;

import com.equo.chromium.CompatibleWithHost;
import com.equo.chromium.Storage;
import com.equo.chromium.internal.CompatibleWithHostImpl;
import com.equo.chromium.internal.Engine;
import com.equo.chromium.internal.IndependentBrowser;
import com.equo.chromium.internal.PopupBrowser;
import com.equo.chromium.internal.Standalone;
import com.equo.chromium.internal.SwingBrowser;
import com.equo.chromium.internal.Windowless;
import com.equo.chromium.swt.Browser;
import com.equo.chromium.swt.internal.WebBrowser;
import com.equo.chromium.utils.PdfPrintSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.cef.CefApp;
import org.cef.CefClient;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefBrowserStandalone;
import org.cef.browser.CefBrowserSwing;
import org.cef.browser.CefBrowserSwt;
import org.cef.browser.CefBrowserWl;
import org.cef.misc.Rectangle;

public interface ChromiumBrowser {
    public static Collection<ChromiumBrowser> getAllBrowsers() {
        ArrayList<ChromiumBrowser> browsers = new ArrayList<ChromiumBrowser>();
        if (CefApp.CefAppState.INITIALIZED.equals((Object)CefApp.getState())) {
            CefApp app = CefApp.getInstance();
            Set<CefClient> clients = app.getAllClients();
            for (CefClient client : clients) {
                Object[] clientBrowsers;
                Object[] objectArray = clientBrowsers = client.getAllBrowser();
                int n = clientBrowsers.length;
                int n2 = 0;
                while (n2 < n) {
                    Object browser = objectArray[n2];
                    CefBrowser castedCefBrowser = (CefBrowser)browser;
                    if (browser instanceof CefBrowserSwt) {
                        Browser composite = (Browser)((CefBrowserSwt)browser).getComposite();
                        if (composite != null) {
                            browsers.add((ChromiumBrowser)composite.getWebBrowser());
                        } else {
                            browsers.add(new PopupBrowser((CefBrowser)browser));
                        }
                    } else if (castedCefBrowser.getReference() == null) {
                        browsers.add(new PopupBrowser((CefBrowser)browser));
                    } else if (browser instanceof CefBrowserStandalone) {
                        browsers.add((ChromiumBrowser)((CefBrowserStandalone)browser).getReference());
                    } else if (browser instanceof CefBrowserWl) {
                        browsers.add((ChromiumBrowser)((CefBrowserWl)browser).getReference());
                    } else if (browser instanceof CefBrowserSwing) {
                        browsers.add((ChromiumBrowser)((CefBrowserSwing)browser).getReference());
                    }
                    ++n2;
                }
            }
        }
        return browsers;
    }

    public static ChromiumBrowser windowless(String url) {
        return new Windowless(url);
    }

    public static ChromiumBrowser windowless(String url, int x, int y, int width, int height) {
        return new Windowless(url, new Rectangle(x, y, width, height));
    }

    public static CompatibleWithHost compatibleWithHost() {
        return new CompatibleWithHostImpl();
    }

    public static ChromiumBrowser standalone(String url) {
        IndependentBrowser.checkToolkit(Engine.BrowserType.STANDALONE);
        return new Standalone(url);
    }

    public static ChromiumBrowser standalone(String url, int x, int y, int width, int height) {
        IndependentBrowser.checkToolkit(Engine.BrowserType.STANDALONE);
        return ChromiumBrowser.standalone(url, new Rectangle(x, y, width, height));
    }

    public static ChromiumBrowser standalone(String url, Rectangle window) {
        IndependentBrowser.checkToolkit(Engine.BrowserType.STANDALONE);
        return new Standalone(url, window);
    }

    public static ChromiumBrowser swing(Object container, String layout, String url) {
        IndependentBrowser.checkToolkit(Engine.BrowserType.SWING);
        return new SwingBrowser(container, layout, url);
    }

    public static ChromiumBrowser swing(String url) {
        IndependentBrowser.checkToolkit(Engine.BrowserType.SWING);
        return new SwingBrowser(url);
    }

    public static ChromiumBrowser swt(Object composite, int style) {
        IndependentBrowser.checkToolkit(Engine.BrowserType.SWT);
        return (ChromiumBrowser)new Browser(composite, style).getWebBrowser();
    }

    public static void earlyInit() throws ClassNotFoundException {
        Class.forName("com.equo.chromium.internal.Engine");
    }

    public static void startBrowsers() {
        String multiThread = System.getProperty("chromium.multi_threaded_message_loop", "");
        if (!Boolean.valueOf(multiThread).booleanValue()) {
            Engine.startCefLoop();
        }
    }

    public static boolean clearCookies(String urlPattern, String namePattern) {
        return WebBrowser.clearCookie(urlPattern, namePattern);
    }

    public boolean isClosed();

    public boolean setUrl(String var1);

    public boolean setText(String var1);

    public boolean close();

    public void executeJavaScript(String var1);

    @Deprecated
    public void executeJavacript(String var1);

    public void find(String var1, boolean var2, boolean var3);

    public void zoom(double var1);

    public double getZoom();

    public void addConsoleListener(ConsoleListener var1);

    public void removeConsoleListener(ConsoleListener var1);

    public List<Object> getErrors();

    public CompletableFuture<byte[]> captureScreenshot();

    public CompletableFuture<byte[]> captureScreenshot(int var1, int var2, int var3, int var4, int var5);

    public void ignoreCertificateErrors(boolean var1);

    public Object getUIComponent();

    public boolean isLoading();

    public void goBack();

    public void goForward();

    public boolean canGoBack();

    public boolean canGoForward();

    public void reload();

    public void stop();

    public CompletableFuture<String> text();

    public String getUrl();

    public CompletableFuture<Boolean> isCreated();

    public void showDevTools();

    public CompletableFuture<Boolean> printToPdf(String var1, PdfPrintSettings var2);

    public CompletableFuture<Boolean> printToPdf(String var1);

    public Storage getLocalStorage();

    public Storage getSessionStorage();

    @FunctionalInterface
    public static interface ConsoleListener {
        public boolean message(int var1, String var2, String var3, int var4);
    }
}

