/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.reminder.part;

import ch.elexis.core.model.IReminder;
import ch.elexis.core.model.issue.Type;
import ch.elexis.core.ui.reminder.part.SelectionUtil;
import ch.elexis.core.ui.reminder.part.nattable.ReminderSpanningBodyDataProvider;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class ReminderNatTableToolTip
extends DefaultToolTip {
    private NatTable natTable;
    private ReminderSpanningBodyDataProvider dataProvider;

    public ReminderNatTableToolTip(NatTable natTable, ReminderSpanningBodyDataProvider dataProvider) {
        super((Control)natTable, 1, false);
        this.natTable = natTable;
        this.dataProvider = dataProvider;
    }

    protected Object getToolTipArea(Event event) {
        int col = this.natTable.getColumnPositionByX(event.x);
        int row = this.natTable.getRowPositionByY(event.y);
        return new Point(col, row);
    }

    protected String getText(Event event) {
        ILayerCell cell = SelectionUtil.getCell(this.natTable, this.dataProvider, event.x, event.y);
        if (SelectionUtil.isHoverCheck(this.natTable, this.dataProvider, cell, event.x, event.y)) {
            return "Erledigt mit Doppelklick.";
        }
        Object data = SelectionUtil.getData(this.natTable, this.dataProvider, event.x, event.y);
        if (data instanceof IReminder) {
            IReminder reminder = (IReminder)data;
            StringBuilder sb = new StringBuilder();
            if (reminder.getType() != null && reminder.getType() != Type.COMMON) {
                sb.append("Typ: ").append(reminder.getType().getLocaleText()).append("\n");
            }
            sb.append("Titel: ").append(StringUtils.defaultString((String)reminder.getSubject())).append("\n");
            sb.append("Status: ").append(reminder.getStatus().getLocaleText()).append("\n");
            sb.append("Beschreibung: \n").append(reminder.getMessage());
            return sb.toString();
        }
        return null;
    }
}

