/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.perspective.handler;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.compatibility.ElexisFastViewUtil;
import ch.elexis.core.ui.perspective.handler.PerspektiveExportHandler;
import ch.elexis.core.ui.perspective.service.IPerspectiveImportService;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component
public class PerspektiveImportHandler
extends AbstractHandler {
    static IPerspectiveImportService perspectiveImportService;

    @Reference(unbind="-")
    public void bind(IPerspectiveImportService service) {
        perspectiveImportService = service;
    }

    private static <T> T getService(Class<T> clazz) {
        return (T)PlatformUI.getWorkbench().getService(clazz);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            EModelService modelService = PerspektiveImportHandler.getService(EModelService.class);
            FileDialog dialog = new FileDialog(UiDesk.getTopShell(), 4096);
            dialog.setFilterNames(new String[]{"XMI", "XML (Legacy)"});
            dialog.setFilterExtensions(new String[]{"*.xmi", "*.xml"});
            dialog.setFilterPath(CoreHub.getWritableUserDir().getAbsolutePath());
            String path = dialog.open();
            if (path != null) {
                IPerspectiveDescriptor createdPd = null;
                if (path.toLowerCase().endsWith("xml")) {
                    MPerspective mPerspective = (MPerspective)modelService.createModelElement(MPerspective.class);
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().open();
                    List<String> fastViewIds = perspectiveImportService.createPerspectiveFromLegacy(path, mPerspective);
                    createdPd = this.savePerspectiveToRegistryLegacy(mPerspective);
                    perspectiveImportService.openPerspective(createdPd);
                    this.switchToPerspectiveLegacy(mPerspective, fastViewIds);
                    IWorkbenchPage wp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    wp.savePerspectiveAs(createdPd);
                } else {
                    createdPd = perspectiveImportService.importPerspective(path, null, true);
                }
                if (createdPd != null) {
                    MessageDialog.openInformation((Shell)UiDesk.getDisplay().getActiveShell(), (String)"Import", (String)("Die Perspektive '" + createdPd.getLabel() + "' wurde erfolgreich importiert."));
                }
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)UiDesk.getDisplay().getActiveShell(), (String)"Import", (String)"Diese Perspektive kann nicht importiert werden.");
            LoggerFactory.getLogger(PerspektiveExportHandler.class).error("import error", (Throwable)e);
        }
        return null;
    }

    private IPerspectiveDescriptor savePerspectiveToRegistryLegacy(MPerspective perspective) {
        PerspectiveRegistry perspectiveRegistry = (PerspectiveRegistry)PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor pd = perspectiveRegistry.findPerspectiveWithId(perspective.getElementId());
        if (pd == null) {
            perspectiveRegistry.addPerspective(perspective);
            pd = perspectiveRegistry.findPerspectiveWithId(perspective.getElementId());
        } else {
            LoggerFactory.getLogger(PerspektiveImportHandler.class).error("perspective descriptor already exists for perspective id: " + perspective.getElementId());
        }
        return pd;
    }

    private void switchToPerspectiveLegacy(MPerspective loadedPerspective, List<String> preLoadedFastViewIds) {
        List windows;
        EModelService modelService = PerspektiveImportHandler.getService(EModelService.class);
        EPartService partService = PerspektiveImportHandler.getService(EPartService.class);
        MApplication mApplication = PerspektiveImportHandler.getService(MApplication.class);
        MTrimmedWindow mWindow = (MTrimmedWindow)modelService.find("IDEWindow", (MUIElement)mApplication);
        if (mWindow == null && !(windows = mApplication.getChildren()).isEmpty() && windows.get(0) instanceof MTrimmedWindow) {
            mWindow = (MTrimmedWindow)windows.get(0);
        }
        MPerspective activePerspective = modelService.getActivePerspective((MWindow)mWindow);
        MElementContainer perspectiveParent = activePerspective.getParent();
        List<String> fastViewIds = preLoadedFastViewIds;
        String id = loadedPerspective.getElementId();
        Iterator it = perspectiveParent.getChildren().iterator();
        while (it.hasNext()) {
            MUIElement element = (MUIElement)it.next();
            if (!id.equals(element.getElementId()) && !element.getElementId().startsWith(id + ".<")) continue;
            it.remove();
        }
        perspectiveParent.getChildren().add(loadedPerspective);
        for (String fastViewId : fastViewIds) {
            ElexisFastViewUtil.addToFastView((String)loadedPerspective.getElementId(), (String)fastViewId);
        }
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().open();
        partService.switchPerspective(loadedPerspective);
    }
}

