/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.entities;

import ch.elexis.core.jpa.entities.AbstractEntityWithId;
import ch.elexis.core.jpa.entities.EntityWithDeleted;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.Invoice;
import ch.elexis.core.jpa.entities.converter.BooleanCharacterConverterSafe;
import ch.elexis.core.jpa.entities.listener.EntityWithIdListener;
import ch.elexis.core.model.util.ElexisIdGenerator;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.time.LocalDate;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Table(name="zahlungen")
@EntityListeners(value={EntityWithIdListener.class})
@NamedQuery(name="Zahlung.invoice", query="SELECT za FROM Zahlung za WHERE za.deleted = false AND za.invoice = :invoice")
public class Zahlung
extends AbstractEntityWithId
implements EntityWithId,
EntityWithDeleted,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    protected Long lastupdate;
    @Id
    @GeneratedValue(generator="system-uuid")
    @Column(unique=true, nullable=false, length=25)
    private String id;
    @Column
    @Convert(converter=BooleanCharacterConverterSafe.class)
    protected boolean deleted;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="rechnungsid")
    private Invoice invoice;
    @Column(length=8, name="betrag")
    protected String amount;
    @Column(name="datum", length=8)
    protected LocalDate date;
    @Column(name="bemerkung", length=80)
    private String remark;
    static final long serialVersionUID = 4579404780171345760L;
    @Transient
    protected WeavedAttributeValueHolderInterface _persistence_invoice_vh;

    public Zahlung() {
        this.id = ElexisIdGenerator.generateId();
        this.deleted = false;
    }

    public Invoice getInvoice() {
        return this._persistence_get_invoice();
    }

    public void setInvoice(Invoice invoice) {
        this._persistence_set_invoice(invoice);
    }

    public String getAmount() {
        return this._persistence_get_amount();
    }

    public void setAmount(String amount) {
        this._persistence_set_amount(amount);
    }

    public LocalDate getDate() {
        return this._persistence_get_date();
    }

    public void setDate(LocalDate date) {
        this._persistence_set_date(date);
    }

    public String getRemark() {
        return this._persistence_get_remark();
    }

    public void setRemark(String remark) {
        this._persistence_set_remark(remark);
    }

    @Override
    public boolean isDeleted() {
        return this._persistence_get_deleted();
    }

    @Override
    public void setDeleted(boolean deleted) {
        this._persistence_set_deleted(deleted);
    }

    @Override
    public String getId() {
        return this._persistence_get_id();
    }

    @Override
    public void setId(String id) {
        this._persistence_set_id(id);
    }

    @Override
    public Long getLastupdate() {
        return this._persistence_get_lastupdate();
    }

    @Override
    public void setLastupdate(Long lastupdate) {
        this._persistence_set_lastupdate(lastupdate);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_invoice_vh != null) {
            this._persistence_invoice_vh = (WeavedAttributeValueHolderInterface)this._persistence_invoice_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Zahlung(persistenceObject);
    }

    public Zahlung(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "date") {
            return this.date;
        }
        if (string == "amount") {
            return this.amount;
        }
        if (string == "deleted") {
            return this.deleted;
        }
        if (string == "remark") {
            return this.remark;
        }
        if (string == "lastupdate") {
            return this.lastupdate;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "invoice") {
            return this.invoice;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "date") {
            this.date = (LocalDate)object;
            return;
        }
        if (string == "amount") {
            this.amount = (String)object;
            return;
        }
        if (string == "deleted") {
            this.deleted = (Boolean)object;
            return;
        }
        if (string == "remark") {
            this.remark = (String)object;
            return;
        }
        if (string == "lastupdate") {
            this.lastupdate = (Long)object;
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "invoice") {
            this.invoice = (Invoice)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public LocalDate _persistence_get_date() {
        this._persistence_checkFetched("date");
        return this.date;
    }

    public void _persistence_set_date(LocalDate localDate) {
        this._persistence_checkFetchedForSet("date");
        this._persistence_propertyChange("date", this.date, localDate);
        this.date = localDate;
    }

    public String _persistence_get_amount() {
        this._persistence_checkFetched("amount");
        return this.amount;
    }

    public void _persistence_set_amount(String string) {
        this._persistence_checkFetchedForSet("amount");
        this._persistence_propertyChange("amount", this.amount, string);
        this.amount = string;
    }

    public boolean _persistence_get_deleted() {
        this._persistence_checkFetched("deleted");
        return this.deleted;
    }

    public void _persistence_set_deleted(boolean bl) {
        this._persistence_checkFetchedForSet("deleted");
        this._persistence_propertyChange("deleted", new Boolean(this.deleted), new Boolean(bl));
        this.deleted = bl;
    }

    public String _persistence_get_remark() {
        this._persistence_checkFetched("remark");
        return this.remark;
    }

    public void _persistence_set_remark(String string) {
        this._persistence_checkFetchedForSet("remark");
        this._persistence_propertyChange("remark", this.remark, string);
        this.remark = string;
    }

    public Long _persistence_get_lastupdate() {
        this._persistence_checkFetched("lastupdate");
        return this.lastupdate;
    }

    public void _persistence_set_lastupdate(Long l) {
        this._persistence_checkFetchedForSet("lastupdate");
        this._persistence_propertyChange("lastupdate", this.lastupdate, l);
        this.lastupdate = l;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }

    protected void _persistence_initialize_invoice_vh() {
        if (this._persistence_invoice_vh == null) {
            this._persistence_invoice_vh = new ValueHolder((Object)this.invoice);
            this._persistence_invoice_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_invoice_vh() {
        Invoice invoice;
        this._persistence_initialize_invoice_vh();
        if ((this._persistence_invoice_vh.isCoordinatedWithProperty() || this._persistence_invoice_vh.isNewlyWeavedValueHolder()) && (invoice = this._persistence_get_invoice()) != this._persistence_invoice_vh.getValue()) {
            this._persistence_set_invoice(invoice);
        }
        return this._persistence_invoice_vh;
    }

    public void _persistence_set_invoice_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_invoice_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Invoice invoice = this._persistence_get_invoice();
            if (invoice != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_invoice((Invoice)object);
            }
        } else {
            this.invoice = null;
        }
    }

    public Invoice _persistence_get_invoice() {
        this._persistence_checkFetched("invoice");
        this._persistence_initialize_invoice_vh();
        this.invoice = (Invoice)this._persistence_invoice_vh.getValue();
        return this.invoice;
    }

    public void _persistence_set_invoice(Invoice invoice) {
        this._persistence_checkFetchedForSet("invoice");
        this._persistence_initialize_invoice_vh();
        this.invoice = (Invoice)this._persistence_invoice_vh.getValue();
        this._persistence_propertyChange("invoice", this.invoice, invoice);
        this.invoice = invoice;
        this._persistence_invoice_vh.setValue((Object)invoice);
    }
}

