/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.model.adapter;

import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.model.adapter.AbstractIdModelAdapter;
import ch.elexis.core.jpa.model.adapter.MappingEntry;
import ch.elexis.core.jpa.model.adapter.event.EntityChangeEventListenerHolder;
import ch.elexis.core.model.Identifiable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.slf4j.LoggerFactory;

public abstract class AbstractModelAdapterFactory {
    protected Map<Class<? extends AbstractIdModelAdapter<?>>, List<MappingEntry>> adapterToEntryMap = new HashMap();
    protected Map<Class<? extends EntityWithId>, List<MappingEntry>> entityToEntryMap = new HashMap<Class<? extends EntityWithId>, List<MappingEntry>>();
    protected Map<Class<?>, List<MappingEntry>> interfaceToEntryMap = new HashMap();
    protected Map<Class<? extends AbstractIdModelAdapter<?>>, Constructor<?>> adapterConstructorMap = new HashMap();

    public AbstractModelAdapterFactory() {
        this.initializeMappings();
        this.initializeAdapterContructors();
    }

    private void initializeAdapterContructors() {
        for (Class<? extends AbstractIdModelAdapter<?>> clazz : this.adapterToEntryMap.keySet()) {
            List<MappingEntry> entries = this.adapterToEntryMap.get(clazz);
            for (MappingEntry interfaceAdapterEntityEntry : entries) {
                this.adapterConstructorMap.put(clazz, this.getAdapterConstructor(clazz, interfaceAdapterEntityEntry.getEntityClass()));
            }
        }
    }

    protected abstract void initializeMappings();

    protected void addMapping(MappingEntry entry) {
        List<MappingEntry> list = this.interfaceToEntryMap.get(entry.getInterfaceClass());
        if (list == null) {
            list = new ArrayList<MappingEntry>();
        }
        list.add(entry);
        this.interfaceToEntryMap.put(entry.getInterfaceClass(), list);
        list = this.adapterToEntryMap.get(entry.getAdapterClass());
        if (list == null) {
            list = new ArrayList<MappingEntry>();
        }
        list.add(entry);
        this.adapterToEntryMap.put(entry.getAdapterClass(), list);
        list = this.entityToEntryMap.get(entry.getEntityClass());
        if (list == null) {
            list = new ArrayList<MappingEntry>();
        }
        list.add(entry);
        this.entityToEntryMap.put(entry.getEntityClass(), list);
    }

    protected MappingEntry getMappingForInterface(Class<?> clazz) {
        List<MappingEntry> entryList = this.interfaceToEntryMap.get(clazz);
        return this.getSingleEntry(entryList);
    }

    protected MappingEntry getMappingForAdapter(Class<? extends AbstractIdModelAdapter<?>> adapter) {
        List<MappingEntry> entryList = this.adapterToEntryMap.get(adapter);
        return this.getSingleEntry(entryList);
    }

    protected MappingEntry getMappingEntity(Class<? extends EntityWithId> entity, Class<?> interfaceClass) {
        List<MappingEntry> entryList = this.entityToEntryMap.get(entity);
        if (interfaceClass != null) {
            return this.getSingleEntry(entryList, e -> e.getInterfaceClass() == interfaceClass);
        }
        return this.getSingleEntry(entryList);
    }

    protected Constructor<?> getAdapterConstructor(Class<? extends AbstractIdModelAdapter<?>> adapter) {
        return this.adapterConstructorMap.get(adapter);
    }

    public Optional<Identifiable> getModelAdapter(EntityWithId entity, Class<?> interfaceClass, boolean testPrecondition) {
        return this.getModelAdapter(entity, interfaceClass, testPrecondition, true);
    }

    public Optional<Identifiable> getModelAdapter(EntityWithId entity, Class<?> interfaceClass, boolean testPrecondition, boolean registerEntityChangeEvent) {
        MappingEntry mapping;
        if (entity != null && (mapping = this.getMappingEntity(entity.getClass(), interfaceClass)) != null) {
            Identifiable adapter = this.getAdapterInstance(mapping.getAdapterClass(), entity);
            if (testPrecondition && !mapping.testAdapterPrecondition((AbstractIdModelAdapter)adapter)) {
                LoggerFactory.getLogger(this.getClass()).error("Adapter precondition failed for [" + String.valueOf(adapter) + "] with id [" + adapter.getId() + "]");
                return Optional.empty();
            }
            if (registerEntityChangeEvent) {
                EntityChangeEventListenerHolder.get().add((AbstractIdModelAdapter)adapter);
            }
            return Optional.of(adapter);
        }
        return Optional.empty();
    }

    public Class<? extends EntityWithId> getEntityClass(Class<?> clazz) {
        MappingEntry mapping = this.getMappingForInterface(clazz);
        if (mapping != null) {
            return mapping.getEntityClass();
        }
        mapping = this.getMappingForAdapter(clazz);
        return mapping != null ? mapping.getEntityClass() : null;
    }

    private Identifiable getAdapterInstance(Class<? extends AbstractIdModelAdapter<?>> adapterClass, EntityWithId dbObject) {
        Constructor<?> constructor = this.getAdapterConstructor(adapterClass);
        if (constructor != null) {
            try {
                return (Identifiable)constructor.newInstance(dbObject);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                throw new IllegalStateException("Error creating new AbstractModelAdapter instance", e);
            }
        }
        throw new IllegalStateException("No contructor for " + String.valueOf(adapterClass) + " found");
    }

    protected Constructor<?> getAdapterConstructor(Class<? extends AbstractIdModelAdapter<?>> adapterClass, Class<? extends EntityWithId> modelClass) {
        try {
            return adapterClass.getConstructor(modelClass);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalStateException("Could not find AbstractModelAdapter constructor for " + String.valueOf(adapterClass), e);
        }
    }

    public <T> T createAdapter(Class<T> clazz) {
        try {
            MappingEntry mapping = this.getMappingForInterface(clazz);
            if (mapping != null) {
                EntityWithId dbObject = mapping.getEntityClass().newInstance();
                Optional<Identifiable> ret = this.getModelAdapter(dbObject, clazz, false);
                if (ret.isPresent() && clazz.isAssignableFrom(ret.get().getClass())) {
                    mapping.initialize((AbstractIdModelAdapter)ret.get());
                    return (T)ret.get();
                }
                throw new IllegalStateException("Created model " + String.valueOf(ret.orElse(null)) + " is no instance of class " + String.valueOf(clazz));
            }
            throw new IllegalStateException("No model class found for " + String.valueOf(clazz));
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Error creating adapter", e);
        }
    }

    private MappingEntry getSingleEntry(List<MappingEntry> entryList) {
        if (entryList != null && !entryList.isEmpty()) {
            return entryList.get(0);
        }
        return null;
    }

    private MappingEntry getSingleEntry(List<MappingEntry> entryList, Predicate<MappingEntry> matcher) {
        if (entryList != null && !entryList.isEmpty()) {
            for (MappingEntry mappingEntry : entryList) {
                if (!matcher.test(mappingEntry)) continue;
                return mappingEntry;
            }
            throw new IllegalStateException("Ambiguous adapter mapping for [" + String.valueOf(entryList.get(0).getAdapterClass()) + "]");
        }
        return null;
    }
}

