/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.mail.ui.handlers;

import ch.elexis.core.mail.AttachmentsUtil;
import ch.elexis.core.mail.MailMessage;
import ch.elexis.core.mail.TaskUtil;
import ch.elexis.core.mail.ui.dialogs.SendMailDialog;
import ch.elexis.core.mail.ui.handlers.SendMailTaskWithProgress;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IDocumentLetter;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.tasks.model.ITask;
import ch.elexis.core.tasks.model.ITaskDescriptor;
import ch.elexis.core.tasks.model.TaskState;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.ui.handlers.HandlerUtil;

public class SendMailHandler
extends AbstractHandler
implements IHandler {
    public static Optional<ITaskDescriptor> taskDescriptor;
    public static final String MESSAGE_KEY = "message";
    public static final String TEXT_KEY = "text";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Map messageMap;
        Object messageText;
        Object messageObject;
        ITaskDescriptor taskDescriptor;
        Map runContext;
        String subject;
        String to;
        String documents;
        SendMailDialog sendMailDialog = new SendMailDialog(HandlerUtil.getActiveShell((ExecutionEvent)event));
        String attachments = event.getParameter("ch.elexis.core.mail.ui.sendMail.attachments");
        if (attachments != null) {
            sendMailDialog.setAttachmentsString(attachments);
        }
        if ((documents = event.getParameter("ch.elexis.core.mail.ui.sendMail.documents")) != null) {
            sendMailDialog.setDocumentsString(documents);
            List loadedDocuments = AttachmentsUtil.getDocuments((String)documents);
            for (IDocument iDocument : loadedDocuments) {
                if (!(iDocument instanceof IDocumentLetter) || ((IDocumentLetter)iDocument).getRecipient() == null || !StringUtils.isNotBlank((CharSequence)((IDocumentLetter)iDocument).getRecipient().getEmail())) continue;
                sendMailDialog.setTo(((IDocumentLetter)iDocument).getRecipient().getEmail());
                break;
            }
        }
        if ((to = event.getParameter("ch.elexis.core.mail.ui.sendMail.to")) != null) {
            sendMailDialog.setTo(to);
        }
        String accountId = event.getParameter("ch.elexis.core.mail.ui.sendMail.accountid");
        if (to != null) {
            sendMailDialog.setAccountId(accountId);
        }
        if ((subject = event.getParameter("ch.elexis.core.mail.ui.sendMail.subject")) != null) {
            sendMailDialog.setSubject(subject);
        }
        String text = event.getParameter("ch.elexis.core.mail.ui.sendMail.text");
        Optional descriptor = ContextServiceHolder.get().getNamed("sendMailDialog.taskDescriptor");
        if (descriptor.isPresent() && descriptor.get() instanceof ITaskDescriptor && (runContext = (taskDescriptor = (ITaskDescriptor)descriptor.get()).getRunContext()) != null && runContext.containsKey(MESSAGE_KEY) && (messageObject = runContext.get(MESSAGE_KEY)) instanceof Map && (messageText = (messageMap = (Map)messageObject).get(TEXT_KEY)) != null) {
            text = messageText.toString();
        }
        if (text != null) {
            sendMailDialog.setText(text);
        }
        Boolean doSend = Boolean.TRUE;
        String doSendString = event.getParameter("ch.elexis.core.mail.ui.sendMail.doSend");
        if (StringUtils.isNotBlank((CharSequence)doSendString)) {
            doSend = Boolean.valueOf(doSendString);
            sendMailDialog.doSend(doSend);
        }
        if (sendMailDialog.open() == 0) {
            MailMessage message = new MailMessage().to(sendMailDialog.getTo()).cc(sendMailDialog.getCc()).subject(sendMailDialog.getSubject()).text(sendMailDialog.getText());
            message.setAttachments(sendMailDialog.getAttachmentsString());
            message.setDocuments(sendMailDialog.getDocumentsString());
            SendMailHandler.taskDescriptor = TaskUtil.createSendMailTaskDescriptor((String)sendMailDialog.getAccount().getId(), (MailMessage)message);
            if (doSend.booleanValue() && SendMailHandler.taskDescriptor.isPresent()) {
                ContextServiceHolder.get().getRootContext().setNamed("sendMailDialog.taskDescriptor", null);
                ITask task = new SendMailTaskWithProgress().execute(HandlerUtil.getActiveShell((ExecutionEvent)event), SendMailHandler.taskDescriptor.get(), message);
                if (task.getState() == TaskState.COMPLETED) {
                    return true;
                }
                return false;
            }
            if (!doSend.booleanValue()) {
                ContextServiceHolder.get().getRootContext().setNamed("sendMailDialog.taskDescriptor", (Object)SendMailHandler.taskDescriptor.get());
            }
        }
        return false;
    }
}

