/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.mail.ui.dialogs;

import ch.elexis.core.mail.ui.dialogs.AttachmentsComposite;
import ch.elexis.core.mail.ui.handlers.BriefeDocumentStoreHolder;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.StoreToStringServiceHolder;
import ch.elexis.core.types.DocumentStatus;
import ch.elexis.core.ui.icons.Images;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.slf4j.LoggerFactory;

public class LaborAttachmentAction
extends Action
implements IAction {
    private AttachmentsComposite composite;
    private Command createRocheLaborCommand;

    public LaborAttachmentAction(AttachmentsComposite attachmentsComposite, Command createRocheLaborCommand) {
        this.composite = attachmentsComposite;
        this.createRocheLaborCommand = createRocheLaborCommand;
    }

    public ImageDescriptor getImageDescriptor() {
        return Images.IMG_VIEW_LABORATORY.getImageDescriptor();
    }

    public void run() {
        block13: {
            try {
                HashMap params = new HashMap();
                ParameterizedCommand parametrizedCommmand = ParameterizedCommand.generateCommand((Command)this.createRocheLaborCommand, params);
                Object pdfFile = ((IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class)).executeCommand(parametrizedCommmand, null);
                if (!(pdfFile instanceof File)) break block13;
                IPatient patient = (IPatient)ContextServiceHolder.get().getActivePatient().get();
                IDocument document = BriefeDocumentStoreHolder.get().createDocument(patient.getId(), "Laborblatt Mail" + (String)(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.composite.getPostfix()}) ? " [" + this.composite.getPostfix() + "]" : ""), "Labor");
                document.setExtension("pdf");
                document.setStatus(DocumentStatus.SENT, true);
                Throwable throwable = null;
                Object var7_9 = null;
                try (FileInputStream fi = new FileInputStream((File)pdfFile);){
                    BriefeDocumentStoreHolder.get().saveDocument(document, (InputStream)fi);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                String existingDocuments = this.composite.getDocuments();
                if (StringUtils.isEmpty((CharSequence)existingDocuments)) {
                    this.composite.setDocuments(StoreToStringServiceHolder.getStoreToString((Object)document));
                } else {
                    this.composite.setDocuments(existingDocuments + ":::" + StoreToStringServiceHolder.getStoreToString((Object)document));
                }
            }
            catch (Exception ex) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Error getting labor pdf", (Throwable)ex);
            }
        }
        super.run();
    }
}

