/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.contacts.views;

import ch.elexis.core.ac.EvACE;
import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.Heartbeat;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IImage;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.ISticker;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.format.AddressFormatUtil;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.StickerServiceHolder;
import ch.elexis.core.types.Gender;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.contacts.dialogs.PatientErfassenDialog;
import ch.elexis.core.ui.contacts.views.PatListeContentProvider;
import ch.elexis.core.ui.contacts.views.PatientMenuPopulator;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.DefaultControlFieldProvider;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import ch.elexis.core.ui.util.viewers.SimpleWidgetProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.data.Anwender;
import ch.elexis.data.Patient;
import ch.elexis.data.Reminder;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.StringJoiner;
import org.eclipse.core.commands.Command;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.ViewPart;

public class PatientenListeView
extends ViewPart
implements IActivationListener,
Heartbeat.HeartListener {
    private CommonViewer cv;
    private ViewerConfigurer vc;
    private ViewMenus menus;
    private RestrictedAction newPatAction;
    private IAction copySelectedPatInfosToClipboardAction;
    private IAction copySelectedAddressesToClipboardAction;
    private String[] currentUserFields;
    PatListeContentProvider plcp;
    DefaultControlFieldProvider dcfp;
    Composite parent;
    private boolean created = false;
    private IUser actUser;
    @Inject
    private IContextService contextService;

    @Inject
    void activeUser(@Optional IUser user) {
        this.actUser = user;
        if (this.created) {
            Display.getDefault().asyncExec(() -> this.userChanged(user));
        }
    }

    @Inject
    @Optional
    public void reload(@UIEventTopic(value="info/elexis/model/reload") Class<?> clazz) {
        if (IPatient.class.equals(clazz) && this.created) {
            Display.getDefault().asyncExec(() -> this.reload());
        }
    }

    public void dispose() {
        this.plcp.stopListening();
        GlobalEventDispatcher.removeActivationListener((IActivationListener)this, (IWorkbenchPart)this);
        super.dispose();
    }

    public IPatient getSelectedPatient() {
        Object[] sel = this.cv.getSelection();
        if (sel != null) {
            return (IPatient)sel[0];
        }
        return null;
    }

    public void reload() {
        this.plcp.invalidate();
        this.cv.notify(CommonViewer.Message.update);
    }

    public void createPartControl(final Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        this.parent = parent;
        this.parent.setLayout((Layout)layout);
        this.cv = new CommonViewer();
        this.collectUserFields();
        this.plcp = new PatListeContentProvider(this.cv, this.currentUserFields, this);
        this.makeActions();
        this.dcfp = new DefaultControlFieldProvider(this.cv, this.currentUserFields){

            public void setQuery(IQuery<?> query) {
                int i = 0;
                while (i < this.dbFields.length) {
                    if (!this.lastFiltered[i].equals("")) {
                        if ("dob".equals(this.dbFields[i])) {
                            query.and(this.dbFields[i], IQuery.COMPARATOR.LIKE, (Object)NoPoUtil.getElexisDateSearchString((String)this.lastFiltered[i]), true);
                        } else if ("code".equals(this.dbFields[i])) {
                            query.and(this.dbFields[i], IQuery.COMPARATOR.EQUALS, (Object)this.lastFiltered[i]);
                        } else {
                            query.and(this.dbFields[i], IQuery.COMPARATOR.LIKE, (Object)(this.lastFiltered[i] + "%"), true);
                        }
                    }
                    ++i;
                }
            }
        };
        this.updateFocusField();
        this.vc = new ViewerConfigurer((ViewerConfigurer.ICommonViewerContentProvider)this.plcp, (LabelProvider)new PatLabelProvider(), (ViewerConfigurer.ControlFieldProvider)this.dcfp, (ViewerConfigurer.ButtonProvider)new ViewerConfigurer.DefaultButtonProvider(), (ViewerConfigurer.WidgetProvider)new SimpleWidgetProvider(3, 4, this.cv));
        this.cv.create(this.vc, parent, 0, (Object)this.getViewSite());
        this.cv.getConfigurer().getControlFieldProvider().addChangeListener((ViewerConfigurer.ControlFieldListener)new ControlFieldSelectionListener());
        this.cv.getViewerWidget().getControl().setFont(UiDesk.getFont((String)"anwender/stdfont"));
        this.plcp.startListening();
        GlobalEventDispatcher.addActivationListener((IActivationListener)this, (IWorkbenchPart)this);
        this.populateViewMenu();
        StructuredViewer viewer = this.cv.getViewerWidget();
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PropertyDialogAction pdAction = new PropertyDialogAction((IShellProvider)new SameShellProvider((Control)parent), PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite().getSelectionProvider());
                if (pdAction.isApplicableForSelection()) {
                    pdAction.run();
                }
            }
        });
        this.getSite().registerContextMenu(this.menus.getContextMenu(), (ISelectionProvider)viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)viewer);
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = service.getCommand("at.medevit.elexis.contacts.core.command.StickerFilter");
        if (command != null) {
            command.getState("org.eclipse.ui.commands.toggleState").setValue((Object)false);
        }
        this.created = true;
    }

    private void updateFocusField() {
        String ff = ConfigServiceHolder.getUser((String)"anwender/patlist/focusfield", null);
        if (ff != null) {
            this.dcfp.setFocusField(ff);
        }
    }

    private void collectUserFields() {
        ArrayList<CallSite> fields = new ArrayList<CallSite>();
        if (ConfigServiceHolder.getUser((String)"anwender/patlist/zeigenr", (boolean)false)) {
            fields.add((CallSite)((Object)("code=" + Messages.PatientenListeView_PatientNr)));
        }
        if (ConfigServiceHolder.getUser((String)"anwender/patlist/zeigename", (boolean)true)) {
            fields.add((CallSite)((Object)("description1=" + Messages.Core_Name)));
        }
        if (ConfigServiceHolder.getUser((String)"anwender/patlist/zeigevorname", (boolean)true)) {
            fields.add((CallSite)((Object)("description2=" + Messages.Core_Firstname)));
        }
        if (ConfigServiceHolder.getUser((String)"anwender/patlist/zeigegebdat", (boolean)true)) {
            fields.add((CallSite)((Object)("dob=" + Messages.Core_Enter_Birthdate)));
        }
        this.currentUserFields = fields.toArray(new String[fields.size()]);
    }

    private void populateViewMenu() {
        this.menus = new ViewMenus(this.getViewSite());
        this.menus.createToolbar(new IAction[]{this.newPatAction});
        this.menus.createToolbar(new IAction[]{this.copySelectedPatInfosToClipboardAction});
        this.menus.createToolbar(new IAction[]{this.copySelectedAddressesToClipboardAction});
        PatientMenuPopulator pmp = new PatientMenuPopulator(this, this.cv.getViewerWidget());
        this.menus.createControlContextMenu(this.cv.getViewerWidget().getControl(), (ViewMenus.IMenuPopulator)pmp);
        this.menus.getContextMenu().addMenuListener((IMenuListener)pmp);
        this.menus.createMenu(new IAction[]{this.newPatAction});
        this.menus.createMenu(new IAction[]{this.copySelectedPatInfosToClipboardAction});
        this.menus.createMenu(new IAction[]{this.copySelectedAddressesToClipboardAction});
    }

    public PatListeContentProvider getContentProvider() {
        return this.plcp;
    }

    public void setFocus() {
        this.vc.getControlFieldProvider().setFocus();
    }

    public void reset() {
        this.vc.getControlFieldProvider().clearValues();
    }

    private void makeActions() {
        this.newPatAction = new RestrictedAction((EvaluatableACE)EvACE.of(IPatient.class, (Right)Right.CREATE), Messages.PatientenListeView_NewPatientAction){
            {
                this.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
                this.setToolTipText(Messages.PatientenListeView_NewPationtToolTip);
            }

            public void doRun() {
                PatientErfassenDialog ped;
                HashMap<String, String> ctlFields = new HashMap<String, String>();
                String[] fx = PatientenListeView.this.vc.getControlFieldProvider().getValues();
                int i = 0;
                if (ConfigServiceHolder.getUser((String)"anwender/patlist/zeigenr", (boolean)false) && i < fx.length) {
                    ctlFields.put("PatientNr", fx[i++]);
                }
                if (ConfigServiceHolder.getUser((String)"anwender/patlist/zeigename", (boolean)true) && i < fx.length) {
                    ctlFields.put("Name", fx[i++]);
                }
                if (ConfigServiceHolder.getUser((String)"anwender/patlist/zeigevorname", (boolean)true) && i < fx.length) {
                    ctlFields.put("Vorname", fx[i++]);
                }
                if (ConfigServiceHolder.getUser((String)"anwender/patlist/zeigegebdat", (boolean)true) && i < fx.length) {
                    ctlFields.put("Geburtsdatum", fx[i++]);
                }
                if ((ped = new PatientErfassenDialog(PatientenListeView.this.getViewSite().getShell(), ctlFields)).open() == 0) {
                    PatientenListeView.this.plcp.temporaryAddObject(ped.getResult());
                    IPatient pat = ped.getResult();
                    int j = 0;
                    while (j < PatientenListeView.this.currentUserFields.length) {
                        String current = PatientenListeView.this.currentUserFields[j];
                        if (current.startsWith("PatientNr")) {
                            PatientenListeView.this.dcfp.setValue(j, pat.getPatientNr());
                        } else if (current.startsWith("Name") && pat.getLastName() != null) {
                            PatientenListeView.this.dcfp.setValue(j, pat.getLastName());
                        } else if (current.startsWith("Vorname") && pat.getFirstName() != null) {
                            PatientenListeView.this.dcfp.setValue(j, pat.getFirstName());
                        }
                        ++j;
                    }
                    PatientenListeView.this.plcp.syncRefresh();
                    TableViewer tv = (TableViewer)PatientenListeView.this.cv.getViewerWidget();
                    tv.setSelection((ISelection)new StructuredSelection((Object)pat), true);
                }
            }
        };
        this.copySelectedPatInfosToClipboardAction = new Action(Messages.PatientenListeView_copySelectedPatInfosToClipboard){
            {
                this.setImageDescriptor(Images.IMG_CLIPBOARD.getImageDescriptor());
                this.setToolTipText(Messages.PatientenListeView_copySelectedPatInfosToClipboard);
            }

            public void run() {
                StringJoiner sj = new StringJoiner(System.lineSeparator());
                Object[] sel = PatientenListeView.this.cv.getSelection();
                if (sel != null && sel.length > 0) {
                    int i = 0;
                    while (i < sel.length) {
                        StringBuilder sb = new StringBuilder();
                        IPatient selectedPatient = (IPatient)sel[i];
                        if (selectedPatient.isPerson()) {
                            sb.append(AddressFormatUtil.getSingleLine((IPerson)selectedPatient));
                        } else {
                            sb.append("Fehler: Bei diesem Patienten ist das Flag \"Person\" nicht gesetzt! Bitte korrigieren!\n");
                        }
                        sj.add(sb.toString());
                        ++i;
                    }
                    Clipboard clipboard = new Clipboard(UiDesk.getDisplay());
                    TextTransfer textTransfer = TextTransfer.getInstance();
                    Transfer[] transfers = new Transfer[]{textTransfer};
                    Object[] data = new Object[]{sj.toString()};
                    clipboard.setContents(data, transfers);
                    clipboard.dispose();
                }
            }
        };
        this.copySelectedAddressesToClipboardAction = new Action(Messages.PatientenListeView_copySelectedAddressesToClipboard){
            {
                this.setImageDescriptor(Images.IMG_CLIPBOARD.getImageDescriptor());
                this.setToolTipText(Messages.PatientenListeView_copySelectedAddressesToClipboard);
            }

            public void run() {
                StringJoiner sj = new StringJoiner(System.lineSeparator());
                Object[] sel = PatientenListeView.this.cv.getSelection();
                if (sel != null && sel.length > 0) {
                    int i = 0;
                    while (i < sel.length) {
                        StringBuilder sb = new StringBuilder();
                        IPatient selectedPatient = (IPatient)sel[i];
                        sb.append(AddressFormatUtil.getAddressPhoneFaxEmail((IContact)selectedPatient, (boolean)true, (boolean)true));
                        sj.add(sb.toString());
                        ++i;
                    }
                    Clipboard clipboard = new Clipboard(UiDesk.getDisplay());
                    TextTransfer textTransfer = TextTransfer.getInstance();
                    Transfer[] transfers = new Transfer[]{textTransfer};
                    Object[] data = new Object[]{sj.toString()};
                    clipboard.setContents(data, transfers);
                    clipboard.dispose();
                }
            }
        };
    }

    public void activation(boolean mode) {
        if (mode) {
            this.newPatAction.reflectRight();
            this.heartbeat();
            CoreHub.heart.addListener((Heartbeat.HeartListener)this);
        } else {
            CoreHub.heart.removeListener((Heartbeat.HeartListener)this);
        }
    }

    public void visible(boolean mode) {
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }

    public void heartbeat() {
        this.cv.notify(CommonViewer.Message.update);
    }

    public void userChanged(IUser user) {
        if (!Objects.equals(this.actUser, user)) {
            SWTHelper.reloadViewPart((String)"ch.elexis.PatListView");
        }
        if (!this.cv.getViewerWidget().getControl().isDisposed()) {
            this.cv.getViewerWidget().getControl().setFont(UiDesk.getFont((String)"anwender/stdfont"));
            this.cv.notify(CommonViewer.Message.update);
            this.collectUserFields();
            this.dcfp.updateFields(this.currentUserFields, true);
            this.plcp.updateFields(this.currentUserFields);
            this.updateFocusField();
            this.dcfp.getParent().layout(true);
        }
    }

    class ControlFieldSelectionListener
    implements ViewerConfigurer.ControlFieldListener {
        ControlFieldSelectionListener() {
        }

        public void changed(HashMap<String, String> values) {
        }

        public void reorder(String field) {
        }

        public void selected() {
            Object element;
            StructuredViewer viewer = PatientenListeView.this.cv.getViewerWidget();
            Object[] elements = PatientenListeView.this.cv.getConfigurer().getContentProvider().getElements(viewer.getInput());
            if (elements != null && elements.length > 0 && (element = elements[0]) instanceof IPatient) {
                ContextServiceHolder.get().getRootContext().setTyped((Object)((IPatient)element));
            }
        }
    }

    class PatLabelProvider
    extends DefaultLabelProvider
    implements ITableColorProvider {
        PatLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof IPatient) {
                IPatient pat = (IPatient)element;
                if (PatientenListeView.this.contextService.getActiveMandator().isPresent() && !Reminder.findRemindersDueFor((Patient)Patient.load((String)pat.getId()), (Anwender)Anwender.load((String)((IMandator)PatientenListeView.this.contextService.getActiveMandator().get()).getId()), (boolean)false).isEmpty()) {
                    return Images.IMG_AUSRUFEZ.getImage();
                }
                ISticker sticker = StickerServiceHolder.get().getSticker((Identifiable)pat).orElse(null);
                if (sticker != null && sticker.getImage() != null) {
                    return CoreUiUtil.getImageAsIcon((IImage)sticker.getImage());
                }
                if (pat.getGender().equals((Object)Gender.MALE)) {
                    return Images.IMG_MANN.getImage();
                }
                return Images.IMG_FRAU.getImage();
            }
            return super.getColumnImage(element, columnIndex);
        }

        public Color getBackground(Object element, int columnIndex) {
            if (element instanceof IPatient) {
                IPatient pat = (IPatient)element;
                ISticker et = StickerServiceHolder.get().getSticker((Identifiable)pat).orElse(null);
                if (et != null && et.getBackground() != null) {
                    return CoreUiUtil.getColorForString((String)et.getBackground());
                }
            }
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            if (element instanceof IPatient) {
                IPatient pat = (IPatient)element;
                ISticker et = StickerServiceHolder.get().getSticker((Identifiable)pat).orElse(null);
                if (et != null && et.getForeground() != null) {
                    return CoreUiUtil.getColorForString((String)et.getForeground());
                }
            }
            return null;
        }
    }
}

