/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.icons;

import ch.elexis.core.jdt.NonNull;
import ch.elexis.core.ui.icons.ImageSize;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public enum Images {
    IMG_LOGO,
    IMG_2E,
    IMG_HOME,
    IMG_ADRESSETIKETTE,
    IMG_PATIENTETIKETTE,
    IMG_VERSIONEDETIKETTE,
    IMG_BOMB,
    IMG_ORGANISATION,
    IMG_ORGANISATION_ADD,
    IMG_EMPTY_TRANSPARENT,
    IMG_TELEPHONE,
    IMG_MOBILEPHONE,
    IMG_FAX,
    IMG_MAIL,
    IMG_MAIL_SEND,
    IMG_WEB,
    IMG_COMMENT_ADD,
    IMG_CONTACT_DETAIL,
    IMG_DELETE,
    IMG_MANN,
    IMG_FRAU,
    IMG_GROUP,
    IMG_MONEY,
    IMG_VIP,
    IMG_VIP_OVERLAY,
    IMG_PRINTER,
    IMG_PRINTER_BIG,
    IMG_PRINT_FIX,
    IMG_PRINT_RESERVE,
    IMG_PRINT_SYMPTOMATIC,
    IMG_FILTER,
    IMG_FOLDER,
    IMG_NEW,
    IMG_IMPORT,
    IMG_EXPORT,
    IMG_GOFURTHER,
    IMG_EDIT,
    IMG_EDIT_DONE,
    IMG_EDIT_ABORT,
    IMG_ACHTUNG,
    IMG_BULLET_RED,
    IMG_BULLET_GREEN,
    IMG_BULLET_YELLOW,
    IMG_BULLET_GREY,
    IMG_BULLET_BLUE,
    IMG_OK,
    IMG_TICK,
    IMG_FEHLER,
    IMG_REFRESH,
    IMG_WIZARD,
    IMG_ADDITEM,
    IMG_REMOVEITEM,
    IMG_AUSRUFEZ_ROT,
    IMG_AUSRUFEZ,
    IMG_NETWORK,
    IMG_BOOK,
    IMG_BOOKMARK_PENCIL,
    IMG_PERSON,
    IMG_PERSON_OK,
    IMG_PERSON_ADD,
    IMG_PERSON_GREY,
    IMG_DISK,
    IMG_LOCK_CLOSED,
    IMG_LOCK_CLOSED_YELLOW,
    IMG_LOCK_CLOSED_GREEN,
    IMG_LOCK_CLOSED_GREY,
    IMG_LOCK_OPEN,
    IMG_LOCK_CO,
    IMG_CLIPBOARD,
    IMG_NEXT,
    IMG_NEXT_WO_SHADOW,
    IMG_PREVIOUS,
    IMG_ARROWUP,
    IMG_ARROWDOWN,
    IMG_ARROWDOWNTORECT,
    IMG_ARROWSTOP,
    IMG_ARROWSTOP_WO_SHADOW,
    IMG_EYE_WO_SHADOW,
    IMG_UNDO,
    IMG_PENCIL_8PX,
    IMG_PILL,
    IMG_PILL_EXCLAMATION_WO_SHADOW,
    IMG_PILLS,
    IMG_LINK,
    IMG_MOVETOUPPERLIST,
    IMG_MOVETOLOWERLIST,
    IMG_CLEAR,
    IMG_PERSPECTIVE_KONS,
    IMG_PERSPECTIVE_CONTACTS,
    IMG_PERSPECTIVE_LETTERS,
    IMG_PERSPECTIVE_LEISTUNGEN,
    IMG_PERSPECTIVE_ARTICLES,
    IMG_PERSPECTIVE_REMINDERS,
    IMG_PERSPECTIVE_BILLS,
    IMG_PERSPECTIVE_BBS,
    IMG_PERSPECTIVE_ORDERS,
    IMG_DOCUMENT_EXCEL,
    IMG_DOCUMENT_PDF,
    IMG_DOCUMENT_TEXT,
    IMG_DOCUMENT_STAND_UP,
    IMG_DOCUMENT_STACK,
    IMG_DOCUMENT,
    IMG_DOCUMENT_ADD,
    IMG_DOCUMENT_WRITE,
    IMG_DOCUMENT_REMOVE,
    IMG_DOCUMENT_CONVERT,
    IMG_MENUBAR,
    IMG_TOOLBAR,
    IMG_RECIPE_FIX,
    IMG_RECIPE_RESERVE,
    IMG_RECIPE_SYMPTOMATIC,
    IMG_BILL,
    IMG_VIEW_WORK_INCAPABLE,
    IMG_VIEW_CONSULTATION_DETAIL,
    IMG_VIEW_LABORATORY,
    IMG_VIEW_PATIENT_DETAIL,
    IMG_VIEW_RECIPES,
    IMG_DATABASE,
    IMG_CONFLICT,
    IMG_QUESTION_MARK,
    IMG_FLAG_AT,
    IMG_FLAG_DE,
    IMG_FLAG_CH,
    IMG_FLAG_FR,
    IMG_FLAG_IT,
    IMG_FLAG_FL,
    IMG_CATEGORY_GROUP,
    IMG_SYRINGE,
    IMG_BLOCKS_SMALL,
    IMG_SYNC,
    IMG_STAR,
    IMG_STAR_EMPTY,
    IMG_STOP,
    IMG_COVERCARD,
    IMG_COPY,
    IMG_USER_SILHOUETTE,
    IMG_TABLE,
    IMG_NODE,
    IMG_NW_STATUS,
    IMG_GEAR,
    IMG_CHECKBOX,
    IMG_CHECKBOX_UNCHECKED,
    IMG_DOC_STAND,
    IMG_DOC_SYS,
    IMG_JAR,
    IMG_FIX_MEDI,
    IMG_RESERVE_MEDI,
    IMG_SYMPTOM_MEDI,
    IMG_NEED_MEDI,
    IMG_SORT_STAR,
    IMG_DATA,
    IMG_BALANCE_EDIT,
    IMG_CART,
    IMG_WIZ_DAY,
    IMG_CALENDAR,
    IMG_COUNTER_STOP,
    IMG_USER_IDLE,
    IMG_SYSTEM_MONITOR,
    IMG_BELL_EXCLAMATION,
    IMG_SORT_DATE,
    IMG_SORT_DATE_DESCENDING,
    IMG_CARDS,
    IMG_NOBILLING,
    IMG_BAGGAGE_CART_BOX,
    IMG_HAND,
    IMG_CLOCK,
    IMG_TASK,
    IMG_SCANNER,
    IMG_SCANNER_BARCODE,
    IMG_DRAWER,
    IMG_DRAWER_ARROW,
    IMG_ADD,
    IMG_INBOX,
    IMG_OUTBOX,
    IMG_SERVER_PENCIL,
    IMG_CHART_CURVE;

    private static int deviceZoom;

    private static void initDeviceZoom() {
        deviceZoom = 100;
        String deviceZoomProp = System.getProperty("org.eclipse.swt.internal.deviceZoom");
        if (deviceZoomProp != null && !deviceZoomProp.isEmpty()) {
            try {
                deviceZoom = Integer.parseInt(deviceZoomProp);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public Image getImage() {
        return this.getImage(ImageSize._16x16_DefaultIconSize);
    }

    public ImageDescriptor getImageDescriptor() {
        return this.getImageDescriptor(ImageSize._16x16_DefaultIconSize);
    }

    public static Image lookupImage(String iconKey, ImageSize is) {
        Image image = JFaceResources.getImageRegistry().get(iconKey + is.name);
        if (image == null) {
            boolean ret = Images.addIconImageDescriptor(iconKey, is);
            if (!ret) {
                return null;
            }
            image = JFaceResources.getImageRegistry().get(iconKey);
        }
        return image;
    }

    public static ImageDescriptor lookupImageDescriptor(@NonNull String iconKey, @NonNull ImageSize is) {
        return Images.getImageDescriptor(iconKey, is);
    }

    public synchronized Image getImage(ImageSize is) {
        Image image = JFaceResources.getImageRegistry().get(this.name() + is.name);
        if (image == null) {
            Images.addIconImageDescriptor(this.name(), is);
            image = JFaceResources.getImageRegistry().get(this.name() + is.name);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(ImageSize is) {
        return Images.getImageDescriptor(this.name(), is);
    }

    public ImageDescriptor getURLImageDescriptor() {
        try {
            URL imageDesciptorUrl = new URL(this.getIconURI());
            return ImageDescriptor.createFromURL((URL)imageDesciptorUrl);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static ImageDescriptor getImageDescriptor(String imageName, ImageSize is) {
        ImageDescriptor id = null;
        id = JFaceResources.getImageRegistry().getDescriptor(imageName + is.name);
        if (id == null) {
            Images.addIconImageDescriptor(imageName, is);
            id = JFaceResources.getImageRegistry().getDescriptor(imageName + is.name);
        }
        return id;
    }

    public String getIconURI() {
        return "icon://" + this.name();
    }

    public InputStream getImageAsInputStream(ImageSize is) throws IOException {
        InputStream ret = null;
        ResourceBundle iconsetProperties = ResourceBundle.getBundle("iconset");
        String fileName = iconsetProperties.getString(this.name());
        URL url = FileLocator.find((Bundle)FrameworkUtil.getBundle(Images.class), (IPath)new Path("icons/" + is.name + "/" + fileName), null);
        ret = url.openConnection().getInputStream();
        return ret;
    }

    public InputStream getImageAsInputStream(ImageSize is, int zoom) throws IOException {
        InputStream ret = null;
        ResourceBundle iconsetProperties = ResourceBundle.getBundle("iconset");
        String fileName = iconsetProperties.getString(this.name());
        URL url = FileLocator.find((Bundle)FrameworkUtil.getBundle(Images.class), (IPath)new Path("icons/" + is.name + "/" + Images.getFileNameWithZoom(fileName, zoom)), null);
        ret = url != null ? url.openConnection().getInputStream() : this.getImageAsInputStream(is);
        return ret;
    }

    private static String getFileNameWithZoom(String fileName, int zoom) {
        int dot = fileName.lastIndexOf(46);
        if (dot != -1 && (zoom == 150 || zoom == 200)) {
            String lead = fileName.substring(0, dot);
            String tail = fileName.substring(dot);
            String x = zoom == 150 ? "@1.5x" : "@2x";
            return lead + x + tail;
        }
        return fileName;
    }

    private static boolean addIconImageDescriptor(String name, ImageSize is) {
        String fileName;
        try {
            ResourceBundle iconsetProperties = ResourceBundle.getBundle("iconset");
            fileName = iconsetProperties.getString(name);
        }
        catch (IllegalArgumentException | MissingResourceException e) {
            fileName = name;
        }
        Path path = new Path("icons/" + is.name + "/" + fileName);
        URL fileLocation = FileLocator.find((Bundle)FrameworkUtil.getBundle(Images.class), (IPath)path, null);
        if (Images.getDeviceZoom() != 100) {
            Path zoomPath = new Path("icons/" + is.name + "/" + Images.getFileNameWithZoom(fileName, Images.getDeviceZoom()));
            URL zoomFileLocation = FileLocator.find((Bundle)FrameworkUtil.getBundle(Images.class), (IPath)zoomPath, null);
            if (zoomFileLocation != null) {
                fileLocation = zoomFileLocation;
            }
        }
        if (fileLocation == null) {
            return false;
        }
        ImageDescriptor id = ImageDescriptor.createFromURL((URL)fileLocation);
        JFaceResources.getImageRegistry().put(name + is.name, id);
        return true;
    }

    private static int getDeviceZoom() {
        if (deviceZoom == 0) {
            Images.initDeviceZoom();
        }
        return deviceZoom;
    }

    public static Image resize(Image image, ImageSize is) {
        return Images.resize(image, is.width, is.height);
    }

    public static Image resize(Image image, int width, int height) {
        return new Image((Device)Display.getDefault(), image.getImageData().scaledTo(width, height));
    }
}

