/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.controls;

import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.views.controls.Messages;
import ch.elexis.data.Kontakt;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class KontaktSelectionComposite
extends Composite
implements ISelectionProvider {
    private ListenerList selectionListeners = new ListenerList();
    protected Button selectButton;
    protected Label selectLabel;
    protected List<Kontakt> kontakt;
    protected boolean multi;

    public KontaktSelectionComposite(Composite parent, int style) {
        super(parent, style);
        this.multi = (style & 2) > 0;
        this.kontakt = new ArrayList<Kontakt>();
        this.createContent();
    }

    private void createContent() {
        this.setLayout((Layout)new GridLayout(2, false));
        this.selectLabel = new Label((Composite)this, 0);
        this.selectLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.selectButton = new Button((Composite)this, 0);
        this.selectButton.setText("...");
        this.selectButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KontaktSelektor ksl = KontaktSelectionComposite.this.getKontaktSelector();
                if (ksl.open() == 0) {
                    Kontakt selected = (Kontakt)ksl.getSelection();
                    KontaktSelectionComposite.this.setKontakt(selected);
                    KontaktSelectionComposite.this.callSelectionListeners();
                }
            }
        });
    }

    protected KontaktSelektor getKontaktSelector() {
        return new KontaktSelektor(this.getShell(), Kontakt.class, Messages.Core_Select_Contact, Messages.Core_Please_Select_Contact, Kontakt.DEFAULT_SORT);
    }

    public void setKontakt(Kontakt kontakt) {
        if (this.multi) {
            this.kontakt.add(kontakt);
        } else {
            this.kontakt.clear();
            if (kontakt != null) {
                this.kontakt.add(kontakt);
            }
        }
        if (this.kontakt != null && !this.kontakt.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            this.kontakt.stream().forEach(k -> {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(k.getLabel());
            });
            this.selectLabel.setText(sb.toString());
        } else {
            this.selectLabel.setText("");
        }
        this.getParent().layout();
    }

    public Kontakt getKontakt() {
        if (!this.kontakt.isEmpty()) {
            return this.kontakt.get(0);
        }
        return null;
    }

    private void callSelectionListeners() {
        Object[] listeners = this.selectionListeners.getListeners();
        if (listeners != null && listeners.length > 0) {
            Object[] objectArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                ((ISelectionChangedListener)object).selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
                ++n2;
            }
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove((Object)listener);
    }

    public ISelection getSelection() {
        if (this.kontakt != null) {
            return new StructuredSelection(this.kontakt);
        }
        return StructuredSelection.EMPTY;
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            if (!selection.isEmpty()) {
                this.setKontakt((Kontakt)((IStructuredSelection)selection).getFirstElement());
            } else {
                this.setKontakt(null);
            }
        }
    }
}

