/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.codesystems;

import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.model.ICodeElementBlock;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.UiDesk;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;

public class BlockElementViewerItem {
    private List<ICodeElement> elements = new ArrayList<ICodeElement>();
    private ICodeElementBlock block;

    public static List<BlockElementViewerItem> of(ICodeElementBlock block, boolean useReferences) {
        ArrayList<BlockElementViewerItem> order = new ArrayList<BlockElementViewerItem>();
        HashMap<CallSite, BlockElementViewerItem> items = new HashMap<CallSite, BlockElementViewerItem>();
        if (block != null) {
            List elements = useReferences ? block.getElementReferences() : block.getElements();
            for (ICodeElement iCodeElement : elements) {
                String key = iCodeElement.getCodeSystemName() + iCodeElement.getCode();
                BlockElementViewerItem item = (BlockElementViewerItem)items.get(key);
                if (item == null) {
                    item = new BlockElementViewerItem(block, iCodeElement);
                    items.put((CallSite)((Object)key), item);
                    order.add(item);
                    continue;
                }
                item.add(iCodeElement);
            }
        }
        return order;
    }

    public BlockElementViewerItem(ICodeElementBlock block, ICodeElement iCodeElement) {
        this.elements.add(iCodeElement);
        this.block = block;
    }

    private void add(ICodeElement iCodeElement) {
        this.elements.add(iCodeElement);
    }

    public String getText() {
        return this.elements.get(0).getText();
    }

    public String getCode() {
        return this.elements.get(0).getCode();
    }

    public String getCodeSystemName() {
        return this.elements.get(0).getCodeSystemName();
    }

    public int getCount() {
        return this.elements.size();
    }

    public void setCount(int count) {
        block3: {
            int diff;
            block2: {
                diff = count - this.getCount();
                if (diff <= 0) break block2;
                while (diff > 0) {
                    this.block.addElement(this.getFirstElement());
                    --diff;
                }
                break block3;
            }
            if (diff >= 0) break block3;
            while (diff < 0) {
                this.block.removeElement(this.getFirstElement());
                ++diff;
            }
        }
    }

    public void remove() {
        for (ICodeElement iCodeElement : this.elements) {
            this.block.removeElement(iCodeElement);
        }
    }

    public boolean isCodeElementInstanceOf(Class<?> clazz) {
        return clazz.isInstance(this.elements.get(0));
    }

    public ICodeElement getFirstElement() {
        return this.elements.get(0);
    }

    public static class ColorizedLabelProvider
    extends LabelProvider
    implements IColorProvider {
        public String getText(Object element) {
            if (element instanceof BlockElementViewerItem) {
                BlockElementViewerItem item = (BlockElementViewerItem)element;
                return item.getCount() + "x " + item.getCode() + " " + item.getText();
            }
            return super.getText(element);
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Color getBackground(Object element) {
            BlockElementViewerItem item;
            String codeSystemName;
            if (element instanceof BlockElementViewerItem && (codeSystemName = (item = (BlockElementViewerItem)element).getCodeSystemName()) != null) {
                String rgbColor = ConfigServiceHolder.getGlobal((String)("billing/color/" + codeSystemName), (String)"ffffff");
                return UiDesk.getColorFromRGB(rgbColor);
            }
            return null;
        }
    }
}

