/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.ac.EvACE;
import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.Heartbeat;
import ch.elexis.core.data.interfaces.IPersistentObject;
import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IReminder;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.issue.Priority;
import ch.elexis.core.model.issue.ProcessStatus;
import ch.elexis.core.model.issue.Type;
import ch.elexis.core.model.issue.Visibility;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.dialogs.ReminderDetailDialog;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.AcquireLockBlockingUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.core.ui.locks.LockResponseHelper;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.util.viewers.CommonContentProviderAdapter;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import ch.elexis.core.ui.util.viewers.SimpleWidgetProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.core.ui.views.reminder.ReminderStatusSubMenu;
import ch.elexis.data.Anwender;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.Reminder;
import ch.rgw.tools.TimeTool;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.part.ViewPart;

public class ReminderView
extends ViewPart
implements IRefreshable,
Heartbeat.HeartListener {
    public static final String ID = "ch.elexis.reminderview";
    private IAction newReminderAction;
    private IAction deleteReminderAction;
    private IAction showOnlyOwnDueReminderToggleAction;
    private IAction showSelfCreatedReminderAction;
    private IAction toggleAutoSelectPatientAction;
    private IAction reloadAction;
    private IAction sortByDueDate;
    private RestrictedAction showOthersRemindersAction;
    private RestrictedAction selectPatientAction;
    private ReminderLabelProvider reminderLabelProvider = new ReminderLabelProvider();
    private IAction[] filterActionType = new IAction[Type.values().length];
    private Set<Integer> filterActionSet = new HashSet<Integer>();
    private long cvHighestLastUpdate = 0L;
    private boolean sortByDueDateSetting = ConfigServiceHolder.getUser((String)"reminder/sortByDueDate", (boolean)false);
    private int filterDueDateDays = ConfigServiceHolder.getUser((String)"reminder/filterDueDays", (int)-1);
    private boolean autoSelectPatient = ConfigServiceHolder.getUser((String)"reminder/autoSelectPatient", (boolean)false);
    private boolean showOnlyDueReminders = ConfigServiceHolder.getUser((String)"reminder/onlyclosed", (boolean)false);
    private boolean showAllReminders = ConfigServiceHolder.getUser((String)"reminder/others", (boolean)false) && AccessControlServiceHolder.get().evaluate((EvaluatableACE)EvACE.of(IReminder.class, (Right)Right.VIEW));
    private boolean showSelfCreatedReminders = ConfigServiceHolder.getUser((String)"reminder/originator", (boolean)false);
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener(this);
    private CommonViewer cv = new CommonViewer();
    private ViewerConfigurer vc;
    private Query<Reminder> qbe;
    private ReminderFilter filter = new ReminderFilter();
    private Patient actPatient;
    private Text txtSearch;
    private int state = ConfigServiceHolder.getUser((String)"reminder/sortByDueDate", (int)0);

    @Optional
    @Inject
    void crudFinding(@UIEventTopic(value="info/elexis/model/*") IReminder reminder) {
        CoreUiUtil.runAsyncIfActive(() -> this.cv.notify(CommonViewer.Message.update), (Object)this.cv);
    }

    @Optional
    @Inject
    void activePatient(IPatient patient) {
        CoreUiUtil.runAsyncIfActive(() -> {
            final Patient selectedPatient = (Patient)NoPoUtil.loadAsPersistentObject((Identifiable)patient);
            if (selectedPatient.equals((Object)this.actPatient)) {
                return;
            }
            this.actPatient = selectedPatient;
            this.cv.getViewerWidget().setSelection((ISelection)StructuredSelection.EMPTY);
            Control control = this.cv.getViewerWidget().getControl();
            if (control != null && !control.isDisposed() && control.isVisible()) {
                this.cv.notify(CommonViewer.Message.update);
            }
            if (!ConfigServiceHolder.getUser((String)"reminder/showPatientChangeReminder", (boolean)true)) {
                UiDesk.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        List list = Reminder.findOpenRemindersResponsibleFor((Anwender)CoreHub.getLoggedInContact(), (boolean)false, (Patient)selectedPatient, (boolean)true);
                        if (!list.isEmpty()) {
                            StringBuilder sb = new StringBuilder();
                            for (Reminder r : list) {
                                sb.append(r.getSubject() + "\n");
                                sb.append(r.getMessage() + "\n\n");
                            }
                            SWTHelper.alert(Messages.ReminderView_importantRemindersCaption, sb.toString());
                        }
                    }
                });
            }
        }, (Object)this.cv);
    }

    @Inject
    void activeUser(@Optional IUser user) {
        Display.getDefault().asyncExec(() -> {
            if (this.txtSearch != null && !this.txtSearch.isDisposed()) {
                this.adaptForUser(user);
            }
        });
    }

    private void adaptForUser(IUser user) {
        this.refreshUserConfiguration();
        Control control = this.cv.getViewerWidget().getControl();
        if (control != null && !control.isDisposed() && control.isVisible()) {
            this.cv.notify(CommonViewer.Message.update);
        }
    }

    public ReminderView() {
        this.qbe = new Query(Reminder.class, null, null, "REMINDERS", new String[]{"Due", "priority", "actionType", "Creator", "IdentID"});
    }

    public void createPartControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(1, false));
        Composite header = new Composite(content, 0);
        GridLayout gl_header = new GridLayout(2, false);
        gl_header.horizontalSpacing = 0;
        gl_header.marginWidth = 0;
        gl_header.marginHeight = 0;
        header.setLayout((Layout)gl_header);
        header.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtSearch = new Text(header, 128);
        this.txtSearch.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtSearch.setMessage(Messages.ReminderView_txtSearch_message);
        this.txtSearch.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                ReminderView.this.filter.setFilterText(ReminderView.this.txtSearch.getText());
                ReminderView.this.cv.notify(CommonViewer.Message.update_keeplabels);
            }
        });
        Label btnClear = new Label(header, 0);
        btnClear.setImage(Images.IMG_CLEAR.getImage());
        btnClear.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ReminderView.this.txtSearch.setText("");
                ReminderView.this.filter.setFilterText(null);
                ReminderView.this.cv.notify(CommonViewer.Message.update_keeplabels);
            }
        });
        this.reminderLabelProvider.updateUserConfiguration();
        ReminderViewCommonContentProvider contentProvider = new ReminderViewCommonContentProvider();
        this.vc = new ViewerConfigurer(contentProvider, this.reminderLabelProvider, null, new ViewerConfigurer.DefaultButtonProvider(), new SimpleWidgetProvider(3, 2, this.cv));
        this.makeActions(contentProvider);
        this.initializeSortByDueDateAction(contentProvider);
        ViewMenus menu = new ViewMenus(this.getViewSite());
        menu.createToolbar(this.reloadAction, this.newReminderAction, this.toggleAutoSelectPatientAction);
        menu.createMenu(this.createActionList());
        if (AccessControlServiceHolder.get().evaluate((EvaluatableACE)EvACE.of(IReminder.class, (Right)Right.VIEW))) {
            this.showOthersRemindersAction.setEnabled(true);
            this.showOthersRemindersAction.setChecked(ConfigServiceHolder.getUser((String)"reminder/others", (boolean)false));
        } else {
            this.showOthersRemindersAction.setEnabled(false);
        }
        this.cv.create(this.vc, content, 0, this.getViewSite());
        this.cv.addDoubleClickListener(new CommonViewer.PoDoubleClickListener(){

            @Override
            public void doubleClicked(final PersistentObject obj, final CommonViewer cv) {
                final Reminder reminder = (Reminder)obj;
                AcquireLockBlockingUi.aquireAndRun((IPersistentObject)reminder, new ILockHandler(){

                    @Override
                    public void lockAcquired() {
                        ReminderDetailDialog rdd = new ReminderDetailDialog(UiDesk.getTopShell(), (Reminder)obj);
                        int retVal = rdd.open();
                        if (retVal == 0) {
                            ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent((IPersistentObject)reminder, this.getClass(), 4)});
                        }
                    }

                    @Override
                    public void lockFailed() {
                        cv.notify(CommonViewer.Message.update);
                    }
                });
            }
        });
        ArrayList<IContributionItem> popupMenuActionList = new ArrayList<IContributionItem>();
        popupMenuActionList.add((IContributionItem)new ReminderStatusSubMenu(this.cv));
        popupMenuActionList.add((IContributionItem)new ActionContributionItem(this.deleteReminderAction));
        popupMenuActionList.add((IContributionItem)new ActionContributionItem((IAction)this.selectPatientAction));
        popupMenuActionList.add((IContributionItem)new Separator());
        popupMenuActionList.addAll(this.createActionList());
        menu.createViewerContextMenu(this.cv.getViewerWidget(), popupMenuActionList);
        this.cv.getViewerWidget().addFilter((ViewerFilter)this.filter);
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
        this.cv.getViewerWidget().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ReminderView.this.selectPatientAction.setEnabled(selection.size() <= 1);
                ReminderView.this.selectPatientAction.reflectRight();
                if (ReminderView.this.autoSelectPatient && ReminderView.this.selectPatientAction.isEnabled()) {
                    ReminderView.this.selectPatientAction.doRun();
                }
            }
        });
    }

    private List<IContributionItem> createActionList() {
        Action labelFilter = new Action("Anzeige filtern"){};
        labelFilter.setEnabled(false);
        MenuManager timeFilterSubMenu = new MenuManager("Zeitraum Anzeige");
        FilterTimeAction action30 = new FilterTimeAction(30);
        FilterTimeAction action60 = new FilterTimeAction(60);
        FilterTimeAction action90 = new FilterTimeAction(90);
        action30.setOthers(Arrays.asList(action60, action90));
        action60.setOthers(Arrays.asList(action30, action90));
        action90.setOthers(Arrays.asList(action30, action60));
        timeFilterSubMenu.add((IAction)action30);
        timeFilterSubMenu.add((IAction)action60);
        timeFilterSubMenu.add((IAction)action90);
        Action labelResponsibility = new Action("Anzeige erweitern"){};
        labelResponsibility.setEnabled(false);
        Action labelSorter = new Action("Anzeige sortieren"){};
        labelSorter.setEnabled(false);
        MenuManager typeFilterSubMenu = new MenuManager("Nach Aktionstyp");
        List<IContributionItem> ca = ViewMenus.convertActionsToContributionItems(this.filterActionType);
        for (IContributionItem iContributionItem : ca) {
            typeFilterSubMenu.add(iContributionItem);
        }
        return Arrays.asList(new ActionContributionItem(this.newReminderAction), null, new ActionContributionItem((IAction)labelSorter), new ActionContributionItem(this.sortByDueDate), null, new ActionContributionItem((IAction)labelFilter), timeFilterSubMenu, new ActionContributionItem(this.showOnlyOwnDueReminderToggleAction), typeFilterSubMenu, null, new ActionContributionItem((IAction)labelResponsibility), new ActionContributionItem(this.showSelfCreatedReminderAction), new ActionContributionItem((IAction)this.showOthersRemindersAction), null);
    }

    private void refreshUserConfiguration() {
        boolean bChecked = ConfigServiceHolder.getUser((String)"reminder/onlyclosed", (boolean)true);
        this.showOnlyOwnDueReminderToggleAction.setChecked(bChecked);
        this.showSelfCreatedReminderAction.setChecked(ConfigServiceHolder.getUser((String)"reminder/originator", (boolean)false));
        this.toggleAutoSelectPatientAction.setChecked(ConfigServiceHolder.getUser((String)"reminder/autoSelectPatient", (boolean)false));
        this.showOthersRemindersAction.setChecked(ConfigServiceHolder.getUser((String)"reminder/others", (boolean)false));
        this.showOthersRemindersAction.reflectRight();
        this.reminderLabelProvider.updateUserConfiguration();
    }

    public void setFocus() {
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
        if (this.showOnlyOwnDueReminderToggleAction != null) {
            ConfigServiceHolder.setUser((String)"reminder/onlyclosed", (boolean)this.showOnlyOwnDueReminderToggleAction.isChecked());
        }
    }

    private Images determineActionTypeImage(Type actionType) {
        switch (actionType) {
            case PRINT: 
            case PRINT_DRUG_STICKER: {
                return Images.IMG_PRINTER;
            }
            case MAKE_APPOINTMENT: {
                return Images.IMG_CALENDAR;
            }
            case DISPENSE_MEDICATION: {
                return Images.IMG_PILL;
            }
            case PROCESS_SERVICE_RECORDING: {
                return Images.IMG_MONEY;
            }
            case READ_DOCUMENT: 
            case CHECK_LAB_RESULT: {
                return Images.IMG_EYE_WO_SHADOW;
            }
            case SEND_DOCUMENT: {
                return Images.IMG_MAIL_SEND;
            }
        }
        return Images.IMG_EMPTY_TRANSPARENT;
    }

    private void makeActions(final ReminderViewCommonContentProvider contentProvider) {
        this.newReminderAction = new Action(Messages.Core_New_ellipsis){
            {
                this.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
                this.setToolTipText(Messages.ReminderView_newReminderToolTip);
            }

            public void run() {
                ReminderDetailDialog erd = null;
                Object[] sel = ReminderView.this.cv.getSelection();
                if (sel != null && sel.length == 1 && sel[0] instanceof Reminder) {
                    Reminder reminder = (Reminder)sel[0];
                    erd = new ReminderDetailDialog(ReminderView.this.getViewSite().getShell(), reminder.getDateDue());
                } else {
                    erd = new ReminderDetailDialog(ReminderView.this.getViewSite().getShell());
                }
                int retVal = erd.open();
                if (retVal == 0) {
                    Reminder reminder = erd.getReminder();
                    LocalLockServiceHolder.get().acquireLock((Object)reminder);
                    LocalLockServiceHolder.get().releaseLock((Object)reminder);
                }
                ReminderView.this.cv.notify(CommonViewer.Message.update_keeplabels);
            }
        };
        this.deleteReminderAction = new Action(Messages.Core_Delete){
            {
                this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
                this.setToolTipText(Messages.ReminderView_deleteToolTip);
            }

            public void run() {
                Object[] selections = ReminderView.this.cv.getSelection();
                if (selections != null && selections.length == 1 && selections[0] instanceof Reminder) {
                    Reminder r = (Reminder)selections[0];
                    LockResponse lockResponse = LocalLockServiceHolder.get().acquireLock((Object)r);
                    if (lockResponse.isOk()) {
                        r.delete();
                        LocalLockServiceHolder.get().releaseLock((Object)r);
                    } else {
                        LockResponseHelper.showInfo(lockResponse, r, null);
                    }
                    ReminderView.this.cv.notify(CommonViewer.Message.update_keeplabels);
                }
            }

            public boolean isEnabled() {
                Object[] sel = ReminderView.this.cv.getSelection();
                return sel != null && sel.length == 1 && sel[0] instanceof Reminder;
            }
        };
        this.sortByDueDate = new Action(Messages.ReminderView_sortByDueDate, 2){

            public void run() {
                switch (ReminderView.this.state) {
                    case 0: {
                        ReminderView.this.setSortByDueDate(contentProvider, 1, Messages.ReminderView_sortByDueDateAscending, true);
                        break;
                    }
                    case 1: {
                        ReminderView.this.setSortByDueDate(contentProvider, 2, Messages.ReminderView_sortByDueDateDescending, true);
                        break;
                    }
                    case 2: {
                        ReminderView.this.setSortByDueDate(contentProvider, 0, Messages.ReminderView_sortByDueDate, false);
                    }
                }
                ReminderView.this.sortByDueDateSetting = ReminderView.this.sortByDueDate.isChecked();
                ReminderView.this.cv.notify(CommonViewer.Message.update_keeplabels);
            }
        };
        this.sortByDueDate.setChecked(this.sortByDueDateSetting);
        this.showOnlyOwnDueReminderToggleAction = new Action(Messages.ReminderView_onlyDueAction, 2){
            {
                this.setToolTipText(Messages.ReminderView_onlyDueToolTip);
            }

            public void run() {
                ReminderView.this.showOnlyDueReminders = ReminderView.this.showOnlyOwnDueReminderToggleAction.isChecked();
                ConfigServiceHolder.setUser((String)"reminder/onlyclosed", (boolean)ReminderView.this.showOnlyDueReminders);
                ReminderView.this.cv.notify(CommonViewer.Message.update_keeplabels);
            }
        };
        this.showSelfCreatedReminderAction = new Action(Messages.ReminderView_myRemindersAction, 2){
            {
                this.setToolTipText(Messages.ReminderView_myRemindersToolTip);
            }

            public void run() {
                ReminderView.this.showSelfCreatedReminders = ReminderView.this.showSelfCreatedReminderAction.isChecked();
                ConfigServiceHolder.setUser((String)"reminder/originator", (boolean)ReminderView.this.showSelfCreatedReminders);
                ReminderView.this.cv.notify(CommonViewer.Message.update_keeplabels);
            }
        };
        this.showOthersRemindersAction = new RestrictedAction((EvaluatableACE)EvACE.of(IReminder.class, (Right)Right.VIEW), Messages.Core_All, 2){
            {
                this.setToolTipText(Messages.ReminderView_foreignTooltip);
                this.setImageDescriptor(Images.IMG_ACHTUNG.getImageDescriptor());
            }

            @Override
            public void doRun() {
                ReminderView.this.showAllReminders = ReminderView.this.showOthersRemindersAction.isChecked();
                ConfigServiceHolder.setUser((String)"reminder/others", (boolean)ReminderView.this.showAllReminders);
                ReminderView.this.cv.notify(CommonViewer.Message.update_keeplabels);
            }
        };
        this.selectPatientAction = new RestrictedAction((EvaluatableACE)EvACE.of(IPatient.class, (Right)Right.VIEW), Messages.ReminderView_activatePatientAction, 0){
            {
                this.setImageDescriptor(Images.IMG_PERSON.getImageDescriptor());
                this.setToolTipText(Messages.ReminderView_activatePatientTooltip);
            }

            @Override
            public void doRun() {
                Object[] sel = ReminderView.this.cv.getSelection();
                if (sel != null && sel.length > 1) {
                    SWTHelper.showInfo(Messages.ReminderView_onePatOnly, Messages.ReminderView_onlyOnePatientForActivation);
                } else if (sel != null && sel.length > 0) {
                    Reminder reminder = (Reminder)sel[0];
                    Patient patient = reminder.getKontakt();
                    Anwender creator = reminder.getCreator();
                    if (patient != null && !patient.getId().equals(creator.getId())) {
                        ElexisEventDispatcher.fireSelectionEvent((PersistentObject)patient);
                    }
                }
            }

            public boolean isEnabled() {
                Object[] sel = ReminderView.this.cv.getSelection();
                if (sel != null && sel.length == 1 && sel[0] instanceof Reminder) {
                    Reminder reminder = (Reminder)sel[0];
                    return reminder.isPatientRelated();
                }
                return false;
            }
        };
        this.toggleAutoSelectPatientAction = new Action(Messages.ReminderView_activatePatientAction, 2){
            {
                this.setImageDescriptor(Images.IMG_PERSON.getImageDescriptor());
                this.setToolTipText(Messages.ReminderView_toggleSelectPatientActionTooltip);
                this.setChecked(ReminderView.this.autoSelectPatient);
            }

            public void run() {
                ReminderView.this.autoSelectPatient = ReminderView.this.toggleAutoSelectPatientAction.isChecked();
                ConfigServiceHolder.setUser((String)"reminder/autoSelectPatient", (boolean)ReminderView.this.autoSelectPatient);
            }
        };
        this.reloadAction = new Action(Messages.Core_Reload){
            {
                this.setImageDescriptor(Images.IMG_REFRESH.getImageDescriptor());
                this.setToolTipText(Messages.Core_Reread_List);
            }

            public void run() {
                ReminderView.this.heartbeat();
            }
        };
        int i = 0;
        while (i < Type.values().length) {
            final Type type = Type.values()[i];
            this.filterActionType[i] = new Action(type.getLocaleText(), 2){

                public void run() {
                    if (this.isChecked()) {
                        ReminderView.this.filterActionSet.add(type.numericValue());
                    } else {
                        ReminderView.this.filterActionSet.remove(type.numericValue());
                    }
                    ReminderView.this.cv.notify(CommonViewer.Message.update_keeplabels);
                }
            };
            this.filterActionType[i].setChecked(this.filterActionSet.contains(type.numericValue()));
            this.filterActionType[i].setImageDescriptor(this.determineActionTypeImage(type).getImageDescriptor());
            ++i;
        }
    }

    public void heartbeat() {
        long highestLastUpdate = PersistentObject.getHighestLastUpdate((String)"REMINDERS");
        if (highestLastUpdate > this.cvHighestLastUpdate) {
            this.cv.notify(CommonViewer.Message.update);
            this.cvHighestLastUpdate = highestLastUpdate;
        }
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }

    @Override
    public void refresh() {
        CoreUiUtil.runAsyncIfActive(() -> this.cv.notify(CommonViewer.Message.update), (Object)this.cv);
    }

    private void initializeSortByDueDateAction(ReminderViewCommonContentProvider contentProvider) {
        switch (this.state) {
            case 0: {
                this.setSortByDueDate(contentProvider, 0, Messages.ReminderView_sortByDueDate, false);
                break;
            }
            case 1: {
                this.setSortByDueDate(contentProvider, 1, Messages.ReminderView_sortByDueDateAscending, true);
                break;
            }
            case 2: {
                this.setSortByDueDate(contentProvider, 2, Messages.ReminderView_sortByDueDateDescending, true);
            }
        }
    }

    private void setSortByDueDate(ReminderViewCommonContentProvider contentProvider, int nextState, String buttonText, boolean isChecked) {
        contentProvider.setComparator((o1, o2) -> this.state == 0 ? TimeTool.compare((TimeTool)o2.getDateDue(), (TimeTool)o1.getDateDue()) : TimeTool.compare((TimeTool)o1.getDateDue(), (TimeTool)o2.getDateDue()));
        this.state = nextState;
        this.sortByDueDate.setText(buttonText);
        this.sortByDueDate.setChecked(isChecked);
        ConfigServiceHolder.setUser((String)"reminder/sortByDueDate", (int)this.state);
    }

    private class FilterTimeAction
    extends Action {
        private List<FilterTimeAction> others;
        private int days;

        public FilterTimeAction(int days) {
            super(String.format("n\u00e4chste %d Tage", days), 2);
            this.days = days;
            if (ReminderView.this.filterDueDateDays == days) {
                this.setChecked(true);
            }
        }

        public void setOthers(List<FilterTimeAction> list) {
            this.others = list;
        }

        public void run() {
            if (this.isChecked()) {
                ConfigServiceHolder.setUser((String)"reminder/filterDueDays", (int)this.days);
                ReminderView.this.filterDueDateDays = this.days;
                ReminderView.this.cv.notify(CommonViewer.Message.update_keeplabels);
            } else {
                ConfigServiceHolder.setUser((String)"reminder/filterDueDays", (int)-1);
                ReminderView.this.filterDueDateDays = -1;
                ReminderView.this.cv.notify(CommonViewer.Message.update_keeplabels);
            }
            if (this.others != null) {
                for (FilterTimeAction other : this.others) {
                    other.setChecked(false);
                }
            }
        }
    }

    private class ReminderFilter
    extends ViewerFilter {
        private String filterText;

        private ReminderFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof Reminder) {
                Visibility vis;
                int determineDueState;
                Reminder check = (Reminder)element;
                if (ReminderView.this.showOnlyOwnDueReminderToggleAction.isChecked() && (determineDueState = Reminder.determineDueState((TimeTool)check.getDateDue())) == 0) {
                    return false;
                }
                Patient act = ElexisEventDispatcher.getSelectedPatient();
                String patientId = act != null ? act.getId() : "INVALID_ID";
                String[] vals = check.get(true, new String[]{"subject", "Message", "IdentID", "Typ"});
                if (!vals[2].equals(patientId) && (vis = Visibility.byNumericSafe((String)vals[3])) != Visibility.ALWAYS && vis != Visibility.POPUP_ON_LOGIN) {
                    return false;
                }
                if (this.filterText != null && this.filterText.length() > 0 && !StringUtils.containsIgnoreCase((CharSequence)vals[0], (CharSequence)this.filterText) && !StringUtils.containsIgnoreCase((CharSequence)vals[1], (CharSequence)this.filterText)) {
                    return false;
                }
            }
            return true;
        }

        public void setFilterText(String text) {
            this.filterText = text;
        }
    }

    private class ReminderLabelProvider
    extends DefaultLabelProvider
    implements IColorProvider,
    IFontProvider {
        private Font boldFont;
        private Color colorInProgress;
        private Color colorDue;
        private Color colorOverdue;
        private Color colorOpen;

        private ReminderLabelProvider() {
        }

        public Color getBackground(Object element) {
            if (element instanceof Reminder) {
                Reminder reminder = (Reminder)element;
                switch (reminder.getDueState()) {
                    case 1: {
                        return this.colorDue;
                    }
                    case 2: {
                        return this.colorOverdue;
                    }
                }
                ProcessStatus processStatus = reminder.getProcessStatus();
                if (ProcessStatus.OPEN == processStatus) {
                    return this.colorOpen;
                }
                if (ProcessStatus.IN_PROGRESS == processStatus) {
                    return this.colorInProgress;
                }
                return null;
            }
            return UiDesk.getColor("schwarz");
        }

        public void updateUserConfiguration() {
            this.colorInProgress = UiDesk.getColorFromRGB(ConfigServiceHolder.getUser((String)("reminder/colors/" + ProcessStatus.IN_PROGRESS.name()), (String)"FFFFFF"));
            this.colorDue = UiDesk.getColorFromRGB(ConfigServiceHolder.getUser((String)("reminder/colors/" + ProcessStatus.DUE.name()), (String)"FFFFFF"));
            this.colorOverdue = UiDesk.getColorFromRGB(ConfigServiceHolder.getUser((String)("reminder/colors/" + ProcessStatus.OVERDUE.name()), (String)"FF0000"));
            this.colorOpen = UiDesk.getColorFromRGB(ConfigServiceHolder.getUser((String)("reminder/colors/" + ProcessStatus.OPEN.name()), (String)"00FF00"));
        }

        public Color getForeground(Object element) {
            if (element instanceof Reminder) {
                Reminder reminder = (Reminder)element;
                Priority prio = reminder.getPriority();
                if (Priority.LOW == prio) {
                    return UiDesk.getColor("grau");
                }
                return null;
            }
            return UiDesk.getColor("weiss");
        }

        @Override
        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof Reminder) {
                Reminder reminder = (Reminder)element;
                ProcessStatus status = reminder.getStatus();
                if (ProcessStatus.CLOSED == status) {
                    return Images.IMG_TICK.getImage();
                }
                Type actionType = reminder.getActionType();
                return ReminderView.this.determineActionTypeImage(actionType).getImage();
            }
            return null;
        }

        @Override
        public String getColumnText(Object element, int column) {
            Reminder reminder;
            ProcessStatus status;
            if (element instanceof Reminder && ProcessStatus.ON_HOLD == (status = (reminder = (Reminder)element).getStatus())) {
                return "[" + status.getLocaleText() + "] " + super.getText(element);
            }
            return super.getText(element);
        }

        public Font getFont(Object element) {
            if (element instanceof Reminder) {
                Priority prio;
                Reminder reminder = (Reminder)element;
                if (this.boldFont == null) {
                    Display disp = Display.getCurrent();
                    Font defaultFont = ReminderView.this.cv.getViewerWidget().getControl().getFont();
                    FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)defaultFont).setStyle(1);
                    this.boldFont = boldDescriptor.createFont((Device)disp);
                }
                if (Priority.HIGH == (prio = reminder.getPriority())) {
                    return this.boldFont;
                }
            }
            return null;
        }
    }

    private class ReminderViewCommonContentProvider
    extends CommonContentProviderAdapter {
        private Comparator<Reminder> comparator;

        private ReminderViewCommonContentProvider() {
        }

        @Override
        public Object[] getElements(Object inputElement) {
            if (CoreHub.getLoggedInContact() == null) {
                return new Object[0];
            }
            TreeSet<Reminder> reminders = new TreeSet<Reminder>();
            if (ReminderView.this.showAllReminders && AccessControlServiceHolder.get().evaluate((EvaluatableACE)EvACE.of(IReminder.class, (Right)Right.VIEW))) {
                ReminderView.this.qbe.clear();
                if (ReminderView.this.filterDueDateDays != -1) {
                    this.applyDueDateFilter(ReminderView.this.qbe);
                }
                reminders.addAll(ReminderView.this.qbe.execute());
            } else {
                reminders.addAll(Reminder.findOpenRemindersResponsibleFor((Anwender)CoreHub.getLoggedInContact(), (boolean)ReminderView.this.showOnlyDueReminders, (int)ReminderView.this.filterDueDateDays, null, (boolean)false));
                if (ReminderView.this.showSelfCreatedReminders) {
                    ReminderView.this.qbe.clear();
                    ReminderView.this.qbe.add("Creator", "=", CoreHub.getLoggedInContact().getId());
                    if (ReminderView.this.filterDueDateDays != -1) {
                        this.applyDueDateFilter(ReminderView.this.qbe);
                    }
                    reminders.addAll(ReminderView.this.qbe.execute());
                }
            }
            if (!ReminderView.this.filterActionSet.isEmpty()) {
                reminders.removeIf(p -> !ReminderView.this.filterActionSet.contains(p.getActionType().numericValue()));
            }
            ArrayList<Reminder> patientRelatedReminders = new ArrayList<Reminder>();
            ArrayList<Reminder> patientRelatedRemindersCurrentPatient = new ArrayList<Reminder>();
            ArrayList<Reminder> otherReminders = new ArrayList<Reminder>();
            Patient currentPatient = ElexisEventDispatcher.getSelectedPatient();
            for (Reminder reminder : reminders) {
                if (reminder.isPatientRelated()) {
                    if (currentPatient != null && reminder.get("IdentID").equals(currentPatient.getId())) {
                        patientRelatedRemindersCurrentPatient.add(reminder);
                        continue;
                    }
                    patientRelatedReminders.add(reminder);
                    continue;
                }
                otherReminders.add(reminder);
            }
            if (this.comparator != null) {
                Collections.sort(patientRelatedReminders, this.comparator);
                Collections.sort(patientRelatedRemindersCurrentPatient, this.comparator);
                Collections.sort(otherReminders, this.comparator);
            }
            ArrayList<String> resultList = new ArrayList<String>();
            resultList.add("------------ Aktueller Patient");
            resultList.addAll(patientRelatedRemindersCurrentPatient);
            resultList.add("------------ Allgemein");
            resultList.addAll(otherReminders);
            resultList.add("------------ Patientenbezogen (nicht aktueller Patient, immer anzeigen)");
            resultList.addAll(patientRelatedReminders);
            return resultList.toArray();
        }

        private void applyDueDateFilter(Query<Reminder> qbe) {
            TimeTool dueDateDays = new TimeTool();
            dueDateDays.addDays(ReminderView.this.filterDueDateDays);
            qbe.add("Due", "<>", "");
            qbe.add("Due", "<=", dueDateDays.toString(9));
        }

        public void setComparator(Comparator<Reminder> comparator) {
            this.comparator = comparator;
        }
    }
}

