/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util.viewers;

import ch.elexis.core.services.IQuery;
import ch.elexis.core.ui.selectors.ActiveControl;
import ch.elexis.core.ui.selectors.ActiveControlListener;
import ch.elexis.core.ui.selectors.ComboField;
import ch.elexis.core.ui.selectors.DateField;
import ch.elexis.core.ui.selectors.FieldDescriptor;
import ch.elexis.core.ui.selectors.IntegerField;
import ch.elexis.core.ui.selectors.MoneyField;
import ch.elexis.core.ui.selectors.SelectorPanel;
import ch.elexis.core.ui.selectors.TextField;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.IFilter;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.Tree;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class SelectorPanelProvider
implements ViewerConfigurer.ControlFieldProvider {
    private LinkedList<ViewerConfigurer.ControlFieldListener> listeners = new LinkedList();
    private SelectorPanel panel;
    private FieldDescriptor<?>[] fields;
    private boolean bExclusive = false;
    private IAction[] actions = null;
    private int changeDelay;
    private volatile Runnable delayedChanged;

    public SelectorPanelProvider(FieldDescriptor<?>[] fields, boolean bExlusive) {
        this.fields = fields;
        this.bExclusive = bExlusive;
        this.changeDelay = -1;
    }

    public void addActions(IAction ... actions) {
        this.actions = actions;
    }

    @Override
    public void addChangeListener(ViewerConfigurer.ControlFieldListener cl) {
        this.listeners.add(cl);
    }

    @Override
    public void clearValues() {
        if (this.panel != null) {
            this.panel.clearValues();
        }
    }

    @Override
    public Composite createControl(Composite parent) {
        this.panel = this.actions == null ? new SelectorPanel(parent, new IAction[0]) : new SelectorPanel(parent, this.actions);
        FieldDescriptor<?>[] fieldDescriptorArray = this.fields;
        int n = this.fields.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDescriptor<?> field = fieldDescriptorArray[n2];
            ActiveControl ac = null;
            switch (field.getFieldType()) {
                case STRING: 
                case HYPERLINK: {
                    ac = new TextField(this.panel.getFieldParent(), 0, field.getLabel(), field.getAssignedListenerEventType(), field.getAssignedListener());
                    break;
                }
                case CURRENCY: {
                    ac = new MoneyField(this.panel.getFieldParent(), 0, field.getLabel());
                    break;
                }
                case DATE: {
                    ac = new DateField(this.panel.getFieldParent(), 0, field.getLabel());
                    break;
                }
                case COMBO: {
                    ac = new ComboField(this.panel.getFieldParent(), 0, field.getLabel(), (String[])field.getExtension());
                    break;
                }
                case INT: {
                    ac = new IntegerField(this.panel.getFieldParent(), 0, field.getLabel());
                }
            }
            if (ac != null) {
                ac.setData("fieldName", field.getFieldname());
                ac.setData("hashName", field.getHashname());
                this.panel.addField(ac);
            }
            ++n2;
        }
        this.panel.setExclusive(this.bExclusive);
        this.panel.addSelectorListener(new ActiveControlListener(){

            @Override
            public void contentsChanged(ActiveControl field) {
                SelectorPanelProvider.this.fireChangedEvent();
            }

            @Override
            public void titleClicked(ActiveControl field) {
                SelectorPanelProvider.this.fireClickedEvent(field.getLabelText());
            }

            @Override
            public void invalidContents(ActiveControl field) {
            }
        });
        return this.panel;
    }

    @Override
    public IFilter createFilter() {
        return new DefaultFilter(this.panel);
    }

    public void fireClickedEvent(String fieldname) {
        for (ViewerConfigurer.ControlFieldListener cl : this.listeners) {
            cl.reorder(fieldname);
        }
    }

    @Override
    public void fireChangedEvent() {
        if (this.changeDelay > 0) {
            if (this.delayedChanged == null) {
                this.delayedChanged = new Runnable(){

                    @Override
                    public void run() {
                        SelectorPanelProvider.this.doFireChangedEvent();
                        SelectorPanelProvider.this.delayedChanged = null;
                    }
                };
                Display.getDefault().timerExec(this.changeDelay, this.delayedChanged);
            }
        } else {
            this.doFireChangedEvent();
        }
    }

    private void doFireChangedEvent() {
        HashMap<String, String> hv = this.panel.getValues();
        for (ViewerConfigurer.ControlFieldListener cl : this.listeners) {
            cl.changed(hv);
        }
    }

    @Override
    public void fireSortEvent(String text) {
        for (ViewerConfigurer.ControlFieldListener cl : this.listeners) {
            cl.reorder(text);
        }
    }

    @Override
    public String[] getValues() {
        HashMap<String, String> vals = this.panel.getValues();
        String[] ret = new String[this.fields.length];
        int i = 0;
        while (i < ret.length) {
            ret[i] = vals.get(this.fields[i].getLabel());
            ++i;
        }
        return ret;
    }

    @Override
    public boolean isEmpty() {
        HashMap<String, String> vals = this.panel.getValues();
        FieldDescriptor<?>[] fieldDescriptorArray = this.fields;
        int n = this.fields.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDescriptor<?> fd = fieldDescriptorArray[n2];
            if (vals.get(fd.getLabel()).length() > 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public void removeChangeListener(ViewerConfigurer.ControlFieldListener cl) {
        this.listeners.remove(cl);
    }

    @Override
    public void setFocus() {
        List<ActiveControl> controls = this.panel.getControls();
        if (controls != null && !controls.isEmpty()) {
            controls.get(0).getCtl().setFocus();
        } else {
            this.panel.setFocus();
        }
    }

    @Override
    public void setQuery(Query<? extends PersistentObject> q) {
        HashMap<String, String> vals = this.panel.getValues();
        FieldDescriptor<?>[] fieldDescriptorArray = this.fields;
        int n = this.fields.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDescriptor<?> field = fieldDescriptorArray[n2];
            String name = field.getFieldname();
            String value = vals.get(name);
            if (!StringTool.isNothing((Object)value)) {
                q.add(name, "LIKE", (field.isValueToLower() ? value.toLowerCase() : value) + "%", true);
            }
            ++n2;
        }
    }

    @Override
    public void setQuery(IQuery<?> query) {
        HashMap<String, String> vals = this.panel.getValues();
        FieldDescriptor<?>[] fieldDescriptorArray = this.fields;
        int n = this.fields.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDescriptor<?> field = fieldDescriptorArray[n2];
            String name = field.getFieldname();
            String value = vals.get(name);
            if (!StringTool.isNothing((Object)value)) {
                query.and(name, IQuery.COMPARATOR.LIKE, (Object)((field.isValueToLower() ? value.toLowerCase() : value) + "%"), field.isIgnoreCase());
            }
            ++n2;
        }
    }

    public SelectorPanel getPanel() {
        return this.panel;
    }

    public void setChangeDelay(int delay) {
        this.changeDelay = delay;
    }

    static class DefaultFilter
    extends ViewerFilter
    implements IFilter {
        SelectorPanel slp;

        public DefaultFilter(SelectorPanel panel) {
            this.slp = panel;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return this.select(element);
        }

        public boolean select(Object element) {
            PersistentObject po = null;
            if (element instanceof Tree) {
                po = (PersistentObject)((Tree)element).contents;
            } else if (element instanceof PersistentObject) {
                po = (PersistentObject)element;
            } else {
                return false;
            }
            HashMap<String, String> vals = this.slp.getValues();
            if (po.isMatching(vals, 1, true)) {
                return true;
            }
            if (element instanceof Tree) {
                Tree p = ((Tree)element).getParent();
                if (p == null) {
                    return false;
                }
                return this.select(p);
            }
            return false;
        }
    }
}

