/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.exchange.elements;

import ch.elexis.core.data.interfaces.ICodeElement;
import ch.elexis.core.data.interfaces.IPersistentObject;
import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.exchange.XChangeExporter;
import ch.elexis.core.ui.exchange.elements.ServiceElement;
import ch.elexis.core.ui.exchange.elements.XChangeElement;
import ch.elexis.core.ui.exchange.elements.XidElement;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.codesystems.CodeSelectorFactory;
import ch.elexis.data.Eigenleistung;
import ch.elexis.data.Leistungsblock;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.PersistentObjectFactory;
import ch.elexis.data.dto.CodeElementDTO;
import ch.rgw.tools.StringTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.slf4j.LoggerFactory;

public class ServiceBlockElement
extends XChangeElement {
    public static final String XMLNAME = "serviceblock";
    public static final String ENCLOSING = "serviceblocks";
    public static final String ATTR_NAME = "name";
    static List<IConfigurationElement> codesystems = Extensions.getExtensions((String)"ch.elexis.core.ui.Verrechnungscode");
    static List<ICodeElement> codeElements = new ArrayList<ICodeElement>(codesystems.size());
    static HashMap<ICodeElement, CodeSelectorFactory> factories = new HashMap(codesystems.size());

    static {
        for (IConfigurationElement ic : codesystems) {
            try {
                PersistentObjectFactory po = (PersistentObjectFactory)ic.createExecutableExtension("ElementFactory");
                CodeSelectorFactory cs = (CodeSelectorFactory)ic.createExecutableExtension("CodeSelectorFactory");
                if (cs == null) {
                    SWTHelper.alert("Fehler", "CodeSelectorFactory is null");
                    continue;
                }
                ICodeElement ics = (ICodeElement)po.createTemplate(cs.getElementClass());
                if (ics == null) {
                    SWTHelper.alert("Fehler", "CodeElement is null");
                }
                codeElements.add(ics);
                factories.put(ics, cs);
            }
            catch (CoreException ex) {
                LoggerFactory.getLogger(ServiceBlockElement.class).warn("Could not create PersistentObject code element factory", (Throwable)ex);
            }
        }
    }

    public ServiceBlockElement asExporter(XChangeExporter p, Leistungsblock lb) {
        this.asExporter(p);
        this.setAttribute(ATTR_NAME, lb.getName());
        List ics = lb.getElementReferences();
        for (ICodeElement ic : ics) {
            if (ic instanceof IVerrechenbar) {
                IVerrechenbar iv = (IVerrechenbar)ic;
                ServiceElement se = new ServiceElement().asExporter(this.sender, iv);
                this.add(se);
                continue;
            }
            if (!(ic instanceof CodeElementDTO)) continue;
            ServiceElement se = new ServiceElement().asExporter(this.sender, (CodeElementDTO)ic);
            this.add(se);
        }
        return this;
    }

    public void doImport() {
        String name = this.getAttr(ATTR_NAME);
        if (!StringTool.isNothing((Object)name)) {
            Leistungsblock block = new Leistungsblock(name, ContextServiceHolder.getActiveMandatorOrNull().getId());
            List<? extends XChangeElement> lService = this.getChildren("service", ServiceElement.class);
            for (ServiceElement serviceElement : lService) {
                if (this.importCodeElement(block, serviceElement)) continue;
                this.importXidElement(block, serviceElement);
            }
        }
    }

    @Deprecated
    private void importXidElement(Leistungsblock block, ServiceElement se) {
        XidElement xid = se.getXid();
        List<IPersistentObject> ls = xid.findObject();
        boolean bFound = false;
        for (IPersistentObject po : ls) {
            if (!(po instanceof IVerrechenbar)) continue;
            block.addElement((ICodeElement)((IVerrechenbar)po));
            bFound = true;
            break;
        }
        if (!bFound) {
            String contract = se.getAttr("contractName");
            String code = se.getAttr("contractCode");
            String lname = se.getAttr(ATTR_NAME);
            boolean bMatched = false;
            for (ICodeElement ice : codeElements) {
                CodeSelectorFactory cof;
                if (!ice.getCodeSystemName().equals(contract) || (cof = factories.get(ice)) == null) continue;
                PersistentObject po = cof.findElement(code);
                if (po != null && po.exists()) {
                    bMatched = true;
                    block.addElement((ICodeElement)po);
                    break;
                }
                Eigenleistung custom = Eigenleistung.load((String)code);
                if (!custom.exists()) continue;
                block.addElement((ICodeElement)custom);
                bMatched = true;
                break;
            }
            if (!bMatched) {
                Eigenleistung custom = new Eigenleistung(code, lname, se.getAttr("cost"), se.getAttr("price"));
                block.addElement((ICodeElement)custom);
            }
        }
    }

    private boolean importCodeElement(Leistungsblock block, ServiceElement se) {
        String codeSystemName = se.getAttr("contractName");
        String code = se.getAttr("contractCode");
        String name = se.getAttr(ATTR_NAME);
        if (codeSystemName != null && !codeSystemName.isEmpty() && code != null && !code.isEmpty()) {
            CodeElementDTO codeElement = new CodeElementDTO(codeSystemName, code);
            if (name != null && !name.isEmpty()) {
                codeElement.setText(name);
            }
            block.addElement((ICodeElement)codeElement);
            return true;
        }
        return false;
    }

    @Override
    public String getXMLName() {
        return XMLNAME;
    }
}

