/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.noa4e.ui.widgets;

import ag.ion.bion.officelayer.OSHelper;
import ag.ion.bion.officelayer.application.IOfficeApplication;
import ag.ion.bion.officelayer.desktop.IFrame;
import ag.ion.bion.officelayer.document.IDocument;
import ag.ion.bion.officelayer.document.IDocumentDescriptor;
import ag.ion.bion.workbench.office.editor.core.EditorCorePlugin;
import ag.ion.noa4e.ui.NOAUIPlugin;
import ag.ion.noa4e.ui.operations.AsyncProgressMonitorWrapper;
import ag.ion.noa4e.ui.operations.LoadDocumentOperation;
import ag.ion.noa4e.ui.widgets.Messages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Panel;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;

public class OfficePanel
extends Composite {
    private IOfficeApplication officeApplication = null;
    private IFrame officeFrame = null;
    private StackLayout stackLayout = null;
    private Frame officeAWTFrame = null;
    private ProgressMonitorPart progressMonitorPart = null;
    private Composite baseComposite = null;
    private Composite progressComposite = null;
    private Composite officeComposite = null;
    private IDocument document = null;
    private IStatus lastLoadingStatus = null;
    private Thread loadingThread = null;
    private String currentDocumentPath = null;
    private boolean buildAlwaysNewFrames = false;
    private boolean showProgressIndicator = true;

    public OfficePanel(Composite parent, int style) {
        this(parent, style, null);
    }

    public OfficePanel(Composite parent, int style, IOfficeApplication officeApplication) {
        super(parent, style);
        System.out.println("OfficePanel: OfficePanel - just supered - Constructs new OfficePanel");
        this.buildControls();
        if (officeApplication == null) {
            officeApplication = EditorCorePlugin.getDefault().getManagedLocalOfficeApplication();
        }
        this.officeApplication = officeApplication;
    }

    public IFrame getFrame() {
        System.out.println("OfficePanel: getFrame");
        return this.officeFrame;
    }

    public IDocument getDocument() {
        System.out.println("OfficePanel: getDocument");
        if (this.document == null) {
            System.out.println("OfficePanel: WARNING: Please note: will return document==null");
        } else {
            System.out.println("OfficePanel: will return document=" + this.document.toString());
        }
        return this.document;
    }

    public boolean setFocus() {
        System.out.println("OfficePanel: setFocus");
        if (this.officeFrame != null) {
            this.officeFrame.setFocus();
            return true;
        }
        return super.setFocus();
    }

    public void setBuildAlwaysNewFrames(boolean buildAlwaysNewFrames) {
        System.out.println("OfficePanel: setBuildAlwaysNewFrames");
        this.buildAlwaysNewFrames = buildAlwaysNewFrames;
    }

    public void showProgressIndicator(boolean showProgressIndicator) {
        System.out.println("OfficePanel: showProgressIndicator");
        this.showProgressIndicator = showProgressIndicator;
    }

    public final void loadDocument(boolean fork, final String documentPath, final IDocumentDescriptor documentDescriptor) {
        System.out.println("OfficePanel: loadDocument");
        if (this.isDisposed()) {
            System.out.println("OfficePanel: loadDocument: WARNING: isDisposed==true; will return immediately.");
            return;
        }
        System.out.println("OfficePanel: loadDocument: Status before doing the work:");
        if (documentPath == null) {
            System.out.println("OfficePanel: documentPath==null");
        } else {
            System.out.println("OfficePanel: documentPath=" + documentPath);
        }
        if (this.currentDocumentPath == null) {
            System.out.println("OfficePanel: currentDocumentPath==null");
        } else {
            System.out.println("OfficePanel: currentDocumentPath=" + this.currentDocumentPath);
        }
        if (this.document == null) {
            System.out.println("OfficePanel: document==null");
        } else {
            System.out.println("OfficePanel: document=" + this.document.toString());
        }
        if (this.officeFrame == null) {
            System.out.println("OfficePanel: officeFrame==null");
        } else {
            System.out.println("OfficePanel: officeFrame=" + this.officeFrame.toString());
        }
        if (this.lastLoadingStatus == null) {
            System.out.println("OfficePanel: lastLoadingStatus==null");
        } else {
            System.out.println("OfficePanel: lastLoadingStatus=" + this.lastLoadingStatus.toString());
        }
        if (!(documentPath == null || this.currentDocumentPath != null && this.currentDocumentPath.equals(documentPath))) {
            try {
                System.out.println("OfficePanel: loadDocument: Setting currentDocumentPath=documentPath;");
                this.currentDocumentPath = documentPath;
                if (this.document != null && this.buildAlwaysNewFrames) {
                    System.out.println("OfficePanel: loadDocument: closing currently open document...");
                    this.document.close();
                }
                if (this.officeFrame == null || this.buildAlwaysNewFrames) {
                    System.out.println("OfficePanel: loadDocument: activating new officeFrame...");
                    this.officeFrame = this.activateNewFrame();
                    if (this.officeFrame == null) {
                        System.out.println("OfficePanel: WARNING: FAILED: still, officeFrame==null");
                    } else {
                        System.out.println("OfficePanel: SUCCESS: officeFrame=" + this.officeFrame.toString());
                    }
                }
                if (!fork) {
                    System.out.println("OfficePanel: fork=false");
                    IProgressMonitor progressMonitor = this.getProgressMonitor();
                    if (progressMonitor == null) {
                        System.out.println("OfficePanel: progressMonitor==null");
                    } else {
                        System.out.println("OfficePanel: progressMonitor=" + progressMonitor.toString());
                    }
                    if (this.showProgressIndicator) {
                        this.showProgressIndicator();
                    }
                    System.out.println("OfficePanel: loadDocument: loading document...");
                    if (documentPath == null) {
                        System.out.println("OfficePanel: documentPath==null");
                    } else {
                        System.out.println("OfficePanel: documentPath=" + documentPath.toString());
                    }
                    if (documentDescriptor == null) {
                        System.out.println("OfficePanel: documentDescriptor==null");
                    } else {
                        System.out.println("OfficePanel: documentDescriptor=" + documentDescriptor.toString());
                    }
                    if (progressMonitor == null) {
                        System.out.println("OfficePanel: progressMonitor==null");
                    } else {
                        System.out.println("OfficePanel: progressMonitor=" + progressMonitor.toString());
                    }
                    this.loadDocument(documentPath, documentDescriptor, progressMonitor);
                    if (this.document != null) {
                        this.lastLoadingStatus = Status.OK_STATUS;
                    }
                    if (this.document == null) {
                        System.out.println("OfficePanel: WARNING: FAILED: document==null");
                    } else {
                        System.out.println("OfficePanel: SUCCESS: document=" + this.document.toString());
                    }
                    if (this.showProgressIndicator) {
                        this.hideProgressIndicator();
                        this.showOfficeFrame();
                    }
                } else {
                    System.out.println("OfficePanel: fork=true");
                    final Display display = Display.getCurrent();
                    this.loadingThread = new Thread(){
                        AsyncProgressMonitorWrapper asyncProgressMonitorWrapper = null;

                        @Override
                        public void run() {
                            display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!OfficePanel.this.isDisposed() && (this).OfficePanel.this.showProgressIndicator) {
                                        OfficePanel.this.showProgressIndicator();
                                    }
                                }
                            });
                            this.asyncProgressMonitorWrapper = new AsyncProgressMonitorWrapper(OfficePanel.this.getProgressMonitor(), OfficePanel.this.getDisplay());
                            try {
                                OfficePanel.this.loadDocument(documentPath, documentDescriptor, this.asyncProgressMonitorWrapper);
                                if (OfficePanel.this.document != null) {
                                    OfficePanel.this.lastLoadingStatus = Status.OK_STATUS;
                                }
                                display.asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if ((this).OfficePanel.this.showProgressIndicator) {
                                            OfficePanel.this.hideProgressIndicator();
                                            OfficePanel.this.showOfficeFrame();
                                        }
                                    }
                                });
                            }
                            catch (CoreException coreException) {
                                if (OfficePanel.this.showProgressIndicator) {
                                    OfficePanel.this.hideProgressIndicator();
                                    OfficePanel.this.showOfficeFrame();
                                }
                                OfficePanel.this.lastLoadingStatus = coreException.getStatus();
                            }
                        }
                    };
                    this.loadingThread.start();
                }
            }
            catch (Throwable throwable) {
                if (this.showProgressIndicator) {
                    this.hideProgressIndicator();
                    this.showOfficeFrame();
                }
                this.lastLoadingStatus = new Status(4, "ag.ion.noa4e.ui", 4, throwable.getMessage(), throwable);
            }
        }
        System.out.println("OfficePanel: loadDocument: Status after doing the work:");
        if (documentPath == null) {
            System.out.println("OfficePanel: documentPath==null");
        } else {
            System.out.println("OfficePanel: documentPath=" + documentPath);
        }
        if (this.currentDocumentPath == null) {
            System.out.println("OfficePanel: currentDocumentPath==null");
        } else {
            System.out.println("OfficePanel: currentDocumentPath=" + this.currentDocumentPath);
        }
        if (this.document == null) {
            System.out.println("OfficePanel: document==null");
        } else {
            System.out.println("OfficePanel: document=" + this.document.toString());
        }
        if (this.officeFrame == null) {
            System.out.println("OfficePanel: officeFrame==null");
        } else {
            System.out.println("OfficePanel: officeFrame=" + this.officeFrame.toString());
        }
        if (this.lastLoadingStatus == null) {
            System.out.println("OfficePanel: lastLoadingStatus==null");
        } else {
            System.out.println("OfficePanel: lastLoadingStatus=" + this.lastLoadingStatus.toString());
        }
    }

    public void dispose() {
        System.out.println("OfficePanel: dispose");
        if (this.officeFrame != null) {
            try {
                this.officeFrame.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        super.dispose();
    }

    public IStatus getLastLoadingStatus() {
        System.out.println("OfficePanel: getLastLoadingStatus");
        return this.lastLoadingStatus;
    }

    public void setLayout(Layout layout) {
        System.out.println("OfficePanel: setLayout, default: nop");
    }

    protected void documentLoadingOperationDone() {
        System.out.println("OfficePanel: documentLoadingOperationDone, default: nop");
    }

    protected IProgressMonitor getProgressMonitor() {
        System.out.println("OfficePanel: getProgressMonitor");
        if (this.progressMonitorPart != null) {
            return this.progressMonitorPart;
        }
        return new NullProgressMonitor();
    }

    protected IStatus startOfficeApplication(IOfficeApplication officeApplication) {
        System.out.println("OfficePanel: StartOfficeApplication");
        if (officeApplication == null) {
            System.out.println("OfficePanel: WARNING: officeApplication==null");
        } else {
            System.out.println("OfficePanel: Please note: officeApplication=" + officeApplication.toString());
        }
        if (this.getShell() == null) {
            System.out.println("OfficePanel: WARNING: getShell()==null");
        } else {
            System.out.println("OfficePanel: Please note: getShell()=" + this.getShell().toString());
        }
        return NOAUIPlugin.startLocalOfficeApplication(this.getShell(), officeApplication);
    }

    protected void buildProgressIndicator(Composite parent) {
        System.out.println("OfficePanel: buildProgressIndicator");
        this.progressComposite = new Composite(parent, 0x1000000);
        this.progressComposite.setBackground(Display.getCurrent().getSystemColor(16));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginLeft = -5;
        gridLayout.marginBottom = -5;
        gridLayout.marginRight = -5;
        this.progressComposite.setLayout((Layout)gridLayout);
        Composite composite = new Composite(this.progressComposite, 0x1000000);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setBackground(Display.getCurrent().getSystemColor(16));
        Composite progressIndicator = new Composite(this.progressComposite, 0x1000000);
        GridData gridData = new GridData(4, 0, true, false);
        gridData.verticalAlignment = 0x1000000;
        progressIndicator.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        progressIndicator.setLayout((Layout)gridLayout);
        this.progressMonitorPart = new ProgressMonitorPart(progressIndicator, null);
        gridData = new GridData(4, 0, true, false);
        gridData.verticalAlignment = 0x1000000;
        this.progressMonitorPart.setLayoutData((Object)gridData);
        Link linkCancel = new Link(progressIndicator, 0x800000);
        linkCancel.setText("<a>" + Messages.OfficePanel_link_text_cancel + "</a>");
        this.progressMonitorPart.attachToCancelComponent((Control)linkCancel);
    }

    protected void showProgressIndicator() {
        System.out.println("OfficePanel: showProgressIndicator");
        if (this.progressComposite == null) {
            this.buildProgressIndicator(this.baseComposite);
        }
        this.stackLayout.topControl = this.progressComposite;
        this.baseComposite.layout();
    }

    protected void hideProgressIndicator() {
        System.out.println("OfficePanel: hideProgressIndicator, default: nop");
    }

    protected final IOfficeApplication getOfficeApplication() {
        System.out.println("OfficePanel: getOfficeApplication");
        return this.officeApplication;
    }

    private void loadDocument(String documentPath, IDocumentDescriptor documentDescriptor, IProgressMonitor progressMonitor) throws CoreException {
        System.out.println("OfficePanel: loadDocument begins");
        if (documentPath == null) {
            System.out.println("OfficePanel: loadDocument: WARNING: documentPath==null");
        } else {
            System.out.println("OfficePanel: loadDocument: documentPath=" + documentPath);
        }
        URL url = this.convertToURL(documentPath);
        System.out.println("OfficePanel: loadDocument: url=" + url.toString());
        try {
            System.out.println("OfficePanel: loadDocument: trying to allocate new LoadDocumentOperation()...");
            LoadDocumentOperation loadDocumentOperation = new LoadDocumentOperation(null, this.getOfficeApplication(), this.officeFrame, url, documentDescriptor);
            if (loadDocumentOperation == null) {
                System.out.println("OfficePanel: loadDocument: WARNING: loadDocumentOperation==null");
            } else {
                System.out.println("OfficePanel: loadDocument: SUCCESS: loadDocumentOperation= " + loadDocumentOperation.toString());
            }
            System.out.println("OfficePanel: loadDocument: trying loadDocumentOperation.run(progressMonitor)...");
            loadDocumentOperation.run(progressMonitor);
            System.out.println("OfficePanel: loadDocument: trying document=loadDocumentOperation.getDocument()...");
            this.document = loadDocumentOperation.getDocument();
        }
        catch (InvocationTargetException invocationTargetException) {
            System.out.println("OfficePanel: loadDocument: FAILURE: caught InvocationTargetException during loadDocumentOperation");
            this.documentLoadingOperationDone();
            throw new CoreException((IStatus)new Status(4, "ag.ion.noa4e.ui", 4, invocationTargetException.getCause().getMessage(), invocationTargetException.getCause()));
        }
        catch (InterruptedException interruptedException) {
            System.out.println("OfficePanel: loadDocument: FAILURE: caught InterruptedException during loadDocumentOperation");
        }
        System.out.println("OfficePanel: loadDocument: loadDocumentOperationDone()...");
        this.documentLoadingOperationDone();
        System.out.println("OfficePanel: loadDocument ends");
    }

    private void showOfficeFrame() {
        System.out.println("OfficePanel: showOfficeFrame: begin");
        System.out.println("OfficePanel: showOfficeFrame: baseComposite.isDisposed()=" + this.baseComposite.isDisposed());
        if (this.officeComposite == null) {
            System.out.println("OfficePanel: showOfficeFrame: WARNING: officeComposite==null");
        } else {
            System.out.println("OfficePanel: showOfficeFrame: officeComposite=" + this.officeComposite.toString());
        }
        if (!this.baseComposite.isDisposed()) {
            this.stackLayout.topControl = this.officeComposite;
            this.baseComposite.layout();
            this.officeComposite.layout();
            System.out.println("OfficePanel: showOfficeFrame: end");
        }
    }

    private void buildControls() {
        System.out.println("OfficePanel: buildControls");
        super.setLayout((Layout)new GridLayout());
        this.baseComposite = new Composite((Composite)this, 0x1000000);
        this.baseComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.stackLayout = new StackLayout();
        this.stackLayout.marginHeight = -5;
        this.stackLayout.marginWidth = -5;
        this.baseComposite.setLayout((Layout)this.stackLayout);
        this.baseComposite.setBackground(this.getParent().getBackground());
        if (!this.showProgressIndicator) {
            this.buildProgressIndicator(this);
        }
    }

    private IFrame activateNewFrame() throws CoreException {
        System.out.println("OfficePanel: activateNewFrame");
        Control oldOfficeComposite = this.stackLayout.topControl;
        Frame oldOfficeAWTFrame = this.officeAWTFrame;
        this.officeComposite = new Composite(this.baseComposite, 0x1000000);
        this.officeComposite.setBackground(this.getBackground());
        this.officeComposite.setLayout((Layout)new GridLayout());
        try {
            System.out.println("OfficePanel: activateNewFrame: Trying...");
            this.officeAWTFrame = SWT_AWT.new_Frame((Composite)this.officeComposite);
            this.officeAWTFrame.setVisible(true);
            this.officeAWTFrame.setBackground(Color.GRAY);
            Panel officeAWTPanel = new Panel();
            officeAWTPanel.setLayout(new BorderLayout());
            officeAWTPanel.setVisible(true);
            this.officeAWTFrame.add(officeAWTPanel);
            if (!this.getOfficeApplication().isActive()) {
                System.out.println("OfficePanel: activateNewFrame: !getOfficeApplication().isActive()...");
                System.out.println("OfficePanel: activateNewFrame: startOfficeApplication(getOfficeApplication)...");
                IStatus status = this.startOfficeApplication(this.getOfficeApplication());
                if (status == null) {
                    System.out.println("OfficePanel: activateNewFrame: resulting status==null");
                } else {
                    System.out.println("OfficePanel: activateNewFrame: resulting status=" + status.toString());
                }
                if (status.getSeverity() == 4) {
                    System.out.println("OfficePanel: activateNewFrame: WARNING: status.getSeverity()==IStatus.ERROR");
                    throw new CoreException(status);
                }
            }
            if (this.isDisposed()) {
                System.out.println("OfficePanel: activateNewFrame: isDisposed() ... throwing");
                throw new CoreException((IStatus)new Status(4, "ag.ion.noa4e.ui", 4, "Widget disposed", null));
            }
            IFrame newOfficeFrame = this.getOfficeApplication().getDesktopService().constructNewOfficeFrame(this.officeAWTFrame);
            if (oldOfficeAWTFrame != null) {
                oldOfficeAWTFrame.dispose();
            }
            if (oldOfficeComposite != null) {
                oldOfficeComposite.dispose();
            }
            this.stackLayout.topControl = this.officeComposite;
            this.baseComposite.layout();
            if (newOfficeFrame == null) {
                System.out.println("OfficePanel: activateNewFrame: WARNING: Returning newOfficeFrame==null");
            } else {
                System.out.println("OfficePanel: activateNewFrame: Returning newOfficeFrame=" + newOfficeFrame.toString());
            }
            return newOfficeFrame;
        }
        catch (Throwable throwable) {
            System.out.println("OfficePanel: activateNewFrame: CATCHING - SORRY...");
            throw new CoreException((IStatus)new Status(4, "ag.ion.noa4e.ui", 4, throwable.getMessage(), throwable));
        }
    }

    private URL convertToURL(String documentPath) throws CoreException {
        System.out.println("OfficePanel: convertToURL - modified by js re. Windows part");
        System.out.println("OfficePanel: convertToURL: TO DO: Please note that the correction-mod may not be necessary any more in noa4e 2.0.14 (js)");
        System.out.println("OfficePanel: convertToURL: Now trying conversion; if it succeeds, will return immediately thereafter.");
        try {
            if (OSHelper.IS_WINDOWS) {
                return new URL("file:///" + documentPath);
            }
            return new URL("file:////" + documentPath);
        }
        catch (Throwable throwable) {
            System.out.println("OfficePanel: convertToURL: FAILURE - catching throwable.");
            throw new CoreException((IStatus)new Status(4, "ag.ion.noa4e.ui", 4, throwable.getMessage(), throwable));
        }
    }
}

