/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.noa.document;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;

public class URLAdapter {
    private static final String DEFAULT_PROTOCOL = "file";
    private static final String LOCALHOST = "localhost";
    private static final String LOCALIP = "127.0.0.1";
    private static final String PROTOCOL_DEVIDER = ":";
    private static final String PORT_DEVIDER = ":";
    private static final String EMPTY_STRING = "";
    private static final String BLANK_STRING = " ";
    private static final String BLANK_ENCODED = "%20";
    private static final char PATH_DEVIDER_CHAR = '/';

    public static String adaptURL(String url) throws MalformedURLException, UnknownHostException {
        if (url == null) {
            return null;
        }
        String localhostAddress = null;
        try {
            localhostAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        url = url.replace('\\', '/');
        URL urlObj = null;
        int port = -1;
        String protocol = DEFAULT_PROTOCOL;
        try {
            urlObj = new URL(url);
            String tmpProtocol = urlObj.getProtocol();
            port = urlObj.getPort();
            if (port < 0) {
                port = urlObj.getDefaultPort();
            }
            if (tmpProtocol != null && tmpProtocol.length() > 0) {
                protocol = tmpProtocol;
            }
        }
        catch (MalformedURLException tmpProtocol) {
            // empty catch block
        }
        if (urlObj == null) {
            if (!url.startsWith(String.valueOf(protocol) + ":")) {
                url = String.valueOf(protocol) + ":" + url;
            }
            urlObj = new URL(url);
        }
        String path = urlObj.getPath();
        String host = urlObj.getHost();
        if (!host.equals(EMPTY_STRING) && host.length() > 1) {
            if (host.equals(LOCALHOST) && path.contains(":")) {
                host = EMPTY_STRING;
            } else if (host.equals(LOCALHOST) && !path.contains(":")) {
                if (localhostAddress.equals(LOCALIP)) {
                    throw new MalformedURLException("localhost 127.0.0.1 not allowed - leave host empty");
                }
                host = localhostAddress;
            } else if (!host.equals(LOCALHOST) && !path.contains(":")) {
                host = InetAddress.getByName(host).getHostAddress();
            }
        } else {
            host = EMPTY_STRING;
        }
        String portString = EMPTY_STRING;
        if (port > 0) {
            portString = ":" + String.valueOf(port);
        }
        url = !host.equals(EMPTY_STRING) ? String.valueOf(protocol) + ":" + '/' + '/' + host + portString + path : (path.startsWith(String.valueOf('/')) ? String.valueOf(protocol) + ":" + '/' + '/' + path : String.valueOf(protocol) + ":" + '/' + '/' + '/' + path);
        url = url.replaceAll(BLANK_STRING, BLANK_ENCODED);
        return url;
    }
}

