/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.util;

import ag.ion.bion.officelayer.text.ITextField;
import ag.ion.bion.officelayer.util.INumberFormat;
import ag.ion.bion.officelayer.util.INumberFormatService;
import ag.ion.noa.NOAException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.uno.UnoRuntime;

public final class VariableTextFieldHelper {
    public static void setContent(String content, ITextField variableTextField, boolean isFormula, INumberFormatService numberFormatService) throws NOAException {
        try {
            if (content == null || variableTextField == null || numberFormatService == null) {
                return;
            }
            XPropertySet xPropertySetField = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)variableTextField.getXTextContent());
            int formatKey = (Integer)xPropertySetField.getPropertyValue("NumberFormat");
            INumberFormat numberFormat = null;
            if (formatKey != -1) {
                numberFormat = numberFormatService.getNumberFormat(formatKey);
            }
            if (numberFormat != null && numberFormat.getFormatType() == 64) {
                String[] split;
                if (content.indexOf(32) > -1) {
                    split = content.split(" ");
                    if (content.indexOf(47) > -1) {
                        if (split[0].indexOf(47) > -1) {
                            throw new Throwable("ERROR");
                        }
                        String[] split2 = split[1].split("/");
                        content = "" + (Double.parseDouble(split[0]) + Double.parseDouble(split2[0]) / Double.parseDouble(split2[1]));
                    } else {
                        content = "" + Double.parseDouble(split[0]) / Double.parseDouble(split[1]);
                    }
                } else if (content.indexOf(47) > -1) {
                    split = content.split("/");
                    content = "" + Double.parseDouble(split[0]) / Double.parseDouble(split[1]);
                }
                content = content.replace('.', ',');
            }
            String presentation = content;
            try {
                if (!isFormula && numberFormat != null && numberFormat.getFormatType() != 256) {
                    presentation = numberFormatService.applyFormat(presentation, numberFormat);
                }
            }
            catch (Throwable split2) {
                // empty catch block
            }
            if (numberFormat != null && (numberFormat.getFormatType() == 2 || numberFormat.getFormatType() == 4 || numberFormat.getFormatType() == 6)) {
                try {
                    double doubelValue = numberFormatService.convertStringToNumber(numberFormat.getFormatKey(), content);
                    content = String.valueOf(doubelValue);
                    content = content.replace('.', ',');
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            xPropertySetField.setPropertyValue("Content", (Object)content);
            if (!isFormula) {
                xPropertySetField.setPropertyValue("CurrentPresentation", (Object)presentation);
            }
        }
        catch (Throwable throwable) {
            throw new NOAException(throwable);
        }
    }

    public static void applyNumberFormat(INumberFormat numberFormat, ITextField variableTextField, boolean isFormula, INumberFormatService numberFormatService) throws NOAException {
        try {
            if (numberFormat == null || variableTextField == null || numberFormatService == null) {
                return;
            }
            XPropertySet xPropertySetField = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)variableTextField.getXTextContent());
            String content = (String)xPropertySetField.getPropertyValue("Content");
            xPropertySetField.setPropertyValue("NumberFormat", (Object)new Integer(numberFormat.getFormatKey()));
            VariableTextFieldHelper.setContent(content, variableTextField, isFormula, numberFormatService);
        }
        catch (Throwable throwable) {
            throw new NOAException(throwable);
        }
    }

    private VariableTextFieldHelper() {
    }
}

