/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text.table.test;

import ag.ion.bion.officelayer.internal.text.table.TextTableCellReference;
import ag.ion.bion.officelayer.internal.text.table.TextTableFormulaExpression;
import ag.ion.bion.officelayer.internal.text.table.TextTableFormulaModel;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TextTableCellReferenceTest
extends TestCase {
    public void testIsRangeReference() {
        TextTableCellReference reference = new TextTableCellReference("<A4:B6>");
        Assert.assertEquals((boolean)true, (boolean)reference.isRangeReference());
    }

    public void testGetTableName() {
        TextTableCellReference reference = new TextTableCellReference("<Table1.A4.1:B6>");
        Assert.assertEquals((String)"Table1", (String)reference.getTableName());
    }

    public void testGetStartColumnIndex() {
        TextTableCellReference reference = new TextTableCellReference("<Table1.A4.1:B6>");
        Assert.assertEquals((int)0, (int)reference.getStartColumnIndex());
    }

    public void testGetEndColumnIndex() {
        TextTableCellReference reference = new TextTableCellReference("<Table1.A4.1:B6>");
        Assert.assertEquals((int)1, (int)reference.getEndColumnIndex());
    }

    public void testGetStartRowIndex() {
        TextTableCellReference reference = new TextTableCellReference("<Table1.A4:B6>");
        Assert.assertEquals((int)3, (int)reference.getStartRowIndex());
    }

    public void testGetEndRowIndex() {
        TextTableCellReference reference = new TextTableCellReference("<Table1.A4:B6>");
        Assert.assertEquals((int)5, (int)reference.getEndRowIndex());
    }

    public void testSetTableName() {
        TextTableCellReference reference = new TextTableCellReference("<A4:B6>");
        reference.setTableName("Table2");
        Assert.assertEquals((String)"<Table2.A4:B6>", (String)reference.toString());
    }

    public void testMoveColumnIndex() {
        try {
            TextTableCellReference reference = new TextTableCellReference("<A4:B6>");
            reference.moveColumnIndex(3);
            Assert.assertEquals((String)"<D4:E6>", (String)reference.toString());
        }
        catch (Exception exception) {
            Assert.fail((String)exception.getMessage());
        }
    }

    public void testMoveRowIndex() {
        try {
            TextTableCellReference reference = new TextTableCellReference("<A4:B6>");
            reference.moveRowIndex(3);
            Assert.assertEquals((String)"<A7:B9>", (String)reference.toString());
        }
        catch (Exception exception) {
            Assert.fail((String)exception.getMessage());
        }
    }

    public void testToColumnRange() {
        try {
            TextTableCellReference reference = new TextTableCellReference("<A4>");
            reference.toColumnRange(0, 3);
            Assert.assertEquals((String)"<A4:D4>", (String)reference.toString());
        }
        catch (Exception exception) {
            Assert.fail((String)exception.getMessage());
        }
    }

    public void testExtendColumnRange() {
        try {
            TextTableCellReference reference = new TextTableCellReference("<A4:B6>");
            reference.extendColumnRangeTo(3);
            Assert.assertEquals((String)"<A4:D6>", (String)reference.toString());
        }
        catch (Exception exception) {
            Assert.fail((String)exception.getMessage());
        }
    }

    public void testContainsCell() {
        TextTableCellReference reference = new TextTableCellReference("<A4:D6>");
        Assert.assertEquals((boolean)true, (boolean)reference.containsCell("C5"));
    }

    public void testContainsColumn() {
        TextTableCellReference reference = new TextTableCellReference("<A4:D6>");
        Assert.assertEquals((boolean)true, (boolean)reference.containsColumn("C5"));
    }

    public void testContainsRow() {
        TextTableCellReference reference = new TextTableCellReference("<A4:D6>");
        Assert.assertEquals((boolean)false, (boolean)reference.containsRow("C7"));
    }

    public void testContainsColumnAfter() {
        TextTableCellReference reference = new TextTableCellReference("<D6>");
        Assert.assertEquals((boolean)true, (boolean)reference.containsColumnAfter("C6"));
    }

    public void testContainsRowAfter() {
        TextTableCellReference reference = new TextTableCellReference("<D6>");
        Assert.assertEquals((boolean)true, (boolean)reference.containsColumnAfter("D4"));
    }

    public void testExtendColumnRange2() {
        try {
            TextTableCellReference reference = new TextTableCellReference("<D6>");
            reference.extendColumnRange(2);
            Assert.assertEquals((String)"<D6:F6>", (String)reference.toString());
            reference = new TextTableCellReference("<D6:F7>");
            reference.extendColumnRange(2);
            Assert.assertEquals((String)"<D6:H7>", (String)reference.toString());
        }
        catch (Exception exception) {
            Assert.fail((String)exception.getMessage());
        }
    }

    public void testExtendRowRange() {
        try {
            TextTableCellReference reference = new TextTableCellReference("<D6>");
            reference.extendRowRange(4);
            Assert.assertEquals((String)"<D6:D10>", (String)reference.toString());
            reference = new TextTableCellReference("<D6:F7>");
            reference.extendRowRange(2);
            Assert.assertEquals((String)"<D6:F9>", (String)reference.toString());
        }
        catch (Exception exception) {
            Assert.fail((String)exception.getMessage());
        }
    }

    public void testTextTableFormulaModel1() {
        try {
            TextTableFormulaExpression textTableFormulaExpression = new TextTableFormulaExpression("<A1>");
            TextTableCellReference[] references = new TextTableCellReference[3];
            TextTableCellReference reference1 = new TextTableCellReference("<D6>");
            TextTableCellReference reference2 = new TextTableCellReference("<E6>");
            TextTableCellReference reference3 = new TextTableCellReference("<F6>");
            references[0] = reference1;
            references[1] = reference2;
            references[2] = reference3;
            TextTableFormulaModel formulaModel = new TextTableFormulaModel(textTableFormulaExpression);
            TextTableCellReference cellReference = formulaModel.getCellReferences()[0];
            formulaModel.replaceCellReference(cellReference, references);
            references = formulaModel.getCellReferences();
            Assert.assertEquals((int)3, (int)references.length);
            Assert.assertEquals((String)"(<D6>+<E6>+<F6>)", (String)formulaModel.getExpression());
        }
        catch (Exception exception) {
            Assert.fail((String)exception.getMessage());
        }
    }

    public void testTextTableFormulaModel2() {
        try {
            TextTableFormulaExpression textTableFormulaExpression = new TextTableFormulaExpression("<A1>+<b2>");
            TextTableCellReference[] references = new TextTableCellReference[3];
            TextTableCellReference reference1 = new TextTableCellReference("<D6>");
            TextTableCellReference reference2 = new TextTableCellReference("<E6>");
            TextTableCellReference reference3 = new TextTableCellReference("<F6>");
            references[0] = reference1;
            references[1] = reference2;
            references[2] = reference3;
            TextTableFormulaModel formulaModel = new TextTableFormulaModel(textTableFormulaExpression);
            TextTableCellReference cellReference = formulaModel.getCellReferences()[0];
            formulaModel.replaceCellReference(cellReference, references);
            references = formulaModel.getCellReferences();
            Assert.assertEquals((int)4, (int)references.length);
            Assert.assertEquals((String)"(<D6>+<E6>+<F6>)+<b2>", (String)formulaModel.getExpression());
        }
        catch (Exception exception) {
            Assert.fail((String)exception.getMessage());
        }
    }
}

