/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text.table;

import ag.ion.bion.officelayer.beans.IProperties;
import ag.ion.bion.officelayer.internal.beans.AbstractPropertyStore;
import ag.ion.bion.officelayer.text.ITextTableCell;
import ag.ion.bion.officelayer.text.ITextTableCellProperties;
import ag.ion.bion.officelayer.text.TextException;
import ag.ion.bion.officelayer.text.table.ITextTableCellPropertyStore;

public class TextTableCellPropertyStore
extends AbstractPropertyStore
implements ITextTableCellPropertyStore {
    private String cellStyle = null;
    private Integer numberFormat = null;
    private Integer backColor = null;
    private Short verticalAlignment = null;
    private int horizontalPosition = -1;
    private int verticalPosition = -1;
    private IProperties properties = null;

    public TextTableCellPropertyStore(ITextTableCell cell) throws TextException {
        this.verticalPosition = cell.getName().getColumnIndex();
        this.horizontalPosition = cell.getName().getRowIndex();
        this.construct(cell);
    }

    @Override
    public IProperties getProperties() {
        return this.properties;
    }

    @Override
    public void setBackColor(int color) throws TextException {
        this.backColor = new Integer(color);
    }

    @Override
    public void setVertOrient(short align) throws TextException {
        this.verticalAlignment = new Short(align);
    }

    @Override
    public void setCellStyle(String cellStyle) throws TextException {
        this.cellStyle = cellStyle;
    }

    @Override
    public String getCellStyle() throws TextException {
        return this.cellStyle;
    }

    @Override
    public void setNumberFormat(int numberFormat) throws TextException {
        this.numberFormat = new Integer(numberFormat);
    }

    @Override
    public int getNumberFormat() throws TextException {
        return this.numberFormat;
    }

    @Override
    public int getBackColor() throws TextException {
        return this.backColor;
    }

    @Override
    public short getVertOrient() throws TextException {
        return this.verticalAlignment;
    }

    private void construct(ITextTableCell cell) throws TextException {
        ITextTableCellProperties properties = cell.getProperties();
        this.properties = properties;
        this.numberFormat = new Integer(properties.getNumberFormat());
        this.backColor = new Integer(properties.getBackColor());
        this.verticalAlignment = new Short(properties.getVertOrient());
    }
}

