/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text;

import ag.ion.bion.officelayer.clone.CloneException;
import ag.ion.bion.officelayer.clone.ICloneService;
import ag.ion.bion.officelayer.internal.text.CharacterPropertyStore;
import ag.ion.bion.officelayer.internal.text.TextRange;
import ag.ion.bion.officelayer.internal.text.TextService;
import ag.ion.bion.officelayer.internal.text.TextTable;
import ag.ion.bion.officelayer.internal.text.TextTableCellName;
import ag.ion.bion.officelayer.internal.text.TextTableCellProperties;
import ag.ion.bion.officelayer.internal.text.table.TextTableCellCloneService;
import ag.ion.bion.officelayer.internal.text.table.TextTableCellPropertyStore;
import ag.ion.bion.officelayer.internal.text.table.TextTableFormulaService;
import ag.ion.bion.officelayer.text.AbstractTextComponent;
import ag.ion.bion.officelayer.text.ICharacterProperties;
import ag.ion.bion.officelayer.text.ICharacterPropertyStore;
import ag.ion.bion.officelayer.text.IPageStyle;
import ag.ion.bion.officelayer.text.IParagraph;
import ag.ion.bion.officelayer.text.IText;
import ag.ion.bion.officelayer.text.ITextCursor;
import ag.ion.bion.officelayer.text.ITextDocument;
import ag.ion.bion.officelayer.text.ITextRange;
import ag.ion.bion.officelayer.text.ITextService;
import ag.ion.bion.officelayer.text.ITextTable;
import ag.ion.bion.officelayer.text.ITextTableCell;
import ag.ion.bion.officelayer.text.ITextTableCellName;
import ag.ion.bion.officelayer.text.ITextTableCellProperties;
import ag.ion.bion.officelayer.text.TextException;
import ag.ion.bion.officelayer.text.table.IFormulaService;
import ag.ion.bion.officelayer.text.table.ITextTableCellPropertyStore;
import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.table.XCell;
import com.sun.star.text.XText;
import com.sun.star.text.XTextTable;
import com.sun.star.uno.Any;
import com.sun.star.uno.UnoRuntime;

public class TextTableCell
extends AbstractTextComponent
implements ITextTableCell {
    protected ITextTableCellName textTableCellName = null;
    private ITextService textService = null;
    private ITextTableCellProperties textTableCellProperties = null;
    private TextTableFormulaService textTableFormulaService = null;
    private ITextRange textRange = null;
    private ITextTableCellPropertyStore textTableCellPropertyStore = null;
    private TextTableCellCloneService textTableCellCloneService = null;
    private ICharacterProperties characterProperties = null;
    private ICharacterPropertyStore characterPropertyStore = null;
    private ITextTable textTable = null;
    private XCell xCell = null;

    public TextTableCell(ITextDocument textDocument, XCell xCell) throws IllegalArgumentException {
        super(textDocument);
        if (xCell == null) {
            throw new IllegalArgumentException("Submitted OpenOffice.org XCell interface is not valid.");
        }
        this.xCell = xCell;
        if (this.getName().getColumnIndex() > 52) {
            this.xCell = null;
            throw new IllegalArgumentException("The submitted range is not valid");
        }
    }

    @Override
    public ITextDocument getTextDocument() {
        return this.textDocument;
    }

    @Override
    public ITextTableCellName getName() {
        if (this.textTableCellName == null) {
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.xCell);
            try {
                this.textTableCellName = new TextTableCellName(xPropertySet.getPropertyValue("CellName").toString());
            }
            catch (Exception exception) {
                return null;
            }
        }
        return this.textTableCellName;
    }

    @Override
    public ITextTable getTextTable() throws TextException {
        if (this.textTable == null) {
            try {
                XText xText = (XText)UnoRuntime.queryInterface(XText.class, (Object)this.xCell);
                XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xText.getStart());
                Any any = (Any)xPropertySet.getPropertyValue("TextTable");
                XTextTable xTextTable = (XTextTable)any.getObject();
                this.textTable = new TextTable(this.textDocument, xTextTable);
            }
            catch (Exception exception) {
                TextException textException = new TextException(exception.getMessage());
                textException.initCause(exception);
                throw textException;
            }
        }
        return this.textTable;
    }

    @Override
    public int getContentType() {
        String formula = this.xCell.getFormula();
        if (formula != null && formula.length() != 0) {
            return 102;
        }
        double value = this.xCell.getValue();
        if (value != 0.0) {
            return 100;
        }
        XText xText = (XText)UnoRuntime.queryInterface(XText.class, (Object)this.xCell);
        String content = xText.getString();
        if (content.length() == 0) {
            return 99;
        }
        char[] chars = content.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (Character.isDigit(chars[i]) && chars[i] != '\u0000') {
                return 101;
            }
            ++i;
        }
        return 101;
    }

    @Override
    public ITextService getTextService() {
        if (this.textService == null) {
            XText xText = (XText)UnoRuntime.queryInterface(XText.class, (Object)this.xCell);
            XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.getTextDocument().getXTextDocument());
            this.textService = new TextService(this.textDocument, xMultiServiceFactory, xText);
        }
        return this.textService;
    }

    @Override
    public ITextTableCellProperties getProperties() {
        if (this.textTableCellProperties == null) {
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.xCell);
            this.textTableCellProperties = new TextTableCellProperties(xPropertySet);
        }
        return this.textTableCellProperties;
    }

    @Override
    public ICharacterProperties getCharacterProperties() {
        if (this.characterProperties == null) {
            ITextCursor cursor = this.getTextService().getCursorService().getTextCursor();
            cursor.gotoStart(false);
            cursor.gotoEnd(true);
            this.characterProperties = cursor.getCharacterProperties();
        }
        return this.characterProperties;
    }

    @Override
    public IFormulaService getFormulaService() {
        if (this.textTableFormulaService == null) {
            this.textTableFormulaService = new TextTableFormulaService(this.xCell);
        }
        return this.textTableFormulaService;
    }

    @Override
    public IPageStyle getPageStyle() throws TextException {
        if (this.textRange == null) {
            XText xText = (XText)UnoRuntime.queryInterface(XText.class, (Object)this.xCell);
            this.textRange = new TextRange(this.textDocument, xText.getStart());
        }
        return this.textRange.getPageStyle();
    }

    @Override
    public ITextTableCellPropertyStore getCellPropertyStore(int horizontalPosition, int verticalPosition) throws TextException {
        if (this.textTableCellPropertyStore == null) {
            this.textTableCellPropertyStore = new TextTableCellPropertyStore(this);
        }
        return this.textTableCellPropertyStore;
    }

    @Override
    public ICharacterPropertyStore getCharacterPropertyStore() throws TextException {
        if (this.characterPropertyStore == null) {
            ITextCursor cursor = this.getTextService().getCursorService().getTextCursor();
            cursor.gotoStart(false);
            this.characterPropertyStore = new CharacterPropertyStore(cursor);
        }
        return this.characterPropertyStore;
    }

    @Override
    public ICloneService getCloneService() throws CloneException {
        if (this.textTableCellCloneService == null) {
            this.textTableCellCloneService = new TextTableCellCloneService(this);
        }
        return this.textTableCellCloneService;
    }

    @Override
    public double getValue() {
        return this.xCell.getValue();
    }

    @Override
    public void setValue(double value) {
        this.xCell.setValue(value);
    }

    @Override
    public void setFormula(String formula) {
        this.getFormulaService().setFormula(formula);
    }

    @Override
    public short getPageNumber() {
        return this.getTextService().getCursorService().getTextCursor().getStartPageNumber();
    }

    @Override
    public void setCellParagraphStyle(String cellParagraphStyle) throws TextException {
        if (cellParagraphStyle == null) {
            return;
        }
        try {
            IText cellText = this.getTextService().getText();
            IParagraph[] paragraphs = cellText.getTextContentEnumeration().getParagraphs();
            int len = paragraphs.length;
            if (len > 1) {
                --len;
            }
            int i = 0;
            while (i < len) {
                paragraphs[i].getParagraphProperties().setParaStyleName(cellParagraphStyle);
                ++i;
            }
        }
        catch (Exception exception) {
            TextException textException = new TextException(exception.getMessage());
            textException.initCause(exception);
            throw textException;
        }
    }

    @Override
    public String getCellParagraphStyle() throws TextException {
        try {
            IText cellText = this.getTextService().getText();
            IParagraph[] paragraphs = cellText.getTextContentEnumeration().getParagraphs();
            if (paragraphs.length > 0) {
                return paragraphs[0].getParagraphProperties().getParaStyleName();
            }
            return null;
        }
        catch (Exception exception) {
            TextException textException = new TextException(exception.getMessage());
            textException.initCause(exception);
            throw textException;
        }
    }
}

