/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text;

import ag.ion.bion.officelayer.internal.text.TextContentEnumeration;
import ag.ion.bion.officelayer.internal.text.TextCursorService;
import ag.ion.bion.officelayer.text.IText;
import ag.ion.bion.officelayer.text.ITextContentEnumeration;
import ag.ion.bion.officelayer.text.ITextCursorService;
import ag.ion.bion.officelayer.text.ITextDocument;
import ag.ion.bion.officelayer.text.TextException;
import com.sun.star.text.XText;
import com.sun.star.text.XTextRange;

public class Text
implements IText {
    private ITextDocument textDocument = null;
    private XText xText = null;

    public Text(ITextDocument textDocument, XText xText) throws IllegalArgumentException {
        if (textDocument == null) {
            throw new IllegalArgumentException("The submitted text document is not valid.");
        }
        this.textDocument = textDocument;
        if (xText == null) {
            throw new IllegalArgumentException("The submitted OpenOffice.org XText interface is not valid.");
        }
        this.xText = xText;
    }

    @Override
    public XText getXText() {
        return this.xText;
    }

    @Override
    public String getText() {
        return this.xText.getString();
    }

    @Override
    public ITextContentEnumeration getTextContentEnumeration() throws TextException {
        try {
            return new TextContentEnumeration(this.textDocument, (XTextRange)this.xText);
        }
        catch (Exception exception) {
            TextException textException = new TextException(exception.getMessage());
            textException.initCause(exception);
            throw textException;
        }
    }

    @Override
    public ITextCursorService getTextCursorService() throws TextException {
        try {
            return new TextCursorService(this.textDocument, this.xText);
        }
        catch (Exception exception) {
            TextException textException = new TextException(exception.getMessage());
            textException.initCause(exception);
            throw textException;
        }
    }

    @Override
    public void setText(String text) {
        this.xText.setString(text);
    }
}

