/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.application;

import ag.ion.bion.officelayer.OSHelper;
import ag.ion.bion.officelayer.application.IApplicationAssistant;
import ag.ion.bion.officelayer.application.IApplicationProperties;
import ag.ion.bion.officelayer.application.ILazyApplicationInfo;
import ag.ion.bion.officelayer.application.OfficeApplicationException;
import ag.ion.bion.officelayer.internal.application.ApplicationProperties;
import ag.ion.bion.officelayer.internal.application.LazyApplicationInfo;
import ag.ion.bion.officelayer.internal.application.Messages;
import ag.ion.bion.officelayer.runtime.IOfficeProgressMonitor;
import com.ice.jni.registry.NoSuchValueException;
import com.ice.jni.registry.Registry;
import com.ice.jni.registry.RegistryKey;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ApplicationAssistant
implements IApplicationAssistant {
    private static final String KEY_MAIN_PART = "OpenOffice.org";
    private static final String PRE_PROGRAM_FOLDER_MAC = "Contents";
    private static final String PROGRAM_FOLDER = "program";
    private static final String RELATIVE_BOOTSTRAP = "program" + File.separator + "bootstrap";
    private static final String APPLICATION_EXECUTEABLE = "soffice";

    public ApplicationAssistant() throws OfficeApplicationException {
        this(null);
    }

    public ApplicationAssistant(String nativeLibPath) throws OfficeApplicationException {
        if (OSHelper.IS_WINDOWS) {
            try {
                String libPathFromProps = System.getProperty("noa.native.lib.path");
                if (libPathFromProps != null) {
                    nativeLibPath = libPathFromProps;
                }
                if (nativeLibPath != null) {
                    boolean is64Bit;
                    String libName = "ICE_JNIRegistry.dll";
                    String folder64bit = "64bit";
                    boolean bl = is64Bit = Integer.valueOf(System.getProperties().getProperty("sun.arch.data.model")) == 64;
                    if (is64Bit && new File(String.valueOf(nativeLibPath) + "/" + folder64bit + "/" + libName).exists()) {
                        nativeLibPath = String.valueOf(nativeLibPath) + "/" + folder64bit;
                    }
                    System.load(String.valueOf(nativeLibPath) + "\\" + libName);
                } else {
                    System.loadLibrary("ICE_JNIRegistry");
                }
            }
            catch (Throwable throwable) {
                throw new OfficeApplicationException(throwable);
            }
        }
    }

    @Override
    public ILazyApplicationInfo getLatestLocalApplication() {
        return this.getLatestLocalApplication(null);
    }

    @Override
    public ILazyApplicationInfo getLatestLocalApplication(IOfficeProgressMonitor officeProgressMonitor) {
        ILazyApplicationInfo[] lazyApplicationInfos = this.getLocalApplications(officeProgressMonitor);
        ILazyApplicationInfo latestLazyApplicationInfo = null;
        if (lazyApplicationInfos.length > 0) {
            int i = 0;
            while (i < lazyApplicationInfos.length) {
                ILazyApplicationInfo appInfo = lazyApplicationInfos[i];
                if (latestLazyApplicationInfo == null) {
                    latestLazyApplicationInfo = appInfo;
                } else if (appInfo.getMajorVersion() > latestLazyApplicationInfo.getMajorVersion()) {
                    latestLazyApplicationInfo = appInfo;
                } else if (appInfo.getMajorVersion() == latestLazyApplicationInfo.getMajorVersion() && appInfo.getMinorVersion() > latestLazyApplicationInfo.getMinorVersion()) {
                    latestLazyApplicationInfo = appInfo;
                } else if (appInfo.getMajorVersion() == latestLazyApplicationInfo.getMajorVersion() && appInfo.getMinorVersion() == latestLazyApplicationInfo.getMinorVersion() && appInfo.getUpdateVersion() > latestLazyApplicationInfo.getUpdateVersion()) {
                    latestLazyApplicationInfo = appInfo;
                }
                ++i;
            }
        }
        return latestLazyApplicationInfo;
    }

    @Override
    public ILazyApplicationInfo[] getLocalApplications() {
        return this.getLocalApplications(null);
    }

    @Override
    public ILazyApplicationInfo[] getLocalApplications(IOfficeProgressMonitor officeProgressMonitor) {
        ArrayList<ILazyApplicationInfo> arrayList = new ArrayList<ILazyApplicationInfo>();
        if (System.getProperty("oo.application.path") != null) {
            String path = new File(System.getProperty("oo.application.path")).getAbsolutePath();
            ILazyApplicationInfo applicationInfo = this.findLocalApplicationInfo(path);
            if (applicationInfo != null) {
                arrayList.add(applicationInfo);
            }
        } else if (OSHelper.IS_WINDOWS) {
            try {
                String[] possibleKeys = this.getPossibleKeys();
                if (officeProgressMonitor != null) {
                    officeProgressMonitor.beginTask(Messages.getString("ApplicationAssistant.monitor_message_scannig_registry"), possibleKeys.length);
                }
                RegistryKey[] ROOTS = new RegistryKey[]{Registry.HKEY_CLASSES_ROOT, Registry.HKEY_CURRENT_USER, Registry.HKEY_LOCAL_MACHINE};
                int i = 0;
                int n = possibleKeys.length;
                while (i < n) {
                    if (officeProgressMonitor != null) {
                        officeProgressMonitor.beginSubTask(Messages.getString("ApplicationAssistant.monitor_scanning_key", possibleKeys[i]));
                    }
                    int j = 0;
                    while (j < ROOTS.length) {
                        RegistryKey registryKey = Registry.openSubkey((RegistryKey)ROOTS[j], (String)possibleKeys[i], (int)1);
                        if (registryKey != null) {
                            ILazyApplicationInfo applicationInfo;
                            int position;
                            String path = null;
                            if (path == null) {
                                try {
                                    path = registryKey.getStringValue("Path");
                                    path = "\"" + path + "\"";
                                }
                                catch (NoSuchValueException noSuchValueException) {
                                    // empty catch block
                                }
                            }
                            if (path == null) {
                                try {
                                    path = registryKey.getDefaultValue();
                                }
                                catch (NoSuchValueException noSuchValueException) {
                                    // empty catch block
                                }
                            }
                            if (path != null && (position = path.indexOf(APPLICATION_EXECUTEABLE)) != -1 && (applicationInfo = this.findLocalApplicationInfo(path = path.substring(1, position - 9))) != null) {
                                boolean found = false;
                                for (ILazyApplicationInfo tmpApplicationInfo : arrayList) {
                                    if (!tmpApplicationInfo.getHome().equalsIgnoreCase(applicationInfo.getHome())) continue;
                                    found = true;
                                    break;
                                }
                                if (!found) {
                                    arrayList.add(applicationInfo);
                                }
                            }
                        }
                        ++j;
                    }
                    if (officeProgressMonitor != null && officeProgressMonitor.isCanceled()) break;
                    ++i;
                }
            }
            catch (Throwable throwable) {
                return ILazyApplicationInfo.EMPTY_LAZY_APPLICATION_INFOS_ARRAY;
            }
        } else {
            try {
                if (officeProgressMonitor != null) {
                    officeProgressMonitor.beginTask(Messages.getString("ApplicationAssistant.monitor_looking_for_office_application"), -1);
                }
                ArrayList possibleOfficeHomes = new ArrayList();
                if (OSHelper.IS_MAC) {
                    File appsFolder = new File("/Applications");
                    File oooStandardFolder = new File(appsFolder, "OpenOffice.org.app");
                    File folderToSearch = oooStandardFolder;
                    if (!folderToSearch.exists()) {
                        folderToSearch = appsFolder;
                    }
                    this.findPossibleOfficeHomes(officeProgressMonitor, folderToSearch, possibleOfficeHomes, 1, -1);
                } else {
                    File file = new File("/opt");
                    this.findPossibleOfficeHomes(officeProgressMonitor, file, possibleOfficeHomes, 1, 2);
                    file = new File("/usr");
                    this.findPossibleOfficeHomes(officeProgressMonitor, file, possibleOfficeHomes, 1, 2);
                }
                if (officeProgressMonitor != null) {
                    officeProgressMonitor.beginSubTask(Messages.getString("ApplicationAssistant.monitor_buildung_application_infos"));
                }
                String[] officeHomes = possibleOfficeHomes.toArray(new String[possibleOfficeHomes.size()]);
                int i = 0;
                int n = officeHomes.length;
                while (i < n) {
                    ILazyApplicationInfo applicationInfo = this.findLocalApplicationInfo(officeHomes[i]);
                    if (applicationInfo != null) {
                        arrayList.add(applicationInfo);
                    }
                    ++i;
                }
            }
            catch (Throwable throwable) {
                return ILazyApplicationInfo.EMPTY_LAZY_APPLICATION_INFOS_ARRAY;
            }
        }
        if (officeProgressMonitor != null && officeProgressMonitor.needsDone()) {
            officeProgressMonitor.done();
        }
        return arrayList.toArray(new ILazyApplicationInfo[arrayList.size()]);
    }

    @Override
    public ILazyApplicationInfo findLocalApplicationInfo(String home) {
        if (home == null) {
            return null;
        }
        File file = null;
        file = OSHelper.IS_WINDOWS ? new File(String.valueOf(home) + File.separator + PROGRAM_FOLDER + File.separator + APPLICATION_EXECUTEABLE + ".exe") : (OSHelper.IS_MAC ? new File(String.valueOf(home) + File.separator + PRE_PROGRAM_FOLDER_MAC + File.separator + PROGRAM_FOLDER + File.separator + APPLICATION_EXECUTEABLE + ".bin") : new File(String.valueOf(home) + File.separator + PROGRAM_FOLDER + File.separator + APPLICATION_EXECUTEABLE + ".bin"));
        if (file.canRead()) {
            return new LazyApplicationInfo(home, this.findApplicationProperties(home));
        }
        if (!OSHelper.IS_WINDOWS && (file = new File(String.valueOf(home) + File.separator + PROGRAM_FOLDER + File.separator + APPLICATION_EXECUTEABLE + ".sh")).canRead()) {
            return new LazyApplicationInfo(home, this.findApplicationProperties(home));
        }
        return null;
    }

    private void findPossibleOfficeHomes(IOfficeProgressMonitor officeProgressMonitor, File root, List list, int currentLevel, int maxLevel) {
        File[] files;
        if (root == null) {
            return;
        }
        if (root.isDirectory() && officeProgressMonitor != null) {
            officeProgressMonitor.beginSubTask(Messages.getString("ApplicationAssistant.monitor_scanning_directory", root.getName()));
        }
        if ((files = root.listFiles()) != null) {
            int i = 0;
            int n = files.length;
            while (i < n) {
                if (officeProgressMonitor != null && officeProgressMonitor.isCanceled()) break;
                File file = files[i];
                if (file != null) {
                    File parent;
                    String fileName = file.getName();
                    boolean homePathIdentified = false;
                    if (!OSHelper.IS_WINDOWS) {
                        if (fileName.equals("soffice.bin") || fileName.equals("soffice.sh")) {
                            homePathIdentified = true;
                        }
                    } else if (fileName.equals("soffice.exe")) {
                        homePathIdentified = true;
                    }
                    if (homePathIdentified && (parent = file.getParentFile()) != null) {
                        parent = parent.getParentFile();
                        if (OSHelper.IS_MAC) {
                            parent = parent.getParentFile();
                        }
                        if (parent != null) {
                            list.add(parent.getAbsolutePath());
                        }
                    }
                    if (file.isDirectory()) {
                        File progDir = new File(file, PROGRAM_FOLDER);
                        boolean progDirExists = progDir.exists();
                        if (progDirExists) {
                            this.findPossibleOfficeHomes(officeProgressMonitor, progDir, list, 1, 1);
                        } else if (currentLevel < maxLevel || maxLevel == -1) {
                            this.findPossibleOfficeHomes(officeProgressMonitor, file, list, currentLevel + 1, maxLevel);
                        }
                    }
                }
                ++i;
            }
        }
    }

    private IApplicationProperties findApplicationProperties(String home) {
        File file = null;
        file = OSHelper.IS_WINDOWS ? new File(String.valueOf(home) + File.separator + RELATIVE_BOOTSTRAP + ".ini") : (OSHelper.IS_MAC ? new File(String.valueOf(home) + File.separator + PRE_PROGRAM_FOLDER_MAC + File.separator + RELATIVE_BOOTSTRAP + "rc") : new File(String.valueOf(home) + File.separator + RELATIVE_BOOTSTRAP + "rc"));
        if (file.canRead()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                Properties properties = new Properties();
                properties.load(fileInputStream);
                return new ApplicationProperties(properties);
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        return null;
    }

    private String[] getPossibleKeys() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int majorVersion = 1;
        int minorVersion = 0;
        int updateVersion = 0;
        while (majorVersion <= 4) {
            arrayList.add("Applications\\OpenOffice.org " + majorVersion + "." + minorVersion + "\\shell\\edit\\command");
            arrayList.add("Applications\\OpenOffice.org " + majorVersion + "." + minorVersion + "." + updateVersion + "\\shell\\edit\\command");
            arrayList.add("Software\\OpenOffice.org\\OpenOffice.org\\" + majorVersion + "." + minorVersion);
            arrayList.add("Software\\OpenOffice.org\\OpenOffice.org\\" + majorVersion + "." + minorVersion + "." + updateVersion);
            updateVersion = 1;
            while (updateVersion <= 150) {
                if (updateVersion < 10 || updateVersion > 80) {
                    arrayList.add("Applications\\OpenOffice.org " + majorVersion + "." + minorVersion + "." + updateVersion + "\\shell\\edit\\command");
                    arrayList.add("Software\\OpenOffice.org\\OpenOffice.org\\" + majorVersion + "." + minorVersion + "." + updateVersion);
                }
                ++updateVersion;
            }
            minorVersion = 1;
            updateVersion = 1;
            while (minorVersion <= 10) {
                arrayList.add("Applications\\OpenOffice.org " + majorVersion + "." + minorVersion + "\\shell\\edit\\command");
                arrayList.add("Applications\\OpenOffice.org " + majorVersion + "." + minorVersion + "." + updateVersion + "\\shell\\edit\\command");
                arrayList.add("Software\\OpenOffice.org\\OpenOffice.org\\" + majorVersion + "." + minorVersion);
                arrayList.add("Software\\OpenOffice.org\\OpenOffice.org\\" + majorVersion + "." + minorVersion + "." + updateVersion);
                updateVersion = 2;
                while (updateVersion <= 150) {
                    if (updateVersion < 10 || updateVersion > 80) {
                        arrayList.add("Applications\\OpenOffice.org " + majorVersion + "." + minorVersion + "." + updateVersion + "\\shell\\edit\\command");
                        arrayList.add("Software\\OpenOffice.org\\OpenOffice.org\\" + majorVersion + "." + minorVersion + "." + updateVersion);
                    }
                    ++updateVersion;
                }
                updateVersion = 1;
                ++minorVersion;
            }
            minorVersion = 0;
            ++majorVersion;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

