# EntityManagementApi

All URIs are relative to *http://localhost*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**getEntityExtInfo**](EntityManagementApi.md#getEntityExtInfo) | **GET** /api/v1/management/entity/{entityType}/{entityId}/extinfo | Return the extinfo stored values of an entity |
| [**getEntityExtInfoWithHttpInfo**](EntityManagementApi.md#getEntityExtInfoWithHttpInfo) | **GET** /api/v1/management/entity/{entityType}/{entityId}/extinfo | Return the extinfo stored values of an entity |
| [**removeEntityExtInfoKeyValue**](EntityManagementApi.md#removeEntityExtInfoKeyValue) | **DELETE** /api/v1/management/entity/{entityType}/{entityId}/extinfo | Remove a single key/value pair on an entities extinfo |
| [**removeEntityExtInfoKeyValueWithHttpInfo**](EntityManagementApi.md#removeEntityExtInfoKeyValueWithHttpInfo) | **DELETE** /api/v1/management/entity/{entityType}/{entityId}/extinfo | Remove a single key/value pair on an entities extinfo |
| [**setMultipleEntityExtInfoKeyValue**](EntityManagementApi.md#setMultipleEntityExtInfoKeyValue) | **POST** /api/v1/management/entity/{entityType}/{entityId}/extinfo | Set multiple key/value pairs on an entities extinfo |
| [**setMultipleEntityExtInfoKeyValueWithHttpInfo**](EntityManagementApi.md#setMultipleEntityExtInfoKeyValueWithHttpInfo) | **POST** /api/v1/management/entity/{entityType}/{entityId}/extinfo | Set multiple key/value pairs on an entities extinfo |
| [**setSingleEntityExtInfoKeyValue**](EntityManagementApi.md#setSingleEntityExtInfoKeyValue) | **PUT** /api/v1/management/entity/{entityType}/{entityId}/extinfo | Set a single key/value pair on an entities extinfo |
| [**setSingleEntityExtInfoKeyValueWithHttpInfo**](EntityManagementApi.md#setSingleEntityExtInfoKeyValueWithHttpInfo) | **PUT** /api/v1/management/entity/{entityType}/{entityId}/extinfo | Set a single key/value pair on an entities extinfo |



## getEntityExtInfo

> Map<String, String> getEntityExtInfo(entityId, entityType)

Return the extinfo stored values of an entity

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.EntityManagementApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        EntityManagementApi apiInstance = new EntityManagementApi(defaultClient);
        String entityId = "entityId_example"; // String | 
        String entityType = "entityType_example"; // String | 
        try {
            Map<String, String> result = apiInstance.getEntityExtInfo(entityId, entityType);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling EntityManagementApi#getEntityExtInfo");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **entityId** | **String**|  | |
| **entityType** | **String**|  | |

### Return type

**Map&lt;String, String&gt;**


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

## getEntityExtInfoWithHttpInfo

> ApiResponse<Map<String, String>> getEntityExtInfo getEntityExtInfoWithHttpInfo(entityId, entityType)

Return the extinfo stored values of an entity

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.EntityManagementApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        EntityManagementApi apiInstance = new EntityManagementApi(defaultClient);
        String entityId = "entityId_example"; // String | 
        String entityType = "entityType_example"; // String | 
        try {
            ApiResponse<Map<String, String>> response = apiInstance.getEntityExtInfoWithHttpInfo(entityId, entityType);
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
            System.out.println("Response body: " + response.getData());
        } catch (ApiException e) {
            System.err.println("Exception when calling EntityManagementApi#getEntityExtInfo");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **entityId** | **String**|  | |
| **entityType** | **String**|  | |

### Return type

ApiResponse<**Map&lt;String, String&gt;**>


### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## removeEntityExtInfoKeyValue

> void removeEntityExtInfoKeyValue(entityId, entityType, key)

Remove a single key/value pair on an entities extinfo

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.EntityManagementApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        EntityManagementApi apiInstance = new EntityManagementApi(defaultClient);
        String entityId = "entityId_example"; // String | 
        String entityType = "entityType_example"; // String | 
        String key = "key_example"; // String | 
        try {
            apiInstance.removeEntityExtInfoKeyValue(entityId, entityType, key);
        } catch (ApiException e) {
            System.err.println("Exception when calling EntityManagementApi#removeEntityExtInfoKeyValue");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **entityId** | **String**|  | |
| **entityType** | **String**|  | |
| **key** | **String**|  | [optional] |

### Return type


null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

## removeEntityExtInfoKeyValueWithHttpInfo

> ApiResponse<Void> removeEntityExtInfoKeyValue removeEntityExtInfoKeyValueWithHttpInfo(entityId, entityType, key)

Remove a single key/value pair on an entities extinfo

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.EntityManagementApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        EntityManagementApi apiInstance = new EntityManagementApi(defaultClient);
        String entityId = "entityId_example"; // String | 
        String entityType = "entityType_example"; // String | 
        String key = "key_example"; // String | 
        try {
            ApiResponse<Void> response = apiInstance.removeEntityExtInfoKeyValueWithHttpInfo(entityId, entityType, key);
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
        } catch (ApiException e) {
            System.err.println("Exception when calling EntityManagementApi#removeEntityExtInfoKeyValue");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **entityId** | **String**|  | |
| **entityType** | **String**|  | |
| **key** | **String**|  | [optional] |

### Return type


ApiResponse<Void>

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |


## setMultipleEntityExtInfoKeyValue

> void setMultipleEntityExtInfoKeyValue(entityId, entityType, requestBody)

Set multiple key/value pairs on an entities extinfo

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.EntityManagementApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        EntityManagementApi apiInstance = new EntityManagementApi(defaultClient);
        String entityId = "entityId_example"; // String | 
        String entityType = "entityType_example"; // String | 
        Map<String, String> requestBody = new HashMap(); // Map<String, String> | 
        try {
            apiInstance.setMultipleEntityExtInfoKeyValue(entityId, entityType, requestBody);
        } catch (ApiException e) {
            System.err.println("Exception when calling EntityManagementApi#setMultipleEntityExtInfoKeyValue");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **entityId** | **String**|  | |
| **entityType** | **String**|  | |
| **requestBody** | [**Map&lt;String, String&gt;**](String.md)|  | |

### Return type


null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: Not defined

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |
| **400** | Bad Request |  -  |

## setMultipleEntityExtInfoKeyValueWithHttpInfo

> ApiResponse<Void> setMultipleEntityExtInfoKeyValue setMultipleEntityExtInfoKeyValueWithHttpInfo(entityId, entityType, requestBody)

Set multiple key/value pairs on an entities extinfo

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.EntityManagementApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        EntityManagementApi apiInstance = new EntityManagementApi(defaultClient);
        String entityId = "entityId_example"; // String | 
        String entityType = "entityType_example"; // String | 
        Map<String, String> requestBody = new HashMap(); // Map<String, String> | 
        try {
            ApiResponse<Void> response = apiInstance.setMultipleEntityExtInfoKeyValueWithHttpInfo(entityId, entityType, requestBody);
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
        } catch (ApiException e) {
            System.err.println("Exception when calling EntityManagementApi#setMultipleEntityExtInfoKeyValue");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **entityId** | **String**|  | |
| **entityType** | **String**|  | |
| **requestBody** | [**Map&lt;String, String&gt;**](String.md)|  | |

### Return type


ApiResponse<Void>

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: Not defined

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |
| **400** | Bad Request |  -  |


## setSingleEntityExtInfoKeyValue

> void setSingleEntityExtInfoKeyValue(entityId, entityType, key, value)

Set a single key/value pair on an entities extinfo

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.EntityManagementApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        EntityManagementApi apiInstance = new EntityManagementApi(defaultClient);
        String entityId = "entityId_example"; // String | 
        String entityType = "entityType_example"; // String | 
        String key = "key_example"; // String | 
        String value = "value_example"; // String | 
        try {
            apiInstance.setSingleEntityExtInfoKeyValue(entityId, entityType, key, value);
        } catch (ApiException e) {
            System.err.println("Exception when calling EntityManagementApi#setSingleEntityExtInfoKeyValue");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **entityId** | **String**|  | |
| **entityType** | **String**|  | |
| **key** | **String**|  | [optional] |
| **value** | **String**|  | [optional] |

### Return type


null (empty response body)

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

## setSingleEntityExtInfoKeyValueWithHttpInfo

> ApiResponse<Void> setSingleEntityExtInfoKeyValue setSingleEntityExtInfoKeyValueWithHttpInfo(entityId, entityType, key, value)

Set a single key/value pair on an entities extinfo

&lt;b&gt;Roles Required:&lt;/b&gt; api-access,ict-administrator&lt;br&gt;

### Example

```java
// Import classes:
import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.auth.*;
import ch.myelexis.server.client.models.*;
import ch.myelexis.server.api.EntityManagementApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost");
        
        // Configure HTTP bearer authorization: ElexisEnvironment
        HttpBearerAuth ElexisEnvironment = (HttpBearerAuth) defaultClient.getAuthentication("ElexisEnvironment");
        ElexisEnvironment.setBearerToken("BEARER TOKEN");

        EntityManagementApi apiInstance = new EntityManagementApi(defaultClient);
        String entityId = "entityId_example"; // String | 
        String entityType = "entityType_example"; // String | 
        String key = "key_example"; // String | 
        String value = "value_example"; // String | 
        try {
            ApiResponse<Void> response = apiInstance.setSingleEntityExtInfoKeyValueWithHttpInfo(entityId, entityType, key, value);
            System.out.println("Status code: " + response.getStatusCode());
            System.out.println("Response headers: " + response.getHeaders());
        } catch (ApiException e) {
            System.err.println("Exception when calling EntityManagementApi#setSingleEntityExtInfoKeyValue");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Response headers: " + e.getResponseHeaders());
            System.err.println("Reason: " + e.getResponseBody());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **entityId** | **String**|  | |
| **entityType** | **String**|  | |
| **key** | **String**|  | [optional] |
| **value** | **String**|  | [optional] |

### Return type


ApiResponse<Void>

### Authorization

[ElexisEnvironment](../README.md#ElexisEnvironment)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | OK |  -  |
| **401** | Not Authorized |  -  |
| **403** | Not Allowed |  -  |

