# openapi-java-client

myElexis-Server API

- API version: 1.0.0-SNAPSHOT

- Build date: 2025-10-07T14:27:54.092423017+02:00[Europe/Zurich]

- Generator version: 7.16.0

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)


*Automatically generated by the [OpenAPI Generator](https://openapi-generator.tech)*

## Requirements

Building the API client library requires:

1. Java 11+
2. Maven/Gradle

## Installation

To install the API client library to your local Maven repository, simply execute:

```shell
mvn clean install
```

To deploy it to a remote Maven repository instead, configure the settings of the repository and execute:

```shell
mvn clean deploy
```

Refer to the [OSSRH Guide](http://central.sonatype.org/pages/ossrh-guide.html) for more information.

### Maven users

Add this dependency to your project's POM:

```xml
<dependency>
  <groupId>org.openapitools</groupId>
  <artifactId>openapi-java-client</artifactId>
  <version>1.0.0-SNAPSHOT</version>
  <scope>compile</scope>
</dependency>
```

### Gradle users

Add this dependency to your project's build file:

```groovy
compile "org.openapitools:openapi-java-client:1.0.0-SNAPSHOT"
```

### Others

At first generate the JAR by executing:

```shell
mvn clean package
```

Then manually install the following JARs:

- `target/openapi-java-client-1.0.0-SNAPSHOT.jar`
- `target/lib/*.jar`

## Getting Started

Please follow the [installation](#installation) instruction and execute the following Java code:

```java

import ch.myelexis.server.client.*;
import ch.myelexis.server.model.*;
import ch.myelexis.server.api.ConfigApi;

public class ConfigApiExample {

    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        // Configure clients using the `defaultClient` object, such as
        // overriding the host and port, timeout, etc.
        ConfigApi apiInstance = new ConfigApi(defaultClient);
        String key = "key_example"; // String | 
        try {
            apiInstance.deleteUserContactConfigurationEntryByKey(key);
        } catch (ApiException e) {
            System.err.println("Exception when calling ConfigApi#deleteUserContactConfigurationEntryByKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ConfigApi* | [**deleteUserContactConfigurationEntryByKey**](docs/ConfigApi.md#deleteUserContactConfigurationEntryByKey) | **DELETE** /api/v1/user/config/contact | Delete User Contact Configuration Entry By Key
*ConfigApi* | [**deleteUserContactConfigurationEntryByKeyWithHttpInfo**](docs/ConfigApi.md#deleteUserContactConfigurationEntryByKeyWithHttpInfo) | **DELETE** /api/v1/user/config/contact | Delete User Contact Configuration Entry By Key
*ConfigApi* | [**findGlobalConfigurationDirectSubnodeKeysForGivenKey**](docs/ConfigApi.md#findGlobalConfigurationDirectSubnodeKeysForGivenKey) | **GET** /api/v1/user/config/global-subnodekeys | Find the direct subnode keys for a given entry branch. Programmatically limited to specific branches.
*ConfigApi* | [**findGlobalConfigurationDirectSubnodeKeysForGivenKeyWithHttpInfo**](docs/ConfigApi.md#findGlobalConfigurationDirectSubnodeKeysForGivenKeyWithHttpInfo) | **GET** /api/v1/user/config/global-subnodekeys | Find the direct subnode keys for a given entry branch. Programmatically limited to specific branches.
*ConfigApi* | [**getContactConfigurationEntries**](docs/ConfigApi.md#getContactConfigurationEntries) | **GET** /api/v1/management/config/contact/{contactid} | Get Contact Configuration Entries
*ConfigApi* | [**getContactConfigurationEntriesWithHttpInfo**](docs/ConfigApi.md#getContactConfigurationEntriesWithHttpInfo) | **GET** /api/v1/management/config/contact/{contactid} | Get Contact Configuration Entries
*ConfigApi* | [**getGlobalConfiguration**](docs/ConfigApi.md#getGlobalConfiguration) | **GET** /api/v1/management/config/global | Return the global configuration tree
*ConfigApi* | [**getGlobalConfigurationWithHttpInfo**](docs/ConfigApi.md#getGlobalConfigurationWithHttpInfo) | **GET** /api/v1/management/config/global | Return the global configuration tree
*ConfigApi* | [**getGlobalConfigurationValueByKey**](docs/ConfigApi.md#getGlobalConfigurationValueByKey) | **GET** /api/v1/user/config/global | Get Global Configuration Value By Key
*ConfigApi* | [**getGlobalConfigurationValueByKeyWithHttpInfo**](docs/ConfigApi.md#getGlobalConfigurationValueByKeyWithHttpInfo) | **GET** /api/v1/user/config/global | Get Global Configuration Value By Key
*ConfigApi* | [**getUserContactConfigurationAsTree**](docs/ConfigApi.md#getUserContactConfigurationAsTree) | **GET** /api/v1/management/config/usercontact | Return the configuration tree of a user contact. If no param provided, returns a list of all user-contact-ids with configuration values.
*ConfigApi* | [**getUserContactConfigurationAsTreeWithHttpInfo**](docs/ConfigApi.md#getUserContactConfigurationAsTreeWithHttpInfo) | **GET** /api/v1/management/config/usercontact | Return the configuration tree of a user contact. If no param provided, returns a list of all user-contact-ids with configuration values.
*ConfigApi* | [**getUserContactConfigurationValueByKey**](docs/ConfigApi.md#getUserContactConfigurationValueByKey) | **GET** /api/v1/user/config/contact | Get User Contact Configuration Value By Key
*ConfigApi* | [**getUserContactConfigurationValueByKeyWithHttpInfo**](docs/ConfigApi.md#getUserContactConfigurationValueByKeyWithHttpInfo) | **GET** /api/v1/user/config/contact | Get User Contact Configuration Value By Key
*ConfigApi* | [**setContactConfiguration**](docs/ConfigApi.md#setContactConfiguration) | **POST** /api/v1/management/config/contact/{contactid} | Update contact configuration
*ConfigApi* | [**setContactConfigurationWithHttpInfo**](docs/ConfigApi.md#setContactConfigurationWithHttpInfo) | **POST** /api/v1/management/config/contact/{contactid} | Update contact configuration
*ConfigApi* | [**setGlobalConfigurationValueByKey**](docs/ConfigApi.md#setGlobalConfigurationValueByKey) | **PUT** /api/v1/user/config/global | Set Global Configuration Value By Key
*ConfigApi* | [**setGlobalConfigurationValueByKeyWithHttpInfo**](docs/ConfigApi.md#setGlobalConfigurationValueByKeyWithHttpInfo) | **PUT** /api/v1/user/config/global | Set Global Configuration Value By Key
*ConfigApi* | [**setUserContactConfigurationValueByKey**](docs/ConfigApi.md#setUserContactConfigurationValueByKey) | **PUT** /api/v1/user/config/contact | Set User Contact Configuration Value By Key
*ConfigApi* | [**setUserContactConfigurationValueByKeyWithHttpInfo**](docs/ConfigApi.md#setUserContactConfigurationValueByKeyWithHttpInfo) | **PUT** /api/v1/user/config/contact | Set User Contact Configuration Value By Key
*ConfigApi* | [**updateGlobalConfigByJson**](docs/ConfigApi.md#updateGlobalConfigByJson) | **PUT** /api/v1/management/config/global | Update Global Config By Json
*ConfigApi* | [**updateGlobalConfigByJsonWithHttpInfo**](docs/ConfigApi.md#updateGlobalConfigByJsonWithHttpInfo) | **PUT** /api/v1/management/config/global | Update Global Config By Json
*EntityManagementApi* | [**getEntityExtInfo**](docs/EntityManagementApi.md#getEntityExtInfo) | **GET** /api/v1/management/entity/{entityType}/{entityId}/extinfo | Return the extinfo stored values of an entity
*EntityManagementApi* | [**getEntityExtInfoWithHttpInfo**](docs/EntityManagementApi.md#getEntityExtInfoWithHttpInfo) | **GET** /api/v1/management/entity/{entityType}/{entityId}/extinfo | Return the extinfo stored values of an entity
*EntityManagementApi* | [**removeEntityExtInfoKeyValue**](docs/EntityManagementApi.md#removeEntityExtInfoKeyValue) | **DELETE** /api/v1/management/entity/{entityType}/{entityId}/extinfo | Remove a single key/value pair on an entities extinfo
*EntityManagementApi* | [**removeEntityExtInfoKeyValueWithHttpInfo**](docs/EntityManagementApi.md#removeEntityExtInfoKeyValueWithHttpInfo) | **DELETE** /api/v1/management/entity/{entityType}/{entityId}/extinfo | Remove a single key/value pair on an entities extinfo
*EntityManagementApi* | [**setMultipleEntityExtInfoKeyValue**](docs/EntityManagementApi.md#setMultipleEntityExtInfoKeyValue) | **POST** /api/v1/management/entity/{entityType}/{entityId}/extinfo | Set multiple key/value pairs on an entities extinfo
*EntityManagementApi* | [**setMultipleEntityExtInfoKeyValueWithHttpInfo**](docs/EntityManagementApi.md#setMultipleEntityExtInfoKeyValueWithHttpInfo) | **POST** /api/v1/management/entity/{entityType}/{entityId}/extinfo | Set multiple key/value pairs on an entities extinfo
*EntityManagementApi* | [**setSingleEntityExtInfoKeyValue**](docs/EntityManagementApi.md#setSingleEntityExtInfoKeyValue) | **PUT** /api/v1/management/entity/{entityType}/{entityId}/extinfo | Set a single key/value pair on an entities extinfo
*EntityManagementApi* | [**setSingleEntityExtInfoKeyValueWithHttpInfo**](docs/EntityManagementApi.md#setSingleEntityExtInfoKeyValueWithHttpInfo) | **PUT** /api/v1/management/entity/{entityType}/{entityId}/extinfo | Set a single key/value pair on an entities extinfo
*LegacyApi* | [**acquireOrReleaseLocks**](docs/LegacyApi.md#acquireOrReleaseLocks) | **POST** /services/elexis/lockservice/acquireOrReleaseLocks | 
*LegacyApi* | [**acquireOrReleaseLocksWithHttpInfo**](docs/LegacyApi.md#acquireOrReleaseLocksWithHttpInfo) | **POST** /services/elexis/lockservice/acquireOrReleaseLocks | 
*LegacyApi* | [**getLockInfo**](docs/LegacyApi.md#getLockInfo) | **GET** /services/elexis/lockservice/lockInfo | 
*LegacyApi* | [**getLockInfoWithHttpInfo**](docs/LegacyApi.md#getLockInfoWithHttpInfo) | **GET** /services/elexis/lockservice/lockInfo | 
*LegacyApi* | [**getStatusJson**](docs/LegacyApi.md#getStatusJson) | **GET** /services/elexis/instances/statusJson | Get Status Json
*LegacyApi* | [**getStatusJsonWithHttpInfo**](docs/LegacyApi.md#getStatusJsonWithHttpInfo) | **GET** /services/elexis/instances/statusJson | Get Status Json
*LegacyApi* | [**isLocked**](docs/LegacyApi.md#isLocked) | **POST** /services/elexis/lockservice/isLocked | 
*LegacyApi* | [**isLockedWithHttpInfo**](docs/LegacyApi.md#isLockedWithHttpInfo) | **POST** /services/elexis/lockservice/isLocked | 
*LegacyApi* | [**postEvent**](docs/LegacyApi.md#postEvent) | **POST** /services/elexis/eventservice/postEvent | 
*LegacyApi* | [**postEventWithHttpInfo**](docs/LegacyApi.md#postEventWithHttpInfo) | **POST** /services/elexis/eventservice/postEvent | 
*ManagementApi* | [**createUser**](docs/ManagementApi.md#createUser) | **POST** /api/v1/management/user | Create a new user
*ManagementApi* | [**createUserWithHttpInfo**](docs/ManagementApi.md#createUserWithHttpInfo) | **POST** /api/v1/management/user | Create a new user
*ManagementApi* | [**deleteUser**](docs/ManagementApi.md#deleteUser) | **DELETE** /api/v1/management/user/{id} | Remove user from database
*ManagementApi* | [**deleteUserWithHttpInfo**](docs/ManagementApi.md#deleteUserWithHttpInfo) | **DELETE** /api/v1/management/user/{id} | Remove user from database
*ManagementApi* | [**getContactConfigurationEntries**](docs/ManagementApi.md#getContactConfigurationEntries) | **GET** /api/v1/management/config/contact/{contactid} | Get Contact Configuration Entries
*ManagementApi* | [**getContactConfigurationEntriesWithHttpInfo**](docs/ManagementApi.md#getContactConfigurationEntriesWithHttpInfo) | **GET** /api/v1/management/config/contact/{contactid} | Get Contact Configuration Entries
*ManagementApi* | [**getEntityExtInfo**](docs/ManagementApi.md#getEntityExtInfo) | **GET** /api/v1/management/entity/{entityType}/{entityId}/extinfo | Return the extinfo stored values of an entity
*ManagementApi* | [**getEntityExtInfoWithHttpInfo**](docs/ManagementApi.md#getEntityExtInfoWithHttpInfo) | **GET** /api/v1/management/entity/{entityType}/{entityId}/extinfo | Return the extinfo stored values of an entity
*ManagementApi* | [**getGlobalConfiguration**](docs/ManagementApi.md#getGlobalConfiguration) | **GET** /api/v1/management/config/global | Return the global configuration tree
*ManagementApi* | [**getGlobalConfigurationWithHttpInfo**](docs/ManagementApi.md#getGlobalConfigurationWithHttpInfo) | **GET** /api/v1/management/config/global | Return the global configuration tree
*ManagementApi* | [**getUser**](docs/ManagementApi.md#getUser) | **GET** /api/v1/management/user/{id} | Get User
*ManagementApi* | [**getUserWithHttpInfo**](docs/ManagementApi.md#getUserWithHttpInfo) | **GET** /api/v1/management/user/{id} | Get User
*ManagementApi* | [**getUserContactConfigurationAsTree**](docs/ManagementApi.md#getUserContactConfigurationAsTree) | **GET** /api/v1/management/config/usercontact | Return the configuration tree of a user contact. If no param provided, returns a list of all user-contact-ids with configuration values.
*ManagementApi* | [**getUserContactConfigurationAsTreeWithHttpInfo**](docs/ManagementApi.md#getUserContactConfigurationAsTreeWithHttpInfo) | **GET** /api/v1/management/config/usercontact | Return the configuration tree of a user contact. If no param provided, returns a list of all user-contact-ids with configuration values.
*ManagementApi* | [**getUsers**](docs/ManagementApi.md#getUsers) | **GET** /api/v1/management/user | List all users
*ManagementApi* | [**getUsersWithHttpInfo**](docs/ManagementApi.md#getUsersWithHttpInfo) | **GET** /api/v1/management/user | List all users
*ManagementApi* | [**listAvailableGroups**](docs/ManagementApi.md#listAvailableGroups) | **GET** /api/v1/management/user/list-available-groups | List available groups
*ManagementApi* | [**listAvailableGroupsWithHttpInfo**](docs/ManagementApi.md#listAvailableGroupsWithHttpInfo) | **GET** /api/v1/management/user/list-available-groups | List available groups
*ManagementApi* | [**listAvailableRoles**](docs/ManagementApi.md#listAvailableRoles) | **GET** /api/v1/management/user/list-available-roles | List available roles
*ManagementApi* | [**listAvailableRolesWithHttpInfo**](docs/ManagementApi.md#listAvailableRolesWithHttpInfo) | **GET** /api/v1/management/user/list-available-roles | List available roles
*ManagementApi* | [**removeEntityExtInfoKeyValue**](docs/ManagementApi.md#removeEntityExtInfoKeyValue) | **DELETE** /api/v1/management/entity/{entityType}/{entityId}/extinfo | Remove a single key/value pair on an entities extinfo
*ManagementApi* | [**removeEntityExtInfoKeyValueWithHttpInfo**](docs/ManagementApi.md#removeEntityExtInfoKeyValueWithHttpInfo) | **DELETE** /api/v1/management/entity/{entityType}/{entityId}/extinfo | Remove a single key/value pair on an entities extinfo
*ManagementApi* | [**setContactConfiguration**](docs/ManagementApi.md#setContactConfiguration) | **POST** /api/v1/management/config/contact/{contactid} | Update contact configuration
*ManagementApi* | [**setContactConfigurationWithHttpInfo**](docs/ManagementApi.md#setContactConfigurationWithHttpInfo) | **POST** /api/v1/management/config/contact/{contactid} | Update contact configuration
*ManagementApi* | [**setMultipleEntityExtInfoKeyValue**](docs/ManagementApi.md#setMultipleEntityExtInfoKeyValue) | **POST** /api/v1/management/entity/{entityType}/{entityId}/extinfo | Set multiple key/value pairs on an entities extinfo
*ManagementApi* | [**setMultipleEntityExtInfoKeyValueWithHttpInfo**](docs/ManagementApi.md#setMultipleEntityExtInfoKeyValueWithHttpInfo) | **POST** /api/v1/management/entity/{entityType}/{entityId}/extinfo | Set multiple key/value pairs on an entities extinfo
*ManagementApi* | [**setSingleEntityExtInfoKeyValue**](docs/ManagementApi.md#setSingleEntityExtInfoKeyValue) | **PUT** /api/v1/management/entity/{entityType}/{entityId}/extinfo | Set a single key/value pair on an entities extinfo
*ManagementApi* | [**setSingleEntityExtInfoKeyValueWithHttpInfo**](docs/ManagementApi.md#setSingleEntityExtInfoKeyValueWithHttpInfo) | **PUT** /api/v1/management/entity/{entityType}/{entityId}/extinfo | Set a single key/value pair on an entities extinfo
*ManagementApi* | [**updateGlobalConfigByJson**](docs/ManagementApi.md#updateGlobalConfigByJson) | **PUT** /api/v1/management/config/global | Update Global Config By Json
*ManagementApi* | [**updateGlobalConfigByJsonWithHttpInfo**](docs/ManagementApi.md#updateGlobalConfigByJsonWithHttpInfo) | **PUT** /api/v1/management/config/global | Update Global Config By Json
*ManagementApi* | [**updateUser**](docs/ManagementApi.md#updateUser) | **PUT** /api/v1/management/user/{id} | Update an existing user
*ManagementApi* | [**updateUserWithHttpInfo**](docs/ManagementApi.md#updateUserWithHttpInfo) | **PUT** /api/v1/management/user/{id} | Update an existing user
*ManagementApi* | [**upstreamSyncToKeycloak**](docs/ManagementApi.md#upstreamSyncToKeycloak) | **PUT** /api/v1/management/user/sync-to-keycloak | Upstream keycloak sync user data
*ManagementApi* | [**upstreamSyncToKeycloakWithHttpInfo**](docs/ManagementApi.md#upstreamSyncToKeycloakWithHttpInfo) | **PUT** /api/v1/management/user/sync-to-keycloak | Upstream keycloak sync user data
*MessageServiceV1Api* | [**getSupportedUriSchemes**](docs/MessageServiceV1Api.md#getSupportedUriSchemes) | **GET** /api/v1/services/message/schemes | Get supported URI schemes for messaging
*MessageServiceV1Api* | [**getSupportedUriSchemesWithHttpInfo**](docs/MessageServiceV1Api.md#getSupportedUriSchemesWithHttpInfo) | **GET** /api/v1/services/message/schemes | Get supported URI schemes for messaging
*MessageServiceV1Api* | [**sendMessage**](docs/MessageServiceV1Api.md#sendMessage) | **POST** /api/v1/services/message | Send a message using an available transporter scheme
*MessageServiceV1Api* | [**sendMessageWithHttpInfo**](docs/MessageServiceV1Api.md#sendMessageWithHttpInfo) | **POST** /api/v1/services/message | Send a message using an available transporter scheme
*TaskServiceV1Api* | [**activateTask**](docs/TaskServiceV1Api.md#activateTask) | **PUT** /api/v1/services/task/{id}/$activate | Activate and possibly incur task
*TaskServiceV1Api* | [**activateTaskWithHttpInfo**](docs/TaskServiceV1Api.md#activateTaskWithHttpInfo) | **PUT** /api/v1/services/task/{id}/$activate | Activate and possibly incur task
*TaskServiceV1Api* | [**createTask**](docs/TaskServiceV1Api.md#createTask) | **POST** /api/v1/services/task | Create a new task
*TaskServiceV1Api* | [**createTaskWithHttpInfo**](docs/TaskServiceV1Api.md#createTaskWithHttpInfo) | **POST** /api/v1/services/task | Create a new task
*TaskServiceV1Api* | [**deactivateTask**](docs/TaskServiceV1Api.md#deactivateTask) | **PUT** /api/v1/services/task/{id}/$deactivate | Deactivate task
*TaskServiceV1Api* | [**deactivateTaskWithHttpInfo**](docs/TaskServiceV1Api.md#deactivateTaskWithHttpInfo) | **PUT** /api/v1/services/task/{id}/$deactivate | Deactivate task
*TaskServiceV1Api* | [**deleteTask**](docs/TaskServiceV1Api.md#deleteTask) | **DELETE** /api/v1/services/task/{id} | Delete task
*TaskServiceV1Api* | [**deleteTaskWithHttpInfo**](docs/TaskServiceV1Api.md#deleteTaskWithHttpInfo) | **DELETE** /api/v1/services/task/{id} | Delete task
*TaskServiceV1Api* | [**findRunnableExecutions**](docs/TaskServiceV1Api.md#findRunnableExecutions) | **GET** /api/v1/services/runnable/{runnableId}/executions | Find all current and past executions of a runnable
*TaskServiceV1Api* | [**findRunnableExecutionsWithHttpInfo**](docs/TaskServiceV1Api.md#findRunnableExecutionsWithHttpInfo) | **GET** /api/v1/services/runnable/{runnableId}/executions | Find all current and past executions of a runnable
*TaskServiceV1Api* | [**findTask**](docs/TaskServiceV1Api.md#findTask) | **GET** /api/v1/services/task/{id} | Get task and its state
*TaskServiceV1Api* | [**findTaskWithHttpInfo**](docs/TaskServiceV1Api.md#findTaskWithHttpInfo) | **GET** /api/v1/services/task/{id} | Get task and its state
*TaskServiceV1Api* | [**findTaskExecutions**](docs/TaskServiceV1Api.md#findTaskExecutions) | **GET** /api/v1/services/task/{id}/executions | Get all task executions ordered by create time descending (limit 25)
*TaskServiceV1Api* | [**findTaskExecutionsWithHttpInfo**](docs/TaskServiceV1Api.md#findTaskExecutionsWithHttpInfo) | **GET** /api/v1/services/task/{id}/executions | Get all task executions ordered by create time descending (limit 25)
*TaskServiceV1Api* | [**findTasks**](docs/TaskServiceV1Api.md#findTasks) | **GET** /api/v1/services/task | List tasks
*TaskServiceV1Api* | [**findTasksWithHttpInfo**](docs/TaskServiceV1Api.md#findTasksWithHttpInfo) | **GET** /api/v1/services/task | List tasks
*TaskServiceV1Api* | [**listRunnables**](docs/TaskServiceV1Api.md#listRunnables) | **GET** /api/v1/services/runnable | List available runnables
*TaskServiceV1Api* | [**listRunnablesWithHttpInfo**](docs/TaskServiceV1Api.md#listRunnablesWithHttpInfo) | **GET** /api/v1/services/runnable | List available runnables
*TaskServiceV1Api* | [**refreshTask**](docs/TaskServiceV1Api.md#refreshTask) | **PUT** /api/v1/services/task/{id}/$refresh | Refreshes the info on this task, and acts on it
*TaskServiceV1Api* | [**refreshTaskWithHttpInfo**](docs/TaskServiceV1Api.md#refreshTaskWithHttpInfo) | **PUT** /api/v1/services/task/{id}/$refresh | Refreshes the info on this task, and acts on it
*TaskServiceV1Api* | [**triggerRunnable**](docs/TaskServiceV1Api.md#triggerRunnable) | **POST** /api/v1/services/runnable/{runnableId}/$trigger | Trigger asynchronous execution of a runnable
*TaskServiceV1Api* | [**triggerRunnableWithHttpInfo**](docs/TaskServiceV1Api.md#triggerRunnableWithHttpInfo) | **POST** /api/v1/services/runnable/{runnableId}/$trigger | Trigger asynchronous execution of a runnable
*TaskServiceV1Api* | [**triggerRunnableSync**](docs/TaskServiceV1Api.md#triggerRunnableSync) | **POST** /api/v1/services/runnable/{runnableId}/$trigger-sync | Trigger synchronous execution of a runnable by its id
*TaskServiceV1Api* | [**triggerRunnableSyncWithHttpInfo**](docs/TaskServiceV1Api.md#triggerRunnableSyncWithHttpInfo) | **POST** /api/v1/services/runnable/{runnableId}/$trigger-sync | Trigger synchronous execution of a runnable by its id
*TaskServiceV1Api* | [**triggerTask**](docs/TaskServiceV1Api.md#triggerTask) | **PUT** /api/v1/services/task/{id}/$trigger | Trigger task
*TaskServiceV1Api* | [**triggerTaskWithHttpInfo**](docs/TaskServiceV1Api.md#triggerTaskWithHttpInfo) | **PUT** /api/v1/services/task/{id}/$trigger | Trigger task
*TaskServiceV1Api* | [**updateTask**](docs/TaskServiceV1Api.md#updateTask) | **PUT** /api/v1/services/task/{id} | Update task
*TaskServiceV1Api* | [**updateTaskWithHttpInfo**](docs/TaskServiceV1Api.md#updateTaskWithHttpInfo) | **PUT** /api/v1/services/task/{id} | Update task
*UserApi* | [**deleteUserContactConfigurationEntryByKey**](docs/UserApi.md#deleteUserContactConfigurationEntryByKey) | **DELETE** /api/v1/user/config/contact | Delete User Contact Configuration Entry By Key
*UserApi* | [**deleteUserContactConfigurationEntryByKeyWithHttpInfo**](docs/UserApi.md#deleteUserContactConfigurationEntryByKeyWithHttpInfo) | **DELETE** /api/v1/user/config/contact | Delete User Contact Configuration Entry By Key
*UserApi* | [**findGlobalConfigurationDirectSubnodeKeysForGivenKey**](docs/UserApi.md#findGlobalConfigurationDirectSubnodeKeysForGivenKey) | **GET** /api/v1/user/config/global-subnodekeys | Find the direct subnode keys for a given entry branch. Programmatically limited to specific branches.
*UserApi* | [**findGlobalConfigurationDirectSubnodeKeysForGivenKeyWithHttpInfo**](docs/UserApi.md#findGlobalConfigurationDirectSubnodeKeysForGivenKeyWithHttpInfo) | **GET** /api/v1/user/config/global-subnodekeys | Find the direct subnode keys for a given entry branch. Programmatically limited to specific branches.
*UserApi* | [**getExecutiveDoctorsWorkingFor**](docs/UserApi.md#getExecutiveDoctorsWorkingFor) | **GET** /api/v1/user/executive-doctors-working-for | Get executive doctors user is working for
*UserApi* | [**getExecutiveDoctorsWorkingForWithHttpInfo**](docs/UserApi.md#getExecutiveDoctorsWorkingForWithHttpInfo) | **GET** /api/v1/user/executive-doctors-working-for | Get executive doctors user is working for
*UserApi* | [**getGlobalConfigurationValueByKey**](docs/UserApi.md#getGlobalConfigurationValueByKey) | **GET** /api/v1/user/config/global | Get Global Configuration Value By Key
*UserApi* | [**getGlobalConfigurationValueByKeyWithHttpInfo**](docs/UserApi.md#getGlobalConfigurationValueByKeyWithHttpInfo) | **GET** /api/v1/user/config/global | Get Global Configuration Value By Key
*UserApi* | [**getUserContactConfigurationValueByKey**](docs/UserApi.md#getUserContactConfigurationValueByKey) | **GET** /api/v1/user/config/contact | Get User Contact Configuration Value By Key
*UserApi* | [**getUserContactConfigurationValueByKeyWithHttpInfo**](docs/UserApi.md#getUserContactConfigurationValueByKeyWithHttpInfo) | **GET** /api/v1/user/config/contact | Get User Contact Configuration Value By Key
*UserApi* | [**getUserInfo**](docs/UserApi.md#getUserInfo) | **GET** /api/v1/user/info | Get user information
*UserApi* | [**getUserInfoWithHttpInfo**](docs/UserApi.md#getUserInfoWithHttpInfo) | **GET** /api/v1/user/info | Get user information
*UserApi* | [**setGlobalConfigurationValueByKey**](docs/UserApi.md#setGlobalConfigurationValueByKey) | **PUT** /api/v1/user/config/global | Set Global Configuration Value By Key
*UserApi* | [**setGlobalConfigurationValueByKeyWithHttpInfo**](docs/UserApi.md#setGlobalConfigurationValueByKeyWithHttpInfo) | **PUT** /api/v1/user/config/global | Set Global Configuration Value By Key
*UserApi* | [**setUserContactConfigurationValueByKey**](docs/UserApi.md#setUserContactConfigurationValueByKey) | **PUT** /api/v1/user/config/contact | Set User Contact Configuration Value By Key
*UserApi* | [**setUserContactConfigurationValueByKeyWithHttpInfo**](docs/UserApi.md#setUserContactConfigurationValueByKeyWithHttpInfo) | **PUT** /api/v1/user/config/contact | Set User Contact Configuration Value By Key
*UserManagementApi* | [**createUser**](docs/UserManagementApi.md#createUser) | **POST** /api/v1/management/user | Create a new user
*UserManagementApi* | [**createUserWithHttpInfo**](docs/UserManagementApi.md#createUserWithHttpInfo) | **POST** /api/v1/management/user | Create a new user
*UserManagementApi* | [**deleteUser**](docs/UserManagementApi.md#deleteUser) | **DELETE** /api/v1/management/user/{id} | Remove user from database
*UserManagementApi* | [**deleteUserWithHttpInfo**](docs/UserManagementApi.md#deleteUserWithHttpInfo) | **DELETE** /api/v1/management/user/{id} | Remove user from database
*UserManagementApi* | [**getUser**](docs/UserManagementApi.md#getUser) | **GET** /api/v1/management/user/{id} | Get User
*UserManagementApi* | [**getUserWithHttpInfo**](docs/UserManagementApi.md#getUserWithHttpInfo) | **GET** /api/v1/management/user/{id} | Get User
*UserManagementApi* | [**getUsers**](docs/UserManagementApi.md#getUsers) | **GET** /api/v1/management/user | List all users
*UserManagementApi* | [**getUsersWithHttpInfo**](docs/UserManagementApi.md#getUsersWithHttpInfo) | **GET** /api/v1/management/user | List all users
*UserManagementApi* | [**listAvailableGroups**](docs/UserManagementApi.md#listAvailableGroups) | **GET** /api/v1/management/user/list-available-groups | List available groups
*UserManagementApi* | [**listAvailableGroupsWithHttpInfo**](docs/UserManagementApi.md#listAvailableGroupsWithHttpInfo) | **GET** /api/v1/management/user/list-available-groups | List available groups
*UserManagementApi* | [**listAvailableRoles**](docs/UserManagementApi.md#listAvailableRoles) | **GET** /api/v1/management/user/list-available-roles | List available roles
*UserManagementApi* | [**listAvailableRolesWithHttpInfo**](docs/UserManagementApi.md#listAvailableRolesWithHttpInfo) | **GET** /api/v1/management/user/list-available-roles | List available roles
*UserManagementApi* | [**updateUser**](docs/UserManagementApi.md#updateUser) | **PUT** /api/v1/management/user/{id} | Update an existing user
*UserManagementApi* | [**updateUserWithHttpInfo**](docs/UserManagementApi.md#updateUserWithHttpInfo) | **PUT** /api/v1/management/user/{id} | Update an existing user
*UserManagementApi* | [**upstreamSyncToKeycloak**](docs/UserManagementApi.md#upstreamSyncToKeycloak) | **PUT** /api/v1/management/user/sync-to-keycloak | Upstream keycloak sync user data
*UserManagementApi* | [**upstreamSyncToKeycloakWithHttpInfo**](docs/UserManagementApi.md#upstreamSyncToKeycloakWithHttpInfo) | **PUT** /api/v1/management/user/sync-to-keycloak | Upstream keycloak sync user data
*VirtualFilesystemServiceV1Api* | [**deleteVfsUrl**](docs/VirtualFilesystemServiceV1Api.md#deleteVfsUrl) | **DELETE** /api/v1/services/vfs/delete | Delete a file or directory from the virtual filesystem
*VirtualFilesystemServiceV1Api* | [**deleteVfsUrlWithHttpInfo**](docs/VirtualFilesystemServiceV1Api.md#deleteVfsUrlWithHttpInfo) | **DELETE** /api/v1/services/vfs/delete | Delete a file or directory from the virtual filesystem
*VirtualFilesystemServiceV1Api* | [**downloadFileByVfsUrl**](docs/VirtualFilesystemServiceV1Api.md#downloadFileByVfsUrl) | **GET** /api/v1/services/vfs/download | Download a file from the virtual filesystem
*VirtualFilesystemServiceV1Api* | [**downloadFileByVfsUrlWithHttpInfo**](docs/VirtualFilesystemServiceV1Api.md#downloadFileByVfsUrlWithHttpInfo) | **GET** /api/v1/services/vfs/download | Download a file from the virtual filesystem
*VirtualFilesystemServiceV1Api* | [**listVfsUrl**](docs/VirtualFilesystemServiceV1Api.md#listVfsUrl) | **GET** /api/v1/services/vfs/list | List the contents of a directory
*VirtualFilesystemServiceV1Api* | [**listVfsUrlWithHttpInfo**](docs/VirtualFilesystemServiceV1Api.md#listVfsUrlWithHttpInfo) | **GET** /api/v1/services/vfs/list | List the contents of a directory
*VirtualFilesystemServiceV1Api* | [**mkdirsVfsUrl**](docs/VirtualFilesystemServiceV1Api.md#mkdirsVfsUrl) | **PUT** /api/v1/services/vfs/mkdirs | Create a directory and all intermediates
*VirtualFilesystemServiceV1Api* | [**mkdirsVfsUrlWithHttpInfo**](docs/VirtualFilesystemServiceV1Api.md#mkdirsVfsUrlWithHttpInfo) | **PUT** /api/v1/services/vfs/mkdirs | Create a directory and all intermediates
*VirtualFilesystemServiceV1Api* | [**uploadFileToVfsUrl**](docs/VirtualFilesystemServiceV1Api.md#uploadFileToVfsUrl) | **POST** /api/v1/services/vfs/upload | Upload a file to the virtual filesystem
*VirtualFilesystemServiceV1Api* | [**uploadFileToVfsUrlWithHttpInfo**](docs/VirtualFilesystemServiceV1Api.md#uploadFileToVfsUrlWithHttpInfo) | **POST** /api/v1/services/vfs/upload | Upload a file to the virtual filesystem


## Documentation for Models

 - [ElexisEvent](docs/ElexisEvent.md)
 - [IdentifiedRunnable](docs/IdentifiedRunnable.md)
 - [InstanceStatus](docs/InstanceStatus.md)
 - [LockInfo](docs/LockInfo.md)
 - [LockRequest](docs/LockRequest.md)
 - [LockResponse](docs/LockResponse.md)
 - [Message](docs/Message.md)
 - [OwnerTaskNotification](docs/OwnerTaskNotification.md)
 - [STATE](docs/STATE.md)
 - [Status](docs/Status.md)
 - [Task](docs/Task.md)
 - [TaskResult](docs/TaskResult.md)
 - [TaskState](docs/TaskState.md)
 - [TaskTriggerType](docs/TaskTriggerType.md)
 - [Type](docs/Type.md)
 - [User](docs/User.md)
 - [VfsHandle](docs/VfsHandle.md)


<a id="documentation-for-authorization"></a>
## Documentation for Authorization


Authentication schemes defined for the API:
<a id="ElexisEnvironment"></a>
### ElexisEnvironment


- **Type**: HTTP Bearer Token authentication (JWT)

<a id="SecurityScheme"></a>
### SecurityScheme



## Recommendation

It's recommended to create an instance of `ApiClient` per thread in a multithreaded environment to avoid any potential issues.
However, the instances of the api clients created from the `ApiClient` are thread-safe and can be re-used.

## Author



