/*
 * Decompiled with CFR 0.152.
 */
package com.equo.chromium.swt;

import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.cef.browser.CefBrowser;

public class Log {
    private static final Logger logger = Logger.getLogger("com.equo.chromium");

    static {
        Log.configureLogger();
    }

    private static void configureLogger() {
        if (Boolean.getBoolean("chromium.debug")) {
            if (Log.isLoggerNotConfigured(logger) && System.getProperty("java.util.logging.config.file", "").isEmpty()) {
                logger.setUseParentHandlers(false);
                ConsoleHandler consoleHandler = new ConsoleHandler();
                consoleHandler.setFormatter(Log.customFormatter());
                consoleHandler.setLevel(Level.ALL);
                logger.setLevel(Level.ALL);
                logger.addHandler(consoleHandler);
                return;
            }
        } else {
            logger.setLevel(Level.OFF);
        }
    }

    public static boolean isLoggerNotConfigured(Logger logger) {
        if (logger != null) {
            boolean noFilter;
            Level level = logger.getLevel();
            boolean loggerLevelOff = level == Level.OFF || level == null;
            boolean noHandlers = logger.getHandlers().length == 0;
            boolean bl = noFilter = logger.getFilter() == null;
            return logger.getUseParentHandlers() && noHandlers && loggerLevelOff && noFilter;
        }
        return true;
    }

    private static SimpleFormatter customFormatter() {
        return new SimpleFormatter(){

            @Override
            public synchronized String format(LogRecord record) {
                int id = record.getParameters() != null && record.getParameters().length > 0 ? (Integer)record.getParameters()[0] : -1;
                return String.format("%1$tF %1$tT.%1$tL %2$s%n", record.getMillis(), String.valueOf(record.getMessage()) + (id != -1 ? " id:" + id : ""));
            }
        };
    }

    public static void debug(String log) {
        Log.log(log, -1);
    }

    public static void debug(String log, CefBrowser cefBrowser) {
        Log.log(log, cefBrowser != null ? cefBrowser.getIdentifier() : -1);
    }

    public static void log(String log, int id) {
        LogRecord record = new LogRecord(Level.FINE, log);
        record.setParameters(new Object[]{id});
        logger.log(record);
    }
}

