/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.mail.internal;

import ch.elexis.core.mail.IMailClient;
import ch.elexis.core.mail.internal.SendMailRunnable;
import ch.elexis.core.model.tasks.IIdentifiedRunnable;
import ch.elexis.core.model.tasks.IIdentifiedRunnableFactory;
import ch.elexis.core.tasks.model.ITaskService;
import io.quarkus.runtime.Startup;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Startup
@Component(immediate=true)
public class MailClientRunnableFactory
implements IIdentifiedRunnableFactory {
    @Inject
    @Reference
    ITaskService taskService;
    @Inject
    @Reference
    IMailClient mailClient;

    public List<IIdentifiedRunnable> getProvidedRunnables() {
        return Collections.singletonList(new SendMailRunnable(this.mailClient));
    }

    @PostConstruct
    @Activate
    public void activate() {
        this.taskService.bindIIdentifiedRunnableFactory((IIdentifiedRunnableFactory)this);
    }

    @PreDestroy
    @Deactivate
    public void deactivate() {
        this.taskService.unbindIIdentifiedRunnableFactory((IIdentifiedRunnableFactory)this);
    }
}

