/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.laboratory.controls;

import ch.elexis.core.types.LabItemTyp;
import ch.elexis.data.Kontakt;
import ch.elexis.data.LabItem;
import ch.elexis.data.LabOrder;
import ch.elexis.data.LabResult;
import ch.rgw.tools.TimeTool;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Control;

public class LaborOrderViewerItem {
    private static ExecutorService executorService = Executors.newCachedThreadPool();
    private StructuredViewer viewer;
    private LabOrder order;
    private String labItemLabel;
    private String labResultString;
    private String itemPrio;
    public volatile boolean resolved;
    public volatile boolean resolving;

    public LaborOrderViewerItem(StructuredViewer viewer, LabOrder order) {
        this.viewer = viewer;
        this.order = order;
    }

    public LabResult getLabResult() {
        return (LabResult)this.order.getLabResult();
    }

    public LabOrder getLabOrder() {
        return this.order;
    }

    public Optional<String> getLabResultString() {
        if (this.hasLabResult()) {
            if (this.labResultString == null && !this.resolved && !this.resolving) {
                this.resolving = true;
                executorService.execute(new ResolveLazyFieldsRunnable(this.viewer, this));
            }
            return this.labResultString != null ? Optional.of(this.labResultString) : Optional.of("...");
        }
        return Optional.empty();
    }

    public void refreshResultString() {
        this.labResultString = null;
        this.resolved = false;
        this.viewer.refresh((Object)this);
    }

    private boolean hasLabResult() {
        return this.getLabResult() != null;
    }

    public void deleteOrder() {
        this.order.delete();
        ((List)this.viewer.getInput()).remove(this);
        this.viewer.refresh();
    }

    public Optional<String> getLabItemPrio() {
        if (this.hasLabItem()) {
            if (this.itemPrio == null) {
                this.itemPrio = this.order.getLabItem().getPrio();
            }
            return Optional.of(this.itemPrio);
        }
        return Optional.empty();
    }

    public TimeTool getObservationTime() {
        return this.order.getObservationTime();
    }

    public void setObservationTimeWithResults(TimeTool date) {
        this.order.setObservationTimeWithResults(date);
        this.viewer.refresh((Object)this);
    }

    public LabResult createResult() {
        LabResult ret = this.order.createResult();
        this.viewer.refresh((Object)this);
        return ret;
    }

    public LabResult createResult(Kontakt origin) {
        LabResult ret = this.order.createResult(origin);
        this.viewer.refresh((Object)this);
        return ret;
    }

    public void setState(LabOrder.State state) {
        this.order.setState(state);
        this.viewer.refresh((Object)this);
    }

    public boolean hasLabItem() {
        return this.order.getLabItem() != null;
    }

    public LabItemTyp getLabItemTyp() {
        return this.order.getLabItem().getTyp();
    }

    public LabOrder.State getState() {
        return this.order.getState();
    }

    public TimeTool getTime() {
        return this.order.getTime();
    }

    public Optional<String> getOrderId() {
        return Optional.ofNullable(this.order.get("orderid"));
    }

    public Optional<String> getOrderGroupName() {
        return Optional.ofNullable(this.order.get("groupname"));
    }

    public Optional<String> getLabItemLabel() {
        if (this.hasLabItem()) {
            if (this.labItemLabel == null && !this.resolved && !this.resolving) {
                this.resolving = true;
                executorService.execute(new ResolveLazyFieldsRunnable(this.viewer, this));
            }
            return this.labItemLabel != null ? Optional.of(this.labItemLabel) : Optional.of("...");
        }
        return Optional.empty();
    }

    private static class ResolveLazyFieldsRunnable
    implements Runnable {
        private LaborOrderViewerItem item;
        private StructuredViewer viewer;

        public ResolveLazyFieldsRunnable(StructuredViewer viewer, LaborOrderViewerItem item) {
            this.item = item;
            this.viewer = viewer;
        }

        @Override
        public void run() {
            this.resolveLabItemLabel();
            this.resolveLabResultString();
            this.item.resolved = true;
            this.item.resolving = false;
            this.updateViewer();
        }

        private void resolveLabItemLabel() {
            LabItem labItem = this.item.order.getLabItem();
            if (labItem != null) {
                this.item.labItemLabel = labItem.getLabel();
            }
        }

        private void resolveLabResultString() {
            LabResult labResult = (LabResult)this.item.order.getLabResult();
            if (labResult != null) {
                this.item.labResultString = this.getNonEmptyResultString(labResult);
            }
        }

        private String getNonEmptyResultString(LabResult labResult) {
            String result = labResult.getResult();
            if (result != null && result.isEmpty()) {
                return "?";
            }
            if (labResult.getItem().getTyp() == LabItemTyp.TEXT && labResult.isLongText() && (result = labResult.getComment()).length() > 20) {
                result = result.substring(0, 20);
            }
            return result;
        }

        private void updateViewer() {
            final Control control = this.viewer.getControl();
            if (control != null && !control.isDisposed()) {
                this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (control.isVisible()) {
                            viewer.refresh((Object)item, true);
                        }
                    }
                });
            }
        }
    }
}

