/*
 * Decompiled with CFR 0.152.
 */
package ch.myelexis.server.api;

import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.Pair;
import ch.myelexis.server.model.LockInfo;
import ch.myelexis.server.model.LockRequest;
import ch.myelexis.server.model.LockResponse;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LegacyLockServiceApi {
    private final HttpClient memberVarHttpClient;
    private final ObjectMapper memberVarObjectMapper;
    private final String memberVarBaseUri;
    private final Consumer<HttpRequest.Builder> memberVarInterceptor;
    private final Duration memberVarReadTimeout;
    private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
    private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

    public LegacyLockServiceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LegacyLockServiceApi(ApiClient apiClient) {
        this.memberVarHttpClient = apiClient.getHttpClient();
        this.memberVarObjectMapper = apiClient.getObjectMapper();
        this.memberVarBaseUri = apiClient.getBaseUri();
        this.memberVarInterceptor = apiClient.getRequestInterceptor();
        this.memberVarReadTimeout = apiClient.getReadTimeout();
        this.memberVarResponseInterceptor = apiClient.getResponseInterceptor();
        this.memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
    }

    protected ApiException getApiException(String operationId, HttpResponse<InputStream> response) throws IOException {
        String body = response.body() == null ? null : new String(response.body().readAllBytes());
        String message = this.formatExceptionMessage(operationId, response.statusCode(), body);
        return new ApiException(response.statusCode(), message, response.headers(), body);
    }

    private String formatExceptionMessage(String operationId, int statusCode, String body) {
        if (body == null || body.isEmpty()) {
            body = "[no body]";
        }
        return operationId + " call failed with: " + statusCode + " - " + body;
    }

    public File downloadFileFromResponse(HttpResponse<InputStream> response) throws ApiException {
        try {
            File file = this.prepareDownloadFile(response);
            Files.copy(response.body(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return file;
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    private File prepareDownloadFile(HttpResponse<InputStream> response) throws IOException {
        Pattern pattern;
        Matcher matcher;
        String filename = null;
        Optional<String> contentDisposition = response.headers().firstValue("Content-Disposition");
        if (contentDisposition.isPresent() && !"".equals(contentDisposition.get()) && (matcher = (pattern = Pattern.compile("filename=['\"]?([^'\"\\s]+)['\"]?")).matcher(contentDisposition.get())).find()) {
            filename = matcher.group(1);
        }
        File file = null;
        if (filename != null) {
            Path tempDir = Files.createTempDirectory("swagger-gen-native", new FileAttribute[0]);
            Path filePath = Files.createFile(tempDir.resolve(filename), new FileAttribute[0]);
            file = filePath.toFile();
            tempDir.toFile().deleteOnExit();
            file.deleteOnExit();
        } else {
            file = Files.createTempFile("download-", "", new FileAttribute[0]).toFile();
            file.deleteOnExit();
        }
        return file;
    }

    public LockResponse acquireOrReleaseLocks(@Nonnull LockRequest lockRequest) throws ApiException {
        return this.acquireOrReleaseLocks(lockRequest, null);
    }

    public LockResponse acquireOrReleaseLocks(@Nonnull LockRequest lockRequest, Map<String, String> headers) throws ApiException {
        ApiResponse<LockResponse> localVarResponse = this.acquireOrReleaseLocksWithHttpInfo(lockRequest, headers);
        return localVarResponse.getData();
    }

    public ApiResponse<LockResponse> acquireOrReleaseLocksWithHttpInfo(@Nonnull LockRequest lockRequest) throws ApiException {
        return this.acquireOrReleaseLocksWithHttpInfo(lockRequest, null);
    }

    public ApiResponse<LockResponse> acquireOrReleaseLocksWithHttpInfo(@Nonnull LockRequest lockRequest, Map<String, String> headers) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.acquireOrReleaseLocksRequestBuilder(lockRequest, headers);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("acquireOrReleaseLocks", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            LockResponse responseValue = responseBody.isBlank() ? null : (LockResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<LockResponse>(){});
            localVarResponse.body().close();
            return new ApiResponse<LockResponse>(localVarResponse.statusCode(), localVarResponse.headers().map(), responseValue);
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder acquireOrReleaseLocksRequestBuilder(@Nonnull LockRequest lockRequest, Map<String, String> headers) throws ApiException {
        if (lockRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'lockRequest' when calling acquireOrReleaseLocks");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/services/elexis/lockservice/acquireOrReleaseLocks";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/xml");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)lockRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public LockInfo getLockInfo(@Nullable String objectId) throws ApiException {
        return this.getLockInfo(objectId, null);
    }

    public LockInfo getLockInfo(@Nullable String objectId, Map<String, String> headers) throws ApiException {
        ApiResponse<LockInfo> localVarResponse = this.getLockInfoWithHttpInfo(objectId, headers);
        return localVarResponse.getData();
    }

    public ApiResponse<LockInfo> getLockInfoWithHttpInfo(@Nullable String objectId) throws ApiException {
        return this.getLockInfoWithHttpInfo(objectId, null);
    }

    public ApiResponse<LockInfo> getLockInfoWithHttpInfo(@Nullable String objectId, Map<String, String> headers) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getLockInfoRequestBuilder(objectId, headers);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getLockInfo", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            LockInfo responseValue = responseBody.isBlank() ? null : (LockInfo)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<LockInfo>(){});
            localVarResponse.body().close();
            return new ApiResponse<LockInfo>(localVarResponse.statusCode(), localVarResponse.headers().map(), responseValue);
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getLockInfoRequestBuilder(@Nullable String objectId, Map<String, String> headers) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/services/elexis/lockservice/lockInfo";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "objectId";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("objectId", objectId));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> {
                StringJoiner stringJoiner2 = queryJoiner.add(p.getName() + "=" + p.getValue());
            });
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "text/plain");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public Boolean isLocked(@Nonnull LockRequest lockRequest) throws ApiException {
        return this.isLocked(lockRequest, null);
    }

    public Boolean isLocked(@Nonnull LockRequest lockRequest, Map<String, String> headers) throws ApiException {
        ApiResponse<Boolean> localVarResponse = this.isLockedWithHttpInfo(lockRequest, headers);
        return localVarResponse.getData();
    }

    public ApiResponse<Boolean> isLockedWithHttpInfo(@Nonnull LockRequest lockRequest) throws ApiException {
        return this.isLockedWithHttpInfo(lockRequest, null);
    }

    public ApiResponse<Boolean> isLockedWithHttpInfo(@Nonnull LockRequest lockRequest, Map<String, String> headers) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.isLockedRequestBuilder(lockRequest, headers);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("isLocked", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            Boolean responseValue = responseBody.isBlank() ? null : (Boolean)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<Boolean>(){});
            localVarResponse.body().close();
            return new ApiResponse<Boolean>(localVarResponse.statusCode(), localVarResponse.headers().map(), responseValue);
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder isLockedRequestBuilder(@Nonnull LockRequest lockRequest, Map<String, String> headers) throws ApiException {
        if (lockRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'lockRequest' when calling isLocked");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/services/elexis/lockservice/isLocked";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/xml");
        localVarRequestBuilder.header("Accept", "text/plain");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)lockRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    private static class HttpRequestBuilderExtensions {
        private HttpRequestBuilderExtensions() {
        }

        static HttpRequest.Builder withAdditionalHeaders(HttpRequest.Builder builder, Map<String, String> headers) {
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    builder.header(entry.getKey(), entry.getValue());
                }
            }
            return builder;
        }
    }
}

