/*
 * Decompiled with CFR 0.152.
 */
package ch.myelexis.server.api;

import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.Pair;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EntityManagementApi {
    private final HttpClient memberVarHttpClient;
    private final ObjectMapper memberVarObjectMapper;
    private final String memberVarBaseUri;
    private final Consumer<HttpRequest.Builder> memberVarInterceptor;
    private final Duration memberVarReadTimeout;
    private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
    private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

    public EntityManagementApi() {
        this(Configuration.getDefaultApiClient());
    }

    public EntityManagementApi(ApiClient apiClient) {
        this.memberVarHttpClient = apiClient.getHttpClient();
        this.memberVarObjectMapper = apiClient.getObjectMapper();
        this.memberVarBaseUri = apiClient.getBaseUri();
        this.memberVarInterceptor = apiClient.getRequestInterceptor();
        this.memberVarReadTimeout = apiClient.getReadTimeout();
        this.memberVarResponseInterceptor = apiClient.getResponseInterceptor();
        this.memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
    }

    protected ApiException getApiException(String operationId, HttpResponse<InputStream> response) throws IOException {
        String body = response.body() == null ? null : new String(response.body().readAllBytes());
        String message = this.formatExceptionMessage(operationId, response.statusCode(), body);
        return new ApiException(response.statusCode(), message, response.headers(), body);
    }

    private String formatExceptionMessage(String operationId, int statusCode, String body) {
        if (body == null || body.isEmpty()) {
            body = "[no body]";
        }
        return operationId + " call failed with: " + statusCode + " - " + body;
    }

    public File downloadFileFromResponse(HttpResponse<InputStream> response) throws ApiException {
        try {
            File file = this.prepareDownloadFile(response);
            Files.copy(response.body(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return file;
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    private File prepareDownloadFile(HttpResponse<InputStream> response) throws IOException {
        Pattern pattern;
        Matcher matcher;
        String filename = null;
        Optional<String> contentDisposition = response.headers().firstValue("Content-Disposition");
        if (contentDisposition.isPresent() && !"".equals(contentDisposition.get()) && (matcher = (pattern = Pattern.compile("filename=['\"]?([^'\"\\s]+)['\"]?")).matcher(contentDisposition.get())).find()) {
            filename = matcher.group(1);
        }
        File file = null;
        if (filename != null) {
            Path tempDir = Files.createTempDirectory("swagger-gen-native", new FileAttribute[0]);
            Path filePath = Files.createFile(tempDir.resolve(filename), new FileAttribute[0]);
            file = filePath.toFile();
            tempDir.toFile().deleteOnExit();
            file.deleteOnExit();
        } else {
            file = Files.createTempFile("download-", "", new FileAttribute[0]).toFile();
            file.deleteOnExit();
        }
        return file;
    }

    public Map<String, String> getEntityExtInfo(@Nonnull String entityId, @Nonnull String entityType) throws ApiException {
        return this.getEntityExtInfo(entityId, entityType, null);
    }

    public Map<String, String> getEntityExtInfo(@Nonnull String entityId, @Nonnull String entityType, Map<String, String> headers) throws ApiException {
        ApiResponse<Map<String, String>> localVarResponse = this.getEntityExtInfoWithHttpInfo(entityId, entityType, headers);
        return localVarResponse.getData();
    }

    public ApiResponse<Map<String, String>> getEntityExtInfoWithHttpInfo(@Nonnull String entityId, @Nonnull String entityType) throws ApiException {
        return this.getEntityExtInfoWithHttpInfo(entityId, entityType, null);
    }

    public ApiResponse<Map<String, String>> getEntityExtInfoWithHttpInfo(@Nonnull String entityId, @Nonnull String entityType, Map<String, String> headers) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getEntityExtInfoRequestBuilder(entityId, entityType, headers);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getEntityExtInfo", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            Map responseValue = responseBody.isBlank() ? null : (Map)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<Map<String, String>>(){});
            localVarResponse.body().close();
            return new ApiResponse<Map<String, String>>(localVarResponse.statusCode(), localVarResponse.headers().map(), responseValue);
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getEntityExtInfoRequestBuilder(@Nonnull String entityId, @Nonnull String entityType, Map<String, String> headers) throws ApiException {
        if (entityId == null) {
            throw new ApiException(400, "Missing the required parameter 'entityId' when calling getEntityExtInfo");
        }
        if (entityType == null) {
            throw new ApiException(400, "Missing the required parameter 'entityType' when calling getEntityExtInfo");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/api/v1/management/entity/{entityType}/{entityId}/extinfo".replace("{entityId}", ApiClient.urlEncode(entityId.toString())).replace("{entityType}", ApiClient.urlEncode(entityType.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public void removeEntityExtInfoKeyValue(@Nonnull String entityId, @Nonnull String entityType, @Nullable String key) throws ApiException {
        this.removeEntityExtInfoKeyValue(entityId, entityType, key, null);
    }

    public void removeEntityExtInfoKeyValue(@Nonnull String entityId, @Nonnull String entityType, @Nullable String key, Map<String, String> headers) throws ApiException {
        this.removeEntityExtInfoKeyValueWithHttpInfo(entityId, entityType, key, headers);
    }

    public ApiResponse<Void> removeEntityExtInfoKeyValueWithHttpInfo(@Nonnull String entityId, @Nonnull String entityType, @Nullable String key) throws ApiException {
        return this.removeEntityExtInfoKeyValueWithHttpInfo(entityId, entityType, key, null);
    }

    public ApiResponse<Void> removeEntityExtInfoKeyValueWithHttpInfo(@Nonnull String entityId, @Nonnull String entityType, @Nullable String key, Map<String, String> headers) throws ApiException {
        ApiResponse<Object> apiResponse;
        HttpRequest.Builder localVarRequestBuilder = this.removeEntityExtInfoKeyValueRequestBuilder(entityId, entityType, key, headers);
        HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
        if (this.memberVarResponseInterceptor != null) {
            this.memberVarResponseInterceptor.accept(localVarResponse);
        }
        try {
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("removeEntityExtInfoKeyValue", localVarResponse);
            }
            apiResponse = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
        }
        catch (Throwable throwable) {
            try {
                while (localVarResponse.body().read() != -1) {
                }
                localVarResponse.body().close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ApiException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ApiException(e);
            }
        }
        while (localVarResponse.body().read() != -1) {
        }
        localVarResponse.body().close();
        return apiResponse;
    }

    private HttpRequest.Builder removeEntityExtInfoKeyValueRequestBuilder(@Nonnull String entityId, @Nonnull String entityType, @Nullable String key, Map<String, String> headers) throws ApiException {
        if (entityId == null) {
            throw new ApiException(400, "Missing the required parameter 'entityId' when calling removeEntityExtInfoKeyValue");
        }
        if (entityType == null) {
            throw new ApiException(400, "Missing the required parameter 'entityType' when calling removeEntityExtInfoKeyValue");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/api/v1/management/entity/{entityType}/{entityId}/extinfo".replace("{entityId}", ApiClient.urlEncode(entityId.toString())).replace("{entityType}", ApiClient.urlEncode(entityType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "key";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("key", key));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> {
                StringJoiner stringJoiner2 = queryJoiner.add(p.getName() + "=" + p.getValue());
            });
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("DELETE", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public void setMultipleEntityExtInfoKeyValue(@Nonnull String entityId, @Nonnull String entityType, @Nonnull Map<String, String> requestBody) throws ApiException {
        this.setMultipleEntityExtInfoKeyValue(entityId, entityType, requestBody, null);
    }

    public void setMultipleEntityExtInfoKeyValue(@Nonnull String entityId, @Nonnull String entityType, @Nonnull Map<String, String> requestBody, Map<String, String> headers) throws ApiException {
        this.setMultipleEntityExtInfoKeyValueWithHttpInfo(entityId, entityType, requestBody, headers);
    }

    public ApiResponse<Void> setMultipleEntityExtInfoKeyValueWithHttpInfo(@Nonnull String entityId, @Nonnull String entityType, @Nonnull Map<String, String> requestBody) throws ApiException {
        return this.setMultipleEntityExtInfoKeyValueWithHttpInfo(entityId, entityType, requestBody, null);
    }

    public ApiResponse<Void> setMultipleEntityExtInfoKeyValueWithHttpInfo(@Nonnull String entityId, @Nonnull String entityType, @Nonnull Map<String, String> requestBody, Map<String, String> headers) throws ApiException {
        ApiResponse<Object> apiResponse;
        HttpRequest.Builder localVarRequestBuilder = this.setMultipleEntityExtInfoKeyValueRequestBuilder(entityId, entityType, requestBody, headers);
        HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
        if (this.memberVarResponseInterceptor != null) {
            this.memberVarResponseInterceptor.accept(localVarResponse);
        }
        try {
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("setMultipleEntityExtInfoKeyValue", localVarResponse);
            }
            apiResponse = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
        }
        catch (Throwable throwable) {
            try {
                while (localVarResponse.body().read() != -1) {
                }
                localVarResponse.body().close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ApiException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ApiException(e);
            }
        }
        while (localVarResponse.body().read() != -1) {
        }
        localVarResponse.body().close();
        return apiResponse;
    }

    private HttpRequest.Builder setMultipleEntityExtInfoKeyValueRequestBuilder(@Nonnull String entityId, @Nonnull String entityType, @Nonnull Map<String, String> requestBody, Map<String, String> headers) throws ApiException {
        if (entityId == null) {
            throw new ApiException(400, "Missing the required parameter 'entityId' when calling setMultipleEntityExtInfoKeyValue");
        }
        if (entityType == null) {
            throw new ApiException(400, "Missing the required parameter 'entityType' when calling setMultipleEntityExtInfoKeyValue");
        }
        if (requestBody == null) {
            throw new ApiException(400, "Missing the required parameter 'requestBody' when calling setMultipleEntityExtInfoKeyValue");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/api/v1/management/entity/{entityType}/{entityId}/extinfo".replace("{entityId}", ApiClient.urlEncode(entityId.toString())).replace("{entityType}", ApiClient.urlEncode(entityType.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes(requestBody);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public void setSingleEntityExtInfoKeyValue(@Nonnull String entityId, @Nonnull String entityType, @Nullable String key, @Nullable String value) throws ApiException {
        this.setSingleEntityExtInfoKeyValue(entityId, entityType, key, value, null);
    }

    public void setSingleEntityExtInfoKeyValue(@Nonnull String entityId, @Nonnull String entityType, @Nullable String key, @Nullable String value, Map<String, String> headers) throws ApiException {
        this.setSingleEntityExtInfoKeyValueWithHttpInfo(entityId, entityType, key, value, headers);
    }

    public ApiResponse<Void> setSingleEntityExtInfoKeyValueWithHttpInfo(@Nonnull String entityId, @Nonnull String entityType, @Nullable String key, @Nullable String value) throws ApiException {
        return this.setSingleEntityExtInfoKeyValueWithHttpInfo(entityId, entityType, key, value, null);
    }

    public ApiResponse<Void> setSingleEntityExtInfoKeyValueWithHttpInfo(@Nonnull String entityId, @Nonnull String entityType, @Nullable String key, @Nullable String value, Map<String, String> headers) throws ApiException {
        ApiResponse<Object> apiResponse;
        HttpRequest.Builder localVarRequestBuilder = this.setSingleEntityExtInfoKeyValueRequestBuilder(entityId, entityType, key, value, headers);
        HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
        if (this.memberVarResponseInterceptor != null) {
            this.memberVarResponseInterceptor.accept(localVarResponse);
        }
        try {
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("setSingleEntityExtInfoKeyValue", localVarResponse);
            }
            apiResponse = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
        }
        catch (Throwable throwable) {
            try {
                while (localVarResponse.body().read() != -1) {
                }
                localVarResponse.body().close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ApiException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ApiException(e);
            }
        }
        while (localVarResponse.body().read() != -1) {
        }
        localVarResponse.body().close();
        return apiResponse;
    }

    private HttpRequest.Builder setSingleEntityExtInfoKeyValueRequestBuilder(@Nonnull String entityId, @Nonnull String entityType, @Nullable String key, @Nullable String value, Map<String, String> headers) throws ApiException {
        if (entityId == null) {
            throw new ApiException(400, "Missing the required parameter 'entityId' when calling setSingleEntityExtInfoKeyValue");
        }
        if (entityType == null) {
            throw new ApiException(400, "Missing the required parameter 'entityType' when calling setSingleEntityExtInfoKeyValue");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/api/v1/management/entity/{entityType}/{entityId}/extinfo".replace("{entityId}", ApiClient.urlEncode(entityId.toString())).replace("{entityType}", ApiClient.urlEncode(entityType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "key";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("key", key));
        localVarQueryParameterBaseName = "value";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("value", value));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> {
                StringJoiner stringJoiner2 = queryJoiner.add(p.getName() + "=" + p.getValue());
            });
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    private static class HttpRequestBuilderExtensions {
        private HttpRequestBuilderExtensions() {
        }

        static HttpRequest.Builder withAdditionalHeaders(HttpRequest.Builder builder, Map<String, String> headers) {
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    builder.header(entry.getKey(), entry.getValue());
                }
            }
            return builder;
        }
    }
}

