/*
 * Decompiled with CFR 0.152.
 */
package ch.myelexis.server.api;

import ch.myelexis.server.client.ApiClient;
import ch.myelexis.server.client.ApiException;
import ch.myelexis.server.client.ApiResponse;
import ch.myelexis.server.client.Configuration;
import ch.myelexis.server.client.Pair;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfigApi {
    private final HttpClient memberVarHttpClient;
    private final ObjectMapper memberVarObjectMapper;
    private final String memberVarBaseUri;
    private final Consumer<HttpRequest.Builder> memberVarInterceptor;
    private final Duration memberVarReadTimeout;
    private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
    private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

    public ConfigApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ConfigApi(ApiClient apiClient) {
        this.memberVarHttpClient = apiClient.getHttpClient();
        this.memberVarObjectMapper = apiClient.getObjectMapper();
        this.memberVarBaseUri = apiClient.getBaseUri();
        this.memberVarInterceptor = apiClient.getRequestInterceptor();
        this.memberVarReadTimeout = apiClient.getReadTimeout();
        this.memberVarResponseInterceptor = apiClient.getResponseInterceptor();
        this.memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
    }

    protected ApiException getApiException(String operationId, HttpResponse<InputStream> response) throws IOException {
        String body = response.body() == null ? null : new String(response.body().readAllBytes());
        String message = this.formatExceptionMessage(operationId, response.statusCode(), body);
        return new ApiException(response.statusCode(), message, response.headers(), body);
    }

    private String formatExceptionMessage(String operationId, int statusCode, String body) {
        if (body == null || body.isEmpty()) {
            body = "[no body]";
        }
        return operationId + " call failed with: " + statusCode + " - " + body;
    }

    public File downloadFileFromResponse(HttpResponse<InputStream> response) throws ApiException {
        try {
            File file = this.prepareDownloadFile(response);
            Files.copy(response.body(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return file;
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    private File prepareDownloadFile(HttpResponse<InputStream> response) throws IOException {
        Pattern pattern;
        Matcher matcher;
        String filename = null;
        Optional<String> contentDisposition = response.headers().firstValue("Content-Disposition");
        if (contentDisposition.isPresent() && !"".equals(contentDisposition.get()) && (matcher = (pattern = Pattern.compile("filename=['\"]?([^'\"\\s]+)['\"]?")).matcher(contentDisposition.get())).find()) {
            filename = matcher.group(1);
        }
        File file = null;
        if (filename != null) {
            Path tempDir = Files.createTempDirectory("swagger-gen-native", new FileAttribute[0]);
            Path filePath = Files.createFile(tempDir.resolve(filename), new FileAttribute[0]);
            file = filePath.toFile();
            tempDir.toFile().deleteOnExit();
            file.deleteOnExit();
        } else {
            file = Files.createTempFile("download-", "", new FileAttribute[0]).toFile();
            file.deleteOnExit();
        }
        return file;
    }

    public void deleteUserContactConfigurationEntryByKey(@Nonnull String key) throws ApiException {
        this.deleteUserContactConfigurationEntryByKey(key, null);
    }

    public void deleteUserContactConfigurationEntryByKey(@Nonnull String key, Map<String, String> headers) throws ApiException {
        this.deleteUserContactConfigurationEntryByKeyWithHttpInfo(key, headers);
    }

    public ApiResponse<Void> deleteUserContactConfigurationEntryByKeyWithHttpInfo(@Nonnull String key) throws ApiException {
        return this.deleteUserContactConfigurationEntryByKeyWithHttpInfo(key, null);
    }

    public ApiResponse<Void> deleteUserContactConfigurationEntryByKeyWithHttpInfo(@Nonnull String key, Map<String, String> headers) throws ApiException {
        ApiResponse<Object> apiResponse;
        HttpRequest.Builder localVarRequestBuilder = this.deleteUserContactConfigurationEntryByKeyRequestBuilder(key, headers);
        HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
        if (this.memberVarResponseInterceptor != null) {
            this.memberVarResponseInterceptor.accept(localVarResponse);
        }
        try {
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("deleteUserContactConfigurationEntryByKey", localVarResponse);
            }
            apiResponse = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
        }
        catch (Throwable throwable) {
            try {
                while (localVarResponse.body().read() != -1) {
                }
                localVarResponse.body().close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ApiException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ApiException(e);
            }
        }
        while (localVarResponse.body().read() != -1) {
        }
        localVarResponse.body().close();
        return apiResponse;
    }

    private HttpRequest.Builder deleteUserContactConfigurationEntryByKeyRequestBuilder(@Nonnull String key, Map<String, String> headers) throws ApiException {
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling deleteUserContactConfigurationEntryByKey");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/api/v1/user/config/contact";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "key";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("key", key));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> {
                StringJoiner stringJoiner2 = queryJoiner.add(p.getName() + "=" + p.getValue());
            });
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("DELETE", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public List<String> findGlobalConfigurationDirectSubnodeKeysForGivenKey(@Nonnull String key) throws ApiException {
        return this.findGlobalConfigurationDirectSubnodeKeysForGivenKey(key, null);
    }

    public List<String> findGlobalConfigurationDirectSubnodeKeysForGivenKey(@Nonnull String key, Map<String, String> headers) throws ApiException {
        ApiResponse<List<String>> localVarResponse = this.findGlobalConfigurationDirectSubnodeKeysForGivenKeyWithHttpInfo(key, headers);
        return localVarResponse.getData();
    }

    public ApiResponse<List<String>> findGlobalConfigurationDirectSubnodeKeysForGivenKeyWithHttpInfo(@Nonnull String key) throws ApiException {
        return this.findGlobalConfigurationDirectSubnodeKeysForGivenKeyWithHttpInfo(key, null);
    }

    public ApiResponse<List<String>> findGlobalConfigurationDirectSubnodeKeysForGivenKeyWithHttpInfo(@Nonnull String key, Map<String, String> headers) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.findGlobalConfigurationDirectSubnodeKeysForGivenKeyRequestBuilder(key, headers);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("findGlobalConfigurationDirectSubnodeKeysForGivenKey", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            List responseValue = responseBody.isBlank() ? null : (List)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<List<String>>(){});
            localVarResponse.body().close();
            return new ApiResponse<List<String>>(localVarResponse.statusCode(), localVarResponse.headers().map(), responseValue);
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder findGlobalConfigurationDirectSubnodeKeysForGivenKeyRequestBuilder(@Nonnull String key, Map<String, String> headers) throws ApiException {
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling findGlobalConfigurationDirectSubnodeKeysForGivenKey");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/api/v1/user/config/global-subnodekeys";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "key";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("key", key));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> {
                StringJoiner stringJoiner2 = queryJoiner.add(p.getName() + "=" + p.getValue());
            });
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public Map<String, String> getContactConfigurationEntries(@Nonnull String contactid) throws ApiException {
        return this.getContactConfigurationEntries(contactid, null);
    }

    public Map<String, String> getContactConfigurationEntries(@Nonnull String contactid, Map<String, String> headers) throws ApiException {
        ApiResponse<Map<String, String>> localVarResponse = this.getContactConfigurationEntriesWithHttpInfo(contactid, headers);
        return localVarResponse.getData();
    }

    public ApiResponse<Map<String, String>> getContactConfigurationEntriesWithHttpInfo(@Nonnull String contactid) throws ApiException {
        return this.getContactConfigurationEntriesWithHttpInfo(contactid, null);
    }

    public ApiResponse<Map<String, String>> getContactConfigurationEntriesWithHttpInfo(@Nonnull String contactid, Map<String, String> headers) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getContactConfigurationEntriesRequestBuilder(contactid, headers);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getContactConfigurationEntries", localVarResponse);
            }
            if (localVarResponse.body() == null) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            String responseBody = new String(localVarResponse.body().readAllBytes());
            Map responseValue = responseBody.isBlank() ? null : (Map)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<Map<String, String>>(){});
            localVarResponse.body().close();
            return new ApiResponse<Map<String, String>>(localVarResponse.statusCode(), localVarResponse.headers().map(), responseValue);
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getContactConfigurationEntriesRequestBuilder(@Nonnull String contactid, Map<String, String> headers) throws ApiException {
        if (contactid == null) {
            throw new ApiException(400, "Missing the required parameter 'contactid' when calling getContactConfigurationEntries");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/api/v1/management/config/contact/{contactid}".replace("{contactid}", ApiClient.urlEncode(contactid.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public void getGlobalConfiguration(@Nullable String format) throws ApiException {
        this.getGlobalConfiguration(format, null);
    }

    public void getGlobalConfiguration(@Nullable String format, Map<String, String> headers) throws ApiException {
        this.getGlobalConfigurationWithHttpInfo(format, headers);
    }

    public ApiResponse<Void> getGlobalConfigurationWithHttpInfo(@Nullable String format) throws ApiException {
        return this.getGlobalConfigurationWithHttpInfo(format, null);
    }

    public ApiResponse<Void> getGlobalConfigurationWithHttpInfo(@Nullable String format, Map<String, String> headers) throws ApiException {
        ApiResponse<Object> apiResponse;
        HttpRequest.Builder localVarRequestBuilder = this.getGlobalConfigurationRequestBuilder(format, headers);
        HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
        if (this.memberVarResponseInterceptor != null) {
            this.memberVarResponseInterceptor.accept(localVarResponse);
        }
        try {
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getGlobalConfiguration", localVarResponse);
            }
            apiResponse = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
        }
        catch (Throwable throwable) {
            try {
                while (localVarResponse.body().read() != -1) {
                }
                localVarResponse.body().close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ApiException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ApiException(e);
            }
        }
        while (localVarResponse.body().read() != -1) {
        }
        localVarResponse.body().close();
        return apiResponse;
    }

    private HttpRequest.Builder getGlobalConfigurationRequestBuilder(@Nullable String format, Map<String, String> headers) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/api/v1/management/config/global";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "format";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("format", format));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> {
                StringJoiner stringJoiner2 = queryJoiner.add(p.getName() + "=" + p.getValue());
            });
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public String getGlobalConfigurationValueByKey(@Nonnull String key) throws ApiException {
        return this.getGlobalConfigurationValueByKey(key, null);
    }

    public String getGlobalConfigurationValueByKey(@Nonnull String key, Map<String, String> headers) throws ApiException {
        ApiResponse<String> localVarResponse = this.getGlobalConfigurationValueByKeyWithHttpInfo(key, headers);
        return localVarResponse.getData();
    }

    public ApiResponse<String> getGlobalConfigurationValueByKeyWithHttpInfo(@Nonnull String key) throws ApiException {
        return this.getGlobalConfigurationValueByKeyWithHttpInfo(key, null);
    }

    public ApiResponse<String> getGlobalConfigurationValueByKeyWithHttpInfo(@Nonnull String key, Map<String, String> headers) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getGlobalConfigurationValueByKeyRequestBuilder(key, headers);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getGlobalConfigurationValueByKey", localVarResponse);
            }
            if (204 == localVarResponse.statusCode()) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            if (localVarResponse.headers().map().containsKey("Content-Type") && "text/plain".equalsIgnoreCase(localVarResponse.headers().map().get("Content-Type").get(0).split(";")[0].trim())) {
                Scanner s = new Scanner(localVarResponse.body()).useDelimiter("\\A");
                String responseBodyText = s.hasNext() ? s.next() : "";
                return new ApiResponse<String>(localVarResponse.statusCode(), localVarResponse.headers().map(), responseBodyText);
            }
            throw new RuntimeException("Error! The response Content-Type is supposed to be `text/plain` but it's not: " + String.valueOf(localVarResponse));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getGlobalConfigurationValueByKeyRequestBuilder(@Nonnull String key, Map<String, String> headers) throws ApiException {
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling getGlobalConfigurationValueByKey");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/api/v1/user/config/global";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "key";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("key", key));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> {
                StringJoiner stringJoiner2 = queryJoiner.add(p.getName() + "=" + p.getValue());
            });
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "text/plain");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public void getUserContactConfigurationAsTree(@Nullable String userContactId, @Nullable String userId) throws ApiException {
        this.getUserContactConfigurationAsTree(userContactId, userId, null);
    }

    public void getUserContactConfigurationAsTree(@Nullable String userContactId, @Nullable String userId, Map<String, String> headers) throws ApiException {
        this.getUserContactConfigurationAsTreeWithHttpInfo(userContactId, userId, headers);
    }

    public ApiResponse<Void> getUserContactConfigurationAsTreeWithHttpInfo(@Nullable String userContactId, @Nullable String userId) throws ApiException {
        return this.getUserContactConfigurationAsTreeWithHttpInfo(userContactId, userId, null);
    }

    public ApiResponse<Void> getUserContactConfigurationAsTreeWithHttpInfo(@Nullable String userContactId, @Nullable String userId, Map<String, String> headers) throws ApiException {
        ApiResponse<Object> apiResponse;
        HttpRequest.Builder localVarRequestBuilder = this.getUserContactConfigurationAsTreeRequestBuilder(userContactId, userId, headers);
        HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
        if (this.memberVarResponseInterceptor != null) {
            this.memberVarResponseInterceptor.accept(localVarResponse);
        }
        try {
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getUserContactConfigurationAsTree", localVarResponse);
            }
            apiResponse = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
        }
        catch (Throwable throwable) {
            try {
                while (localVarResponse.body().read() != -1) {
                }
                localVarResponse.body().close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ApiException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ApiException(e);
            }
        }
        while (localVarResponse.body().read() != -1) {
        }
        localVarResponse.body().close();
        return apiResponse;
    }

    private HttpRequest.Builder getUserContactConfigurationAsTreeRequestBuilder(@Nullable String userContactId, @Nullable String userId, Map<String, String> headers) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/api/v1/management/config/usercontact";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "user-contact-id";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("user-contact-id", userContactId));
        localVarQueryParameterBaseName = "user-id";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("user-id", userId));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> {
                StringJoiner stringJoiner2 = queryJoiner.add(p.getName() + "=" + p.getValue());
            });
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public String getUserContactConfigurationValueByKey(@Nonnull String key, @Nullable String contactId) throws ApiException {
        return this.getUserContactConfigurationValueByKey(key, contactId, null);
    }

    public String getUserContactConfigurationValueByKey(@Nonnull String key, @Nullable String contactId, Map<String, String> headers) throws ApiException {
        ApiResponse<String> localVarResponse = this.getUserContactConfigurationValueByKeyWithHttpInfo(key, contactId, headers);
        return localVarResponse.getData();
    }

    public ApiResponse<String> getUserContactConfigurationValueByKeyWithHttpInfo(@Nonnull String key, @Nullable String contactId) throws ApiException {
        return this.getUserContactConfigurationValueByKeyWithHttpInfo(key, contactId, null);
    }

    public ApiResponse<String> getUserContactConfigurationValueByKeyWithHttpInfo(@Nonnull String key, @Nullable String contactId, Map<String, String> headers) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getUserContactConfigurationValueByKeyRequestBuilder(key, contactId, headers);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getUserContactConfigurationValueByKey", localVarResponse);
            }
            if (204 == localVarResponse.statusCode()) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            if (localVarResponse.headers().map().containsKey("Content-Type") && "text/plain".equalsIgnoreCase(localVarResponse.headers().map().get("Content-Type").get(0).split(";")[0].trim())) {
                Scanner s = new Scanner(localVarResponse.body()).useDelimiter("\\A");
                String responseBodyText = s.hasNext() ? s.next() : "";
                return new ApiResponse<String>(localVarResponse.statusCode(), localVarResponse.headers().map(), responseBodyText);
            }
            throw new RuntimeException("Error! The response Content-Type is supposed to be `text/plain` but it's not: " + String.valueOf(localVarResponse));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getUserContactConfigurationValueByKeyRequestBuilder(@Nonnull String key, @Nullable String contactId, Map<String, String> headers) throws ApiException {
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling getUserContactConfigurationValueByKey");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/api/v1/user/config/contact";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "contact-id";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("contact-id", contactId));
        localVarQueryParameterBaseName = "key";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("key", key));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> {
                StringJoiner stringJoiner2 = queryJoiner.add(p.getName() + "=" + p.getValue());
            });
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "text/plain");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public void setContactConfiguration(@Nonnull String contactid, @Nonnull Map<String, String> requestBody) throws ApiException {
        this.setContactConfiguration(contactid, requestBody, null);
    }

    public void setContactConfiguration(@Nonnull String contactid, @Nonnull Map<String, String> requestBody, Map<String, String> headers) throws ApiException {
        this.setContactConfigurationWithHttpInfo(contactid, requestBody, headers);
    }

    public ApiResponse<Void> setContactConfigurationWithHttpInfo(@Nonnull String contactid, @Nonnull Map<String, String> requestBody) throws ApiException {
        return this.setContactConfigurationWithHttpInfo(contactid, requestBody, null);
    }

    public ApiResponse<Void> setContactConfigurationWithHttpInfo(@Nonnull String contactid, @Nonnull Map<String, String> requestBody, Map<String, String> headers) throws ApiException {
        ApiResponse<Object> apiResponse;
        HttpRequest.Builder localVarRequestBuilder = this.setContactConfigurationRequestBuilder(contactid, requestBody, headers);
        HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
        if (this.memberVarResponseInterceptor != null) {
            this.memberVarResponseInterceptor.accept(localVarResponse);
        }
        try {
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("setContactConfiguration", localVarResponse);
            }
            apiResponse = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
        }
        catch (Throwable throwable) {
            try {
                while (localVarResponse.body().read() != -1) {
                }
                localVarResponse.body().close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ApiException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ApiException(e);
            }
        }
        while (localVarResponse.body().read() != -1) {
        }
        localVarResponse.body().close();
        return apiResponse;
    }

    private HttpRequest.Builder setContactConfigurationRequestBuilder(@Nonnull String contactid, @Nonnull Map<String, String> requestBody, Map<String, String> headers) throws ApiException {
        if (contactid == null) {
            throw new ApiException(400, "Missing the required parameter 'contactid' when calling setContactConfiguration");
        }
        if (requestBody == null) {
            throw new ApiException(400, "Missing the required parameter 'requestBody' when calling setContactConfiguration");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/api/v1/management/config/contact/{contactid}".replace("{contactid}", ApiClient.urlEncode(contactid.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes(requestBody);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public String setGlobalConfigurationValueByKey(@Nonnull String key, @Nonnull String body) throws ApiException {
        return this.setGlobalConfigurationValueByKey(key, body, null);
    }

    public String setGlobalConfigurationValueByKey(@Nonnull String key, @Nonnull String body, Map<String, String> headers) throws ApiException {
        ApiResponse<String> localVarResponse = this.setGlobalConfigurationValueByKeyWithHttpInfo(key, body, headers);
        return localVarResponse.getData();
    }

    public ApiResponse<String> setGlobalConfigurationValueByKeyWithHttpInfo(@Nonnull String key, @Nonnull String body) throws ApiException {
        return this.setGlobalConfigurationValueByKeyWithHttpInfo(key, body, null);
    }

    public ApiResponse<String> setGlobalConfigurationValueByKeyWithHttpInfo(@Nonnull String key, @Nonnull String body, Map<String, String> headers) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.setGlobalConfigurationValueByKeyRequestBuilder(key, body, headers);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("setGlobalConfigurationValueByKey", localVarResponse);
            }
            if (204 == localVarResponse.statusCode()) {
                return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
            }
            if (localVarResponse.headers().map().containsKey("Content-Type") && "text/plain".equalsIgnoreCase(localVarResponse.headers().map().get("Content-Type").get(0).split(";")[0].trim())) {
                Scanner s = new Scanner(localVarResponse.body()).useDelimiter("\\A");
                String responseBodyText = s.hasNext() ? s.next() : "";
                return new ApiResponse<String>(localVarResponse.statusCode(), localVarResponse.headers().map(), responseBodyText);
            }
            throw new RuntimeException("Error! The response Content-Type is supposed to be `text/plain` but it's not: " + String.valueOf(localVarResponse));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder setGlobalConfigurationValueByKeyRequestBuilder(@Nonnull String key, @Nonnull String body, Map<String, String> headers) throws ApiException {
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling setGlobalConfigurationValueByKey");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling setGlobalConfigurationValueByKey");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/api/v1/user/config/global";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "key";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("key", key));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> {
                StringJoiner stringJoiner2 = queryJoiner.add(p.getName() + "=" + p.getValue());
            });
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Content-Type", "text/plain");
        localVarRequestBuilder.header("Accept", "text/plain");
        localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofString(body));
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public void setUserContactConfigurationValueByKey(@Nonnull String key, @Nonnull String body) throws ApiException {
        this.setUserContactConfigurationValueByKey(key, body, null);
    }

    public void setUserContactConfigurationValueByKey(@Nonnull String key, @Nonnull String body, Map<String, String> headers) throws ApiException {
        this.setUserContactConfigurationValueByKeyWithHttpInfo(key, body, headers);
    }

    public ApiResponse<Void> setUserContactConfigurationValueByKeyWithHttpInfo(@Nonnull String key, @Nonnull String body) throws ApiException {
        return this.setUserContactConfigurationValueByKeyWithHttpInfo(key, body, null);
    }

    public ApiResponse<Void> setUserContactConfigurationValueByKeyWithHttpInfo(@Nonnull String key, @Nonnull String body, Map<String, String> headers) throws ApiException {
        ApiResponse<Object> apiResponse;
        HttpRequest.Builder localVarRequestBuilder = this.setUserContactConfigurationValueByKeyRequestBuilder(key, body, headers);
        HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
        if (this.memberVarResponseInterceptor != null) {
            this.memberVarResponseInterceptor.accept(localVarResponse);
        }
        try {
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("setUserContactConfigurationValueByKey", localVarResponse);
            }
            apiResponse = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
        }
        catch (Throwable throwable) {
            try {
                while (localVarResponse.body().read() != -1) {
                }
                localVarResponse.body().close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ApiException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ApiException(e);
            }
        }
        while (localVarResponse.body().read() != -1) {
        }
        localVarResponse.body().close();
        return apiResponse;
    }

    private HttpRequest.Builder setUserContactConfigurationValueByKeyRequestBuilder(@Nonnull String key, @Nonnull String body, Map<String, String> headers) throws ApiException {
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling setUserContactConfigurationValueByKey");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling setUserContactConfigurationValueByKey");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/api/v1/user/config/contact";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "key";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("key", key));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> {
                StringJoiner stringJoiner2 = queryJoiner.add(p.getName() + "=" + p.getValue());
            });
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Content-Type", "text/plain");
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofString(body));
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public void updateGlobalConfigByJson(@Nonnull String body) throws ApiException {
        this.updateGlobalConfigByJson(body, null);
    }

    public void updateGlobalConfigByJson(@Nonnull String body, Map<String, String> headers) throws ApiException {
        this.updateGlobalConfigByJsonWithHttpInfo(body, headers);
    }

    public ApiResponse<Void> updateGlobalConfigByJsonWithHttpInfo(@Nonnull String body) throws ApiException {
        return this.updateGlobalConfigByJsonWithHttpInfo(body, null);
    }

    public ApiResponse<Void> updateGlobalConfigByJsonWithHttpInfo(@Nonnull String body, Map<String, String> headers) throws ApiException {
        ApiResponse<Object> apiResponse;
        HttpRequest.Builder localVarRequestBuilder = this.updateGlobalConfigByJsonRequestBuilder(body, headers);
        HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
        if (this.memberVarResponseInterceptor != null) {
            this.memberVarResponseInterceptor.accept(localVarResponse);
        }
        try {
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("updateGlobalConfigByJson", localVarResponse);
            }
            apiResponse = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
        }
        catch (Throwable throwable) {
            try {
                while (localVarResponse.body().read() != -1) {
                }
                localVarResponse.body().close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ApiException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ApiException(e);
            }
        }
        while (localVarResponse.body().read() != -1) {
        }
        localVarResponse.body().close();
        return apiResponse;
    }

    private HttpRequest.Builder updateGlobalConfigByJsonRequestBuilder(@Nonnull String body, Map<String, String> headers) throws ApiException {
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateGlobalConfigByJson");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/api/v1/management/config/global";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofString(body));
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    private static class HttpRequestBuilderExtensions {
        private HttpRequestBuilderExtensions() {
        }

        static HttpRequest.Builder withAdditionalHeaders(HttpRequest.Builder builder, Map<String, String> headers) {
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    builder.header(entry.getKey(), entry.getValue());
                }
            }
            return builder;
        }
    }
}

