/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.contacts.views.filter;

import ch.elexis.core.model.IContact;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.PlatformUI;

public class KontaktAnzeigeTypViewerFilter
extends ViewerFilter {
    private static Viewer viewer;
    private static boolean showPerson;
    private static boolean showOrganisation;
    private static boolean showPatient;
    private static boolean showMandant;
    private static boolean showAnwender;
    private static boolean showDeleted;

    static {
        showPerson = false;
        showOrganisation = false;
        showPatient = true;
        showMandant = false;
        showAnwender = false;
        showDeleted = false;
    }

    public KontaktAnzeigeTypViewerFilter(Viewer viewer) {
        KontaktAnzeigeTypViewerFilter.viewer = viewer;
        PlatformUI.getPreferenceStore().setDefault(KontaktAnzeigeTypViewerFilter.class.getName() + ".showPatient", true);
        showPerson = PlatformUI.getPreferenceStore().getBoolean(KontaktAnzeigeTypViewerFilter.class.getName() + ".showPerson");
        showPatient = PlatformUI.getPreferenceStore().getBoolean(KontaktAnzeigeTypViewerFilter.class.getName() + ".showPatient");
        showOrganisation = PlatformUI.getPreferenceStore().getBoolean(KontaktAnzeigeTypViewerFilter.class.getName() + ".showOrganisation");
        showMandant = PlatformUI.getPreferenceStore().getBoolean(KontaktAnzeigeTypViewerFilter.class.getName() + ".showMandant");
        showAnwender = PlatformUI.getPreferenceStore().getBoolean(KontaktAnzeigeTypViewerFilter.class.getName() + ".showAnwender");
        showDeleted = PlatformUI.getPreferenceStore().getBoolean(KontaktAnzeigeTypViewerFilter.class.getName() + ".showDeleted");
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        IContact contact = (IContact)element;
        if (showDeleted && contact.isDeleted()) {
            return true;
        }
        if (contact.isOrganization() && showOrganisation) {
            return true;
        }
        if (contact.isPerson()) {
            if (showPerson) {
                return true;
            }
            if (contact.isPatient() && !contact.isDeleted() && showPatient) {
                return true;
            }
            if (contact.isUser() && !contact.isDeleted() && showAnwender) {
                return true;
            }
            if (contact.isMandator() && !contact.isDeleted() && showMandant) {
                return true;
            }
        }
        return false;
    }

    public static void refreshViewer() {
        viewer.getControl().setRedraw(false);
        viewer.refresh();
        if (showAnwender || showDeleted || showMandant || showOrganisation || !showPatient) {
            // empty if block
        }
        viewer.getControl().setRedraw(true);
    }

    public static boolean isShowPerson() {
        return showPerson;
    }

    public static void setShowPerson(boolean showPerson) {
        KontaktAnzeigeTypViewerFilter.showPerson = showPerson;
        PlatformUI.getPreferenceStore().setValue(KontaktAnzeigeTypViewerFilter.class.getName() + ".showPerson", showPerson);
        KontaktAnzeigeTypViewerFilter.refreshViewer();
    }

    public static boolean isShowOrganisation() {
        return showOrganisation;
    }

    public static void setShowOrganisation(boolean showOrganisation) {
        KontaktAnzeigeTypViewerFilter.showOrganisation = showOrganisation;
        PlatformUI.getPreferenceStore().setValue(KontaktAnzeigeTypViewerFilter.class.getName() + ".showOrganisation", showOrganisation);
        KontaktAnzeigeTypViewerFilter.refreshViewer();
    }

    public static boolean isShowPatient() {
        return showPatient;
    }

    public static void setShowPatient(boolean showPatient) {
        KontaktAnzeigeTypViewerFilter.showPatient = showPatient;
        PlatformUI.getPreferenceStore().setValue(KontaktAnzeigeTypViewerFilter.class.getName() + ".showPatient", showPatient);
        KontaktAnzeigeTypViewerFilter.refreshViewer();
    }

    public static boolean isShowMandant() {
        return showMandant;
    }

    public static void setShowMandant(boolean showMandant) {
        KontaktAnzeigeTypViewerFilter.showMandant = showMandant;
        PlatformUI.getPreferenceStore().setValue(KontaktAnzeigeTypViewerFilter.class.getName() + ".showMandant", showMandant);
        KontaktAnzeigeTypViewerFilter.refreshViewer();
    }

    public static boolean isShowAnwender() {
        return showAnwender;
    }

    public static void setShowAnwender(boolean showAnwender) {
        KontaktAnzeigeTypViewerFilter.showAnwender = showAnwender;
        PlatformUI.getPreferenceStore().setValue(KontaktAnzeigeTypViewerFilter.class.getName() + ".showAnwender", showAnwender);
        KontaktAnzeigeTypViewerFilter.refreshViewer();
    }

    public static boolean isShowDeleted() {
        return showDeleted;
    }

    public static void setShowDeleted(boolean showDeleted) {
        KontaktAnzeigeTypViewerFilter.showDeleted = showDeleted;
        PlatformUI.getPreferenceStore().setValue(KontaktAnzeigeTypViewerFilter.class.getName() + ".showDeleted", showDeleted);
        KontaktAnzeigeTypViewerFilter.refreshViewer();
    }
}

