/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util;

import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IImage;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.MimeType;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.LocalDate;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatientImageUtil {
    private static Logger logger = LoggerFactory.getLogger(PatientImageUtil.class);

    public static Image getPatientImage(String patientId) {
        if (patientId == null) {
            return null;
        }
        IContact person = CoreModelServiceHolder.get().load(patientId, IContact.class).orElse(null);
        if (person == null) {
            return null;
        }
        IImage image = person.getImage();
        if (image == null) {
            return null;
        }
        byte[] imgBytes = image.getImage();
        if (imgBytes == null || imgBytes.length == 0) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ByteArrayInputStream bais = new ByteArrayInputStream(imgBytes);){
                ImageData imgData = new ImageData((InputStream)bais);
                return new Image((Device)Display.getDefault(), imgData);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            logger.error("Error loading patient image for patientId {}: {}", new Object[]{patientId, e.getMessage(), e});
            return null;
        }
    }

    public static void savePatientImage(String patientId, byte[] imageBytes, String patientName, MimeType mimeType) {
        try {
            IContact patient = CoreModelServiceHolder.get().load(patientId, IContact.class).orElse(null);
            if (patient != null) {
                IImage patientImage = (IImage)CoreModelServiceHolder.get().create(IImage.class);
                patientImage.setId(patientId);
                patientImage.setImage(imageBytes);
                patientImage.setDate(LocalDate.now());
                patientImage.setPrefix("ch.elexis.data.Kontakt");
                patientImage.setTitle(patient.getDescription1() + " " + patient.getDescription2());
                patientImage.setMimeType(mimeType);
                CoreModelServiceHolder.get().save((Identifiable)patientImage);
            } else {
                logger.warn("No patient found for ID {} while saving patient image.", (Object)patientId);
            }
        }
        catch (Exception e) {
            logger.error("Error saving patient image for patientId {}: {}", new Object[]{patientId, e.getMessage(), e});
        }
    }

    public static Image scaleSwtImage(Image original, int targetWidth, int targetHeight, Display display) {
        Image scaled = new Image((Device)display, targetWidth, targetHeight);
        GC gc = new GC((Drawable)scaled);
        gc.setAntialias(1);
        gc.setInterpolation(2);
        gc.drawImage(original, 0, 0, original.getBounds().width, original.getBounds().height, 0, 0, targetWidth, targetHeight);
        gc.dispose();
        return scaled;
    }

    public static void deletePatientImage(String patientId) {
        if (patientId == null) {
            return;
        }
        IContact contact = CoreModelServiceHolder.get().load(patientId, IContact.class).orElse(null);
        if (contact == null) {
            return;
        }
        IImage img = contact.getImage();
        if (img != null) {
            CoreModelServiceHolder.get().delete((Deleteable)img);
        }
    }
}

