/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.text;

import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.services.holder.LocalLockServiceHolder;
import ch.elexis.core.ui.locks.LockResponseHelper;
import ch.elexis.core.ui.text.EnhancedTextField;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TransparentTextModificationLockHandler
implements VerifyKeyListener {
    private static final int LOCK_WINDOW_SECS = 60;
    private Logger logger;
    private ScheduledExecutorService executor;
    private EnhancedTextField enhancedTextField;
    private UnlockRunnable currentUnlockRunnable;

    public TransparentTextModificationLockHandler(EnhancedTextField enhancedTextField) {
        this.enhancedTextField = enhancedTextField;
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public void verifyKey(VerifyEvent event) {
        if (0x1000003 == event.keyCode || 0x1000004 == event.keyCode || 0x1000001 == event.keyCode || 0x1000002 == event.keyCode) {
            event.doit = true;
            return;
        }
        IEncounter encounter = this.enhancedTextField.getEncounter();
        if (encounter != null) {
            if (LocalLockServiceHolder.get().isLockedLocal((Object)encounter)) {
                if (this.currentUnlockRunnable != null) {
                    this.currentUnlockRunnable.setSeconds(60);
                }
            } else {
                BusyIndicator.showWhile((Display)this.enhancedTextField.getDisplay(), () -> {
                    LockResponse lockResponse = LocalLockServiceHolder.get().acquireLockBlocking((Object)encounter, 1, (IProgressMonitor)new NullProgressMonitor());
                    if (!lockResponse.isOk()) {
                        verifyEvent.doit = false;
                        LockResponseHelper.showInfo(lockResponse, encounter, this.logger);
                        return;
                    }
                });
                this.currentUnlockRunnable = new UnlockRunnable(encounter, 60);
                this.executor.schedule(this.currentUnlockRunnable, 1L, TimeUnit.SECONDS);
            }
        }
        event.doit = true;
    }

    private class UnlockRunnable
    implements Runnable {
        private IEncounter encounter;
        private int seconds;

        public UnlockRunnable(IEncounter encounter, int seconds) {
            this.encounter = encounter;
            this.seconds = seconds;
            TransparentTextModificationLockHandler.this.logger.info("LOCK [" + encounter.getId() + "]");
        }

        public void setSeconds(int seconds) {
            this.seconds = seconds;
        }

        @Override
        public void run() {
            if (LocalLockServiceHolder.get().isLockedLocal((Object)this.encounter)) {
                if (this.seconds > 0) {
                    --this.seconds;
                    TransparentTextModificationLockHandler.this.executor.schedule(this, 1L, TimeUnit.SECONDS);
                } else if (LocalLockServiceHolder.get().isLockedLocal((Object)this.encounter)) {
                    TransparentTextModificationLockHandler.this.logger.info("UNLOCK [" + this.encounter.getId() + "]");
                    LockResponse releaseLock = LocalLockServiceHolder.get().releaseLock((Object)this.encounter);
                    if (!releaseLock.isOk()) {
                        LockResponseHelper.showInfo(releaseLock, this.encounter, TransparentTextModificationLockHandler.this.logger);
                    }
                } else {
                    TransparentTextModificationLockHandler.this.logger.info("NO LOCK [" + this.encounter.getId() + "]");
                }
            } else {
                TransparentTextModificationLockHandler.this.logger.info("UNLOCKED [" + this.encounter.getId() + "]");
            }
        }
    }
}

