/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.text;

import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.ISickCertificate;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.text.model.Samdas;
import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.services.EncounterServiceHolder;
import ch.elexis.core.ui.text.IRichTextDisplay;
import ch.elexis.core.ui.util.IKonsExtension;
import ch.elexis.core.ui.views.AUF2;
import ch.rgw.tools.ExHandler;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.ui.PartInitException;

public class AUFExtension
implements IKonsExtension {
    private IRichTextDisplay tx;

    @Override
    public String connect(IRichTextDisplay tf) {
        this.tx = tf;
        this.tx.addDropReceiver(ISickCertificate.class, this);
        return "ch.elexis.text.AUFXRef";
    }

    @Override
    public boolean doLayout(StyleRange n, String provider, String id) {
        n.background = UiDesk.getColor("hellblau");
        n.foreground = UiDesk.getColor("grau20");
        return true;
    }

    @Override
    public boolean doXRef(String refProvider, String refID) {
        Optional loaded = CoreModelServiceHolder.get().load(refID, ISickCertificate.class);
        if (loaded.isPresent()) {
            try {
                AUF2 aUF2 = (AUF2)Hub.plugin.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.elexis.auf");
            }
            catch (PartInitException e) {
                ExHandler.handle((Throwable)e);
            }
            return true;
        }
        return false;
    }

    @Override
    public void insert(Object o, int pos) {
        if (o instanceof ISickCertificate) {
            ISickCertificate auf = (ISickCertificate)o;
            ContextServiceHolder.get().getTyped(IEncounter.class).ifPresent(e -> {
                this.tx.insertXRef(pos, "AUF: " + auf.getLabel(), "ch.elexis.text.AUFXRef", auf.getId());
                EncounterServiceHolder.get().updateVersionedEntry(e, new Samdas(this.tx.getContentsAsXML()));
                ContextServiceHolder.get().postEvent("info/elexis/model/update", e);
            });
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    @Override
    public IAction[] getActions() {
        return null;
    }

    @Override
    public void removeXRef(String refProvider, String refID) {
    }
}

