/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.preferences;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.preferences.Messages;
import ch.elexis.core.ui.util.SWTHelper;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PrinterPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String ARROW = "->";
    private static final String PRINTERWITH = Messages.PrinterPreferencePage_PrinterWith;
    private static final String TRAYFOR = Messages.PrinterPreferencePage_TrayFor;
    private static final String LABELS = Messages.PrinterPreferencePage_Labels;
    private static final String PAPER_ESR = Messages.PrinterPreferencePage_PaperWithESR;
    private static final String PAPER_PLAIN_A4 = Messages.PrinterPreferencePage_PaperA4Plain;
    private static final String PAPER_PLAIN_A5 = Messages.PrinterPreferencePage_PaperA5Plain;
    private static final String SHEETFEEDER = Messages.PrinterPreferencePage_SheetFeeder;
    Text tEtiketten;
    Text tEtikettenschacht;
    Text tA5;
    Text tA5Schacht;
    Text tA4ESR;
    Text tA4ESRSchacht;
    Text tA4;
    Text tA4Schacht;
    Text tEinzelblatt;
    Text tEinzelblattSchacht;
    Button bEtiketten;
    Button cEtiketten;
    Button bClear;
    PrinterSelector psel;

    protected Control createContents(Composite parent) {
        this.psel = new PrinterSelector();
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout(3, false));
        new Label(ret, 0).setText(PRINTERWITH + LABELS);
        this.tEtiketten = new Text(ret, 2056);
        this.tEtiketten.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.tEtiketten.setData((Object)Messages.PrinterPreferencePage_Labelrinter);
        this.bEtiketten = new Button(ret, 8);
        this.bEtiketten.setText(" ->");
        this.bEtiketten.setData((Object)this.tEtiketten);
        this.bEtiketten.addSelectionListener((SelectionListener)this.psel);
        new Label(ret, 0).setText(TRAYFOR + LABELS);
        this.tEtikettenschacht = new Text(ret, 2048);
        this.tEtikettenschacht.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        new Label(ret, 0);
        new Label(ret, 0);
        this.cEtiketten = new Button(ret, 32);
        this.cEtiketten.setText(Messages.PrinterPreferencePage_ChosePrinterAlways);
        this.cEtiketten.setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, false));
        this.cEtiketten.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrinterPreferencePage.this.setEtikettenSelection(PrinterPreferencePage.this.cEtiketten.getSelection());
            }
        });
        new Label(ret, 0).setText(PRINTERWITH + PAPER_ESR);
        this.tA4ESR = new Text(ret, 2056);
        this.tA4ESR.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        Button b = new Button(ret, 8);
        b.setData((Object)this.tA4ESR);
        b.addSelectionListener((SelectionListener)this.psel);
        b.setText(ARROW);
        new Label(ret, 0).setText(TRAYFOR + PAPER_ESR);
        this.tA4ESRSchacht = new Text(ret, 2048);
        this.tA4ESRSchacht.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        new Label(ret, 0);
        new Label(ret, 0).setText(PRINTERWITH + PAPER_PLAIN_A4);
        this.tA4 = new Text(ret, 2056);
        this.tA4.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        b = new Button(ret, 8);
        b.setData((Object)this.tA4);
        b.addSelectionListener((SelectionListener)this.psel);
        b.setText(ARROW);
        new Label(ret, 0).setText(TRAYFOR + PAPER_PLAIN_A4);
        this.tA4Schacht = new Text(ret, 2048);
        this.tA4Schacht.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        new Label(ret, 0);
        new Label(ret, 0).setText(PRINTERWITH + PAPER_PLAIN_A5);
        this.tA5 = new Text(ret, 2056);
        this.tA5.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        b = new Button(ret, 8);
        b.setData((Object)this.tA5);
        b.addSelectionListener((SelectionListener)this.psel);
        b.setText(ARROW);
        new Label(ret, 0).setText(TRAYFOR + PAPER_PLAIN_A5);
        this.tA5Schacht = new Text(ret, 2048);
        this.tA5Schacht.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        new Label(ret, 0);
        new Label(ret, 0).setText(PRINTERWITH + SHEETFEEDER);
        this.tEinzelblatt = new Text(ret, 2056);
        this.tEinzelblatt.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        b = new Button(ret, 8);
        b.setData((Object)this.tEinzelblatt);
        b.addSelectionListener((SelectionListener)this.psel);
        b.setText(ARROW);
        new Label(ret, 0).setText(TRAYFOR + SHEETFEEDER);
        this.tEinzelblattSchacht = new Text(ret, 2048);
        this.tEinzelblattSchacht.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        new Label(ret, 0);
        this.tEtiketten.setText(CoreHub.localCfg.get("Drucker/Etiketten/Name", ""));
        this.tEtikettenschacht.setText(CoreHub.localCfg.get("Drucker/Etiketten/Schacht", ""));
        boolean selection = CoreHub.localCfg.get("Drucker/Etiketten/Choose", false);
        this.cEtiketten.setSelection(selection);
        this.setEtikettenSelection(selection);
        this.tA4ESR.setText(CoreHub.localCfg.get("Drucker/A4ESR/Name", ""));
        this.tA4ESRSchacht.setText(CoreHub.localCfg.get("Drucker/A4ESR/Schacht", ""));
        this.tA4.setText(CoreHub.localCfg.get("Drucker/A4/Name", ""));
        this.tA4Schacht.setText(CoreHub.localCfg.get("Drucker/A4/Schacht", ""));
        this.tA5.setText(CoreHub.localCfg.get("Drucker/A5/Name", ""));
        this.tA5Schacht.setText(CoreHub.localCfg.get("Drucker/A5/Schacht", ""));
        this.tEinzelblatt.setText(CoreHub.localCfg.get("Drucker/Einzelblatt/Name", ""));
        this.tEinzelblattSchacht.setText(CoreHub.localCfg.get("Drucker/Einzelblatt/Schacht", ""));
        new Label(ret, 258).setLayoutData((Object)SWTHelper.getFillGridData(3, true, 1, false));
        this.bClear = new Button(ret, 8);
        this.bClear.setText(Messages.PrinterPreferencePage_ClearPrinterSettings);
        this.bClear.setLayoutData((Object)SWTHelper.getFillGridData(3, true, 1, false));
        this.bClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrinterPreferencePage.this.tEtiketten.setText("");
                PrinterPreferencePage.this.tA4.setText("");
                PrinterPreferencePage.this.tA4ESR.setText("");
                PrinterPreferencePage.this.tA5.setText("");
            }
        });
        return ret;
    }

    private void setEtikettenSelection(boolean selection) {
        if (selection) {
            this.tEtiketten.setText("");
            this.tEtiketten.setData(null);
            this.tEtikettenschacht.setText("");
        }
        this.tEtiketten.setEnabled(!selection);
        this.tEtikettenschacht.setEnabled(!selection);
        this.bEtiketten.setEnabled(!selection);
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        CoreHub.localCfg.set("Drucker/Etiketten/Name", this.tEtiketten.getText());
        CoreHub.localCfg.set("Drucker/Etiketten/Schacht", this.tEtikettenschacht.getText());
        CoreHub.localCfg.set("Drucker/Etiketten/Choose", this.cEtiketten.getSelection());
        Object data = this.tEtiketten.getData();
        if (data instanceof PrinterData) {
            PrinterData pdata = (PrinterData)data;
            CoreHub.localCfg.set("Drucker/Etiketten/Driver", pdata.driver);
        } else {
            CoreHub.localCfg.set("Drucker/Etiketten/Driver", "");
        }
        CoreHub.localCfg.set("Drucker/A4ESR/Name", this.tA4ESR.getText());
        CoreHub.localCfg.set("Drucker/A4ESR/Schacht", this.tA4ESRSchacht.getText());
        CoreHub.localCfg.set("Drucker/A4/Name", this.tA4.getText());
        CoreHub.localCfg.set("Drucker/A4/Schacht", this.tA4Schacht.getText());
        CoreHub.localCfg.set("Drucker/A5/Name", this.tA5.getText());
        CoreHub.localCfg.set("Drucker/A5/Schacht", this.tA5Schacht.getText());
        CoreHub.localCfg.set("Drucker/Einzelblatt/Name", this.tEinzelblatt.getText());
        CoreHub.localCfg.set("Drucker/Einzelblatt/Schacht", this.tEinzelblattSchacht.getText());
        return super.performOk();
    }

    class PrinterSelector
    extends SelectionAdapter {
        PrinterSelector() {
        }

        public void widgetSelected(SelectionEvent e) {
            PrintDialog pd = new PrintDialog(PrinterPreferencePage.this.getShell());
            PrinterData pdata = pd.open();
            if (pdata != null) {
                Text tx = (Text)((Button)e.getSource()).getData();
                tx.setText(pdata.name);
                tx.setData((Object)pdata);
            }
        }
    }
}

