/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs.eedep;

import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.ee.json.OpenIdConfiguration;
import ch.elexis.core.ee.json.WellKnownEE;
import ch.elexis.core.eenv.AccessToken;
import ch.elexis.core.services.oauth2.OAuth2Service;
import ch.elexis.core.status.ObjectStatus;
import ch.elexis.core.time.TimeUtil;
import ch.elexis.core.ui.ILoginNews;
import ch.elexis.core.ui.dialogs.eedep.OidcBrowserLoginDialog;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.icons.ImageSize;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.rgw.tools.ExHandler;
import com.google.gson.Gson;
import jakarta.inject.Inject;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EEDependentLoginDialog
extends TitleAreaDialog {
    @Inject
    private HttpClient httpClient;
    @Inject
    private Gson gson;
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String eeHostname;
    private Text txtUsername;
    private Text txtPassword;
    private WellKnownEE wellKnownEE;
    private OpenIdConfiguration openidConfiguration;
    private AccessToken accessToken;
    private Button btnOidcLogin;

    public EEDependentLoginDialog(Shell parentShell, String eeHostname) {
        super(parentShell);
        this.eeHostname = eeHostname;
        CoreUiUtil.injectServices((Object)((Object)this));
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitleImage(Images.IMG_EE_TITLE_BANNER.getImage(ImageSize._75x66_TitleDialogIconSize));
        this.setTitle("Elexis-Environment Anmeldung");
        this.setMessage("\u00dcberpr\u00fcfe EE Verbindung ...");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        this.txtUsername = new Text(container, 2048);
        this.txtUsername.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtUsername.setMessage("Benutzername");
        this.txtUsername.setEnabled(false);
        this.btnOidcLogin = new Button(container, 0x800000);
        this.btnOidcLogin.setText("OIDC Login");
        this.btnOidcLogin.setLayoutData((Object)new GridData(4, 4, false, false, 1, 2));
        this.btnOidcLogin.setImage(Images.IMG_OIDC.getImage(ImageSize._75x66_TitleDialogIconSize));
        this.btnOidcLogin.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OidcBrowserLoginDialog oidcBrowserLoginDialog = new OidcBrowserLoginDialog(EEDependentLoginDialog.this.getShell(), EEDependentLoginDialog.this.openidConfiguration.authorizationEndpoint, EEDependentLoginDialog.this.openidConfiguration.tokenEndpoint);
                int open = oidcBrowserLoginDialog.open();
                if (open == 0) {
                    EEDependentLoginDialog.this.accessToken = oidcBrowserLoginDialog.getAccessToken();
                    EEDependentLoginDialog.this.setReturnCode(0);
                    EEDependentLoginDialog.this.close();
                }
            }
        });
        this.txtPassword = new Text(container, 0x400800);
        this.txtPassword.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.txtPassword.setMessage("Passwort");
        this.txtPassword.setEnabled(false);
        this.loadWellKnownEEInfo();
        List newsModules = Extensions.getClasses((String)"ch.elexis.core.ui.LoginNews", (String)"class");
        if (!newsModules.isEmpty()) {
            Composite cNews = new Composite(area, 0);
            cNews.setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, true));
            cNews.setLayout((Layout)new GridLayout());
            for (ILoginNews lm : newsModules) {
                try {
                    Composite comp = lm.getComposite(cNews);
                    comp.setLayoutData((Object)SWTHelper.getFillGridData());
                }
                catch (Exception ex) {
                    ExHandler.handle((Throwable)ex);
                }
            }
        }
        return area;
    }

    private void loadWellKnownEEInfo() {
        new Thread(() -> {
            HttpRequest request = HttpRequest.newBuilder(URI.create("https://" + this.eeHostname + "/.well-known/elexis-environment")).header("accept", "application/json").build();
            try {
                String body = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString()).body();
                this.wellKnownEE = (WellKnownEE)this.gson.fromJson(body, WellKnownEE.class);
                String organisationName = this.wellKnownEE.ee.config.organisationName.replaceAll("__", " ");
                request = HttpRequest.newBuilder(URI.create(this.wellKnownEE.openidConfiguration)).header("accept", "application/json").build();
                body = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString()).body();
                this.openidConfiguration = (OpenIdConfiguration)this.gson.fromJson(body, OpenIdConfiguration.class);
                this.getShell().getDisplay().syncExec(() -> {
                    this.setErrorMessage(null);
                    this.setMessage(organisationName + " (" + this.eeHostname + ")");
                    this.getButton(0).setEnabled(true);
                    this.txtUsername.setEnabled(true);
                    this.txtPassword.setEnabled(true);
                    this.txtUsername.setFocus();
                });
            }
            catch (Exception e) {
                this.getShell().getDisplay().syncExec(() -> {
                    this.getButton(0).setEnabled(false);
                    this.setErrorMessage("Fehler bei EE Verbindung");
                    this.logger.error("Cannot load .well-known/elexis-environment", (Throwable)e);
                });
            }
        }).start();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, "Beenden", false);
        this.getButton(0).setEnabled(false);
    }

    protected void okPressed() {
        ObjectStatus<AccessToken> status = this.performDirectOAuthLogin();
        if (status.isOK()) {
            this.accessToken = (AccessToken)status.get();
            super.okPressed();
        } else {
            this.accessToken = null;
            this.setErrorMessage(this.txtUsername.getText() + ": " + status.getMessage());
        }
    }

    private ObjectStatus<AccessToken> performDirectOAuthLogin() {
        String clientSecret = System.getProperty("ee.client-secret");
        ObjectStatus accessToken = new OAuth2Service().performDirectAccessGrantFlow(URI.create(this.openidConfiguration.tokenEndpoint), "elexis-rcp-openid", clientSecret, this.txtUsername.getText(), this.txtPassword.getText().toCharArray());
        if (accessToken.isOK()) {
            this.logger.info("Loaded access-token for [{}], valid until [{}], refresh until [{}]", new Object[]{((AccessToken)accessToken.getObject()).getUsername(), TimeUtil.toLocalDateTime((Date)((AccessToken)accessToken.getObject()).getAccessTokenExpiration()), TimeUtil.toLocalDateTime((Date)((AccessToken)accessToken.getObject()).refreshTokenExpiration())});
        } else {
            this.logger.warn("Could not load accessToken: " + accessToken.getMessage());
        }
        return accessToken;
    }

    protected void cancelPressed() {
        this.wellKnownEE = null;
        this.accessToken = null;
        super.cancelPressed();
    }

    protected Point getInitialSize() {
        return new Point(450, 300);
    }

    public WellKnownEE getWellKnownEE() {
        return this.wellKnownEE;
    }

    public AccessToken getAccessToken() {
        return this.accessToken;
    }
}

