/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.commands;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.IDocumentLetter;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.text.MimeTypeUtil;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.text.ITextPlugin;
import ch.elexis.core.ui.views.textsystem.TextTemplateView;
import ch.elexis.core.ui.views.textsystem.model.TextTemplate;
import ch.elexis.data.Brief;
import ch.elexis.data.Kontakt;
import ch.rgw.tools.ExHandler;
import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportSelectedTemplateCommand
extends AbstractHandler {
    private static Logger logger = LoggerFactory.getLogger(ImportSelectedTemplateCommand.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        TextTemplateView textTemplateView = (TextTemplateView)activePage.findView("ch.elexis.views.textsystem.TextTemplateView");
        TextTemplate textTemplate = this.getSelectedTextTemplate(event);
        if (textTemplate == null) {
            logger.warn("No TextTemplate selected - skipping template import");
            return null;
        }
        ITextPlugin plugin = textTemplateView.getActiveTextPlugin();
        if (plugin == null) {
            logger.warn("No TextPlugin found - skipping text template import");
            return null;
        }
        try {
            File file;
            String mimeType = plugin.getMimeType();
            FileDialog fdl = new FileDialog(UiDesk.getTopShell());
            fdl.setFilterExtensions(new String[]{MimeTypeUtil.getExtensions((String)mimeType)});
            fdl.setFilterNames(new String[]{MimeTypeUtil.getPrettyPrintName((String)mimeType)});
            String filename = fdl.open();
            if (filename != null && (file = new File(filename)).exists()) {
                FileInputStream fis = new FileInputStream(file);
                byte[] contentToStore = new byte[(int)file.length()];
                fis.read(contentToStore);
                fis.close();
                List<Brief> existing = TextTemplate.findExistingTemplates(textTemplate.isSystemTemplate(), textTemplate.getName(), null, textTemplate.getMandant() != null ? textTemplate.getMandant().getId() : "");
                if (!existing.isEmpty() && MessageDialog.openQuestion((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Vorlagen existieren", (String)String.format("Sollen die (%d) existierenden %s Vorlagen \u00fcberschrieben werden?", existing.size(), textTemplate.getName()))) {
                    for (Brief brief : existing) {
                        brief.delete();
                    }
                }
                Brief bTemplate = new Brief(textTemplate.getName(), null, (Kontakt)CoreHub.getLoggedInContact(), (Kontakt)textTemplate.getMandant(), null, "Vorlagen");
                if (textTemplate.isSystemTemplate()) {
                    bTemplate.set("BehandlungsID", "SYS");
                    textTemplate.addSystemTemplateReference(bTemplate);
                } else {
                    textTemplate.addFormTemplateReference(bTemplate);
                }
                bTemplate.save(contentToStore, plugin.getMimeType());
                textTemplateView.update(textTemplate);
            }
        }
        catch (Throwable ex) {
            ExHandler.handle((Throwable)ex);
        }
        ContextServiceHolder.get().postEvent("info/elexis/model/reload", IDocumentLetter.class);
        return null;
    }

    private TextTemplate getSelectedTextTemplate(ExecutionEvent event) {
        IStructuredSelection strucSelection;
        Object firstElement;
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        if (selection != null && (firstElement = (strucSelection = (IStructuredSelection)selection).getFirstElement()) != null && firstElement instanceof TextTemplate) {
            TextTemplate textTemplate = (TextTemplate)firstElement;
            return textTemplate;
        }
        return null;
    }
}

