/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.entities.converter;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter
public class DoubleStringConverter
implements AttributeConverter<Double, String> {
    private Logger log = LoggerFactory.getLogger(DoubleStringConverter.class);

    public String convertToDatabaseColumn(Double objectValue) {
        return Double.toString(objectValue);
    }

    public Double convertToEntityAttribute(String dataValue) {
        if (StringUtils.isEmpty((CharSequence)dataValue)) {
            return 0.0;
        }
        try {
            return Double.parseDouble(dataValue.trim());
        }
        catch (NumberFormatException ex) {
            this.log.warn("Number format exception " + dataValue, (Throwable)ex);
            return 0.0;
        }
    }
}

