/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.tasks.parts.controls;

import ch.elexis.core.model.IUser;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.tasks.TaskException;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.tasks.model.ITaskDescriptor;
import ch.elexis.core.tasks.model.ITaskService;
import ch.elexis.core.tasks.model.OwnerTaskNotification;
import ch.elexis.core.ui.tasks.parts.controls.AbstractTaskDescriptorConfigurationComposite;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ListDialog;
import org.slf4j.LoggerFactory;

public class GeneralConfigurationComposite
extends AbstractTaskDescriptorConfigurationComposite {
    private Text txtReferenceId;
    private Text txtOwnerId;
    private Text txtRunner;
    private ComboViewer cvNotificationType;
    private Button btnSingleton;
    private Button btnActive;

    public GeneralConfigurationComposite(final ITaskService taskService, Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        Label lblReferenceid = new Label((Composite)this, 0);
        lblReferenceid.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblReferenceid.setText("referenceId");
        this.txtReferenceId = new Text((Composite)this, 2048);
        this.txtReferenceId.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtReferenceId.addModifyListener(event -> {
            String text = ((Text)event.widget).getText();
            if (this.taskDescriptor != null) {
                this.taskDescriptor.setReferenceId(text);
                this.saveTaskDescriptor();
            }
        });
        Label lblOwner = new Label((Composite)this, 0);
        lblOwner.setText("owner");
        Composite compOwner = new Composite((Composite)this, 0);
        GridLayout gl_compOwner = new GridLayout(2, false);
        gl_compOwner.verticalSpacing = 0;
        gl_compOwner.marginWidth = 0;
        gl_compOwner.marginHeight = 0;
        compOwner.setLayout((Layout)gl_compOwner);
        compOwner.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtOwnerId = new Text(compOwner, 2048);
        this.txtOwnerId.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtOwnerId.setBounds(0, 0, 64, 19);
        Link linkOwner = new Link(compOwner, 0);
        linkOwner.setText("<a>...</a>");
        linkOwner.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                GeneralConfigurationComposite.this.openUserSelectionDialog();
            }
        });
        Label lblNotification = new Label((Composite)this, 0);
        lblNotification.setText("notification");
        this.cvNotificationType = new ComboViewer((Composite)this, 0);
        Combo combo = this.cvNotificationType.getCombo();
        combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.cvNotificationType.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cvNotificationType.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element == null) {
                    return "";
                }
                OwnerTaskNotification otn = (OwnerTaskNotification)element;
                switch (otn) {
                    case NEVER: {
                        return "Notify never";
                    }
                    case WHEN_FINISHED: {
                        return "Notify when task finished";
                    }
                    case WHEN_FINISHED_FAILED: {
                        return "Notify when task failed";
                    }
                }
                return super.getText(element);
            }
        });
        this.cvNotificationType.setInput((Object)OwnerTaskNotification.values());
        this.cvNotificationType.addSelectionChangedListener(sel -> {
            OwnerTaskNotification otn = (OwnerTaskNotification)sel.getStructuredSelection().getFirstElement();
            if (this.taskDescriptor != null) {
                this.taskDescriptor.setOwnerNotification(otn);
                this.saveTaskDescriptor();
            }
        });
        Label lblRunner = new Label((Composite)this, 0);
        lblRunner.setText("runner");
        this.txtRunner = new Text((Composite)this, 2048);
        this.txtRunner.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtRunner.setToolTipText("The station to run on (e.g. ELEXIS-SERVER), leave empty for all stations");
        this.txtRunner.addModifyListener(ev -> {
            String runner = ((Text)ev.widget).getText();
            if (this.taskDescriptor != null) {
                this.taskDescriptor.setRunner(runner);
                this.saveTaskDescriptor();
            }
        });
        new Label((Composite)this, 0);
        this.btnSingleton = new Button((Composite)this, 32);
        this.btnSingleton.setText("singleton");
        this.btnSingleton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selection = ((Button)e.widget).getSelection();
                if (GeneralConfigurationComposite.this.taskDescriptor != null) {
                    GeneralConfigurationComposite.this.taskDescriptor.setSingleton(selection);
                    GeneralConfigurationComposite.this.saveTaskDescriptor();
                }
            }
        });
        new Label((Composite)this, 0);
        this.btnActive = new Button((Composite)this, 32);
        this.btnActive.setText("active");
        this.btnActive.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selection = ((Button)e.widget).getSelection();
                if (GeneralConfigurationComposite.this.taskDescriptor != null) {
                    try {
                        taskService.setActive(GeneralConfigurationComposite.this.taskDescriptor, selection);
                        ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)GeneralConfigurationComposite.this.taskDescriptor);
                    }
                    catch (TaskException e1) {
                        MessageDialog.openWarning((Shell)GeneralConfigurationComposite.this.btnActive.getShell(), (String)"Error de-/activating", (String)e1.getLocalizedMessage());
                        LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Error de-/activating", (Throwable)e1);
                    }
                }
            }
        });
    }

    @Override
    public void setSelection(ITaskDescriptor taskDescriptor) {
        super.setSelection(taskDescriptor);
        if (taskDescriptor != null) {
            this.txtReferenceId.setText(taskDescriptor.getReferenceId() != null ? taskDescriptor.getReferenceId() : "");
            String ownerId = taskDescriptor.getOwner() != null ? taskDescriptor.getOwner().getId() : "";
            this.txtOwnerId.setText(ownerId);
            this.txtRunner.setText(taskDescriptor.getRunner());
            this.cvNotificationType.setSelection((ISelection)new StructuredSelection((Object)taskDescriptor.getOwnerNotification()));
            this.btnActive.setSelection(taskDescriptor.isActive());
            this.btnSingleton.setSelection(taskDescriptor.isSingleton());
        } else {
            this.txtReferenceId.setText("");
            this.txtOwnerId.setText("");
            this.txtRunner.setText("");
            this.cvNotificationType.setSelection(null);
            this.btnSingleton.setSelection(false);
            this.btnActive.setSelection(false);
        }
    }

    private void openUserSelectionDialog() {
        Object[] result;
        ListDialog listDialog = new ListDialog(this.getShell());
        listDialog.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
        List users = CoreModelServiceHolder.get().getQuery(IUser.class).execute();
        Collections.sort(users, Comparator.comparing(Identifiable::getId));
        listDialog.setInput((Object)users);
        listDialog.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                IUser runnable = (IUser)element;
                return runnable.getId();
            }
        });
        listDialog.setMessage("Select an action");
        int open = listDialog.open();
        if (open == 0 && (result = listDialog.getResult()) != null && result.length >= 1) {
            IUser selection = (IUser)result[0];
            this.taskDescriptor.setOwner(selection);
            this.setSelection(this.taskDescriptor);
        }
    }
}

