/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.ui.composites;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.ObservationComponent;
import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.ui.composites.ICompositeSaveable;
import ch.elexis.core.findings.ui.services.FindingsServiceComponent;
import ch.elexis.core.findings.ui.util.FindingsUiUtil;
import ch.elexis.core.findings.util.ModelUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CompositeBoolean
extends Composite
implements ICompositeSaveable {
    private IFinding iFinding;
    private ObservationComponent backboneComponent;
    private Label lbl;
    private Button fieldButton;
    private List<Action> toolbarActions = new ArrayList<Action>();
    private IObservation.ObservationType observationType;

    public CompositeBoolean(Composite parent, IFinding iFinding, ObservationComponent backboneComponent) {
        super(parent, 0);
        this.iFinding = iFinding;
        this.backboneComponent = backboneComponent;
        GridLayout gd = new GridLayout(2, false);
        gd.marginTop = 5;
        gd.marginBottom = 0;
        gd.marginHeight = 0;
        gd.verticalSpacing = 0;
        this.setLayout((Layout)gd);
        this.setLayoutData(new GridData(4, 4, true, true));
        List codings = null;
        String title = null;
        Boolean value = null;
        if (backboneComponent != null) {
            this.observationType = (IObservation.ObservationType)backboneComponent.getTypeFromExtension(IObservation.ObservationType.class);
            value = backboneComponent.getBooleanValue().orElse(Boolean.FALSE);
            codings = backboneComponent.getCoding();
        } else if (iFinding instanceof IObservation) {
            IObservation iObservation = (IObservation)iFinding;
            this.observationType = iObservation.getObservationType();
            value = iObservation.getBooleanValue().orElse(Boolean.FALSE);
            codings = iObservation.getCoding();
        }
        if (title == null && codings != null) {
            Optional coding = ModelUtil.getCodeBySystem(codings, (CodingSystem)CodingSystem.ELEXIS_LOCAL_CODESYSTEM);
            String string = title = coding.isPresent() ? ((ICoding)coding.get()).getDisplay() : "";
        }
        if (title == null) {
            title = iFinding.getText().orElse("");
        }
        this.createContents(title, value, backboneComponent != null);
    }

    private void createContents(String title, Boolean value, boolean componentChild) {
        this.lbl = new Label((Composite)this, 0);
        this.lbl.setText(title);
        GridData minGD = new GridData(16384, 0x1000000, false, false);
        this.lbl.setLayoutData((Object)minGD);
        if (this.fieldButton == null) {
            this.fieldButton = new Button((Composite)this, 32);
            GridData gdFieldText = new GridData(16384, 0x1000000, true, false);
            this.fieldButton.setLayoutData((Object)gdFieldText);
            this.fieldButton.setSelection(value.booleanValue());
            this.fieldButton.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 16 || e.detail == 8) {
                        e.doit = true;
                    }
                }
            });
        }
    }

    @Override
    public IFinding saveContents(LocalDateTime localDateTime) {
        if (this.iFinding.getId() == null) {
            this.iFinding = FindingsServiceComponent.getService().create(this.iFinding.getClass());
        }
        return FindingsUiUtil.saveObservation((IObservation)this.iFinding, this, localDateTime);
    }

    @Override
    public void hideLabel(boolean all) {
        if (this.lbl != null) {
            this.fieldButton.setToolTipText(this.lbl.getText());
            this.lbl.setVisible(false);
            ((GridData)this.lbl.getLayoutData()).widthHint = 0;
            ((GridData)this.lbl.getLayoutData()).heightHint = 0;
        }
    }

    @Override
    public void setToolbarActions(List<Action> toolbarActions) {
        this.toolbarActions = toolbarActions;
    }

    @Override
    public List<Action> getToolbarActions() {
        return this.toolbarActions;
    }

    @Override
    public String getTitle() {
        return this.lbl != null ? this.lbl.getText() : "";
    }

    @Override
    public IFinding getFinding() {
        return this.iFinding;
    }

    @Override
    public List<ICompositeSaveable> getChildReferences() {
        return Collections.emptyList();
    }

    @Override
    public List<ICompositeSaveable> getChildComponents() {
        return Collections.emptyList();
    }

    @Override
    public String getFieldTextValue() {
        return this.fieldButton != null ? Boolean.valueOf(this.fieldButton.getSelection()).toString() : "";
    }

    @Override
    public ObservationComponent getObservationComponent() {
        return this.backboneComponent;
    }

    @Override
    public IObservation.ObservationType getObservationType() {
        return this.observationType;
    }
}

