/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.model.adapter;

import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.model.adapter.AbstractIdModelAdapter;
import ch.elexis.core.jpa.model.adapter.AbstractModelQuery;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class MappingEntry {
    private Class<?> interfaceClass;
    private Class<? extends AbstractIdModelAdapter<?>> adapterClass;
    private Class<? extends EntityWithId> entityClass;
    private Predicate<AbstractIdModelAdapter<?>> preCondition;
    private Consumer<AbstractIdModelAdapter<?>> initializer;
    private Consumer<AbstractModelQuery<?>> queryPreCondition;

    public MappingEntry(Class<?> interfaceClass, Class<? extends AbstractIdModelAdapter<?>> adapterClass, Class<? extends EntityWithId> entityClass) {
        this.interfaceClass = interfaceClass;
        this.adapterClass = adapterClass;
        this.entityClass = entityClass;
    }

    public MappingEntry adapterPreCondition(Predicate<AbstractIdModelAdapter<?>> predicate) {
        this.preCondition = predicate;
        return this;
    }

    public MappingEntry adapterInitializer(Consumer<AbstractIdModelAdapter<?>> consumer) {
        this.initializer = consumer;
        return this;
    }

    public MappingEntry queryPreCondition(Consumer<AbstractModelQuery<?>> consumer) {
        this.queryPreCondition = consumer;
        return this;
    }

    public void initialize(AbstractIdModelAdapter<?> adapter) {
        if (this.initializer != null) {
            this.initializer.accept(adapter);
        }
    }

    public boolean testAdapterPrecondition(AbstractIdModelAdapter<?> adapter) {
        if (this.preCondition != null) {
            return this.preCondition.test(adapter);
        }
        return true;
    }

    public Class<?> getInterfaceClass() {
        return this.interfaceClass;
    }

    public Class<? extends AbstractIdModelAdapter<?>> getAdapterClass() {
        return this.adapterClass;
    }

    public Class<? extends EntityWithId> getEntityClass() {
        return this.entityClass;
    }

    public void applyQueryPrecondition(AbstractModelQuery<?> abstractModelQuery) {
        if (this.queryPreCondition != null) {
            this.queryPreCondition.accept(abstractModelQuery);
        }
    }
}

